/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.material;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.base.cell.BaseItemCell;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.data.StringUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.thaumcraft.objects.wrapper.aspect.TC_Aspect_Wrapper;
import gtPlusPlus.xmod.tinkers.material.BaseTinkersMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Material {
    public static final Set<Material> mMaterialMap = new HashSet<Material>();
    public static HashMap<String, Material> mMaterialCache = new HashMap();
    public static final Map<String, Map<String, ItemStack>> mComponentMap = new HashMap<String, Map<String, ItemStack>>();
    public static HashMap<String, String> sChemicalFormula = new HashMap();
    private String unlocalizedName;
    private String localizedName;
    private String translatedName;
    private MaterialState materialState;
    private TextureSet textureSet;
    private Fluid mFluid;
    private Fluid mPlasma;
    private boolean vGenerateCells;
    protected Object dataVar = MathUtils.generateSingularRandomHexValue();
    private ArrayList<MaterialStack> vMaterialInput = new ArrayList();
    public long[] vSmallestRatio;
    public short vComponentCount;
    private short[] RGBA;
    private boolean usesBlastFurnace;
    public boolean isRadioactive;
    public byte vRadiationLevel;
    private int meltingPointK;
    private int boilingPointK;
    private int meltingPointC;
    private int boilingPointC;
    private long vProtons;
    private long vNeutrons;
    private long vMass;
    public int smallestStackSizeWhenProcessing;
    public int vTier;
    public int vVoltageMultiplier;
    public String vChemicalFormula;
    public String vChemicalSymbol;
    public long vDurability;
    public int vToolQuality;
    public int vHarvestLevel;
    private TC_Aspect_Wrapper[] vAspects;
    public BaseTinkersMaterial vTiConHandler;
    public short werkstoffID;
    public static AutoMap<Materials> invalidMaterials = new AutoMap();
    public boolean isFluidQueued = false;

    public Material(String materialName, MaterialState defaultState, MaterialStack ... inputs) {
        this(materialName, defaultState, (short[])null, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, MaterialStack ... inputs) {
        this(materialName, defaultState, null, 0L, rgba, -1, -1, -1L, -1L, false, "", 0, false, false, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int radiationLevel, MaterialStack ... materialStacks) {
        this(materialName, defaultState, null, 0L, rgba, -1, -1, -1L, -1L, false, "", radiationLevel, false, materialStacks);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int j, int k, int l, int m, int radiationLevel, MaterialStack[] materialStacks) {
        this(materialName, defaultState, null, 0L, rgba, j, k, (long)l, (long)m, false, "", radiationLevel, false, materialStacks);
    }

    public Material(String materialName, MaterialState defaultState, TextureSet set, short[] rgba, int meltingPoint, int boilingPoint, int protons, int neutrons, int radiationLevel, MaterialStack[] materialStacks) {
        this(materialName, defaultState, set, 0L, rgba, meltingPoint, boilingPoint, (long)protons, (long)neutrons, false, "", radiationLevel, false, materialStacks);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, MaterialStack ... inputs) {
        this(materialName, defaultState, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, "", 0, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemSymbol, MaterialStack ... inputs) {
        this(materialName, defaultState, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemSymbol, 0, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, boolean generateCells, MaterialStack ... inputs) {
        this(materialName, defaultState, null, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, "", 0, generateCells, true, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, int radiationLevel, MaterialStack ... inputs) {
        this(materialName, defaultState, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, "", radiationLevel, inputs);
    }

    public Material(String materialName, MaterialState defaultState, long durability, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, int radiationLevel, MaterialStack ... inputs) {
        this(materialName, defaultState, durability, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, "", radiationLevel, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, MaterialStack ... inputs) {
        this(materialName, defaultState, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemicalSymbol, radiationLevel, inputs);
    }

    public Material(String materialName, MaterialState defaultState, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, boolean addCells, MaterialStack ... inputs) {
        this(materialName, defaultState, null, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemicalSymbol, radiationLevel, addCells, true, inputs);
    }

    public Material(String materialName, MaterialState defaultState, TextureSet textureSet, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, MaterialStack ... inputs) {
        this(materialName, defaultState, textureSet, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemicalSymbol, radiationLevel, true, true, inputs);
    }

    public Material(String materialName, MaterialState defaultState, TextureSet textureSet, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, boolean addCells, MaterialStack ... inputs) {
        this(materialName, defaultState, textureSet, 0L, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemicalSymbol, radiationLevel, addCells, true, inputs);
    }

    private Material(String materialName, MaterialState defaultState, long durability, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, MaterialStack ... inputs) {
        this(materialName, defaultState, null, durability, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemicalSymbol, radiationLevel, true, true, inputs);
    }

    public Material(String materialName, MaterialState defaultState, TextureSet set, long durability, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, boolean generateCells, MaterialStack ... inputs) {
        this(materialName, defaultState, set, durability, rgba, meltingPoint, boilingPoint, protons, neutrons, blastFurnace, chemicalSymbol, radiationLevel, true, true, inputs);
    }

    public Material(String materialName, MaterialState defaultState, TextureSet set, long durability, short[] rgba, int meltingPoint, int boilingPoint, long protons, long neutrons, boolean blastFurnace, String chemicalSymbol, int radiationLevel, boolean generateCells, boolean generateFluid, MaterialStack ... inputs) {
        if (mMaterialMap.add(this)) {
            // empty if block
        }
        if (defaultState == MaterialState.ORE) {
            rgba = null;
        }
        mComponentMap.put(this.unlocalizedName, new HashMap());
        try {
            block69: {
                this.unlocalizedName = Utils.sanitizeString(materialName);
                this.localizedName = materialName;
                this.translatedName = GT_LanguageManager.addStringLocalization((String)("gtplusplus.material." + this.unlocalizedName), (String)this.localizedName);
                mMaterialCache.put(this.getLocalizedName().toLowerCase(), this);
                Logger.INFO("Stored " + this.getLocalizedName() + " to cache with key: " + this.getLocalizedName().toLowerCase());
                this.materialState = defaultState;
                Logger.MATERIALS(this.getLocalizedName() + " is " + defaultState.name() + ".");
                this.vGenerateCells = generateCells;
                if (inputs == null) {
                    this.vMaterialInput = null;
                } else if (inputs.length != 0) {
                    for (int i = 0; i < inputs.length; ++i) {
                        if (inputs[i] == null) continue;
                        this.vMaterialInput.add(i, inputs[i]);
                    }
                }
                if (rgba == null) {
                    if (this.vMaterialInput.size() > 0) {
                        try {
                            Short[] mMixedRGB = new Short[3];
                            AutoMap<Material> mMaterialSet = MaterialUtils.getCompoundMaterialsRecursively(this);
                            for (int mnh = 0; mnh < 3; ++mnh) {
                                AutoMap<Short> aDataSet = new AutoMap<Short>();
                                HashSet<Material> set4 = new HashSet<Material>();
                                for (Material u : mMaterialSet) {
                                    set4.add(u);
                                }
                                for (Material e : set4) {
                                    aDataSet.put(e.getRGB()[mnh]);
                                }
                                Short aAverage = MathUtils.getShortAverage(aDataSet);
                                if (aAverage > Short.MAX_VALUE || aAverage < Short.MIN_VALUE || aAverage < 0 || aAverage > 255) {
                                    if (aAverage > 255) {
                                        while (aAverage > 255) {
                                            aAverage = (short)(aAverage / 2);
                                        }
                                    }
                                    aAverage = (short)Math.max(Math.min(aAverage.shortValue(), 255), 0);
                                }
                                mMixedRGB[mnh] = aAverage;
                            }
                            if (mMixedRGB != null && mMixedRGB[0] != null && mMixedRGB[1] != null && mMixedRGB[2] != null) {
                                this.RGBA = new short[]{mMixedRGB[0], mMixedRGB[1], mMixedRGB[2], 0};
                                break block69;
                            }
                            this.RGBA = Materials.Steel.mRGBa;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            this.RGBA = Materials.Steel.mRGBa;
                        }
                    } else {
                        int aValueForGen = this.getUnlocalizedName().hashCode();
                        int hashSize = MathUtils.howManyPlaces(aValueForGen);
                        String a = String.valueOf(aValueForGen);
                        String b = "";
                        if (hashSize < 9) {
                            int aSecondHash = this.materialState.hashCode();
                            int hashSize2 = MathUtils.howManyPlaces(aSecondHash);
                            if (hashSize2 + hashSize >= 9) {
                                b = String.valueOf(aValueForGen);
                            } else {
                                String c = b;
                                while (MathUtils.howManyPlaces(hashSize + c.length()) < 9) {
                                    c = c + c.hashCode();
                                }
                                b = c;
                            }
                        }
                        String valueR = b != null ? a + b : a;
                        short[] fc = new short[3];
                        int aIndex = 0;
                        for (char gg : valueR.toCharArray()) {
                            short ui = Short.parseShort("" + gg);
                            if (ui > 255 || ui < 0) {
                                if (ui > 255) {
                                    while (ui > 255) {
                                        ui = (short)(ui / 2);
                                    }
                                } else {
                                    ui = 0;
                                }
                            }
                            fc[aIndex++] = ui;
                        }
                        this.RGBA = fc;
                    }
                } else {
                    this.RGBA = rgba;
                }
            }
            this.meltingPointC = meltingPoint != -1 ? meltingPoint : this.calculateMeltingPoint();
            this.boilingPointC = boilingPoint != -1 ? (boilingPoint != 0 ? boilingPoint : meltingPoint * 4) : this.calculateBoilingPoint();
            this.meltingPointK = (int)MathUtils.celsiusToKelvin(this.meltingPointC);
            this.boilingPointK = (int)MathUtils.celsiusToKelvin(this.boilingPointC);
            this.vProtons = protons != -1L ? protons : this.calculateProtons();
            this.vNeutrons = boilingPoint != -1 ? neutrons : this.calculateNeutrons();
            this.vAspects = null;
            this.vMass = this.getMass();
            if (durability != 0L) {
                this.vDurability = durability;
            } else {
                long aTempDura = 0L;
                for (MaterialStack g : this.getComposites()) {
                    if (g == null) continue;
                    aTempDura += (long)MathUtils.safeCast_LongToInt(g.getStackMaterial().getMass() * 2000L);
                }
                long l = aTempDura > 0L ? aTempDura : (this.vDurability = (long)(this.getComposites().isEmpty() ? 51200 : 32000 * this.getComposites().size()));
            }
            if (this.vDurability >= 0L && this.vDurability < 64000L) {
                this.vToolQuality = 1;
                this.vHarvestLevel = 2;
            } else if (this.vDurability >= 64000L && this.vDurability < 128000L) {
                this.vToolQuality = 2;
                this.vHarvestLevel = 2;
            } else if (this.vDurability >= 128000L && this.vDurability < 256000L) {
                this.vToolQuality = 3;
                this.vHarvestLevel = 2;
            } else if (this.vDurability >= 256000L && this.vDurability < 512000L) {
                this.vToolQuality = 3;
                this.vHarvestLevel = 3;
            } else if (this.vDurability >= 512000L && this.vDurability <= Integer.MAX_VALUE) {
                this.vToolQuality = 4;
                this.vHarvestLevel = 4;
            } else {
                this.vToolQuality = 1;
                this.vHarvestLevel = 1;
            }
            if (radiationLevel > 0) {
                Logger.MATERIALS(this.getLocalizedName() + " is radioactive. Level: " + radiationLevel + ".");
                this.isRadioactive = true;
                this.vRadiationLevel = (byte)radiationLevel;
            } else if (this.vMaterialInput.size() > 0) {
                AutoMap<Byte> aDataSet = new AutoMap<Byte>();
                for (MaterialStack m : this.vMaterialInput) {
                    aDataSet.put(m.getStackMaterial().vRadiationLevel);
                }
                byte aAverage = MathUtils.getByteAverage(aDataSet);
                if (aAverage > 0) {
                    Logger.MATERIALS(this.getLocalizedName() + " is radioactive due to trace elements. Level: " + aAverage + ".");
                    this.isRadioactive = true;
                    this.vRadiationLevel = aAverage;
                } else {
                    Logger.MATERIALS(this.getLocalizedName() + " is not radioactive.");
                    this.isRadioactive = false;
                    this.vRadiationLevel = 0;
                }
            } else {
                Logger.MATERIALS(this.getLocalizedName() + " is not radioactive.");
                this.isRadioactive = false;
                this.vRadiationLevel = 0;
            }
            this.vTier = MaterialUtils.getTierOfMaterial(meltingPoint);
            this.usesBlastFurnace = blastFurnace;
            this.vVoltageMultiplier = MaterialUtils.getVoltageForTier(this.vTier);
            this.vComponentCount = this.getComponentCount(inputs);
            this.vSmallestRatio = this.getSmallestRatio(this.vMaterialInput);
            int tempSmallestSize = 0;
            if (this.vSmallestRatio != null) {
                for (int v = 0; v < this.vSmallestRatio.length; ++v) {
                    tempSmallestSize = (int)((long)tempSmallestSize + this.vSmallestRatio[v]);
                }
                this.smallestStackSizeWhenProcessing = tempSmallestSize;
            } else {
                this.smallestStackSizeWhenProcessing = 1;
            }
            if (chemicalSymbol == null) {
                chemicalSymbol = "";
            }
            this.vChemicalSymbol = chemicalSymbol;
            if (this.vMaterialInput != null) {
                this.vChemicalFormula = this.getToolTip(chemicalSymbol, OrePrefixes.dust.mMaterialAmount / 3628800L, true);
            } else if (!this.vChemicalSymbol.equals("")) {
                Logger.MATERIALS("materialInput is null, using a valid chemical symbol.");
                this.vChemicalFormula = this.vChemicalSymbol;
            } else {
                Logger.MATERIALS("MaterialInput == null && chemicalSymbol probably equals nothing");
                this.vChemicalSymbol = "??";
                this.vChemicalFormula = "??";
            }
            if (generateFluid) {
                Materials aGregtechMaterial = this.tryFindGregtechMaterialEquivalent();
                FluidStack aTest = FluidUtils.getWildcardFluidStack(this.localizedName, 1);
                if (aTest != null) {
                    this.mFluid = aTest.getFluid();
                    Material.checkForCellAndGenerate(this);
                } else {
                    if (aGregtechMaterial != null && !MaterialUtils.isNullGregtechMaterial(aGregtechMaterial)) {
                        aTest = FluidUtils.getWildcardFluidStack(aGregtechMaterial, 1);
                    }
                    if (aTest != null) {
                        this.mFluid = aTest.getFluid();
                        Material.checkForCellAndGenerate(this);
                    } else {
                        this.mFluid = this.generateFluid();
                    }
                }
                if (this.getComposites().isEmpty()) {
                    this.mPlasma = this.generatePlasma();
                }
            } else {
                this.mFluid = null;
                this.mPlasma = null;
            }
            String ratio = "";
            if (this.vSmallestRatio != null) {
                for (int hu = 0; hu < this.vSmallestRatio.length; ++hu) {
                    ratio = ratio.equals("") ? String.valueOf(this.vSmallestRatio[hu]) : ratio + ":" + this.vSmallestRatio[hu];
                }
            }
            this.textureSet = this.setTextureSet(set, this.vTier);
            if (LoadedMods.TiCon && this.materialState == MaterialState.SOLID && (this.getProtons() >= 98L || this.getComposites().size() > 1 || this.getMeltingPointC() >= 3600)) {
                this.vTiConHandler = new BaseTinkersMaterial(this);
            }
            sChemicalFormula.put(materialName.toLowerCase(), this.vChemicalFormula);
            Logger.MATERIALS("Creating a Material instance for " + materialName);
            Logger.MATERIALS("Formula: " + this.vChemicalFormula + " Smallest Stack: " + this.smallestStackSizeWhenProcessing + " Smallest Ratio:" + ratio);
            Logger.MATERIALS("Protons: " + this.vProtons);
            Logger.MATERIALS("Neutrons: " + this.vNeutrons);
            Logger.MATERIALS("Mass: " + this.vMass + "/units");
            Logger.MATERIALS("Melting Point: " + this.meltingPointC + "C.");
            Logger.MATERIALS("Boiling Point: " + this.boilingPointC + "C.");
        }
        catch (Throwable t) {
            Logger.MATERIALS("Stack Trace for " + materialName);
            t.printStackTrace();
        }
    }

    private static void checkForCellAndGenerate(Material material) {
        if (!material.vGenerateCells) {
            return;
        }
        String aName = Utils.sanitizeString(material.unlocalizedName);
        String aName2 = Utils.sanitizeString(material.unlocalizedName.toLowerCase());
        String aName3 = material.localizedName == null ? aName : material.localizedName;
        ItemStack aTestCell1 = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + aName, 1);
        ItemStack aTestCell2 = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + aName2, 1);
        ItemStack aTestCell3 = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + aName3, 1);
        if (aTestCell1 == null && aTestCell2 == null && aTestCell3 == null) {
            Logger.INFO("Generating cell for " + material.localizedName);
            new BaseItemCell(material);
        } else if (aTestCell1 != null) {
            Logger.INFO("Registering existing cell for " + material.localizedName + ", " + aName);
            material.registerComponentForMaterial(OrePrefixes.cell, aTestCell1);
        } else if (aTestCell2 != null) {
            Logger.INFO("Registering existing cell for " + material.localizedName + ", " + aName2);
            material.registerComponentForMaterial(OrePrefixes.cell, aTestCell2);
        } else if (aTestCell3 != null) {
            Logger.INFO("Registering existing cell for " + material.localizedName + ", " + aName3);
            material.registerComponentForMaterial(OrePrefixes.cell, aTestCell3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextureSet getTextureSet() {
        Material material = this;
        synchronized (material) {
            return this.textureSet;
        }
    }

    public TextureSet setTextureSet(TextureSet set) {
        return this.setTextureSet(set, this.vTier);
    }

    public TextureSet setTextureSet(TextureSet set, int aTier) {
        if (set != null) {
            Logger.MATERIALS("Set textureset for " + this.localizedName + " to be " + set.mSetName + ". This textureSet was supplied.");
            return set;
        }
        int aGem = 0;
        int aShiny = 0;
        Object aSet = null;
        for (MaterialStack materialStack : this.getComposites()) {
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().AER) {
                ++aGem;
            } else if (materialStack.getStackMaterial() == ELEMENT.getInstance().AQUA) {
                ++aGem;
            } else if (materialStack.getStackMaterial() == ELEMENT.getInstance().IGNIS) {
                ++aGem;
            } else if (materialStack.getStackMaterial() == ELEMENT.getInstance().TERRA) {
                ++aGem;
            } else if (materialStack.getStackMaterial() == ELEMENT.getInstance().MAGIC) {
                ++aGem;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().GOLD) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().SILVER) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().PLATINUM) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().AMERICIUM) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().TITANIUM) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().GERMANIUM) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().GALLIUM) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().MERCURY) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().MAGIC) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() == ELEMENT.getInstance().SAMARIUM) {
                ++aShiny;
                continue;
            }
            if (materialStack.getStackMaterial() != ELEMENT.getInstance().TANTALUM) continue;
            ++aShiny;
        }
        if (aSet == null && aGem >= this.getComposites().size() / 2) {
            if (MathUtils.isNumberEven(aGem)) {
                Logger.MATERIALS("Set textureset for " + this.localizedName + " to be " + TextureSet.SET_GEM_HORIZONTAL.mSetName + ".");
                return TextureSet.SET_GEM_HORIZONTAL;
            }
            Logger.MATERIALS("Set textureset for " + this.localizedName + " to be " + TextureSet.SET_GEM_VERTICAL.mSetName + ".");
            return TextureSet.SET_GEM_VERTICAL;
        }
        if (aSet == null && aShiny >= this.getComposites().size() / 3) {
            Logger.MATERIALS("Set textureset for " + this.localizedName + " to be " + TextureSet.SET_SHINY.mSetName + ".");
            return TextureSet.SET_SHINY;
        }
        AutoMap<Material> sets = new AutoMap<Material>();
        if (this.vMaterialInput != null) {
            for (MaterialStack r : this.vMaterialInput) {
                if (r.getStackMaterial().getTextureSet().mSetName.toLowerCase().contains("fluid")) {
                    sets.put(ELEMENT.getInstance().GOLD);
                    continue;
                }
                sets.put(r.getStackMaterial());
            }
            TextureSet textureSet = MaterialUtils.getMostCommonTextureSet(new ArrayList<Material>(sets.values()));
            if (textureSet != null && textureSet instanceof TextureSet) {
                Logger.MATERIALS("Set textureset for " + this.localizedName + " to be " + textureSet.mSetName + ".");
                return textureSet;
            }
        }
        Logger.MATERIALS("Set textureset for " + this.localizedName + " to be " + Materials.Iron.mIconSet.mSetName + ". [Fallback]");
        return Materials.Gold.mIconSet;
    }

    public final String getLocalizedName() {
        if (this.localizedName != null) {
            return this.localizedName;
        }
        return "ERROR BAD LOCALIZED NAME";
    }

    public final String getUnlocalizedName() {
        if (this.unlocalizedName != null) {
            return this.unlocalizedName;
        }
        return "ERROR.BAD.UNLOCALIZED.NAME";
    }

    public final String getTranslatedName() {
        if (this.translatedName != null) {
            return this.translatedName;
        }
        return "ERROR.BAD.TRANSLATED.NAME";
    }

    public final MaterialState getState() {
        return this.materialState;
    }

    public final short[] getRGB() {
        if (this.RGBA != null) {
            return this.RGBA;
        }
        return new short[]{255, 0, 0};
    }

    public final short[] getRGBA() {
        if (this.RGBA != null) {
            if (this.RGBA.length == 4) {
                return this.RGBA;
            }
            return new short[]{this.RGBA[0], this.RGBA[1], this.RGBA[2], 0};
        }
        return new short[]{255, 0, 0, 0};
    }

    public final int getRgbAsHex() {
        int returnValue = Utils.rgbtoHexValue(this.RGBA[0], this.RGBA[1], this.RGBA[2]);
        if (returnValue == 0) {
            return (Integer)this.dataVar;
        }
        return Utils.rgbtoHexValue(this.RGBA[0], this.RGBA[1], this.RGBA[2]);
    }

    public final long getProtons() {
        return this.vProtons;
    }

    public final long getNeutrons() {
        return this.vNeutrons;
    }

    public final long getMass() {
        return this.vProtons + this.vNeutrons;
    }

    public final int getMeltingPointC() {
        return this.meltingPointC;
    }

    public final int getBoilingPointC() {
        return this.boilingPointC;
    }

    public final int getMeltingPointK() {
        return this.meltingPointK;
    }

    public final int getBoilingPointK() {
        return this.boilingPointK;
    }

    public final boolean requiresBlastFurnace() {
        return this.usesBlastFurnace;
    }

    public final ItemStack getComponentByPrefix(OrePrefixes aPrefix, int stacksize) {
        ItemStack i;
        String aKey = aPrefix.name();
        Map<String, ItemStack> g = mComponentMap.get(this.unlocalizedName);
        if (g == null) {
            HashMap<String, ItemStack> aMap = new HashMap<String, ItemStack>();
            mComponentMap.put(this.unlocalizedName, aMap);
            g = aMap;
        }
        if ((i = g.get(aKey)) != null) {
            return ItemUtils.getSimpleStack(i, stacksize);
        }
        Materials Erf = MaterialUtils.getMaterial(this.unlocalizedName);
        if (Erf != null && !MaterialUtils.isNullGregtechMaterial(Erf)) {
            ItemStack Erg = ItemUtils.getOrePrefixStack(aPrefix, Erf, stacksize);
            if (Erg != null && ItemUtils.checkForInvalidItems(Erg)) {
                Logger.MATERIALS("Found \"" + aKey + this.unlocalizedName + "\" using backup GT Materials option.");
                g.put(aKey, Erg);
                mComponentMap.put(this.unlocalizedName, g);
                return Erg;
            }
            if (aPrefix == OrePrefixes.cell && (Erg = ItemUtils.getOrePrefixStack(OrePrefixes.cellMolten, Erf, stacksize)) != null && ItemUtils.checkForInvalidItems(Erg)) {
                Logger.MATERIALS("Found \"" + OrePrefixes.cellMolten.name() + this.unlocalizedName + "\" using backup GT Materials option.");
                g.put(aKey, Erg);
                mComponentMap.put(this.unlocalizedName, g);
                return Erg;
            }
        } else {
            ItemStack u = ItemUtils.getItemStackOfAmountFromOreDictNoBroken(aKey + this.unlocalizedName, stacksize);
            if (u != null) {
                g.put(aKey, u);
                mComponentMap.put(this.unlocalizedName, g);
                return u;
            }
        }
        return ItemUtils.getErrorStack(stacksize, aKey + this.unlocalizedName + " x" + stacksize);
    }

    public final Block getBlock() {
        Block b = Block.func_149634_a((Item)this.getBlock(1).func_77973_b());
        if (b == null) {
            Logger.INFO("[ERROR] Tried to get invalid block for " + this.getLocalizedName() + ", returning debug block instead.");
        }
        return b != null ? b : Blocks.field_150470_am;
    }

    public final ItemStack getBlock(int stacksize) {
        ItemStack i = this.getComponentByPrefix(OrePrefixes.block, stacksize);
        return i != null ? i : ItemUtils.getItemStackOfAmountFromOreDictNoBroken("block" + this.unlocalizedName, stacksize);
    }

    public final ItemStack getDust(int stacksize) {
        ItemStack i = this.getComponentByPrefix(OrePrefixes.dust, stacksize);
        return i != null ? i : ItemUtils.getGregtechDust("dust" + this.unlocalizedName, stacksize);
    }

    public final ItemStack getSmallDust(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.dustSmall, stacksize);
    }

    public final ItemStack getTinyDust(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.dustTiny, stacksize);
    }

    public final ItemStack getIngot(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.ingot, stacksize);
    }

    public final ItemStack getHotIngot(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.ingotHot, stacksize);
    }

    public final ItemStack getPlate(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.plate, stacksize);
    }

    public final ItemStack getPlateDouble(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.plateDouble, stacksize);
    }

    public final ItemStack getPlateDense(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.plateDense, stacksize);
    }

    public final ItemStack getGear(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.gearGt, stacksize);
    }

    public final ItemStack getRod(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.stick, stacksize);
    }

    public final ItemStack getLongRod(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.stickLong, stacksize);
    }

    public final ItemStack getBolt(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.bolt, stacksize);
    }

    public final ItemStack getScrew(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.screw, stacksize);
    }

    public final ItemStack getFineWire(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireFine, stacksize);
    }

    public final ItemStack getFoil(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.foil, stacksize);
    }

    public final ItemStack getRing(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.ring, stacksize);
    }

    public final ItemStack getRotor(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.rotor, stacksize);
    }

    public final ItemStack getFrameBox(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.frameGt, stacksize);
    }

    public final ItemStack getCell(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cell, stacksize);
    }

    public final ItemStack getPlasmaCell(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cellPlasma, stacksize);
    }

    public final ItemStack getNugget(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.nugget, stacksize);
    }

    public final ItemStack getWire01(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireGt01, stacksize);
    }

    public final ItemStack getWire02(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireGt02, stacksize);
    }

    public final ItemStack getWire04(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireGt04, stacksize);
    }

    public final ItemStack getWire08(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireGt08, stacksize);
    }

    public final ItemStack getWire12(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireGt12, stacksize);
    }

    public final ItemStack getWire16(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.wireGt16, stacksize);
    }

    public final ItemStack getCable01(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cableGt01, stacksize);
    }

    public final ItemStack getCable02(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cableGt02, stacksize);
    }

    public final ItemStack getCable04(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cableGt04, stacksize);
    }

    public final ItemStack getCable08(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cableGt08, stacksize);
    }

    public final ItemStack getCable12(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cableGt12, stacksize);
    }

    public final ItemStack getCable16(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.cableGt16, stacksize);
    }

    public final ItemStack getOre(int stacksize) {
        return ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ore" + Utils.sanitizeString(this.getUnlocalizedName()), stacksize);
    }

    public final Block getOreBlock(int stacksize) {
        try {
            ItemStack a1 = this.getOre(1);
            Item a2 = a1.func_77973_b();
            Block a3 = Block.func_149634_a((Item)a2);
            if (a3 != null) {
                return a3;
            }
            Block x = Block.func_149634_a((Item)ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ore" + Utils.sanitizeString(this.unlocalizedName), stacksize).func_77973_b());
            if (x != null) {
                return x;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Blocks.field_150348_b;
    }

    public final ItemStack getCrushed(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.crushed, stacksize);
    }

    public final ItemStack getCrushedPurified(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.crushedPurified, stacksize);
    }

    public final ItemStack getCrushedCentrifuged(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.crushedCentrifuged, stacksize);
    }

    public final ItemStack getDustPurified(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.dustPure, stacksize);
    }

    public final ItemStack getDustImpure(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.dustImpure, stacksize);
    }

    public final ItemStack getMilled(int stacksize) {
        return this.getComponentByPrefix(OrePrefixes.milled, stacksize);
    }

    public final boolean hasSolidForm() {
        return ItemUtils.checkForInvalidItems(new ItemStack[]{this.getDust(1), this.getBlock(1), this.getTinyDust(1), this.getSmallDust(1)});
    }

    public final ItemStack[] getMaterialComposites() {
        if (this.vMaterialInput != null && !this.vMaterialInput.isEmpty()) {
            ItemStack[] temp = new ItemStack[this.vMaterialInput.size()];
            for (int i = 0; i < this.vMaterialInput.size(); ++i) {
                ItemStack testNull = null;
                try {
                    testNull = this.vMaterialInput.get(i).getValidStack();
                }
                catch (Throwable r) {
                    Logger.MATERIALS("Failed gathering material stack for " + this.localizedName + ".");
                    Logger.MATERIALS("What Failed: Length:" + this.vMaterialInput.size() + " current:" + i);
                }
                try {
                    if (testNull == null) continue;
                    temp[i] = this.vMaterialInput.get(i).getValidStack();
                    continue;
                }
                catch (Throwable r) {
                    Logger.MATERIALS("Failed setting slot " + i + ", using " + this.localizedName);
                }
            }
            return temp;
        }
        return new ItemStack[0];
    }

    public final ArrayList<MaterialStack> getComposites() {
        return this.vMaterialInput;
    }

    public final int[] getMaterialCompositeStackSizes() {
        if (!this.vMaterialInput.isEmpty()) {
            int[] temp = new int[this.vMaterialInput.size()];
            for (int i = 0; i < this.vMaterialInput.size(); ++i) {
                temp[i] = this.vMaterialInput.get(i) != null ? this.vMaterialInput.get((int)i).getDustStack().field_77994_a : 0;
            }
            return temp;
        }
        return new int[0];
    }

    private final short getComponentCount(MaterialStack[] inputs) {
        if (inputs == null || inputs.length < 1) {
            return 1;
        }
        int counterTemp = 0;
        for (MaterialStack m : inputs) {
            if (m.getStackMaterial() == null) continue;
            ++counterTemp;
        }
        if (counterTemp != 0) {
            return (short)counterTemp;
        }
        return 1;
    }

    public final long[] getSmallestRatio(ArrayList<MaterialStack> tempInput) {
        if (tempInput != null && !tempInput.isEmpty()) {
            Logger.MATERIALS("length: " + tempInput.size());
            Logger.MATERIALS("(inputs != null): " + (tempInput != null));
            long[] tempRatio = new long[tempInput.size()];
            for (int x = 0; x < tempInput.size(); ++x) {
                if (tempInput.get(x) == null) continue;
                tempRatio[x] = tempInput.get(x).getPartsPerOneHundred();
            }
            long[] smallestRatio = MathUtils.simplifyNumbersToSmallestForm(tempRatio);
            if (smallestRatio.length > 0) {
                String tempRatioStringThing1 = "";
                for (int r = 0; r < tempRatio.length; ++r) {
                    tempRatioStringThing1 = tempRatioStringThing1 + tempRatio[r] + " : ";
                }
                Logger.MATERIALS("Default Ratio: " + tempRatioStringThing1);
                String tempRatioStringThing = "";
                int tempSmallestCraftingUseSize = 0;
                for (int r = 0; r < smallestRatio.length; ++r) {
                    tempRatioStringThing = tempRatioStringThing + smallestRatio[r] + " : ";
                    tempSmallestCraftingUseSize = (int)((long)tempSmallestCraftingUseSize + smallestRatio[r]);
                }
                Logger.MATERIALS("Smallest Ratio: " + tempRatioStringThing);
                return smallestRatio;
            }
        }
        return new long[0];
    }

    public final String getToolTip(String chemSymbol, long aMultiplier, boolean aShowQuestionMarks) {
        if (!aShowQuestionMarks && (this.vChemicalFormula.equals("?") || this.vChemicalFormula.equals("??"))) {
            return "";
        }
        Logger.MATERIALS("===============| Calculating Atomic Formula for " + this.localizedName + " |===============");
        if (!chemSymbol.equals("")) {
            return chemSymbol;
        }
        ArrayList<MaterialStack> tempInput = this.vMaterialInput;
        if (tempInput != null) {
            if (!tempInput.isEmpty()) {
                String dummyFormula = "";
                long[] dummyFormulaArray = this.getSmallestRatio(tempInput);
                if (dummyFormulaArray != null) {
                    if (dummyFormulaArray.length >= 1) {
                        for (int e = 0; e < tempInput.size(); ++e) {
                            MaterialStack g = tempInput.get(e);
                            if (g == null) continue;
                            if (g.getStackMaterial() != null) {
                                String aChemSymbol = g.getStackMaterial().vChemicalSymbol;
                                String aChemFormula = g.getStackMaterial().vChemicalFormula;
                                if (aChemSymbol == null) {
                                    aChemSymbol = "??";
                                }
                                if (aChemFormula == null) {
                                    aChemFormula = "??";
                                }
                                if (!aChemSymbol.equals("??")) {
                                    if (dummyFormulaArray[e] > 1L) {
                                        if (aChemFormula.length() > 3) {
                                            dummyFormula = dummyFormula + "(" + aChemFormula + ")" + dummyFormulaArray[e];
                                            continue;
                                        }
                                        dummyFormula = dummyFormula + aChemFormula + dummyFormulaArray[e];
                                        continue;
                                    }
                                    if (dummyFormulaArray[e] == 1L) {
                                        if (aChemFormula.length() > 3) {
                                            dummyFormula = dummyFormula + "(" + aChemFormula + ")";
                                            continue;
                                        }
                                        dummyFormula = dummyFormula + aChemFormula;
                                        continue;
                                    }
                                    dummyFormula = dummyFormula + "??";
                                    continue;
                                }
                                dummyFormula = dummyFormula + "??";
                                continue;
                            }
                            dummyFormula = dummyFormula + "??";
                        }
                        return StringUtils.subscript(dummyFormula);
                    }
                    Logger.MATERIALS("dummyFormulaArray <= 0");
                }
                Logger.MATERIALS("dummyFormulaArray == null");
            }
            Logger.MATERIALS("tempInput.length <= 0");
        }
        Logger.MATERIALS("tempInput == null");
        return "??";
    }

    public final boolean queueFluidGeneration() {
        this.isFluidQueued = true;
        return true;
    }

    public static final void generateQueuedFluids() {
        for (Material m : mMaterialMap) {
            if (!m.isFluidQueued) continue;
        }
    }

    public final Fluid generateFluid() {
        if (this.materialState == MaterialState.ORE) {
            return null;
        }
        Fluid aGTBaseFluid = null;
        Materials n1 = MaterialUtils.getMaterial(this.getLocalizedName(), Utils.sanitizeString(this.getLocalizedName()));
        Materials n2 = MaterialUtils.getMaterial(this.getUnlocalizedName(), Utils.sanitizeString(this.getUnlocalizedName()));
        FluidStack f1 = FluidUtils.getWildcardFluidStack(n1, 1);
        FluidStack f2 = FluidUtils.getWildcardFluidStack(n2, 1);
        FluidStack f3 = FluidUtils.getWildcardFluidStack(Utils.sanitizeString(this.getUnlocalizedName(), new char[]{'-', '_'}), 1);
        FluidStack f4 = FluidUtils.getWildcardFluidStack(Utils.sanitizeString(this.getLocalizedName(), new char[]{'-', '_'}), 1);
        if (f1 != null) {
            aGTBaseFluid = f1.getFluid();
        } else if (f2 != null) {
            aGTBaseFluid = f2.getFluid();
        } else if (f3 != null) {
            aGTBaseFluid = f3.getFluid();
        } else if (f4 != null) {
            aGTBaseFluid = f4.getFluid();
        }
        ItemStack aFullCell = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + this.getUnlocalizedName(), 1);
        ItemStack aFullCell2 = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + this.getLocalizedName(), 1);
        ItemStack aFullCell3 = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + Utils.sanitizeString(this.getUnlocalizedName(), new char[]{'-', '_'}), 1);
        ItemStack aFullCell4 = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + Utils.sanitizeString(this.getLocalizedName(), new char[]{'-', '_'}), 1);
        Logger.MATERIALS("Generating our own fluid.");
        if (!ItemUtils.checkForInvalidItems(new ItemStack[]{aFullCell, aFullCell2, aFullCell3, aFullCell4})) {
            if (this.vGenerateCells) {
                BaseItemCell g = new BaseItemCell(this);
                aFullCell = ItemUtils.getSimpleStack(g);
                Logger.MATERIALS("Generated a cell for " + this.getUnlocalizedName());
            } else {
                Logger.MATERIALS("Did not generate a cell for " + this.getUnlocalizedName());
            }
        } else if (aFullCell != null) {
            this.registerComponentForMaterial(BaseItemComponent.ComponentTypes.CELL, aFullCell);
        } else if (aFullCell2 != null) {
            this.registerComponentForMaterial(BaseItemComponent.ComponentTypes.CELL, aFullCell2);
        } else if (aFullCell3 != null) {
            this.registerComponentForMaterial(BaseItemComponent.ComponentTypes.CELL, aFullCell3);
        } else if (aFullCell4 != null) {
            this.registerComponentForMaterial(BaseItemComponent.ComponentTypes.CELL, aFullCell4);
        }
        if (aGTBaseFluid != null) {
            return aGTBaseFluid;
        }
        if (this.materialState == MaterialState.SOLID) {
            return FluidUtils.addGTFluid(this.getUnlocalizedName(), "Molten " + this.getLocalizedName(), this.RGBA, 4, this.getMeltingPointK(), aFullCell, ItemUtils.getEmptyCell(), 1000, this.vGenerateCells);
        }
        if (this.materialState == MaterialState.LIQUID || this.materialState == MaterialState.PURE_LIQUID) {
            return FluidUtils.addGTFluid(this.getUnlocalizedName(), this.getLocalizedName(), this.RGBA, 0, this.getMeltingPointK(), aFullCell, ItemUtils.getEmptyCell(), 1000, this.vGenerateCells);
        }
        if (this.materialState == MaterialState.GAS || this.materialState == MaterialState.PURE_GAS) {
            return FluidUtils.generateGas(this.unlocalizedName, this.getLocalizedName(), this.getMeltingPointK(), this.getRGBA(), this.vGenerateCells);
        }
        return this.generatePlasma();
    }

    public final Fluid generatePlasma() {
        if (this.materialState == MaterialState.ORE) {
            return null;
        }
        Materials isValid = this.tryFindGregtechMaterialEquivalent();
        if (!this.vGenerateCells) {
            return null;
        }
        if (isValid != null) {
            for (Materials m : invalidMaterials.values()) {
                if (isValid != m) continue;
                return null;
            }
            if (isValid.mPlasma != null) {
                Logger.MATERIALS("Using a pre-defined Plasma from GT.");
                return isValid.mPlasma;
            }
        }
        Logger.MATERIALS("Generating our own Plasma.");
        return FluidUtils.addGTPlasma(this);
    }

    public Fluid getFluid() {
        return this.mFluid;
    }

    public Fluid getPlasma() {
        return this.mPlasma;
    }

    public final FluidStack getFluidStack(int fluidAmount) {
        if (this.mFluid == null) {
            return null;
        }
        FluidStack moltenFluid = new FluidStack(this.mFluid, fluidAmount);
        return moltenFluid;
    }

    public final boolean setFluid(Fluid aFluid) {
        if (this.mFluid == null) {
            this.mFluid = aFluid;
            return true;
        }
        return false;
    }

    public final int calculateMeltingPoint() {
        try {
            AutoMap<Integer> aDataSet = new AutoMap<Integer>();
            for (MaterialStack m : this.vMaterialInput) {
                aDataSet.put(m.getStackMaterial().getMeltingPointC());
            }
            long aAverage = MathUtils.getIntAverage(aDataSet);
            return MathUtils.safeInt(aAverage);
        }
        catch (Throwable r) {
            r.printStackTrace();
            return 500;
        }
    }

    public final int calculateBoilingPoint() {
        try {
            AutoMap<Integer> aDataSet = new AutoMap<Integer>();
            for (MaterialStack m : this.vMaterialInput) {
                aDataSet.put(m.getStackMaterial().getBoilingPointC());
            }
            long aAverage = MathUtils.getIntAverage(aDataSet);
            return MathUtils.safeInt(aAverage);
        }
        catch (Throwable r) {
            r.printStackTrace();
            return 2500;
        }
    }

    public final long calculateProtons() {
        try {
            AutoMap<Long> aDataSet = new AutoMap<Long>();
            for (MaterialStack m : this.vMaterialInput) {
                aDataSet.put(m.getStackMaterial().getProtons());
            }
            long aAverage = MathUtils.getLongAverage(aDataSet);
            return MathUtils.safeInt(aAverage);
        }
        catch (Throwable r) {
            r.printStackTrace();
            return 50L;
        }
    }

    public final long calculateNeutrons() {
        try {
            AutoMap<Long> aDataSet = new AutoMap<Long>();
            for (MaterialStack m : this.vMaterialInput) {
                aDataSet.put(m.getStackMaterial().getNeutrons());
            }
            long aAverage = MathUtils.getLongAverage(aDataSet);
            return MathUtils.safeInt(aAverage);
        }
        catch (Throwable r) {
            r.printStackTrace();
            return 75L;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!Material.class.isInstance(obj)) {
            return false;
        }
        Material aObj = (Material)obj;
        return aObj.unlocalizedName.equals(this.unlocalizedName) && aObj.localizedName.equals(this.localizedName);
    }

    public boolean registerComponentForMaterial(FluidStack aStack) {
        return Material.registerComponentForMaterial(this, aStack);
    }

    private static boolean registerComponentForMaterial(Material componentMaterial, FluidStack aStack) {
        if (componentMaterial != null && aStack != null && componentMaterial.mFluid == null) {
            componentMaterial.mFluid = aStack.getFluid();
            return true;
        }
        return false;
    }

    public boolean registerComponentForMaterial(BaseItemComponent.ComponentTypes aPrefix, ItemStack aStack) {
        return Material.registerComponentForMaterial(this, aPrefix.getGtOrePrefix(), aStack);
    }

    public boolean registerComponentForMaterial(OrePrefixes aPrefix, ItemStack aStack) {
        return Material.registerComponentForMaterial(this, aPrefix, aStack);
    }

    public static boolean registerComponentForMaterial(Material componentMaterial, BaseItemComponent.ComponentTypes aPrefix, ItemStack aStack) {
        return Material.registerComponentForMaterial(componentMaterial, aPrefix.getGtOrePrefix(), aStack);
    }

    public static boolean registerComponentForMaterial(Material componentMaterial, OrePrefixes aPrefix, ItemStack aStack) {
        String aKey;
        ItemStack x;
        if (componentMaterial == null) {
            return false;
        }
        Map<String, ItemStack> aMap = mComponentMap.get(componentMaterial.getUnlocalizedName());
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        if ((x = aMap.get(aKey = aPrefix.name())) == null) {
            aMap.put(aKey, aStack);
            Logger.MATERIALS("Registering a material component. Item: [" + componentMaterial.getUnlocalizedName() + "] Map: [" + aKey + "]");
            mComponentMap.put(componentMaterial.getUnlocalizedName(), aMap);
            return true;
        }
        Logger.MATERIALS("Tried to double register a material component. ");
        return false;
    }

    public Materials tryFindGregtechMaterialEquivalent() {
        return Material.tryFindGregtechMaterialEquivalent(this);
    }

    public static Materials tryFindGregtechMaterialEquivalent(Material aMaterial) {
        String aMaterialName = aMaterial.getLocalizedName();
        Materials aGregtechMaterial = Materials.get((String)aMaterialName);
        if (aGregtechMaterial == null || MaterialUtils.isNullGregtechMaterial(aGregtechMaterial)) {
            aGregtechMaterial = Materials.get((String)(aMaterialName = aMaterialName.replace(" ", "_")));
            if (aGregtechMaterial == null || MaterialUtils.isNullGregtechMaterial(aGregtechMaterial)) {
                aGregtechMaterial = Materials.get((String)(aMaterialName = aMaterialName.replace(" ", "")));
                if (aGregtechMaterial == null || MaterialUtils.isNullGregtechMaterial(aGregtechMaterial)) {
                    return null;
                }
                return aGregtechMaterial;
            }
            return aGregtechMaterial;
        }
        return aGregtechMaterial;
    }

    public void setWerkstoffID(short werkstoffID) {
        this.werkstoffID = werkstoffID;
    }
}

