/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.ore;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseOreComponent
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon base;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlay;
    public final Material componentMaterial;
    public final String materialName;
    public final String unlocalName;
    public final ComponentTypes componentType;
    public final int componentColour;
    public Object extraData;

    public BaseOreComponent(Material material, ComponentTypes componentType) {
        this.componentMaterial = material;
        this.unlocalName = componentType.COMPONENT_NAME + material.getUnlocalizedName();
        this.materialName = material.getLocalizedName();
        this.componentType = componentType;
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(this.unlocalName);
        this.func_77625_d(64);
        this.componentColour = material.getRgbAsHex();
        GameRegistry.registerItem((Item)this, (String)this.unlocalName);
        this.registerComponent();
        GT_OreDictUnificator.registerOre((Object)(componentType.getComponent() + material.getUnlocalizedName()), (ItemStack)ItemUtils.getSimpleStack(this));
        if (!LoadedMods.Thaumcraft || this.componentMaterial.isRadioactive) {
            // empty if block
        }
    }

    public boolean registerComponent() {
        Logger.MATERIALS("Attempting to register " + this.func_77658_a() + ".");
        if (this.componentMaterial == null) {
            Logger.MATERIALS("Tried to register " + this.func_77658_a() + " but the material was null.");
            return false;
        }
        Map<String, ItemStack> aMap = Material.mComponentMap.get(this.componentMaterial.getUnlocalizedName());
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        String aKey = "Invalid";
        if (this.componentType == ComponentTypes.CRUSHED) {
            aKey = OrePrefixes.crushed.name();
        } else if (this.componentType == ComponentTypes.CRUSHEDCENTRIFUGED) {
            aKey = OrePrefixes.crushedCentrifuged.name();
        } else if (this.componentType == ComponentTypes.CRUSHEDPURIFIED) {
            aKey = OrePrefixes.crushedPurified.name();
        } else if (this.componentType == ComponentTypes.DUST) {
            aKey = OrePrefixes.dust.name();
        } else if (this.componentType == ComponentTypes.DUSTIMPURE) {
            aKey = OrePrefixes.dustImpure.name();
        } else if (this.componentType == ComponentTypes.DUSTPURE) {
            aKey = OrePrefixes.dustPure.name();
        } else if (this.componentType == ComponentTypes.MILLED) {
            aKey = OrePrefixes.milled.name();
        }
        ItemStack x = aMap.get(aKey);
        if (x == null) {
            aMap.put(aKey, ItemUtils.getSimpleStack(this));
            Logger.MATERIALS("Registering a material component. Item: [" + this.componentMaterial.getUnlocalizedName() + "] Map: [" + aKey + "]");
            Material.mComponentMap.put(this.componentMaterial.getUnlocalizedName(), aMap);
            return true;
        }
        Logger.MATERIALS("Tried to double register a material component. ");
        return false;
    }

    public final String getMaterialName() {
        return this.materialName;
    }

    public final void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        if (this.materialName != null && !this.materialName.equals("")) {
            if (this.componentMaterial != null) {
                if (!this.componentMaterial.vChemicalFormula.contains("?")) {
                    list.add(Utils.sanitizeStringKeepBrackets(this.componentMaterial.vChemicalFormula));
                } else if (this.componentMaterial.vChemicalFormula.contains("?")) {
                    String temp = this.componentMaterial.vChemicalFormula;
                    temp = temp.replace(" ", "");
                    temp = temp.replace("-", "");
                    temp = temp.replace("_", "");
                    temp = temp.replace("!", "");
                    temp = temp.replace("@", "");
                    temp = temp.replace("#", "");
                    temp = temp.replace(" ", "");
                    list.add(temp);
                }
                if (this.componentMaterial.isRadioactive) {
                    list.add(CORE.GT_Tooltip_Radioactive.get() + " | Level: " + this.componentMaterial.vRadiationLevel);
                }
            } else {
                String aChemicalFormula = Material.sChemicalFormula.get(this.materialName.toLowerCase());
                if (aChemicalFormula != null && aChemicalFormula.length() > 0) {
                    list.add(Utils.sanitizeStringKeepBrackets(aChemicalFormula));
                }
            }
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (this.componentMaterial != null && entityHolding instanceof EntityPlayer && !((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d) {
            EntityUtils.applyRadiationDamageToEntity(iStack.field_77994_a, this.componentMaterial.vRadiationLevel, world, entityHolding);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return this.componentType.hasOverlay();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        if (this.componentType == ComponentTypes.MILLED) {
            this.base = par1IconRegister.func_94245_a("miscutils:processing/MilledOre/milled");
            if (this.componentType.hasOverlay()) {
                this.overlay = par1IconRegister.func_94245_a("miscutils:processing/MilledOre/milled_OVERLAY");
            }
        } else if (CORE.ConfigSwitches.useGregtechTextures) {
            this.base = par1IconRegister.func_94245_a("gregtech:materialicons/METALLIC/" + this.componentType.COMPONENT_NAME);
            if (this.componentType.hasOverlay()) {
                this.overlay = par1IconRegister.func_94245_a("gregtech:materialicons/METALLIC/" + this.componentType.COMPONENT_NAME + "_OVERLAY");
            }
        } else {
            this.base = par1IconRegister.func_94245_a("miscutils:item" + this.componentType.getComponent());
            if (this.componentType.hasOverlay()) {
                this.overlay = par1IconRegister.func_94245_a("miscutils:item" + this.componentType.getComponent() + "_Overlay");
            }
        }
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        if (this.componentType == ComponentTypes.MILLED) {
            if (renderPass == 1) {
                return Utils.rgbtoHexValue(230, 230, 230);
            }
            return this.componentColour;
        }
        if (renderPass == 0 && !CORE.ConfigSwitches.useGregtechTextures) {
            return this.componentColour;
        }
        if (renderPass == 1 && CORE.ConfigSwitches.useGregtechTextures) {
            return Utils.rgbtoHexValue(230, 230, 230);
        }
        return this.componentColour;
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 0) {
            return this.base;
        }
        return this.overlay;
    }

    public static enum ComponentTypes {
        DUST("dust", "", " Dust", true),
        DUSTIMPURE("dustImpure", "Impure ", " Dust", true),
        DUSTPURE("dustPure", "Purified ", " Dust", true),
        CRUSHED("crushed", "Crushed ", " Ore", true),
        CRUSHEDCENTRIFUGED("crushedCentrifuged", "Centrifuged Crushed ", " Ore", true),
        CRUSHEDPURIFIED("crushedPurified", "Purified Crushed ", " Ore", true),
        MILLED("milled", "Milled ", " Ore", true);

        private String COMPONENT_NAME;
        private String PREFIX;
        private String DISPLAY_NAME;
        private boolean HAS_OVERLAY;

        private ComponentTypes(String LocalName, String prefix, String DisplayName, boolean overlay) {
            this.COMPONENT_NAME = LocalName;
            this.PREFIX = prefix;
            this.DISPLAY_NAME = DisplayName;
            this.HAS_OVERLAY = overlay;
        }

        public String getComponent() {
            return this.COMPONENT_NAME;
        }

        public String getName() {
            return this.DISPLAY_NAME;
        }

        public boolean hasOverlay() {
            return this.HAS_OVERLAY;
        }

        public String getPrefix() {
            return this.PREFIX;
        }
    }
}

