/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.inventories.modulartable;

import gtPlusPlus.core.tileentities.machines.TileEntityModularityTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryModularOutput
implements IInventory {
    private final String name = "Inventory Output";
    public static final int INV_SIZE = 3;
    private int mRecpeTime = -1;
    private ItemStack[] inventory = new ItemStack[3];

    public void readFromNBT(NBTTagCompound nbt) {
        if (this.mRecpeTime > -1) {
            nbt.func_74768_a("mRecipeTime", this.mRecpeTime);
        }
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[3];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= 3) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        if (nbt.func_74764_b("mRecipeTime")) {
            this.mRecpeTime = nbt.func_74762_e("mRecipeTime");
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            stack.func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int setRecipeTime(int mTime) {
        this.mRecpeTime = mTime;
        return this.mRecpeTime;
    }

    public int getRecipeTime() {
        return this.mRecpeTime;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a > amount) {
                stack = stack.func_77979_a(amount);
                this.func_70296_d();
            } else {
                this.func_70299_a(slot, null);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack temp = this.func_70301_a(i);
            if (temp != null) {
                // empty if block
            }
            if (temp == null || temp.field_77994_a != 0) continue;
            this.inventory[i] = null;
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (slot == 0) {
            return TileEntityModularityTable.isValidUpgrade(itemstack);
        }
        return TileEntityModularityTable.isValidModularPiece(itemstack);
    }
}

