/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.random;

import gtPlusPlus.api.objects.random.CSPRNG_DO_NOT_USE;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;
import java.util.UUID;

public class UUIDGenerator {
    public static final int TYPE1 = 1;
    public static final int TYPE4 = 4;
    private static final byte IDX_TIME_HI = 6;
    private static final byte IDX_TYPE = 6;
    private static final byte IDX_TIME_MID = 4;
    private static final byte IDX_TIME_LO = 0;
    private static final byte IDX_TIME_SEQ = 8;
    private static final byte IDX_VARIATION = 8;
    private static final byte TS_TIME_LO_IDX = 4;
    private static final byte TS_TIME_LO_LEN = 4;
    private static final byte TS_TIME_MID_IDX = 2;
    private static final byte TS_TIME_MID_LEN = 2;
    private static final byte TS_TIME_HI_IDX = 0;
    private static final byte TS_TIME_HI_LEN = 2;
    private static final long GREG_OFFSET = 12219292800000L;
    private static final long MILLI_MULT = 10000L;
    private static final byte TYPE_TIME_BASED = 16;
    private Random RANDOM;
    private byte[] IP;
    private int _counter;
    private long _currentMillis;
    private long _lastMillis = 0L;
    private static final int MAX_14BIT = 16383;
    private short _seq = 0;
    private boolean type1Initialized = false;

    private synchronized void initializeForType1() {
        if (this.type1Initialized) {
            return;
        }
        this.RANDOM = CSPRNG_DO_NOT_USE.generate();
        this._seq = (short)this.RANDOM.nextInt(16383);
        byte[] ip = null;
        try {
            ip = InetAddress.getLocalHost().getAddress();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.IP = new byte[6];
        this.RANDOM.nextBytes(this.IP);
        for (int i = 0; i < ip.length; ++i) {
            int n = 2 + i % 4;
            this.IP[n] = (byte)(this.IP[n] ^ ip[i]);
        }
        this.type1Initialized = true;
    }

    public byte[] next(int type) {
        if (type == 4) {
            return this.createType4();
        }
        return this.createType1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] createType1() {
        if (!this.type1Initialized) {
            this.initializeForType1();
        }
        byte[] uuid = new byte[16];
        System.arraycopy(this.IP, 0, uuid, 10, this.IP.length);
        long now = 0L;
        Class<UUIDGenerator> clazz = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            now = this.getTime();
            uuid[8] = (byte)((this._seq & 0x3F00) >>> 8);
            uuid[8] = (byte)(uuid[8] | 0x80);
            uuid[9] = (byte)(this._seq & 0xFF);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            byte[] timeBytes = Bytes.toBytes(now);
            System.arraycopy(timeBytes, 4, uuid, 0, 4);
            System.arraycopy(timeBytes, 2, uuid, 4, 2);
            System.arraycopy(timeBytes, 0, uuid, 6, 2);
            uuid[6] = (byte)(uuid[6] | 0x10);
            return uuid;
        }
    }

    private byte[] createType4() {
        UUID type4 = UUID.randomUUID();
        byte[] uuid = new byte[16];
        this.longToBytes(type4.getMostSignificantBits(), uuid, 0);
        this.longToBytes(type4.getLeastSignificantBits(), uuid, 8);
        return uuid;
    }

    private void longToBytes(long longVal, byte[] buf, int sPos) {
        sPos += 7;
        for (int i = 0; i < 8; ++i) {
            buf[sPos - i] = (byte)(longVal >>> i * 8);
        }
    }

    public String nextString(int type) {
        byte[] bytes = this.next(type);
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (Exception e) {
            return new String(bytes);
        }
    }

    public String nextHex(int type) {
        return Base16Encoder.encode(this.next(type));
    }

    private long getTime() {
        long newTime;
        if (this.RANDOM == null) {
            this.initializeForType1();
        }
        if ((newTime = this.getUUIDTime()) <= this._lastMillis) {
            this.incrementSequence();
            newTime = this.getUUIDTime();
        }
        this._lastMillis = newTime;
        return newTime;
    }

    private long getUUIDTime() {
        if (this._currentMillis != System.currentTimeMillis()) {
            this._currentMillis = System.currentTimeMillis();
            this._counter = 0;
        }
        if ((long)(this._counter + 1) >= 10000L) {
            ++this._currentMillis;
            this._counter = 0;
        }
        long currentTime = (this._currentMillis + 12219292800000L) * 10000L;
        return currentTime + (long)this._counter++;
    }

    private void incrementSequence() {
        this._seq = (short)(this._seq + 1);
        if (this._seq > 16383) {
            this._seq = (short)this.RANDOM.nextInt(16383);
        }
    }

    public static final class Base16Encoder {
        private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        public static String encode(byte[] byteArray) {
            StringBuilder hexBuffer = new StringBuilder(byteArray.length * 2);
            for (int i = 0; i < byteArray.length; ++i) {
                for (int j = 1; j >= 0; --j) {
                    hexBuffer.append(HEX[byteArray[i] >> j * 4 & 0xF]);
                }
            }
            return hexBuffer.toString();
        }

        public static byte[] decode(String s) {
            int len = s.length();
            byte[] r = new byte[len / 2];
            for (int i = 0; i < r.length; ++i) {
                int digit1 = s.charAt(i * 2);
                int digit2 = s.charAt(i * 2 + 1);
                if (digit1 >= 48 && digit1 <= 57) {
                    digit1 -= 48;
                } else if (digit1 >= 65 && digit1 <= 70) {
                    digit1 -= 55;
                }
                if (digit2 >= 48 && digit2 <= 57) {
                    digit2 -= 48;
                } else if (digit2 >= 65 && digit2 <= 70) {
                    digit2 -= 55;
                }
                r[i] = (byte)((digit1 << 4) + digit2);
            }
            return r;
        }
    }

    public static final class Bytes {
        private Bytes() {
        }

        public static byte[] append(byte[] a, byte[] b) {
            byte[] z = new byte[a.length + b.length];
            System.arraycopy(a, 0, z, 0, a.length);
            System.arraycopy(b, 0, z, a.length, b.length);
            return z;
        }

        public static byte[] toBytes(long n) {
            return Bytes.toBytes(n, new byte[8]);
        }

        public static byte[] toBytes(long n, byte[] b) {
            b[7] = (byte)n;
            b[6] = (byte)(n >>>= 8);
            b[5] = (byte)(n >>>= 8);
            b[4] = (byte)(n >>>= 8);
            b[3] = (byte)(n >>>= 8);
            b[2] = (byte)(n >>>= 8);
            b[1] = (byte)(n >>>= 8);
            b[0] = (byte)(n >>>= 8);
            return b;
        }

        public static long toLong(byte[] b) {
            return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
        }

        public static boolean areEqual(byte[] a, byte[] b) {
            int aLength = a.length;
            if (aLength != b.length) {
                return false;
            }
            for (int i = 0; i < aLength; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }

        public static int compareTo(byte[] lhs, byte[] rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            if (lhs.length != rhs.length) {
                return lhs.length < rhs.length ? -1 : 1;
            }
            for (int i = 0; i < lhs.length; ++i) {
                if (lhs[i] < rhs[i]) {
                    return -1;
                }
                if (lhs[i] <= rhs[i]) continue;
                return 1;
            }
            return 0;
        }

        public static short toShort(byte[] b) {
            return (short)((b[1] & 0xFF) + ((b[0] & 0xFF) << 8));
        }
    }
}

