/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.api.objects.minecraft.FakeWorld;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class FakeBlockPos
extends BlockPos {
    private static final long serialVersionUID = -6442245826092414593L;
    private transient Block aBlockAtPos;
    private int aBlockMetaAtPos = 0;

    public static FakeBlockPos generateBlockPos(String sUUID) {
        String[] s2 = sUUID.split("@");
        return new FakeBlockPos(s2);
    }

    public FakeBlockPos(String[] s) {
        this(Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]), Integer.parseInt(s[0]));
    }

    public FakeBlockPos(int x, int y, int z, Block aBlock, int aMeta) {
        this(x, y, z, 0);
        this.aBlockAtPos = aBlock;
        this.aBlockMetaAtPos = aMeta;
    }

    private FakeBlockPos(int x, int y, int z, int dim) {
        this(x, y, z, (World)DimensionManager.getWorld((int)dim));
    }

    private FakeBlockPos(int x, int y, int z, World dim) {
        super(x, y, z, null);
    }

    @Override
    public String getLocationString() {
        String S = "" + this.xPos + "@" + this.yPos + "@" + this.zPos;
        return S;
    }

    @Override
    public String getUniqueIdentifier() {
        String S = "" + this.xPos + "@" + this.yPos + "@" + this.zPos + this.aBlockAtPos.func_149732_F() + "@" + this.aBlockMetaAtPos;
        return S;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash += 13 * this.xPos;
        hash += 19 * this.yPos;
        hash += 31 * this.zPos;
        return hash += 17 * this.dim;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof FakeBlockPos)) {
            return false;
        }
        FakeBlockPos otherPoint = (FakeBlockPos)other;
        return this.xPos == otherPoint.xPos && this.yPos == otherPoint.yPos && this.zPos == otherPoint.zPos;
    }

    public int distanceFrom(FakeBlockPos target) {
        if (target.dim != this.dim) {
            return Short.MIN_VALUE;
        }
        return this.distanceFrom(target.xPos, target.yPos, target.zPos);
    }

    @Override
    public int distanceFrom(int x, int y, int z) {
        int distanceX = this.xPos - x;
        int distanceY = this.yPos - y;
        int distanceZ = this.zPos - z;
        return distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
    }

    public boolean isWithinRange(FakeBlockPos target, int range) {
        if (target.dim != this.dim) {
            return false;
        }
        return this.isWithinRange(target.xPos, target.yPos, target.zPos, range);
    }

    @Override
    public boolean isWithinRange(int x, int y, int z, int range) {
        return this.distanceFrom(x, y, z) <= range * range;
    }

    @Override
    public FakeBlockPos getUp() {
        return new FakeBlockPos(this.xPos, this.yPos + 1, this.zPos, this.dim);
    }

    @Override
    public FakeBlockPos getDown() {
        return new FakeBlockPos(this.xPos, this.yPos - 1, this.zPos, this.dim);
    }

    @Override
    public FakeBlockPos getXPos() {
        return new FakeBlockPos(this.xPos + 1, this.yPos, this.zPos, this.dim);
    }

    @Override
    public FakeBlockPos getXNeg() {
        return new FakeBlockPos(this.xPos - 1, this.yPos, this.zPos, this.dim);
    }

    @Override
    public FakeBlockPos getZPos() {
        return new FakeBlockPos(this.xPos, this.yPos, this.zPos + 1, this.dim);
    }

    @Override
    public FakeBlockPos getZNeg() {
        return new FakeBlockPos(this.xPos, this.yPos, this.zPos - 1, this.dim);
    }

    @Override
    public AutoMap<BlockPos> getSurroundingBlocks() {
        AutoMap<BlockPos> sides = new AutoMap<BlockPos>();
        sides.put(this.getUp());
        sides.put(this.getDown());
        sides.put(this.getXPos());
        sides.put(this.getXNeg());
        sides.put(this.getZPos());
        sides.put(this.getZNeg());
        return sides;
    }

    @Override
    public Block getBlockAtPos() {
        return this.getBlockAtPos(this);
    }

    public Block getBlockAtPos(FakeBlockPos pos) {
        return this.getBlockAtPos(this.world, pos);
    }

    public Block getBlockAtPos(World world, FakeBlockPos pos) {
        return this.aBlockAtPos;
    }

    @Override
    public int getMetaAtPos() {
        return this.getMetaAtPos(this);
    }

    public int getMetaAtPos(FakeBlockPos pos) {
        return this.getMetaAtPos(this.world, pos);
    }

    public int getMetaAtPos(World world, FakeBlockPos pos) {
        return this.aBlockMetaAtPos;
    }

    @Override
    public boolean hasSimilarNeighbour() {
        return this.hasSimilarNeighbour(false);
    }

    @Override
    public boolean hasSimilarNeighbour(boolean strict) {
        for (BlockPos g : this.getSurroundingBlocks().values()) {
            if (this.getBlockAtPos(g) != this.getBlockAtPos()) continue;
            if (!strict) {
                return true;
            }
            if (this.getMetaAtPos() != this.getMetaAtPos(g)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AutoMap<BlockPos> getSimilarNeighbour() {
        return this.getSimilarNeighbour(false);
    }

    @Override
    public AutoMap<BlockPos> getSimilarNeighbour(boolean strict) {
        AutoMap<BlockPos> sides = new AutoMap<BlockPos>();
        for (BlockPos g : this.getSurroundingBlocks().values()) {
            if (this.getBlockAtPos(g) != this.getBlockAtPos()) continue;
            if (!strict) {
                sides.put(g);
                continue;
            }
            if (this.getMetaAtPos() != this.getMetaAtPos(g)) continue;
            sides.put(g);
        }
        return sides;
    }

    @Override
    public Set<BlockPos> getValidNeighboursAndSelf() {
        AutoMap<BlockPos> h = this.getSimilarNeighbour(true);
        h.put(this);
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (BlockPos f : h.values()) {
            result.add(f);
        }
        return result;
    }

    public void onPlantGrow(FakeWorld world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        if (this.getBlockAtPos() == Blocks.field_150349_c || this.getBlockAtPos() == Blocks.field_150458_ak) {
            this.aBlockAtPos = Blocks.field_150346_d;
            this.aBlockMetaAtPos = 0;
        }
    }
}

