/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.ReactorItem;
import gregtech.api.objects.GT_ItemStack;
import java.util.ArrayList;

public class FuelRod
extends ReactorItem {
    private final int energyMult;
    private final double heatMult;
    private final int rodCount;
    private final boolean moxStyle;

    public FuelRod(int id, String baseName, GT_ItemStack aItem, double maxDamage, double maxHeat, String sourceMod, int energyMult, double heatMult, int rodCount, boolean moxStyle) {
        super(id, baseName, aItem, maxDamage, maxHeat, sourceMod);
        this.energyMult = energyMult;
        this.heatMult = heatMult;
        this.rodCount = rodCount;
        this.moxStyle = moxStyle;
    }

    public FuelRod(FuelRod other) {
        super(other);
        this.energyMult = other.energyMult;
        this.heatMult = other.heatMult;
        this.rodCount = other.rodCount;
        this.moxStyle = other.moxStyle;
    }

    @Override
    public boolean isNeutronReflector() {
        return !this.isBroken();
    }

    private int countNeutronNeighbors() {
        int neutronNeighbors = 0;
        ReactorItem component = this.parent.getComponentAt(this.row + 1, this.col);
        if (component != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isNeutronReflector()) {
            ++neutronNeighbors;
        }
        return neutronNeighbors;
    }

    protected void handleHeat(int heat) {
        ArrayList<ReactorItem> heatableNeighbors = new ArrayList<ReactorItem>(4);
        ReactorItem component = this.parent.getComponentAt(this.row + 1, this.col);
        if (component != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row - 1, this.col)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row, this.col - 1)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if ((component = this.parent.getComponentAt(this.row, this.col + 1)) != null && component.isHeatAcceptor()) {
            heatableNeighbors.add(component);
        }
        if (heatableNeighbors.isEmpty()) {
            this.parent.adjustCurrentHeat(heat);
            this.currentHullHeating = heat;
        } else {
            this.currentComponentHeating = heat;
            for (ReactorItem heatableNeighbor : heatableNeighbors) {
                heatableNeighbor.adjustCurrentHeat(heat / heatableNeighbors.size());
            }
            int remainderHeat = heat % heatableNeighbors.size();
            ((ReactorItem)heatableNeighbors.get(0)).adjustCurrentHeat(remainderHeat);
        }
    }

    @Override
    public double generateHeat() {
        int pulses = this.countNeutronNeighbors() + (this.rodCount == 1 ? 1 : (this.rodCount == 2 ? 2 : 3));
        int heat = (int)(this.heatMult * (double)pulses * (double)(pulses + 1));
        if (this.moxStyle && this.parent.isFluid() && this.parent.getCurrentHeat() / this.parent.getMaxHeat() > 0.5) {
            heat *= 2;
        }
        this.currentHeatGenerated = heat;
        this.minHeatGenerated = Math.min(this.minHeatGenerated, (double)heat);
        this.maxHeatGenerated = Math.max(this.maxHeatGenerated, (double)heat);
        this.handleHeat(heat);
        return this.currentHeatGenerated;
    }

    @Override
    public double generateEnergy() {
        int pulses = this.countNeutronNeighbors() + (this.rodCount == 1 ? 1 : (this.rodCount == 2 ? 2 : 3));
        double energy = this.energyMult * pulses;
        if ("GT5".equals(this.sourceMod)) {
            energy *= 2.0;
            if (this.moxStyle) {
                energy *= 1.0 + 1.5 * this.parent.getCurrentHeat() / this.parent.getMaxHeat();
            }
        } else if ("GTNH".equals(this.sourceMod)) {
            energy *= 10.0;
            if (this.moxStyle) {
                energy *= 1.0 + 1.5 * this.parent.getCurrentHeat() / this.parent.getMaxHeat();
            }
        } else if (this.moxStyle) {
            energy *= 1.0 + 4.0 * this.parent.getCurrentHeat() / this.parent.getMaxHeat();
        }
        this.minEUGenerated = Math.min(this.minEUGenerated, energy);
        this.maxEUGenerated = Math.max(this.maxEUGenerated, energy);
        this.currentEUGenerated = energy;
        this.parent.addEUOutput(energy);
        this.applyDamage(1.0);
        return energy;
    }

    @Override
    public int getRodCount() {
        return this.rodCount;
    }

    @Override
    public double getCurrentOutput() {
        if (this.parent != null) {
            if (this.parent.isFluid()) {
                return this.currentHeatGenerated;
            }
            return this.currentEUGenerated;
        }
        return 0.0;
    }
}

