/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.Reactor;
import Ic2ExpReactorPlanner.SimulationData;
import Ic2ExpReactorPlanner.components.ReactorItem;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.misc.GT_TileEntity_ComputerCube;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class AutomationSimulator {
    private final Reactor reactor;
    private final ArrayList<String> output;
    private final GT_TileEntity_ComputerCube mReactor;
    private final boolean[][] needsCooldown = new boolean[6][9];
    private final int initialHeat;
    private double minEUoutput = Double.MAX_VALUE;
    private double maxEUoutput = 0.0;
    private double minHeatOutput = Double.MAX_VALUE;
    private double maxHeatOutput = 0.0;
    private final int onPulseDuration;
    private final int offPulseDuration;
    private final int clockPeriod;
    private final int suspendTemp;
    private final int resumeTemp;
    private final int maxSimulationTicks;
    private boolean reachedBelow50;
    private boolean reachedBurn;
    private boolean reachedEvaporate;
    private boolean reachedHurt;
    private boolean reachedLava;
    private boolean reachedExplode;
    private boolean allFuelRodsDepleted = false;
    private boolean componentsIntact = true;
    private boolean anyRodsDepleted = false;
    private int activeTime = 0;
    private int inactiveTime = 0;
    private int currentActiveTime = 0;
    private int minActiveTime = Integer.MAX_VALUE;
    private int maxActiveTime = 0;
    private int currentInactiveTime = 0;
    private int minInactiveTime = Integer.MAX_VALUE;
    private int maxInactiveTime = 0;
    private double totalHullHeating = 0.0;
    private double totalComponentHeating = 0.0;
    private double totalHullCooling = 0.0;
    private double totalVentCooling = 0.0;
    private boolean showHeatingCoolingCalled = false;
    private boolean active = true;
    private int pauseTimer = 0;
    private int redstoneUsed = 0;
    private int lapisUsed = 0;
    private boolean completed = false;
    private boolean mRunning = false;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#,##0.##");
    private final SimulationData data = new SimulationData();

    public SimulationData getData() {
        if (this.completed) {
            return this.data;
        }
        return null;
    }

    public AutomationSimulator(Reactor reactor, ArrayList<String> output2, GT_TileEntity_ComputerCube aTile) {
        this.reactor = reactor;
        this.output = output2;
        this.mReactor = aTile;
        this.initialHeat = (int)reactor.getCurrentHeat();
        this.onPulseDuration = reactor.getOnPulse();
        this.offPulseDuration = reactor.getOffPulse();
        this.clockPeriod = this.onPulseDuration + this.offPulseDuration;
        this.suspendTemp = reactor.getSuspendTemp();
        this.resumeTemp = reactor.getResumeTemp();
        this.maxSimulationTicks = reactor.getMaxSimulationTicks();
    }

    public void process() {
        ReactorItem component;
        int col;
        int row;
        this.mRunning = true;
        this.completed = false;
        long startTime = System.nanoTime();
        int reactorTicks = 0;
        int cooldownTicks = 0;
        int totalRodCount = 0;
        this.publish("");
        this.publish("Simulation.Started");
        this.reactor.setCurrentHeat(this.initialHeat);
        this.reactor.clearVentedHeat();
        double minReactorHeat = this.initialHeat;
        double maxReactorHeat = this.initialHeat;
        this.reachedBelow50 = false;
        this.reachedBurn = (double)this.initialHeat >= 0.4 * this.reactor.getMaxHeat();
        this.reachedEvaporate = (double)this.initialHeat >= 0.5 * this.reactor.getMaxHeat();
        this.reachedHurt = (double)this.initialHeat >= 0.7 * this.reactor.getMaxHeat();
        this.reachedLava = (double)this.initialHeat >= 0.85 * this.reactor.getMaxHeat();
        this.reachedExplode = false;
        for (int row2 = 0; row2 < 6; ++row2) {
            for (int col2 = 0; col2 < 9; ++col2) {
                ReactorItem component2 = this.reactor.getComponentAt(row2, col2);
                if (component2 != null) {
                    component2.clearCurrentHeat();
                    component2.clearDamage();
                    totalRodCount += component2.getRodCount();
                }
                this.publish(String.format("R%dC%d:0xC0C0C0", row2, col2));
            }
        }
        this.data.totalRodCount = totalRodCount;
        double lastEUoutput = 0.0;
        double totalEUoutput = 0.0;
        double lastHeatOutput = 0.0;
        double totalHeatOutput = 0.0;
        double maxGeneratedHeat = 0.0;
        double explosionPower = 10.0;
        this.allFuelRodsDepleted = false;
        this.componentsIntact = true;
        this.anyRodsDepleted = false;
        Logger.INFO("Reactor Current Heat: " + this.reactor.getCurrentHeat());
        Logger.INFO("Reactor Max Heat: " + this.reactor.getMaxHeat());
        Logger.INFO("Least EU Output: " + lastEUoutput);
        Logger.INFO("Least Heat Output: " + lastHeatOutput);
        Logger.INFO("Reactor Max Ticks: " + this.maxSimulationTicks);
        Logger.INFO("All Fuel Depleted: " + this.allFuelRodsDepleted);
        Logger.INFO("Running: " + this.isRunning());
        Logger.INFO("Stopped: " + this.hasStopped());
        while (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat() && (!this.allFuelRodsDepleted || lastEUoutput > 0.0 || lastHeatOutput > 0.0) && reactorTicks < this.maxSimulationTicks && this.isRunning()) {
            ++reactorTicks;
            this.reactor.clearEUOutput();
            this.reactor.clearVentedHeat();
            for (int row3 = 0; row3 < 6; ++row3) {
                for (int col3 = 0; col3 < 9; ++col3) {
                    ReactorItem component3 = this.reactor.getComponentAt(row3, col3);
                    if (component3 == null) continue;
                    component3.preReactorTick();
                }
            }
            if (this.active) {
                this.allFuelRodsDepleted = true;
            }
            double generatedHeat = 0.0;
            for (row = 0; row < 6; ++row) {
                for (col = 0; col < 9; ++col) {
                    component = this.reactor.getComponentAt(row, col);
                    if (component == null || component.isBroken()) continue;
                    if (this.allFuelRodsDepleted && component.getRodCount() > 0) {
                        this.allFuelRodsDepleted = false;
                    }
                    if (this.active) {
                        generatedHeat += component.generateHeat();
                    }
                    component.dissipate();
                    component.transfer();
                }
            }
            maxReactorHeat = Math.max(this.reactor.getCurrentHeat(), maxReactorHeat);
            minReactorHeat = Math.min(this.reactor.getCurrentHeat(), minReactorHeat);
            this.checkReactorTemperature(reactorTicks);
            maxGeneratedHeat = Math.max(generatedHeat, maxGeneratedHeat);
            if (this.active) {
                for (row = 0; row < 6; ++row) {
                    for (col = 0; col < 9; ++col) {
                        component = this.reactor.getComponentAt(row, col);
                        if (component == null || component.isBroken()) continue;
                        component.generateEnergy();
                    }
                }
            }
            lastEUoutput = this.reactor.getCurrentEUoutput();
            totalEUoutput += lastEUoutput;
            lastHeatOutput = this.reactor.getVentedHeat();
            totalHeatOutput += lastHeatOutput;
            if (this.reactor.getCurrentHeat() <= this.reactor.getMaxHeat()) {
                if (this.reactor.isPulsed() || this.reactor.isAutomated()) {
                    if (this.active) {
                        ++this.activeTime;
                        ++this.currentActiveTime;
                        if (this.reactor.isPulsed() && (this.reactor.getCurrentHeat() >= (double)this.suspendTemp || reactorTicks % this.clockPeriod >= this.onPulseDuration)) {
                            this.active = false;
                            this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                            this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                            this.currentActiveTime = 0;
                        }
                    } else {
                        ++this.inactiveTime;
                        ++this.currentInactiveTime;
                        if (this.reactor.isAutomated() && this.pauseTimer > 0) {
                            --this.pauseTimer;
                        } else if (this.reactor.isPulsed() && this.reactor.getCurrentHeat() <= (double)this.resumeTemp && reactorTicks % this.clockPeriod < this.onPulseDuration) {
                            this.active = true;
                            this.minInactiveTime = Math.min(this.currentInactiveTime, this.minInactiveTime);
                            this.maxInactiveTime = Math.max(this.currentInactiveTime, this.maxInactiveTime);
                            this.currentInactiveTime = 0;
                        }
                    }
                }
                this.minEUoutput = Math.min(lastEUoutput, this.minEUoutput);
                this.maxEUoutput = Math.max(lastEUoutput, this.maxEUoutput);
                this.minHeatOutput = Math.min(lastHeatOutput, this.minHeatOutput);
                this.maxHeatOutput = Math.max(lastHeatOutput, this.maxHeatOutput);
            }
            this.calculateHeatingCooling(reactorTicks);
            this.handleAutomation(reactorTicks);
        }
        if (this.hasStopped()) {
            this.publish("Simulation.CancelledAtTick", reactorTicks);
        }
        this.data.minTemp = (int)minReactorHeat;
        this.data.maxTemp = (int)maxReactorHeat;
        this.publish("Simulation.ReactorMinTemp", minReactorHeat);
        this.publish("Simulation.ReactorMaxTemp", maxReactorHeat);
        if (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat()) {
            this.publish("Simulation.TimeWithoutExploding", reactorTicks);
            if (this.reactor.isPulsed()) {
                String rangeString = "";
                if (this.maxActiveTime > this.minActiveTime) {
                    rangeString = this.rangeString("Simulation.ActiveTimeRange", this.minActiveTime, this.maxActiveTime);
                } else if (this.minActiveTime < this.activeTime) {
                    rangeString = "Simulation.ActiveTimeSingle " + this.minActiveTime;
                }
                this.publish("Simulation.ActiveTime", this.activeTime, rangeString);
                rangeString = "";
                if (this.maxInactiveTime > this.minInactiveTime) {
                    rangeString = this.rangeString("Simulation.InactiveTimeRange", this.minInactiveTime, this.maxInactiveTime);
                } else if (this.minInactiveTime < this.inactiveTime) {
                    rangeString = "Simulation.InactiveTimeSingle " + this.minInactiveTime;
                }
                this.publish("Simulation.InactiveTime", this.inactiveTime, rangeString);
            }
            if (reactorTicks > 0) {
                this.data.totalReactorTicks = reactorTicks;
                if (this.reactor.isFluid()) {
                    this.data.totalHUoutput = (int)(40.0 * totalHeatOutput);
                    this.data.avgHUoutput = (int)(2.0 * totalHeatOutput / (double)reactorTicks);
                    this.data.minHUoutput = 2.0 * this.minHeatOutput;
                    this.data.maxHUoutput = (int)(2.0 * this.maxHeatOutput);
                    if (totalHeatOutput > 0.0) {
                        this.publish("Simulation.HeatOutputs", DECIMAL_FORMAT.format(40.0 * totalHeatOutput), DECIMAL_FORMAT.format(2.0 * totalHeatOutput / (double)reactorTicks), DECIMAL_FORMAT.format(2.0 * this.minHeatOutput), DECIMAL_FORMAT.format(2.0 * this.maxHeatOutput));
                        if (totalRodCount > 0) {
                            this.publish("Simulation.Efficiency", totalHeatOutput / (double)reactorTicks / 4.0 / (double)totalRodCount, this.minHeatOutput / 4.0 / (double)totalRodCount, this.maxHeatOutput / 4.0 / (double)totalRodCount);
                        }
                    }
                } else {
                    this.data.totalEUoutput = (int)totalEUoutput;
                    this.data.avgEUoutput = MathUtils.roundToClosestInt(Math.ceil(totalEUoutput / (double)(reactorTicks * 20)));
                    this.data.minEUoutput = this.minEUoutput / 20.0;
                    this.data.maxEUoutput = (int)(this.maxEUoutput / 20.0);
                    if (totalEUoutput > 0.0) {
                        this.publish("Simulation.EUOutputs", DECIMAL_FORMAT.format(totalEUoutput), DECIMAL_FORMAT.format(totalEUoutput / (double)(reactorTicks * 20)), DECIMAL_FORMAT.format(this.minEUoutput / 20.0), DECIMAL_FORMAT.format(this.maxEUoutput / 20.0));
                        if (totalRodCount > 0) {
                            this.publish("Simulation.Efficiency", totalEUoutput / (double)reactorTicks / 100.0 / (double)totalRodCount, this.minEUoutput / 100.0 / (double)totalRodCount, this.maxEUoutput / 100.0 / (double)totalRodCount);
                        }
                    }
                }
            }
            if (this.reactor.getCurrentHeat() > 0.0) {
                this.publish("Simulation.ReactorRemainingHeat", this.reactor.getCurrentHeat());
            }
            double prevReactorHeat = this.reactor.getCurrentHeat();
            double prevTotalComponentHeat = 0.0;
            for (int row4 = 0; row4 < 6; ++row4) {
                for (int col4 = 0; col4 < 9; ++col4) {
                    ReactorItem component4 = this.reactor.getComponentAt(row4, col4);
                    if (component4 == null || component4.isBroken() || !(component4.getCurrentHeat() > 0.0)) continue;
                    prevTotalComponentHeat += component4.getCurrentHeat();
                    this.publish(String.format("R%dC%d:0xFFA500", row4, col4));
                    component4.info.append("ComponentInfo.RemainingHeat " + component4.getCurrentHeat());
                }
            }
            if (prevReactorHeat == 0.0 && prevTotalComponentHeat == 0.0) {
                this.publish("Simulation.NoCooldown");
            } else if (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat()) {
                double currentTotalComponentHeat = prevTotalComponentHeat;
                int reactorCooldownTime = 0;
                do {
                    ReactorItem component5;
                    int col5;
                    int row5;
                    this.reactor.clearVentedHeat();
                    prevReactorHeat = this.reactor.getCurrentHeat();
                    if (prevReactorHeat == 0.0) {
                        reactorCooldownTime = cooldownTicks;
                    }
                    prevTotalComponentHeat = currentTotalComponentHeat;
                    for (row5 = 0; row5 < 6; ++row5) {
                        for (col5 = 0; col5 < 9; ++col5) {
                            component5 = this.reactor.getComponentAt(row5, col5);
                            if (component5 == null || component5.isBroken()) continue;
                            component5.dissipate();
                            component5.transfer();
                        }
                    }
                    lastHeatOutput = this.reactor.getVentedHeat();
                    totalHeatOutput += lastHeatOutput;
                    this.minEUoutput = Math.min(lastEUoutput, this.minEUoutput);
                    this.maxEUoutput = Math.max(lastEUoutput, this.maxEUoutput);
                    this.minHeatOutput = Math.min(lastHeatOutput, this.minHeatOutput);
                    this.maxHeatOutput = Math.max(lastHeatOutput, this.maxHeatOutput);
                    ++cooldownTicks;
                    currentTotalComponentHeat = 0.0;
                    for (row5 = 0; row5 < 6; ++row5) {
                        for (col5 = 0; col5 < 9; ++col5) {
                            component5 = this.reactor.getComponentAt(row5, col5);
                            if (component5 == null || component5.isBroken()) continue;
                            currentTotalComponentHeat += component5.getCurrentHeat();
                            if (component5.getCurrentHeat() != 0.0 || !this.needsCooldown[row5][col5]) continue;
                            component5.info.append("ComponentInfo.CooldownTime " + cooldownTicks);
                            this.needsCooldown[row5][col5] = false;
                        }
                    }
                } while (lastHeatOutput > 0.0 && cooldownTicks < 50000);
                if (this.reactor.getCurrentHeat() < this.reactor.getMaxHeat()) {
                    if (this.reactor.getCurrentHeat() == 0.0) {
                        this.publish("Simulation.ReactorCooldownTime", reactorCooldownTime);
                    } else if (reactorCooldownTime > 0) {
                        this.publish("Simulation.ReactorResidualHeat", this.reactor.getCurrentHeat(), reactorCooldownTime);
                    }
                    this.publish("Simulation.TotalCooldownTime", cooldownTicks);
                }
            }
        } else {
            this.publish("Simulation.ReactorOverheatedTime", reactorTicks);
            explosionPower = 10.0;
            double explosionPowerMult = 1.0;
            for (row = 0; row < 6; ++row) {
                for (col = 0; col < 9; ++col) {
                    component = this.reactor.getComponentAt(row, col);
                    if (component == null) continue;
                    explosionPower += component.getExplosionPowerOffset();
                    explosionPowerMult *= component.getExplosionPowerMultiplier();
                }
            }
            this.publish("Simulation.ExplosionPower", explosionPower *= explosionPowerMult);
        }
        double totalEffectiveVentCooling = 0.0;
        double totalVentCoolingCapacity = 0.0;
        double totalCellCooling = 0.0;
        double totalCondensatorCooling = 0.0;
        for (int row6 = 0; row6 < 6; ++row6) {
            for (int col6 = 0; col6 < 9; ++col6) {
                ReactorItem component6 = this.reactor.getComponentAt(row6, col6);
                if (component6 == null) continue;
                if (component6.getVentCoolingCapacity() > 0.0) {
                    component6.info.append("ComponentInfo.UsedCooling " + component6.getBestVentCooling() + " | " + component6.getVentCoolingCapacity());
                    totalEffectiveVentCooling += component6.getBestVentCooling();
                    totalVentCoolingCapacity += component6.getVentCoolingCapacity();
                } else if (component6.getBestCellCooling() > 0.0) {
                    component6.info.append("ComponentInfo.ReceivedHeat " + component6.getBestCellCooling());
                    totalCellCooling += component6.getBestCellCooling();
                } else if (component6.getBestCondensatorCooling() > 0.0) {
                    component6.info.append("ComponentInfo.ReceivedHeat " + component6.getBestCondensatorCooling());
                    totalCondensatorCooling += component6.getBestCondensatorCooling();
                } else if (component6.getMaxHeatGenerated() > 0.0) {
                    if (!this.reactor.isFluid() && component6.getMaxEUGenerated() > 0.0) {
                        component6.info.append("ComponentInfo.GeneratedEU " + component6.getMinEUGenerated() + " | " + component6.getMaxEUGenerated());
                    }
                    component6.info.append("ComponentInfo.GeneratedHeat " + component6.getMinHeatGenerated() + " | " + component6.getMaxHeatGenerated());
                }
                if (!(component6.getMaxReachedHeat() > 0.0)) continue;
                component6.info.append("ComponentInfo.ReachedHeat " + component6.getMaxReachedHeat() + " | " + component6.getMaxHeat());
            }
        }
        this.showHeatingCooling(reactorTicks);
        if (totalCellCooling > 0.0) {
            this.publish("Simulation.TotalCellCooling", totalCellCooling);
        }
        if (totalCondensatorCooling > 0.0) {
            this.publish("Simulation.TotalCondensatorCooling", totalCondensatorCooling);
        }
        if (maxGeneratedHeat > 0.0) {
            this.publish("Simulation.MaxHeatGenerated", maxGeneratedHeat);
        }
        if (this.redstoneUsed > 0) {
            this.publish("Simulation.RedstoneUsed", this.redstoneUsed);
        }
        if (this.lapisUsed > 0) {
            this.publish("Simulation.LapisUsed", this.lapisUsed);
        }
        this.data.explosionPower = (int)explosionPower;
        this.data.totalReactorTicks = reactorTicks;
        long endTime = System.nanoTime();
        this.publish("Simulation.ElapsedTime", (double)(endTime - startTime) / 1.0E9);
        this.mRunning = false;
        this.completed = true;
    }

    public boolean hasStopped() {
        return !this.mRunning;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private void handleAutomation(int reactorTicks) {
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 9; ++col) {
                ReactorItem component = this.reactor.getComponentAt(row, col);
                if (component != null && this.reactor.isAutomated()) {
                    if (component.getMaxHeat() > 1.0) {
                        if ((double)component.getAutomationThreshold() > component.getInitialHeat() && component.getCurrentHeat() >= (double)component.getAutomationThreshold()) {
                            component.clearCurrentHeat();
                            component.info.append("ComponentInfo.ReplacedTime | " + reactorTicks);
                            if (component.getReactorPause() > 0) {
                                this.active = false;
                                this.pauseTimer = Math.max(this.pauseTimer, component.getReactorPause());
                                this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                                this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                                this.currentActiveTime = 0;
                            }
                        } else if ((double)component.getAutomationThreshold() < component.getInitialHeat() && component.getCurrentHeat() <= (double)component.getAutomationThreshold()) {
                            component.clearCurrentHeat();
                            component.info.append("ComponentInfo.ReplacedTime | " + reactorTicks);
                            if (component.getReactorPause() > 0) {
                                this.active = false;
                                this.pauseTimer = Math.max(this.pauseTimer, component.getReactorPause());
                                this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                                this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                                this.currentActiveTime = 0;
                            }
                        }
                    } else if (component.isBroken() || component.getMaxDamage() > 1.0 && component.getCurrentDamage() >= (double)component.getAutomationThreshold()) {
                        component.clearDamage();
                        component.info.append("ComponentInfo.ReplacedTime | " + reactorTicks);
                        if (component.getReactorPause() > 0) {
                            this.active = false;
                            this.pauseTimer = Math.max(this.pauseTimer, component.getReactorPause());
                            this.minActiveTime = Math.min(this.currentActiveTime, this.minActiveTime);
                            this.maxActiveTime = Math.max(this.currentActiveTime, this.maxActiveTime);
                            this.currentActiveTime = 0;
                        }
                    }
                }
                if (!this.reactor.isUsingReactorCoolantInjectors() || component == null || !component.needsCoolantInjected()) continue;
                component.injectCoolant();
                if ("rshCondensator".equals(component.baseName)) {
                    ++this.redstoneUsed;
                    continue;
                }
                if (!"lzhCondensator".equals(component.baseName)) continue;
                ++this.lapisUsed;
            }
        }
    }

    private void checkReactorTemperature(int reactorTicks) {
        if (this.reactor.getCurrentHeat() < 0.5 * this.reactor.getMaxHeat() && !this.reachedBelow50 && this.reachedEvaporate) {
            this.publish("Simulation.TimeToBelow50", reactorTicks);
            this.reachedBelow50 = true;
            this.data.timeToBelow50 = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.4 * this.reactor.getMaxHeat() && !this.reachedBurn) {
            this.publish("Simulation.TimeToBurn", reactorTicks);
            this.reachedBurn = true;
            this.data.timeToBurn = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.5 * this.reactor.getMaxHeat() && !this.reachedEvaporate) {
            this.publish("Simulation.TimeToEvaporate", reactorTicks);
            this.reachedEvaporate = true;
            this.data.timeToEvaporate = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.7 * this.reactor.getMaxHeat() && !this.reachedHurt) {
            this.publish("Simulation.TimeToHurt", reactorTicks);
            this.reachedHurt = true;
            this.data.timeToHurt = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= 0.85 * this.reactor.getMaxHeat() && !this.reachedLava) {
            this.publish("Simulation.TimeToLava", reactorTicks);
            this.reachedLava = true;
            this.data.timeToLava = reactorTicks;
        }
        if (this.reactor.getCurrentHeat() >= this.reactor.getMaxHeat() && !this.reachedExplode) {
            this.publish("Simulation.TimeToXplode", reactorTicks);
            this.reachedExplode = true;
            this.data.timeToXplode = reactorTicks;
        }
    }

    private void calculateHeatingCooling(int reactorTicks) {
        if (reactorTicks > 20) {
            for (int row = 0; row < 6; ++row) {
                for (int col = 0; col < 9; ++col) {
                    ReactorItem component = this.reactor.getComponentAt(row, col);
                    if (component == null) continue;
                    this.totalHullHeating += component.getCurrentHullHeating();
                    this.totalComponentHeating += component.getCurrentComponentHeating();
                    this.totalHullCooling += component.getCurrentHullCooling();
                    this.totalVentCooling += component.getCurrentVentCooling();
                }
            }
        }
    }

    private void showHeatingCooling(int reactorTicks) {
        if (!this.showHeatingCoolingCalled) {
            this.showHeatingCoolingCalled = true;
            if (reactorTicks >= 40) {
                double totalHullCoolingCapacity = 0.0;
                double totalVentCoolingCapacity = 0.0;
                for (int row = 0; row < 6; ++row) {
                    for (int col = 0; col < 9; ++col) {
                        ReactorItem component = this.reactor.getComponentAt(row, col);
                        if (component == null) continue;
                        totalHullCoolingCapacity += component.getHullCoolingCapacity();
                        totalVentCoolingCapacity += component.getVentCoolingCapacity();
                    }
                }
                this.data.hullHeating = this.totalHullHeating / (double)(reactorTicks - 20);
                this.data.componentHeating = this.totalComponentHeating / (double)(reactorTicks - 20);
                this.data.hullCooling = this.totalHullCooling / (double)(reactorTicks - 20);
                this.data.hullCoolingCapacity = totalHullCoolingCapacity;
                this.data.ventCooling = this.totalVentCooling / (double)(reactorTicks - 20);
                this.data.ventCoolingCapacity = totalVentCoolingCapacity;
                if (this.totalHullHeating > 0.0) {
                    this.publish("Simulation.HullHeating", this.totalHullHeating / (double)(reactorTicks - 20));
                }
                if (this.totalComponentHeating > 0.0) {
                    this.publish("Simulation.ComponentHeating", this.totalComponentHeating / (double)(reactorTicks - 20));
                }
                if (totalHullCoolingCapacity > 0.0) {
                    this.publish("Simulation.HullCooling | " + this.totalHullCooling / (double)(reactorTicks - 20), totalHullCoolingCapacity);
                }
                if (totalVentCoolingCapacity > 0.0) {
                    this.publish("Simulation.VentCooling | " + this.totalVentCooling / (double)(reactorTicks - 20), totalVentCoolingCapacity);
                }
            }
        }
    }

    private void publish(String string, double currentHeat, int reactorCooldownTime) {
        this.publish(string + " | " + currentHeat + " | " + reactorCooldownTime);
    }

    private void publish(String string, double d, double e, double f) {
        this.publish(string + " | " + d + " | " + e + " | " + f);
    }

    private void publish(String string, String format, String format2, String format3, String format4) {
        this.publish(string + " | " + format + " | " + format2 + " | " + format3 + " | " + format4);
    }

    private void publish(String string, int activeTime2, String rangeString) {
        this.publish(string + " | " + activeTime2 + " | " + rangeString);
    }

    private void publish(String aString, double aData) {
        this.publish(aString + ":" + aData);
    }

    private void publish(String aString, long aData) {
        this.publish(aString + ":" + aData);
    }

    private void publish(String aString) {
        this.output.add(aString);
    }

    private String rangeString(String string, int aMin, int aMax) {
        return string + " (" + aMin + "-" + aMax + ")";
    }

    protected void process(List<String> chunks) {
    }

    public void cancel() {
        Logger.INFO("Stopping Simulation.");
        this.mRunning = false;
        this.completed = true;
    }
}

