/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.registration.gregtech;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine_GT_Recipe;
import gregtech.api.util.GTPP_Recipe;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GregtechComponentAssembler {
    public static void run() {
        if (!CORE.ConfigSwitches.enableMachine_ComponentAssemblers) {
            return;
        }
        GregtechItemList.Machine_LV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(985, "basicmachine.componentmaker.tier.01", "Basic Component Maker", 1, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 16000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_MV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(986, "basicmachine.componentmaker.tier.02", "Advanced Component Maker", 2, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 16000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_HV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(987, "basicmachine.componentmaker.tier.03", "Advanced Component Maker II", 3, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 16000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_EV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(988, "basicmachine.componentmaker.tier.04", "Advanced Component Maker III", 4, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 16000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_IV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(989, "basicmachine.componentmaker.tier.05", "Advanced Component Maker IV", 5, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 16000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_LuV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(31012, "basicmachine.componentmaker.tier.06", "Advanced Component Maker V", 6, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 24000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_ZPM_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(31013, "basicmachine.componentmaker.tier.07", "Advanced Component Maker VI", 7, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 32000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechItemList.Machine_UV_Component_Maker.set(new GT_MetaTileEntity_BasicMachine_GT_Recipe(31014, "basicmachine.componentmaker.tier.08", "Advanced Component Maker VII", 8, "Components, Unite!", GTPP_Recipe.GTPP_Recipe_Map.sComponentAssemblerRecipes, 6, 1, 48000, 0, 1, "Assembler.png", "", false, false, 0, "ASSEMBLER", new Object[]{"ACA", "VMV", "WCW", Character.valueOf('M'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.HULL, Character.valueOf('V'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.ROBOT_ARM, Character.valueOf('A'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.PISTON, Character.valueOf('C'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.CIRCUIT, Character.valueOf('W'), GT_MetaTileEntity_BasicMachine_GT_Recipe.X.WIRE4}).getStackForm(1L));
        GregtechComponentAssembler.addRecipeMotor(1, Materials.Copper, 1, Materials.Tin, 1, Materials.Iron, Materials.IronMagnetic);
        GregtechComponentAssembler.addRecipeMotor(2, Materials.Copper, 2, Materials.Copper, 1, Materials.Aluminium, Materials.SteelMagnetic);
        GregtechComponentAssembler.addRecipeMotor(3, Materials.Copper, 4, Materials.Gold, 1, Materials.StainlessSteel, Materials.SteelMagnetic);
        GregtechComponentAssembler.addRecipeMotor(4, Materials.Copper, 8, Materials.Aluminium, 1, Materials.Titanium, Materials.NeodymiumMagnetic);
        GregtechComponentAssembler.addRecipeMotor(5, Materials.Copper, 16, Materials.Tungsten, 1, Materials.TungstenSteel, Materials.NeodymiumMagnetic);
        GregtechComponentAssembler.addRecipePiston(1, Materials.Steel, Materials.Tin);
        GregtechComponentAssembler.addRecipePiston(2, Materials.Aluminium, Materials.Copper);
        GregtechComponentAssembler.addRecipePiston(3, Materials.StainlessSteel, Materials.Gold);
        GregtechComponentAssembler.addRecipePiston(4, Materials.Titanium, Materials.Aluminium);
        GregtechComponentAssembler.addRecipePiston(5, Materials.TungstenSteel, Materials.Tungsten);
        GregtechComponentAssembler.addRecipeConveyor(1, Materials.Tin);
        GregtechComponentAssembler.addRecipeConveyor(2, Materials.Copper);
        GregtechComponentAssembler.addRecipeConveyor(3, Materials.Gold);
        GregtechComponentAssembler.addRecipeConveyor(4, Materials.Aluminium);
        GregtechComponentAssembler.addRecipeConveyor(5, Materials.Tungsten);
        GregtechComponentAssembler.addRecipePump(1, Materials.Tin, Materials.Copper, Materials.Tin);
        GregtechComponentAssembler.addRecipePump(2, Materials.Bronze, Materials.Steel, Materials.Copper);
        GregtechComponentAssembler.addRecipePump(3, Materials.Steel, Materials.StainlessSteel, Materials.Gold);
        GregtechComponentAssembler.addRecipePump(4, Materials.StainlessSteel, Materials.Titanium, Materials.Aluminium);
        GregtechComponentAssembler.addRecipePump(5, Materials.TungstenSteel, Materials.TungstenSteel, Materials.Tungsten);
        GregtechComponentAssembler.addRecipeRobotArm(1, Materials.Steel, Materials.Tin);
        GregtechComponentAssembler.addRecipeRobotArm(2, Materials.Aluminium, Materials.Copper);
        GregtechComponentAssembler.addRecipeRobotArm(3, Materials.StainlessSteel, Materials.Gold);
        GregtechComponentAssembler.addRecipeRobotArm(4, Materials.Titanium, Materials.Aluminium);
        GregtechComponentAssembler.addRecipeRobotArm(5, Materials.TungstenSteel, Materials.Tungsten);
        GregtechComponentAssembler.addRecipeFieldGenerator(1);
        GregtechComponentAssembler.addRecipeFieldGenerator(2);
        GregtechComponentAssembler.addRecipeFieldGenerator(3);
        GregtechComponentAssembler.addRecipeFieldGenerator(4);
        GregtechComponentAssembler.addRecipeFieldGenerator(5);
        GregtechComponentAssembler.addRecipeEmitter(1, Materials.Tin, Materials.Brass, Materials.Quartzite);
        GregtechComponentAssembler.addRecipeEmitter(2, Materials.Copper, Materials.Electrum, Materials.NetherQuartz);
        GregtechComponentAssembler.addRecipeEmitter(3, Materials.Gold, Materials.Chrome, Materials.Emerald);
        GregtechComponentAssembler.addRecipeEmitter(4, Materials.Aluminium, Materials.Platinum, Materials.EnderPearl);
        GregtechComponentAssembler.addRecipeEmitter(5, Materials.Tungsten, Materials.Osmium, Materials.EnderEye);
        GregtechComponentAssembler.addRecipeSensor(1, Materials.Steel, Materials.Brass, Materials.Quartzite);
        GregtechComponentAssembler.addRecipeSensor(2, Materials.Aluminium, Materials.Electrum, Materials.NetherQuartz);
        GregtechComponentAssembler.addRecipeSensor(3, Materials.StainlessSteel, Materials.Chrome, Materials.Emerald);
        GregtechComponentAssembler.addRecipeSensor(4, Materials.Titanium, Materials.Platinum, Materials.EnderPearl);
        GregtechComponentAssembler.addRecipeSensor(5, Materials.TungstenSteel, Materials.Osmium, Materials.EnderEye);
    }

    private static boolean addRecipeMotor(int tier, Materials wire, int wirethickness, Materials cable, int cablethickness, Materials stick, Materials magstick) {
        try {
            String mWT = "" + wirethickness;
            String mCT = "" + cablethickness;
            if (wirethickness < 10) {
                mWT = "0" + wirethickness;
            }
            if (cablethickness < 10) {
                mCT = "0" + cablethickness;
            }
            OrePrefixes prefixWire = OrePrefixes.getOrePrefix((String)("wireGt" + mWT));
            OrePrefixes prefixCable = OrePrefixes.getOrePrefix((String)("cableGt" + mCT));
            ItemStack wireStack = ItemUtils.getGregtechOreStack(prefixWire, wire, 4);
            ItemStack cableStack = ItemUtils.getGregtechOreStack(prefixCable, cable, 2);
            ItemStack rodStack = ItemUtils.getGregtechOreStack(OrePrefixes.stick, stick, 2);
            ItemStack magrodStack = ItemUtils.getGregtechOreStack(OrePrefixes.stick, magstick, 1);
            ItemStack[] Input = new ItemStack[]{wireStack, cableStack, rodStack, magrodStack};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getElectricMotor(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipePiston(int tier, Materials mat, Materials cable) {
        try {
            OrePrefixes prefixCable = OrePrefixes.cableGt01;
            ItemStack cableStack = ItemUtils.getGregtechOreStack(prefixCable, cable, 2);
            ItemStack rodStack = ItemUtils.getGregtechOreStack(OrePrefixes.stick, mat, 2);
            ItemStack plateStack = ItemUtils.getGregtechOreStack(OrePrefixes.plate, mat, 3);
            ItemStack gearStack = ItemUtils.getGregtechOreStack(OrePrefixes.gearGtSmall, mat, 1);
            ItemStack motorStack = CI.getElectricMotor(tier, 1);
            ItemStack[] Input = new ItemStack[]{plateStack, cableStack, rodStack, gearStack, motorStack};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getElectricPiston(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipeConveyor(int tier, Materials cable) {
        try {
            OrePrefixes prefixCable = OrePrefixes.cableGt01;
            ItemStack cableStack = ItemUtils.getGregtechOreStack(prefixCable, cable, 1);
            ItemStack motorStack = CI.getElectricMotor(tier, 2);
            ArrayList oreDictList = OreDictionary.getOres((String)"plateAnyRubber");
            if (!oreDictList.isEmpty()) {
                int mcount = 0;
                boolean[] mAdd = new boolean[oreDictList.size()];
                for (ItemStack mRubberType : oreDictList) {
                    ItemStack returnValue = mRubberType.func_77946_l();
                    returnValue.field_77994_a = 6;
                    ItemStack[] Input = new ItemStack[]{cableStack, motorStack, returnValue};
                    mAdd[mcount++] = CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getConveyor(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
                }
                int added = 0;
                for (boolean y : mAdd) {
                    if (!y) continue;
                    ++added;
                }
                return added >= oreDictList.size() / 2;
            }
            ItemStack[] Input = new ItemStack[]{cableStack, motorStack, ItemUtils.getItemStackOfAmountFromOreDictNoBroken("plateRubber", 6)};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getConveyor(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipePump(int tier, Materials main, Materials pipe, Materials cable) {
        try {
            ItemStack cableStack = ItemUtils.getGregtechOreStack(OrePrefixes.cableGt01, cable, 1);
            ItemStack screwStack = ItemUtils.getGregtechOreStack(OrePrefixes.screw, main, 1);
            ItemStack rotorStack = ItemUtils.getGregtechOreStack(OrePrefixes.rotor, main, 1);
            ItemStack pipeStack = ItemUtils.getGregtechOreStack(OrePrefixes.pipeMedium, pipe, 1);
            ItemStack motorStack = CI.getElectricMotor(tier, 1);
            ArrayList oreDictList = OreDictionary.getOres((String)"ringAnyRubber");
            if (!oreDictList.isEmpty()) {
                int mcount = 0;
                boolean[] mAdd = new boolean[oreDictList.size()];
                for (ItemStack mRubberType : oreDictList) {
                    ItemStack returnValue = mRubberType.func_77946_l();
                    returnValue.field_77994_a = 2;
                    ItemStack[] Input = new ItemStack[]{cableStack, screwStack, rotorStack, pipeStack, motorStack, returnValue};
                    mAdd[mcount++] = CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getElectricPump(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
                }
                int added = 0;
                for (boolean y : mAdd) {
                    if (!y) continue;
                    ++added;
                }
                return added >= oreDictList.size() / 2;
            }
            ItemStack[] Input = new ItemStack[]{cableStack, screwStack, rotorStack, pipeStack, motorStack, ItemUtils.getItemStackOfAmountFromOreDictNoBroken("ringRubber", 2)};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getElectricPump(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipeRobotArm(int tier, Materials stick, Materials cable) {
        try {
            ItemStack cableStack = ItemUtils.getGregtechOreStack(OrePrefixes.cableGt01, cable, 3);
            ItemStack rodStack = ItemUtils.getGregtechOreStack(OrePrefixes.stick, stick, 2);
            ItemStack motorStack = CI.getElectricMotor(tier, 2);
            ItemStack pistonStack = CI.getElectricPiston(tier, 1);
            ItemStack[] oreDictList = CI.getAllCircuitsOfTier(tier);
            if (oreDictList.length > 0) {
                int mcount = 0;
                int added = 0;
                boolean[] mAdd = new boolean[oreDictList.length];
                for (ItemStack mCircuitType : oreDictList) {
                    ItemStack returnValue = mCircuitType.func_77946_l();
                    returnValue.field_77994_a = 1;
                    ItemStack[] Input = new ItemStack[]{returnValue, cableStack, rodStack, pistonStack, motorStack};
                    mAdd[mcount++] = CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getRobotArm(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
                }
                for (boolean y : mAdd) {
                    if (!y) continue;
                    ++added;
                }
                return added >= oreDictList.length / 2;
            }
            ItemStack[] Input = new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(tier), 1), cableStack, rodStack, pistonStack, motorStack};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getRobotArm(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipeFieldGenerator(int tier) {
        try {
            String mWT = tier == 1 ? "01" : (tier == 2 ? "02" : (tier == 3 ? "04" : (tier == 4 ? "08" : (tier == 5 ? "16" : "01"))));
            ItemStack eyeQuantum = ItemList.QuantumEye.get(1L, new Object[0]);
            ItemStack starQuantum = ItemList.QuantumStar.get(1L, new Object[0]);
            ItemStack gem = tier == 1 ? ItemUtils.getSimpleStack(Items.field_151079_bi) : (tier == 2 ? ItemUtils.getSimpleStack(Items.field_151061_bv) : (tier == 3 ? eyeQuantum : (tier == 4 ? ItemUtils.getSimpleStack(Items.field_151156_bN) : (tier == 5 ? starQuantum : ItemUtils.getSimpleStack(Items.field_151079_bi)))));
            OrePrefixes prefixWire = OrePrefixes.getOrePrefix((String)("wireGt" + mWT));
            ItemStack wireStack = ItemUtils.getGregtechOreStack(prefixWire, Materials.Osmium, 4);
            ItemStack[] oreDictList = CI.getAllCircuitsOfTier(tier);
            if (oreDictList.length > 0) {
                int mcount = 0;
                int added = 0;
                boolean[] mAdd = new boolean[oreDictList.length];
                for (ItemStack mCircuitType : oreDictList) {
                    ItemStack returnValue = mCircuitType.func_77946_l();
                    returnValue.field_77994_a = 4;
                    ItemStack[] Input = new ItemStack[]{returnValue, wireStack, gem};
                    mAdd[mcount++] = CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getFieldGenerator(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
                }
                for (boolean y : mAdd) {
                    if (!y) continue;
                    ++added;
                }
                return added >= oreDictList.length / 2;
            }
            ItemStack[] Input = new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(tier), 4), wireStack, gem};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getFieldGenerator(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipeEmitter(int tier, Materials cable, Materials stick, Materials gem) {
        try {
            ItemStack cableStack = ItemUtils.getGregtechOreStack(OrePrefixes.cableGt01, cable, 2);
            ItemStack gemstack = ItemUtils.getGregtechOreStack(OrePrefixes.gem, gem, 1);
            ItemStack magrodStack = ItemUtils.getGregtechOreStack(OrePrefixes.stick, stick, 4);
            ItemStack[] oreDictList = CI.getAllCircuitsOfTier(tier);
            if (oreDictList.length > 0) {
                int mcount = 0;
                int added = 0;
                boolean[] mAdd = new boolean[oreDictList.length];
                for (ItemStack mCircuitType : oreDictList) {
                    ItemStack returnValue = mCircuitType.func_77946_l();
                    returnValue.field_77994_a = 2;
                    ItemStack[] Input = new ItemStack[]{returnValue, cableStack, gemstack, magrodStack};
                    mAdd[mcount++] = CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getEmitter(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
                }
                for (boolean y : mAdd) {
                    if (!y) continue;
                    ++added;
                }
                return added >= oreDictList.length / 2;
            }
            ItemStack[] Input = new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(tier), 2), cableStack, gemstack, magrodStack};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getEmitter(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean addRecipeSensor(int tier, Materials plate, Materials rod, Materials gem) {
        try {
            ItemStack cableStack = ItemUtils.getGregtechOreStack(OrePrefixes.plate, plate, 4);
            ItemStack magrodStack = ItemUtils.getGregtechOreStack(OrePrefixes.stick, rod, 1);
            ItemStack gemStack = ItemUtils.getGregtechOreStack(OrePrefixes.gem, gem, 1);
            ItemStack[] oreDictList = CI.getAllCircuitsOfTier(tier);
            if (oreDictList.length > 0) {
                int mcount = 0;
                int added = 0;
                boolean[] mAdd = new boolean[oreDictList.length];
                for (ItemStack mCircuitType : oreDictList) {
                    ItemStack returnValue = mCircuitType.func_77946_l();
                    returnValue.field_77994_a = 1;
                    ItemStack[] Input = new ItemStack[]{gemStack, cableStack, returnValue, magrodStack};
                    mAdd[mcount++] = CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getSensor(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
                }
                for (boolean y : mAdd) {
                    if (!y) continue;
                    ++added;
                }
                return added >= oreDictList.length / 2;
            }
            ItemStack[] Input = new ItemStack[]{gemStack, cableStack, magrodStack, ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(tier), 1)};
            return CORE.RA.addComponentMakerRecipe(Input, GT_Values.NF, CI.getSensor(tier, 1), tier * 40, (int)GT_Values.V[tier] / 16 * 15);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

