/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.plugin.agrichem.BioRecipes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoader_GlueLine {
    public static void generate() {
        RecipeLoader_GlueLine.createRecipes();
    }

    private static void createRecipes() {
        RecipeLoader_GlueLine.chemicalPlantRecipes();
        RecipeLoader_GlueLine.chemicalReactorRecipes();
        RecipeLoader_GlueLine.dehydratorRecipes();
        RecipeLoader_GlueLine.distillationTowerRecipes();
        RecipeLoader_GlueLine.electrolyzerRecipes();
        RecipeLoader_GlueLine.fluidHeaterRecipes();
        RecipeLoader_GlueLine.mixerRecipes();
        RecipeLoader_GlueLine.glueUsageRecipes();
    }

    private static void chemicalPlantRecipes() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(17), ItemUtils.getSimpleStack(GenericChem.mBlueCatalyst, 0)}, new FluidStack[]{FluidUtils.getFluidStack("carbonmonoxide", 1000), FluidUtils.getFluidStack("methylacetate", 1000)}, new ItemStack[0], new FluidStack[]{MISC_MATERIALS.ACETIC_ANHYDRIDE.getFluidStack(1000)}, 200, 500L, 3);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(18)}, new FluidStack[]{FluidUtils.getFluidStack("aceticacid", 1000), FluidUtils.getFluidStack("chlorine", 1000), MISC_MATERIALS.ACETIC_ANHYDRIDE.getFluidStack(1000)}, new ItemStack[0], new FluidStack[]{MISC_MATERIALS.CHLOROACETIC_MIXTURE.getFluidStack(1000), MISC_MATERIALS.ACETIC_ANHYDRIDE.getFluidStack(950)}, 3000, 1000L, 4);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(19), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 6), MISC_MATERIALS.SODIUM_CYANIDE.getDust(3)}, new FluidStack[]{MISC_MATERIALS.CHLOROACETIC_ACID.getFluidStack(1000), FluidUtils.getFluidStack("hydrochloricacid_gt5u", 2000)}, new ItemStack[]{MISC_MATERIALS.CYANOACETIC_ACID.getDust(9), Materials.Salt.getDust(6)}, new FluidStack[]{Materials.CarbonDioxide.getGas(1000L), GT_ModHandler.getWater((long)1000L)}, 400, 1000L, 4);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(20), ItemUtils.getSimpleStack(GenericChem.mSolidAcidCatalyst, 0), MISC_MATERIALS.COPPER_SULFATE.getDust(6), MISC_MATERIALS.CYANOACETIC_ACID.getDust(45)}, new FluidStack[]{Materials.Ethanol.getFluid(5000L)}, new ItemStack[]{MISC_MATERIALS.COPPER_SULFATE_HYDRATED.getDust(11)}, new FluidStack[]{MISC_MATERIALS.ETHYL_CYANOACETATE.getFluidStack(5000)}, 10000, 6000L, 5);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(21), MISC_MATERIALS.CYANOACETIC_ACID.getDust(9)}, new FluidStack[]{Materials.Ethanol.getFluid(1000L)}, new ItemStack[0], new FluidStack[]{MISC_MATERIALS.ETHYL_CYANOACETATE.getFluidStack(1000)}, 20000, 6000L, 5);
        BioRecipes.mFormaldehyde = FluidUtils.getFluidStack("fluid.formaldehyde", 1).getFluid();
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(22), ItemUtils.getSimpleStack(GenericChem.mSolidAcidCatalyst, 0)}, new FluidStack[]{MISC_MATERIALS.ETHYL_CYANOACETATE.getFluidStack(100), FluidUtils.getFluidStack(BioRecipes.mFormaldehyde, 100)}, new ItemStack[0], new FluidStack[]{MISC_MATERIALS.CYANOACRYLATE_POLYMER.getFluidStack(100), FluidUtils.getWater(1000)}, 200, 8000L, 5);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedCircuit(23), ItemUtils.getSimpleStack(GenericChem.mPinkCatalyst, 0)}, new FluidStack[]{FluidUtils.getFluidStack("methane", 2000), FluidUtils.getFluidStack("ammonia", 2000), FluidUtils.getFluidStack("oxygen", 6000)}, new ItemStack[0], new FluidStack[]{MISC_MATERIALS.HYDROGEN_CYANIDE.getFluidStack(2000), FluidUtils.getWater(6000)}, 200, 500L, 3);
    }

    private static void chemicalReactorRecipes() {
        GT_Values.RA.addChemicalRecipe(CI.getNumberedCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 3), MISC_MATERIALS.HYDROGEN_CYANIDE.getFluidStack(1000), FluidUtils.getWater(1000), MISC_MATERIALS.SODIUM_CYANIDE.getDust(3), 200);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{CI.getNumberedCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 3)}, new FluidStack[]{MISC_MATERIALS.HYDROGEN_CYANIDE.getFluidStack(1000)}, new FluidStack[]{FluidUtils.getWater(1000)}, new ItemStack[]{MISC_MATERIALS.SODIUM_CYANIDE.getDust(3)}, 200, 30);
        if (LoadedMods.BartWorks) {
            GT_Values.RA.addChemicalRecipe(CI.getNumberedCircuit(18), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 5), Materials.HydrochloricAcid.getFluid(2000L), Materials.CarbonDioxide.getGas(1000L), ItemUtils.getItemStackFromFQRN("bartworks:gt.bwMetaGenerateddust:63", 3), 100);
        } else {
            GT_Values.RA.addChemicalRecipe(CI.getNumberedCircuit(18), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 5), Materials.HydrochloricAcid.getFluid(2000L), Materials.CarbonDioxide.getGas(1000L), MISC_MATERIALS.CALCIUM_CHLORIDE.getDust(3), 100);
        }
        GT_Values.RA.addChemicalRecipe(CI.getNumberedCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 1), FluidUtils.getFluidStack("sulfuricacid", 2000), FluidUtils.getFluidStack("dilutedsulfuricacid", 1000), MISC_MATERIALS.COPPER_SULFATE.getDust(6), 100);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{CI.getNumberedCircuit(19), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 1)}, new FluidStack[]{FluidUtils.getFluidStack("sulfuricacid", 2000)}, new FluidStack[]{FluidUtils.getFluidStack("dilutedsulfuricacid", 1000)}, new ItemStack[]{MISC_MATERIALS.COPPER_SULFATE.getDust(6)}, 100, 30);
    }

    private static void dehydratorRecipes() {
        CORE.RA.addDehydratorRecipe(new ItemStack[]{MISC_MATERIALS.COPPER_SULFATE_HYDRATED.getDust(11)}, null, GT_ModHandler.getWater((long)5000L), new ItemStack[]{MISC_MATERIALS.COPPER_SULFATE.getDust(6)}, new int[]{10000, 10000, 10000}, 6000, 10);
    }

    private static void distillationTowerRecipes() {
        GT_Values.RA.addDistillationTowerRecipe(MISC_MATERIALS.CHLOROACETIC_MIXTURE.getFluidStack(1000), new FluidStack[]{MISC_MATERIALS.CHLOROACETIC_ACID.getFluidStack(100), MISC_MATERIALS.DICHLOROACETIC_ACID.getFluidStack(450), MISC_MATERIALS.TRICHLOROACETIC_ACID.getFluidStack(450)}, null, 80, MaterialUtils.getVoltageForTier(5));
    }

    private static void electrolyzerRecipes() {
        if (!LoadedMods.BartWorks) {
            GT_Values.RA.addElectrolyzerRecipe(CI.getNumberedCircuit(1), MISC_MATERIALS.CALCIUM_CHLORIDE.getDust(3), null, Materials.Chlorine.getFluid(2000L), Materials.Calcium.getDust(1), null, null, null, null, null, new int[]{10000, 10000, 10000}, 600, 120);
        }
    }

    private static void fluidHeaterRecipes() {
        CORE.RA.addFluidHeaterRecipe(CI.getNumberedCircuit(16), MISC_MATERIALS.CYANOACRYLATE_POLYMER.getFluidStack(100), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(100), 900, 500);
    }

    private static void mixerRecipes() {
        GT_Values.RA.addMixerRecipe(CI.getNumberedCircuit(1), MISC_MATERIALS.DICHLOROACETIC_ACID.getCell(1), null, null, MISC_MATERIALS.TRICHLOROACETIC_ACID.getFluidStack(1000), MISC_MATERIALS.CHLOROACETIC_MIXTURE.getFluidStack(2000), CI.emptyCells(1), 100, 100);
        GT_Values.RA.addMixerRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurTrioxide", 1), CI.getNumberedCircuit(2), null, null, FluidUtils.getFluidStack("sulfuricacid", 1000), MISC_MATERIALS.SOLID_ACID_MIXTURE.getFluidStack(1000), CI.emptyCells(1), 100, 40);
    }

    private static void glueUsageRecipes() {
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Polybenzimidazole, (long)1L), GT_ModHandler.getIC2Item((String)"carbonMesh", (long)1L), CI.getNumberedCircuit(10)}, MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(100), ItemList.Duct_Tape.get(16L, new Object[0]), 120, 30);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemList.Hull_LV.get(1L, new Object[0]), ItemList.Duct_Tape.get(1L, new Object[0]), CI.getNumberedCircuit(1)}, MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(100), ItemList.Hatch_Maintenance.get(1L, new Object[0]), 120, 30);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustGraphite", 64), ItemList.Circuit_Silicon_Wafer4.get(2L, new Object[0]), CI.getNumberedCircuit(2)}, MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(500), ItemUtils.getItemStackOfAmountFromOreDict("dustGraphene", 64), 400, 30720);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustGraphite", 64), ItemList.Circuit_Silicon_Wafer5.get(1L, new Object[0]), CI.getNumberedCircuit(2)}, MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(250), ItemUtils.getItemStackOfAmountFromOreDict("dustGraphene", 64), 80, 122880);
        GT_Values.RA.addMixerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Sulfur, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Lithium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Wood, (long)4L), GT_Values.NI, GT_Values.NI, GT_Utility.getIntegratedCircuit((int)1), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(100), null, ItemList.SFMixture.get(32L, new Object[0]), 1600, 16);
        GT_Values.RA.addMixerRecipe(ItemList.GelledToluene.get(1L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Aluminium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Polybenzimidazole, (long)1L), GT_Values.NI, GT_Values.NI, GT_Utility.getIntegratedCircuit((int)1), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(100), null, ItemList.SFMixture.get(64L, new Object[0]), 1600, 16);
        GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.PolyvinylChloride, (long)8L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Paper, (long)32L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(200), new ItemStack(Items.field_151122_aG, 64, 0), 32, 8);
        if (LoadedMods.TecTech) {
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt01, (Object)Materials.Naquadah, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.RedSteel, (long)18L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(144), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32505", 1), 300, 7680);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt01, (Object)Materials.NaquadahAlloy, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Europium, (long)6L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(288), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32506", 1), 200, 30720);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt01, (Object)Materials.ElectrumFlux, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Americium, (long)18L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(576), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32507", 1), 300, 122880);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt02, (Object)Materials.ElectrumFlux, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Naquadah, (long)24L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(1152), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32561", 1), 100, 491520);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt04, (Object)Materials.ElectrumFlux, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.NaquadahEnriched, (long)36L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(2304), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32562", 1), 200, 0x1E0000);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cableGt08, (Object)Materials.ElectrumFlux, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.NaquadahAlloy, (long)48L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(4608), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32563", 1), 300, 0x1E0000);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt16, (Object)Materials.SuperconductorUHV, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Neutronium, (long)56L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(9216), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32564", 1), 600, 0x1E0000);
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt16, (Object)Materials.SuperconductorUHV, (long)2L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.DraconiumAwakened, (long)64L), MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(18432), ItemUtils.getItemStackFromFQRN("gregtech:gt.metaitem.01:32565", 1), 1200, 0x1E0000);
        }
        if (LoadedMods.DreamCraft && LoadedMods.GalacticraftCore) {
            GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemUtils.getItemStackFromFQRN("GalacticraftMars:item.itemBasicAsteroids:7", 1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.foil, (Object)Materials.Titanium, (long)8L), ItemUtils.getItemStackFromFQRN("dreamcraft:item.TungstenString", 8), CI.getNumberedCircuit(1)}, MISC_MATERIALS.ETHYL_CYANOACRYLATE.getFluidStack(576), ItemUtils.getItemStackFromFQRN("GalaxySpace:item.ThermalClothT2", 1), 600, 1024);
        }
    }
}

