/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.ITexture;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGen_Plates
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_Plates(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        int tVoltageMultiplier = material.getMeltingPointK() >= 2800 ? 60 : 15;
        ItemStack ingotStackOne = material.getIngot(1);
        ItemStack ingotStackTwo = material.getIngot(2);
        ItemStack ingotStackThree = material.getIngot(3);
        ItemStack ingotStackNine = material.getIngot(9);
        ItemStack shape_Mold = ItemList.Shape_Mold_Plate.get(0L, new Object[0]);
        ItemStack plate_Single = material.getPlate(1);
        ItemStack plate_SingleTwo = material.getPlate(2);
        ItemStack plate_SingleNine = material.getPlate(9);
        ItemStack plate_Double = material.getPlateDouble(1);
        ItemStack plate_Dense = material.getPlateDense(1);
        ItemStack foil_SingleFour = material.getFoil(4);
        ItemStack block = material.getBlock(1);
        Logger.WARNING("Generating Plate recipes for " + material.getLocalizedName());
        if (ItemUtils.checkForInvalidItems(ingotStackTwo) && ItemUtils.checkForInvalidItems(plate_Single)) {
            if (RecipeGen_Plates.addForgeHammerRecipe(ingotStackThree, plate_SingleTwo, (int)Math.max(material.getMass(), 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Forge Hammer Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Forge Hammer Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(ingotStackOne) && ItemUtils.checkForInvalidItems(plate_Single)) {
            if (RecipeGen_Plates.addBenderRecipe(ingotStackOne, plate_Single, (int)Math.max(material.getMass() * 1L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(ingotStackOne) && ItemUtils.checkForInvalidItems(foil_SingleFour)) {
            if (RecipeGen_Plates.addBenderRecipe(ingotStackOne, CI.getNumberedCircuit(10), foil_SingleFour, (int)Math.max(material.getMass() * 2L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(ingotStackTwo) && ItemUtils.checkForInvalidItems(plate_Single)) {
            if (GT_Values.RA.addAlloySmelterRecipe(ingotStackTwo, shape_Mold, plate_Single, (int)Math.max(material.getMass() * 2L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Alloy Smelter Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Alloy Smelter Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(block) && ItemUtils.checkForInvalidItems(plate_Single)) {
            if (GT_Values.RA.addCutterRecipe(block, plate_SingleNine, null, (int)Math.max(material.getMass() * 10L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Cutting Machine Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Cutting Machine Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(ingotStackTwo) && ItemUtils.checkForInvalidItems(plate_Double)) {
            if (RecipeGen_Plates.addBenderRecipe(ingotStackTwo, plate_Double, (int)Math.max(material.getMass() * 2L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(plate_SingleTwo) && ItemUtils.checkForInvalidItems(plate_Double)) {
            if (RecipeGen_Plates.addBenderRecipe(plate_SingleTwo, plate_Double, (int)Math.max(material.getMass() * 2L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(material.getPlate(1)) && ItemUtils.checkForInvalidItems(material.getFoil(1))) {
            if (RecipeGen_Plates.addBenderRecipe(material.getPlate(1), material.getFoil(4), (int)Math.max(material.getMass(), 1L), material.vVoltageMultiplier)) {
                GregTech_API.registerCover((ItemStack)material.getFoil(1), (ITexture)new GT_RenderedTexture(material.getTextureSet().mTextures[70], material.getRGBA(), false), null);
                Logger.WARNING("Bender Foil Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Foil Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(ingotStackNine) && ItemUtils.checkForInvalidItems(plate_Dense)) {
            if (RecipeGen_Plates.addBenderRecipe(ingotStackNine, plate_Dense, (int)Math.max(material.getMass() * 2L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(plate_SingleNine) && ItemUtils.checkForInvalidItems(plate_Dense)) {
            if (RecipeGen_Plates.addBenderRecipe(plate_SingleNine, plate_Double, (int)Math.max(material.getMass() * 2L, 1L), material.vVoltageMultiplier)) {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
            } else {
                Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Failed");
            }
        }
    }

    public static boolean addBenderRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt) {
        return GT_Values.RA.addBenderRecipe(aInput1, aOutput1, aDuration, aEUt);
    }

    public static boolean addBenderRecipe(ItemStack aInput1, ItemStack aCircuit, ItemStack aOutput1, int aDuration, int aEUt) {
        return GT_Values.RA.addBenderRecipe(aInput1, aCircuit, aOutput1, aDuration, aEUt);
    }

    public static boolean addExtruderRecipe(ItemStack aInput, ItemStack aShape, ItemStack aOutput, int aDuration, int aEUt) {
        if (aInput == null || aShape == null || aOutput == null) {
            return false;
        }
        if ((aDuration = GregTech_API.sRecipeFile.get((Object)"extruder", aOutput, aDuration)) <= 0) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sExtruderRecipes.addRecipe(true, new ItemStack[]{aInput, aShape}, new ItemStack[]{aOutput}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    public static boolean addForgeHammerRecipe(ItemStack aInput1, ItemStack aOutput1, int aDuration, int aEUt) {
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)"forgehammer", aOutput1, true)) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sHammerRecipes.addRecipe(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1}, null, null, null, aDuration, aEUt, 0);
        return true;
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

