/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.misc;

import Ic2ExpReactorPlanner.SimulationData;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_AssemblyLineUtils;
import gregtech.api.util.GT_Assemblyline_Server;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.api.gui.widget.DataStickSlotWidget;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.computer.GT_Computercube_Description;
import gtPlusPlus.xmod.gregtech.common.computer.GT_Computercube_Simulator;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GT_TileEntity_ComputerCube
extends GT_MetaTileEntity_BasicTank
implements IAddGregtechLogo {
    public static int MODE_MAIN = 0;
    public static int MODE_REACTOR_PLANNER = 1;
    public static int MODE_SCANNER = 2;
    public static int MODE_CENTRIFUGE = 3;
    public static int MODE_FUSION = 4;
    public static int MODE_INFO = 5;
    public static int MODE_ELECTROLYZER = 6;
    public static boolean mSeedscanner = true;
    public static boolean mReactorplanner = true;
    public static ArrayList<GT_ItemStack> sReactorList;
    public boolean mStarted = false;
    public int mMode = 0;
    public int mHeat = 0;
    public long mEUOut = 0L;
    public int mMaxHeat = 1;
    public long mEU = 0L;
    public int mProgress = 0;
    public int mMaxProgress = 0;
    public int mEUTimer = 0;
    public int mEULast1 = 0;
    public int mEULast2 = 0;
    public int mEULast3 = 0;
    public int mEULast4 = 0;
    public float mHEM = 1.0f;
    public float mExplosionStrength = 0.0f;
    public String mFusionOutput = "";
    private boolean mNeedsUpdate;
    private GT_Computercube_Simulator mSimulator;
    public static ArrayList<GT_Recipe> sFusionReactorRecipes;
    protected static final int DID_NOT_FIND_RECIPE = 0;
    protected static final int FOUND_RECIPE_BUT_DID_NOT_MEET_REQUIREMENTS = 1;
    protected static final int FOUND_AND_SUCCESSFULLY_USED_RECIPE = 2;

    public GT_TileEntity_ComputerCube(int aID, String aDescription) {
        super(aID, "computer.cube", "Computer Cube MKII", 5, 114, aDescription, new ITexture[0]);
    }

    public GT_TileEntity_ComputerCube(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 5, 114, aDescription, aTextures);
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Built in Reactor Planner", "Built in Scanner", "Built in Info-Bank", "Displays Fusion Recipes", CORE.GT_Tooltip.get()};
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)aBaseMetaTileEntity, (EntityPlayer)aPlayer);
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_ComputerCube(this.mName, this.mDescription, this.mTextures);
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        ItemStack tStack = aPlayer.func_71045_bC();
        return tStack == null || !ItemList.Tool_DataOrb.isStackEqual((Object)tStack);
    }

    public final GT_Computercube_Simulator getSimulator() {
        return this.mSimulator;
    }

    public final void setSimulator(GT_Computercube_Simulator mSimulator) {
        this.mSimulator = mSimulator;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(byte aDirection) {
        return true;
    }

    public long maxAmperesIn() {
        return 4L;
    }

    public long maxEUInput() {
        return GT_Values.V[4];
    }

    public long maxEUStore() {
        return GT_Values.V[5] * 1024L;
    }

    public boolean ownerControl() {
        return false;
    }

    public int func_70302_i_() {
        return 114;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex > 53 && aIndex < 58;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public void saveNuclearReactor() {
        for (int i = 0; i < 54; ++i) {
            this.mInventory[i + 59] = this.mInventory[i] == null ? null : this.mInventory[i].func_77946_l();
        }
    }

    public void loadNuclearReactor() {
        for (int i = 0; i < 54; ++i) {
            this.mInventory[i] = this.mInventory[i + 59] == null ? null : this.mInventory[i + 59].func_77946_l();
        }
    }

    public int getXCoord() {
        return this.getBaseMetaTileEntity().getXCoord();
    }

    public int getYCoord() {
        return this.getBaseMetaTileEntity().getYCoord();
    }

    public int getZCoord() {
        return this.getBaseMetaTileEntity().getZCoord();
    }

    public void reset() {
        int i;
        this.mEU = 0L;
        this.mHeat = 0;
        this.mEUOut = 0L;
        this.mMaxHeat = 10000;
        this.mHEM = 1.0f;
        this.mExplosionStrength = 0.0f;
        this.mProgress = 0;
        this.mMaxProgress = 0;
        this.mFusionOutput = "";
        this.mInventory[113] = null;
        for (i = 0; i < 54; ++i) {
            this.mInventory[i] = null;
            this.mInventory[i + 59] = null;
        }
        for (i = 54; i < 58; ++i) {
            if (this.mInventory[i] == null) continue;
            if (!this.getWorld().field_72995_K) {
                this.getWorld().func_72838_d((Entity)new EntityItem(this.getWorld(), (double)this.getXCoord() + 0.5, (double)this.getYCoord() + 0.5, (double)this.getZCoord() + 0.5, this.mInventory[i]));
            }
            this.mInventory[i] = null;
        }
    }

    public void switchModeForward() {
        int aTempMode = this.mMode;
        if (++aTempMode == MODE_ELECTROLYZER || aTempMode == MODE_CENTRIFUGE) {
            ++aTempMode;
        }
        if (aTempMode >= 7) {
            aTempMode = 0;
        }
        this.mMode = aTempMode;
        this.switchMode();
    }

    public void switchModeBackward() {
        int aTempMode = this.mMode;
        if (--aTempMode == MODE_ELECTROLYZER || aTempMode == MODE_CENTRIFUGE) {
            --aTempMode;
        }
        if (aTempMode < 0) {
            aTempMode = 6;
        }
        this.mMode = aTempMode;
        this.switchMode();
    }

    private void switchMode() {
        this.reset();
        if (this.mMode == MODE_REACTOR_PLANNER && !mReactorplanner) {
            this.switchMode();
            return;
        }
        if (this.mMode == MODE_SCANNER && !mSeedscanner) {
            this.switchMode();
            return;
        }
        if (this.mMode == MODE_CENTRIFUGE) {
            this.showCentrifugeRecipe(0);
        }
        if (this.mMode == MODE_FUSION) {
            this.showFusionRecipe(0);
        }
        if (this.mMode == MODE_INFO) {
            this.showDescription(0);
        }
        if (this.mMode == MODE_ELECTROLYZER) {
            this.showElectrolyzerRecipe(0);
        }
        this.getWorld().func_147452_c(this.getXCoord(), this.getYCoord(), this.getZCoord(), GregTech_API.sBlockMachines, 10, this.mMode);
        this.getWorld().func_147452_c(this.getXCoord(), this.getYCoord(), this.getZCoord(), GregTech_API.sBlockMachines, 11, this.mMaxHeat);
    }

    public void showDescription(int aIndex) {
        this.mExplosionStrength = 0.0f;
        if (GT_Computercube_Description.sDescriptions.isEmpty()) {
            return;
        }
        if (aIndex >= GT_Computercube_Description.sDescriptions.size() || aIndex < 0) {
            aIndex = 0;
        }
        this.mInventory[59] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[0] == null ? null : GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[0].func_77946_l();
        this.mInventory[60] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[1] == null ? null : GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[1].func_77946_l();
        this.mInventory[61] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[2] == null ? null : GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[2].func_77946_l();
        this.mInventory[62] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[3] == null ? null : GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[3].func_77946_l();
        this.mInventory[63] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[4] == null ? null : GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[4].func_77946_l();
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[5] == null) {
            this.mInventory[64] = null;
        } else {
            this.mInventory[64] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[5].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[6] == null) {
            this.mInventory[65] = null;
        } else {
            this.mInventory[65] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[6].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[7] == null) {
            this.mInventory[66] = null;
        } else {
            this.mInventory[66] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[7].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[8] == null) {
            this.mInventory[67] = null;
        } else {
            this.mInventory[67] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[8].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[9] == null) {
            this.mInventory[68] = null;
        } else {
            this.mInventory[68] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[9].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[10] == null) {
            this.mInventory[69] = null;
        } else {
            this.mInventory[69] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[10].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[11] == null) {
            this.mInventory[70] = null;
        } else {
            this.mInventory[70] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[11].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[12] == null) {
            this.mInventory[71] = null;
        } else {
            this.mInventory[71] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[12].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        if (GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[13] == null) {
            this.mInventory[72] = null;
        } else {
            this.mInventory[72] = GT_Computercube_Description.sDescriptions.get((int)aIndex).mStacks[13].func_77946_l();
            this.mExplosionStrength = 100.0f;
        }
        this.mMaxHeat = aIndex;
        this.getWorld().func_147452_c(this.getXCoord(), this.getYCoord(), this.getZCoord(), GregTech_API.sBlockMachines, 11, this.mMaxHeat);
    }

    public void switchDescriptionPageForward() {
        if (++this.mMaxHeat >= GT_Computercube_Description.sDescriptions.size()) {
            this.mMaxHeat = 0;
        }
        this.showDescription(this.mMaxHeat);
    }

    public void switchDescriptionPageBackward() {
        if (--this.mMaxHeat < 0) {
            this.mMaxHeat = GT_Computercube_Description.sDescriptions.size() - 1;
        }
        this.showDescription(this.mMaxHeat);
    }

    public void showCentrifugeRecipe(int aIndex) {
    }

    public void switchCentrifugePageForward() {
        if (++this.mMaxHeat >= GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.size()) {
            this.mMaxHeat = 0;
        }
    }

    public void switchCentrifugePageBackward() {
        if (--this.mMaxHeat < 0) {
            this.mMaxHeat = GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.size() - 1;
        }
    }

    public void showElectrolyzerRecipe(int aIndex) {
    }

    public void switchElectrolyzerPageForward() {
        if (++this.mMaxHeat >= GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList.size()) {
            this.mMaxHeat = 0;
        }
        this.showElectrolyzerRecipe(this.mMaxHeat);
    }

    public void switchElectrolyzerPageBackward() {
        if (--this.mMaxHeat < 0) {
            this.mMaxHeat = GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList.size() - 1;
        }
        this.showElectrolyzerRecipe(this.mMaxHeat);
    }

    public void showFusionRecipe(int aIndex) {
        GT_Recipe tRecipe;
        if (sFusionReactorRecipes.isEmpty()) {
            for (GT_Recipe aRecipe : GT_Recipe.GT_Recipe_Map.sFusionRecipes.mRecipeList) {
                sFusionReactorRecipes.add(aRecipe);
            }
            Collections.sort(sFusionReactorRecipes);
        }
        if (aIndex >= sFusionReactorRecipes.size() || aIndex < 0) {
            aIndex = 0;
        }
        if ((tRecipe = sFusionReactorRecipes.get(aIndex)) != null) {
            this.mInventory[59] = tRecipe.mFluidInputs[0] == null ? null : GT_Utility.getFluidDisplayStack((FluidStack)tRecipe.mFluidInputs[0], (boolean)true);
            this.mInventory[60] = tRecipe.mFluidInputs[1] == null ? null : GT_Utility.getFluidDisplayStack((FluidStack)tRecipe.mFluidInputs[1], (boolean)true);
            this.mInventory[61] = tRecipe.mFluidOutputs[0] == null ? null : GT_Utility.getFluidDisplayStack((FluidStack)tRecipe.mFluidOutputs[0], (boolean)true);
            this.mEU = tRecipe.mSpecialValue;
            this.mEUOut = tRecipe.mEUt;
            this.mHeat = tRecipe.mDuration;
            this.mMaxHeat = aIndex;
            this.mFusionOutput = tRecipe.mFluidOutputs[0].getLocalizedName();
        }
        this.getWorld().func_147452_c(this.getXCoord(), this.getYCoord(), this.getZCoord(), GregTech_API.sBlockMachines, 11, this.mMaxHeat);
    }

    public void switchFusionPageForward() {
        if (++this.mMaxHeat >= sFusionReactorRecipes.size()) {
            this.mMaxHeat = 0;
        }
        this.showFusionRecipe(this.mMaxHeat);
    }

    public void switchFusionPageBackward() {
        if (--this.mMaxHeat < 0) {
            this.mMaxHeat = sFusionReactorRecipes.size() - 1;
        }
        this.showFusionRecipe(this.mMaxHeat);
    }

    public void switchNuclearReactor() {
        if (this.mStarted) {
            this.stopNuclearReactor();
        } else {
            this.startNuclearReactor();
        }
    }

    public void startNuclearReactor() {
        this.mStarted = true;
        this.mHeat = 0;
        this.mEU = 0L;
        this.mSimulator.simulate();
    }

    public void stopNuclearReactor() {
        this.mStarted = false;
        this.mSimulator.simulate();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mMode", this.mMode);
        aNBT.func_74768_a("mProgress", this.mProgress);
        aNBT.func_74768_a("mMaxProgress", this.mMaxProgress);
        aNBT.func_74757_a("mStarted", this.mStarted);
        int[] aSplitLong1 = MathUtils.splitLongIntoTwoIntegers(this.mEU);
        aNBT.func_74768_a("mEU1", aSplitLong1[0]);
        aNBT.func_74768_a("mEU2", aSplitLong1[1]);
        aNBT.func_74768_a("mHeat", this.mHeat);
        int[] aSplitLong2 = MathUtils.splitLongIntoTwoIntegers(this.mEUOut);
        aNBT.func_74768_a("mEUOut1", aSplitLong2[0]);
        aNBT.func_74768_a("mEUOut2", aSplitLong2[1]);
        aNBT.func_74768_a("mMaxHeat", this.mMaxHeat);
        aNBT.func_74776_a("mHEM", this.mHEM);
        aNBT.func_74776_a("mExplosionStrength", this.mExplosionStrength);
        aNBT.func_74778_a("mFusionOutput", this.mFusionOutput);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mMode = aNBT.func_74762_e("mMode");
        this.mProgress = aNBT.func_74762_e("mProgress");
        this.mMaxProgress = aNBT.func_74762_e("mMaxProgress");
        this.mStarted = aNBT.func_74767_n("mStarted");
        int partA = aNBT.func_74762_e("mEU1");
        int partB = aNBT.func_74762_e("mEU2");
        this.mEU = MathUtils.combineTwoIntegersToLong(partA, partB);
        this.mHeat = aNBT.func_74762_e("mHeat");
        partA = aNBT.func_74762_e("mEUOut1");
        partB = aNBT.func_74762_e("mEUOut2");
        this.mEUOut = MathUtils.combineTwoIntegersToLong(partA, partB);
        this.mMaxHeat = aNBT.func_74762_e("mMaxHeat");
        this.mHEM = aNBT.func_74760_g("mHEM");
        this.mExplosionStrength = aNBT.func_74760_g("mExplosionStrength");
        this.mFusionOutput = aNBT.func_74779_i("mFusionOutput");
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mSimulator == null) {
            this.mSimulator = new GT_Computercube_Simulator(this);
        }
        if (this.getBaseMetaTileEntity().isClientSide()) {
            this.getWorld().func_147471_g(this.getXCoord(), this.getYCoord(), this.getZCoord());
            this.mNeedsUpdate = false;
        } else {
            this.mNeedsUpdate = false;
        }
        if (this.getBaseMetaTileEntity().isServerSide()) {
            SimulationData aData;
            if (this.mMode == MODE_SCANNER) {
                if (this.mInventory[57] == null) {
                    this.mInventory[57] = this.mInventory[56];
                    this.mInventory[56] = null;
                }
                if (!mSeedscanner || this.mMode == MODE_SCANNER) {
                    // empty if block
                }
            }
            if (this.mMode == MODE_REACTOR_PLANNER && mReactorplanner && this.mSimulator != null && this.mSimulator.simulator != null && this.mSimulator.simulatedReactor != null && (aData = this.mSimulator.simulator.getData()) != null && aData.totalReactorTicks > 0 && this.mProgress != aData.totalReactorTicks) {
                Logger.INFO("Updating Variables");
                this.mEU = aData.avgEUoutput;
                this.mEUOut = aData.totalEUoutput / aData.totalReactorTicks;
                this.mHeat = aData.avgHUoutput;
                this.mMaxHeat = aData.maxHUoutput;
                this.mExplosionStrength = aData.explosionPower;
                this.mHEM = (float)aData.hullHeating;
                this.mProgress = aData.totalReactorTicks;
            }
            if (aTick % 20L == 0L) {
                this.getWorld().func_147452_c(this.getXCoord(), this.getYCoord(), this.getZCoord(), GregTech_API.sBlockMachines, 10, this.mMode);
                this.getWorld().func_147452_c(this.getXCoord(), this.getYCoord(), this.getZCoord(), GregTech_API.sBlockMachines, 11, this.mMaxHeat);
            }
        }
    }

    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (this.getWorld().field_72995_K) {
            switch (aEventID) {
                case 10: {
                    this.mNeedsUpdate = true;
                    this.mMode = aValue;
                    break;
                }
                case 11: {
                    this.mMaxHeat = aValue;
                }
            }
        }
    }

    public void onValueUpdate(byte aValue) {
        super.onValueUpdate(aValue);
        this.mNeedsUpdate = true;
    }

    public void onMachineBlockUpdate() {
        super.onMachineBlockUpdate();
        this.mNeedsUpdate = true;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.mMode == MODE_SCANNER ? i == 54 || i == 55 : false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.mMode == MODE_SCANNER ? i == 56 || i == 57 : false;
    }

    public World getWorld() {
        return this.getBaseMetaTileEntity().getWorld();
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return false;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getSides(i);
            rTextures[2][i + 1] = this.getSides(i);
            rTextures[3][i + 1] = this.getSides(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getSides(i);
            rTextures[7][i + 1] = this.getSides(i);
            rTextures[8][i + 1] = this.getSides(i);
            rTextures[9][i + 1] = this.getSides(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4)))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Screen_3)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Computer_Cube)};
    }

    protected void calculateOverclockedNess(int aEUt, int aDuration) {
        if (this.mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEU = 0x7FFFFFFEL;
                this.mMaxProgress = 0x7FFFFFFE;
            } else {
                this.mEU = aEUt >> 2;
                this.mMaxProgress = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgress = aDuration;
            while (tempEUt <= GT_Values.V[this.mTier - 1] * this.maxAmperesIn()) {
                tempEUt <<= 2;
                this.mMaxProgress >>= 1;
                xEUt = this.mMaxProgress == 0 ? xEUt >> 1 : xEUt << 2;
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEU = 0x7FFFFFFEL;
                this.mMaxProgress = 0x7FFFFFFE;
            } else {
                this.mEU = (int)xEUt;
                if (this.mEU == 0L) {
                    this.mEU = 1L;
                }
                if (this.mMaxProgress == 0) {
                    this.mMaxProgress = 1;
                }
            }
        }
    }

    public int doScan(ItemStack aInput) {
        if (this.mMode != MODE_SCANNER) {
            return 0;
        }
        ItemStack aStack = aInput;
        if (this.mInventory[56] != null) {
            return 0;
        }
        if (GT_Utility.isStackValid((Object)aStack) && aStack.field_77994_a > 0) {
            if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true)) {
                NBTTagCompound tNBT = aStack.func_77978_p();
                if (tNBT == null) {
                    tNBT = new NBTTagCompound();
                }
                if (tNBT.func_74771_c("scan") < 4) {
                    tNBT.func_74774_a("scan", (byte)4);
                    this.calculateOverclockedNess(8, 160);
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                } else {
                    this.mMaxProgress = 1;
                    this.mEU = 1L;
                }
                --aStack.field_77994_a;
                this.mInventory[57] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack});
                this.mInventory[57].func_77982_d(tNBT);
                return 2;
            }
            if (ItemList.Tool_DataOrb.isStackEqual((Object)this.getSpecialSlot(), false, true)) {
                if (ItemList.Tool_DataOrb.isStackEqual((Object)aStack, false, true)) {
                    --aStack.field_77994_a;
                    this.mInventory[57] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{this.getSpecialSlot()});
                    this.calculateOverclockedNess(30, 512);
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                    return 2;
                }
                ItemData tData = GT_OreDictUnificator.getAssociation((ItemStack)aStack);
                if (!(tData == null || tData.mPrefix != OrePrefixes.dust && tData.mPrefix != OrePrefixes.cell || tData.mMaterial.mMaterial.mElement == null || tData.mMaterial.mMaterial.mElement.mIsIsotope || tData.mMaterial.mMaterial == Materials.Magic || tData.mMaterial.mMaterial.getMass() <= 0L)) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mInventory[57] = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mInventory[57], (String)"Elemental-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mInventory[57], (String)tData.mMaterial.mMaterial.mElement.name());
                    this.calculateOverclockedNess(30, GT_Utility.safeInt((long)(tData.mMaterial.mMaterial.getMass() * 8192L)));
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                    return 2;
                }
            }
            if (ItemList.Tool_DataStick.isStackEqual((Object)this.getSpecialSlot(), false, true)) {
                if (ItemList.Tool_DataStick.isStackEqual((Object)aStack, false, true)) {
                    --aStack.field_77994_a;
                    this.mInventory[57] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{this.getSpecialSlot()});
                    this.calculateOverclockedNess(30, 128);
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                    return 2;
                }
                if (aStack.func_77973_b() == Items.field_151164_bB) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mInventory[57] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{this.getSpecialSlot()});
                    this.mInventory[57].func_77982_d(aStack.func_77978_p());
                    this.calculateOverclockedNess(30, 128);
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                    return 2;
                }
                if (aStack.func_77973_b() == Items.field_151098_aY) {
                    --this.getSpecialSlot().field_77994_a;
                    --aStack.field_77994_a;
                    this.mInventory[57] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{this.getSpecialSlot()});
                    this.mInventory[57].func_77982_d(GT_Utility.getNBTContainingShort((NBTTagCompound)new NBTTagCompound(), (Object)"map_id", (short)((short)aStack.func_77960_j())));
                    this.calculateOverclockedNess(30, 128);
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                    return 2;
                }
            }
            if (ItemList.Tool_DataStick.isStackEqual((Object)this.getSpecialSlot(), false, true) && aStack != null) {
                for (GT_Recipe.GT_Recipe_AssemblyLine tRecipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
                    if (!GT_Utility.areStacksEqual((ItemStack)tRecipe.mResearchItem, (ItemStack)aStack, (boolean)true)) continue;
                    boolean failScanner = true;
                    for (GT_Recipe scannerRecipe : GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.mRecipeList) {
                        if (!GT_Utility.areStacksEqual((ItemStack)scannerRecipe.mInputs[0], (ItemStack)aStack, (boolean)true)) continue;
                        failScanner = false;
                        break;
                    }
                    if (failScanner) {
                        return 1;
                    }
                    String s = tRecipe.mOutput.func_82833_r();
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (s = (String)GT_Assemblyline_Server.lServerNames.get(tRecipe.mOutput.func_82833_r())) == null) {
                        s = tRecipe.mOutput.func_82833_r();
                    }
                    this.mInventory[57] = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{this.getSpecialSlot()});
                    if (!GT_AssemblyLineUtils.setAssemblyLineRecipeOnDataStick((ItemStack)this.mInventory[57], (GT_Recipe.GT_Recipe_AssemblyLine)tRecipe)) continue;
                    --aStack.field_77994_a;
                    this.calculateOverclockedNess(30, tRecipe.mResearchTime);
                    if (this.mMaxProgress == 0x7FFFFFFE && this.mEU == 0x7FFFFFFEL) {
                        return 1;
                    }
                    --this.getSpecialSlot().field_77994_a;
                    return 2;
                }
            }
        }
        return 0;
    }

    private ItemStack getSpecialSlot() {
        return this.mInventory[54];
    }

    public boolean useModularUI() {
        return true;
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
    }

    public int getGUIWidth() {
        return this.mMode == 5 ? 226 : 176;
    }

    public boolean doesBindPlayerInventory() {
        return this.mMode != 1 && this.mMode != 5;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        switch (this.mMode) {
            case 0: {
                this.addPage0(builder);
                break;
            }
            case 1: {
                this.addPage1(builder);
                break;
            }
            case 2: {
                this.addPage2(builder);
                break;
            }
            case 3: {
                this.addPage3(builder);
                break;
            }
            case 4: {
                this.addPage4(builder);
                break;
            }
            case 5: {
                this.addPage5(builder);
                break;
            }
            case 6: {
                this.addPage6(builder);
            }
        }
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (clickData.mouseButton == 0) {
                this.switchModeForward();
            } else if (clickData.mouseButton == 1) {
                this.switchModeBackward();
            }
            if (!widget.isClient()) {
                GT_UIInfos.openGTTileEntityUI((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), (EntityPlayer)widget.getContext().getPlayer());
            }
        }).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_COMPUTER_MODE}).setPos(156 + (this.mMode == 5 ? 50 : 0), 4).setSize(16, 16));
    }

    private void addPage0(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_COMPUTER_TOP).setPos(32, 4).setSize(112, 76))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.getBaseMetaTileEntity().getStoredEU() / (float)this.getBaseMetaTileEntity().getEUCapacity())).setTexture(GTPP_UITextures.PROGRESSBAR_COMPUTER_ENERGY, 96).setDirection(ProgressBar.Direction.RIGHT).setPos(44, 8).setSize(96, 5))).widget(new TextWidget("Solaris 1.7.10").setDefaultColor(Utils.rgbtoHexValue(100, 190, 255)).setPos(56, 70));
    }

    private void addPage1(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 103).setSize(150, 59))).widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.ITEM_SLOT).setPos(4, 4).setSize(146, 98))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_V202).setPos(155, 103).setSize(17, 5))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.saveNuclearReactor()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_SAVE}).setPos(156, 54).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.loadNuclearReactor()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_LOAD}).setPos(156, 70).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchNuclearReactor()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_NUCLEAR_SWITCH}).setPos(156, 86).setSize(16, 16));
        NuclearSlotWidget displaySlot = new NuclearSlotWidget((IItemHandlerModifiable)this.inventoryHandler, 54, null);
        for (int i = 0; i < 54; ++i) {
            builder.widget(new NuclearSlotWidget((IItemHandlerModifiable)this.inventoryHandler, i, (Slot)displaySlot.getMcSlot()).setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(5 + i % 9 * 16, 5 + i / 9 * 16));
        }
        builder.widget(displaySlot.setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_ARROW_4}).setPos(152, 27));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget("Reactorstats:").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 108))).widget(TextWidget.dynamicString(() -> GT_Utility.formatNumbers((long)this.mEU) + "EU at " + this.mEUOut + "EU/t").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 120))).widget(TextWidget.dynamicString(() -> "HEM: " + this.mHEM / 10000.0f).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 128))).widget(TextWidget.dynamicString(() -> GT_Utility.formatNumbers((long)this.mHeat) + "/" + GT_Utility.formatNumbers((long)this.mMaxHeat) + "Heat").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 136))).widget(TextWidget.dynamicString(() -> "Explosionpower: " + this.mExplosionStrength / 100.0f).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 144))).widget(TextWidget.dynamicString(() -> "Runtime: " + (this.mProgress > 0 ? this.mProgress / 20 : 0) + "secs").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 152));
    }

    private void addPage2(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(48, 4).setSize(81, 67));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DataStickSlotWidget((IItemHandlerModifiable)this.inventoryHandler, 54).setPos(7, 27))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 55).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_MICROSCOPE}).setPos(25, 27))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 56).setAccess(true, false).setPos(133, 27))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 57).setAccess(true, false).setPos(151, 27));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextWidget("Scanner").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mProgress == 0).setPos(51, 7))).widget(new TextWidget("Can be used to").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mProgress == 0).setPos(51, 24))).widget(new TextWidget("scan things").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mProgress == 0).setPos(51, 32))).widget(new TextWidget("Currently").setDefaultColor(Utils.rgbtoHexValue(200, 20, 20)).setEnabled(widget -> this.mProgress == 0).setPos(51, 48))).widget(new TextWidget("Disabled").setDefaultColor(Utils.rgbtoHexValue(200, 20, 20)).setEnabled(widget -> this.mProgress == 0).setPos(51, 56))).widget(new TextWidget("Progress:").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mProgress != 0).setPos(51, 24))).widget(TextWidget.dynamicString(() -> MathUtils.findPercentage(this.mProgress, this.getBaseMetaTileEntity().getMaxProgress()) + " %").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mProgress != 0).setPos(51, 32))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mProgress, val -> {
            this.mProgress = val;
        }));
    }

    private void addPage3(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(86, 41))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_ARROWS_SEPARATE).setPos(110, 23).setSize(40, 40))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchCentrifugePageBackward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_LEFT}).setPos(88, 65).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchCentrifugePageForward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_RIGHT}).setPos(104, 65).setSize(16, 16))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)59).disableInteraction().setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_CENTRIFUGE}).setPos(121, 34))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)60).disableInteraction().setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_CANISTER}).setPos(91, 4))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)61).disableInteraction().setPos(121, 4))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)62).disableInteraction().setPos(151, 34))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)63).disableInteraction().setPos(121, 64))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)64).disableInteraction().setPos(91, 34))).widget(new TextWidget("Centrifuge").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 7))).widget(TextWidget.dynamicString(() -> "Recipe: " + (this.mMaxHeat + 1) + "/" + GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.size()).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 23))).widget(TextWidget.dynamicString(() -> "EU: " + GT_Utility.formatNumbers((long)this.mEU)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 31));
    }

    private void addPage4(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(116, 61))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_ARROWS_FUSION).setPos(121, 23).setSize(29, 40))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchFusionPageBackward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_LEFT}).setPos(88, 65).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchFusionPageForward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_RIGHT}).setPos(104, 65).setSize(16, 16))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)59).disableInteraction().setPos(121, 4))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)60).disableInteraction().setPos(121, 64))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)61).disableInteraction().setPos(151, 34))).widget(new TextWidget("Fusionreactor").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 7))).widget(TextWidget.dynamicString(() -> "Recipe: " + (this.mMaxHeat + 1) + "/" + sFusionReactorRecipes.size()).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 15))).widget(TextWidget.dynamicString(() -> "Start: " + GT_Utility.formatNumbers((long)this.mEU) + "EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 23))).widget(TextWidget.dynamicString(() -> "EU/t: " + GT_Utility.formatNumbers((long)this.mEUOut)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 31))).widget(TextWidget.dynamicString(() -> GT_Utility.formatNumbers((long)this.mHeat) + " Ticks").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 39))).widget(TextWidget.dynamicString(() -> GT_TileEntity_ComputerCube.sFusionReactorRecipes.get((int)this.mMaxHeat).mFluidOutputs[0].getLocalizedName()).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 55))).widget(TextWidget.dynamicString(() -> this.mEUOut < 0L ? "IN: " + GT_Utility.formatNumbers((long)(-this.mEUOut * (long)this.mHeat)) + "EU" : "OUT: " + GT_Utility.formatNumbers((long)(this.mEUOut * (long)this.mHeat)) + "EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 47));
    }

    private void addPage5(ModularWindow.Builder builder) {
        int i;
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(200, 141))).widget(new DrawableWidget().setDrawable(() -> this.mExplosionStrength != 0.0f ? GTPP_UITextures.PICTURE_COMPUTER_GRID : null).setPos(152, 6).setSize(50, 50))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchDescriptionPageBackward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_LEFT}).setPos(190, 146).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchDescriptionPageForward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_RIGHT}).setPos(206, 146).setSize(16, 16));
        for (i = 0; i < 5; ++i) {
            builder.widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)(i + 59)).disableInteraction().setPos(205, 37 + i * 18));
        }
        for (i = 0; i < 9; ++i) {
            builder.widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)(i + 64)).disableInteraction().setBackground(new IDrawable[]{GT_UITextures.TRANSPARENT}).setPos(152 + i % 3 * 16, 6 + i / 3 * 16));
        }
        int descriptionMaxLines = ((GT_Computercube_Description)GT_Computercube_Description.sDescriptions.stream().sorted((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$addPage5$35(gtPlusPlus.xmod.gregtech.common.computer.GT_Computercube_Description gtPlusPlus.xmod.gregtech.common.computer.GT_Computercube_Description ), (LgtPlusPlus/xmod/gregtech/common/computer/GT_Computercube_Description;LgtPlusPlus/xmod/gregtech/common/computer/GT_Computercube_Description;)I)()).collect(Collectors.toList()).get((int)0)).mDescription.length;
        int i2 = 0;
        while (i2 < descriptionMaxLines) {
            int index = i2++;
            builder.widget(TextWidget.dynamicString(() -> {
                String[] descriptions;
                if (this.mMaxHeat >= 0 && this.mMaxHeat < GT_Computercube_Description.sDescriptions.size() && index < (descriptions = GT_Computercube_Description.sDescriptions.get((int)this.mMaxHeat).mDescription).length) {
                    return descriptions[index];
                }
                return "";
            }).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 7 + index * 8));
        }
    }

    private void addPage6(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(86, 41))).widget(new DrawableWidget().setDrawable((IDrawable)GTPP_UITextures.PICTURE_ARROWS_SEPARATE).setPos(110, 23).setSize(40, 40))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchElectrolyzerPageBackward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_LEFT}).setPos(88, 65).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> this.switchElectrolyzerPageForward()).setBackground(new IDrawable[]{GTPP_UITextures.BUTTON_STANDARD_16x16, GTPP_UITextures.OVERLAY_BUTTON_ARROW_RIGHT}).setPos(104, 65).setSize(16, 16))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)59).disableInteraction().setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_CHARGER}).setPos(121, 34))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)60).disableInteraction().setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_CANISTER}).setPos(91, 4))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)61).disableInteraction().setPos(121, 4))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)62).disableInteraction().setPos(151, 34))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)63).disableInteraction().setPos(121, 64))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)64).disableInteraction().setPos(91, 34))).widget(new TextWidget("Electrolyzer").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 7))).widget(TextWidget.dynamicString(() -> "Recipe: " + (this.mMaxHeat + 1) + "/" + GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList.size()).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 23))).widget(TextWidget.dynamicString(() -> "EU: " + GT_Utility.formatNumbers((long)this.mEU)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 31));
    }

    private static /* synthetic */ int lambda$addPage5$35(GT_Computercube_Description d1, GT_Computercube_Description d2) {
        return d2.mDescription.length - d1.mDescription.length;
    }

    static {
        sFusionReactorRecipes = new ArrayList();
    }

    private class NuclearSlotWidget
    extends SlotWidget {
        private final Slot displaySlot;

        public NuclearSlotWidget(IItemHandlerModifiable handler, int index, Slot displaySlot) {
            super(BaseSlot.phantom((IItemHandlerModifiable)handler, (int)index));
            this.displaySlot = displaySlot != null ? displaySlot : this.getMcSlot();
        }

        protected void phantomClick(Widget.ClickData clickData, ItemStack cursorStack) {
            int aSlotIndex = this.getMcSlot().getSlotIndex() + 4;
            BaseSlot tSlot = this.getMcSlot();
            ItemStack tStack = tSlot.func_75211_c();
            if (clickData.shift) {
                tSlot.func_75215_d(null);
                GT_TileEntity_ComputerCube.this.getSimulator().slotClick(aSlotIndex, null);
                return;
            }
            if (clickData.mouseButton == 1) {
                tSlot.func_75215_d(null);
            }
            if (clickData.mouseButton == 0) {
                if (tStack == null) {
                    if (this.displaySlot.func_75211_c() != null && aSlotIndex != 58) {
                        tSlot.func_75215_d(this.displaySlot.func_75211_c().func_77946_l());
                        GT_TileEntity_ComputerCube.this.getSimulator().slotClick(aSlotIndex, new GT_ItemStack(this.displaySlot.func_75211_c().func_77946_l()));
                    } else {
                        tSlot.func_75215_d(new ItemStack(GT_TileEntity_ComputerCube.sReactorList.get((int)0).mItem, 1));
                        GT_TileEntity_ComputerCube.this.getSimulator().slotClick(aSlotIndex, sReactorList.get(0));
                    }
                    return;
                }
                for (int i = 1; i < sReactorList.size(); ++i) {
                    if (GT_TileEntity_ComputerCube.sReactorList.get((int)(i - 1)).mItem != tStack.func_77973_b()) continue;
                    tSlot.func_75215_d(new ItemStack(GT_TileEntity_ComputerCube.sReactorList.get((int)i).mItem, 1, 0));
                    GT_TileEntity_ComputerCube.this.getSimulator().slotClick(aSlotIndex, sReactorList.get(i));
                    return;
                }
                tSlot.func_75215_d(null);
                GT_TileEntity_ComputerCube.this.getSimulator().slotClick(aSlotIndex, null);
                return;
            }
            if (tStack == null) {
                return;
            }
            if (tStack.field_77994_a < tStack.func_77976_d()) {
                ++tStack.field_77994_a;
                return;
            }
            tStack.field_77994_a = 1;
        }

        protected void handleDragAndDropServer(Widget.ClickData clickData, ItemStack draggedStack) {
        }

        public List<String> getExtraTooltip() {
            return Collections.emptyList();
        }
    }
}

