/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Turbine;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public abstract class GregtechMetaTileEntity_LargerTurbineBase
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_LargerTurbineBase>
implements ISurvivalConstructable {
    protected int baseEff = 0;
    protected long optFlow = 0L;
    protected double realOptFlow = 0.0;
    protected int storedFluid = 0;
    protected int counter = 0;
    protected boolean mFastMode = false;
    protected double mufflerReduction = 1.0;
    protected float[] flowMultipliers = new float[]{1.0f, 1.0f, 1.0f};
    public ITexture frontFace;
    public ITexture frontFaceActive;
    public ArrayList<GT_MetaTileEntity_Hatch_Turbine> mTurbineRotorHatches = new ArrayList();
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<GregtechMetaTileEntity_LargerTurbineBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GregtechMetaTileEntity_LargerTurbineBase>>(){

        @Override
        protected IStructureDefinition<GregtechMetaTileEntity_LargerTurbineBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GregtechMetaTileEntity_LargerTurbineBase.STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"ccchccc", "ccccccc", "ccmmmcc", "ccm~mcc", "ccmmmcc", "ccccccc", "ccchccc"}, {"ctchctc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "ctchctc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ctchctc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "ctchctc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}, {"ctchctc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "cscccsc", "ctchctc"}, {"ccchccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccccccc", "ccchccc"}}).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).addElement('s', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getShaftBlock(), (int)t.getTurbineShaftMeta()))).addElement('t', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_LargerTurbineBase.class).adder(GregtechMetaTileEntity_LargerTurbineBase::addTurbineHatch).hatchClass(GT_MetaTileEntity_Hatch_Turbine.class).casingIndex(t.getCasingTextureIndex()).dot(1).build())).addElement('h', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_LargerTurbineBase.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Dynamo.or((IHatchElement)GregtechMeta_MultiBlockBase.GTPPHatchElement.TTDynamo), GT_HatchElement.Maintenance}).casingIndex(t.getCasingTextureIndex()).dot(4).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).addElement('m', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_LargerTurbineBase.class).atLeast(new IHatchElement[]{GT_HatchElement.Muffler}).casingIndex(t.getCasingTextureIndex()).dot(7).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).build();
        }
    };
    private Long mLastHatchUpdate;

    public GregtechMetaTileEntity_LargerTurbineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.frontFace = this.getTextureFrontFace();
        this.frontFaceActive = this.getTextureFrontFaceActive();
    }

    public GregtechMetaTileEntity_LargerTurbineBase(String aName) {
        super(aName);
        this.frontFace = this.getTextureFrontFace();
        this.frontFaceActive = this.getTextureFrontFaceActive();
    }

    protected abstract ITexture getTextureFrontFace();

    protected abstract ITexture getTextureFrontFaceActive();

    protected abstract String getTurbineType();

    protected abstract String getCasingName();

    protected abstract boolean requiresOutputHatch();

    protected final GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the XL " + this.getTurbineType() + " Turbine").addInfo("Runs as fast as 16 Large Turbines of the same type, takes the space of 12").addInfo("Right-click with screwdriver to enable Fast Mode, to run it even faster").addInfo("Optimal flow will increase or decrease accordingly on mode switch").addInfo("Fast Mode increases speed to 48x instead of 16x, with some penalties").addInfo("Maintenance problems and turbine damage happen 12x as often in Fast Mode").addInfo("XL Steam Turbines can use Loose Mode with either Slow or Fast Mode").addPollutionAmount(this.getPollutionPerSecond(null)).addInfo("Pollution is 3x higher in Fast Mode").addSeparator().beginStructureBlock(7, 9, 7, false).addController("Top Middle").addCasingInfo(this.getCasingName(), 360).addCasingInfo("Rotor Shaft", 30).addOtherStructurePart("Rotor Assembly", "Any 1 dot hint", new int[]{1}).addInputBus("Any 4 dot hint (min 1)", new int[]{4}).addInputHatch("Any 4 dot hint(min 1)", new int[]{4});
        if (this.requiresOutputHatch()) {
            tt.addOutputHatch("Any 4 dot hint(min 1)", new int[]{4});
        }
        tt.addDynamoHatch("Any 4 dot hint(min 1)", new int[]{4}).addMaintenanceHatch("Any 4 dot hint(min 1)", new int[]{4});
        if (this.requiresMufflers()) {
            tt.addMufflerHatch("Any 7 dot hint (x4)", new int[]{7});
        }
        tt.toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_LargerTurbineBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(((Object)((Object)this)).getClass());
    }

    private boolean requiresMufflers() {
        if (!PollutionUtils.isPollutionEnabled()) {
            return false;
        }
        return this.getPollutionPerSecond(null) > 0;
    }

    public final double getMufflerReduction() {
        double totalReduction = 0.0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GregtechMetaTileEntity_LargerTurbineBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            totalReduction += (double)tHatch.calculatePollutionReduction(100) / 100.0;
        }
        return totalReduction / 4.0;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mDynamoHatches.clear();
        this.mTecTechDynamoHatches.clear();
        this.mTurbineRotorHatches.clear();
        this.mMaintenanceHatches.clear();
        if (this.requiresMufflers()) {
            this.mMufflerHatches.clear();
        }
        this.mInputBusses.clear();
        this.mInputHatches.clear();
        if (this.requiresOutputHatch()) {
            this.mOutputHatches.clear();
        }
        boolean aStructure = this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 3, 0);
        this.log("Structure Check: " + aStructure);
        if (this.mTurbineRotorHatches.size() != 12 || this.mMaintenanceHatches.size() != 1 || this.mDynamoHatches.size() < 1 && this.mTecTechDynamoHatches.size() < 1 || this.requiresMufflers() && this.mMufflerHatches.size() != 4 || this.mInputBusses.size() < 1 || this.mInputHatches.size() < 1 || this.requiresOutputHatch() && this.mOutputHatches.size() < 1) {
            this.log("Bad Hatches - Turbine Housings: " + this.mTurbineRotorHatches.size() + ", Maint: " + this.mMaintenanceHatches.size() + ", Dynamo: " + this.mDynamoHatches.size() + ", Muffler: " + this.mMufflerHatches.size() + ", Input Buses: " + this.mInputBusses.size() + ", Input Hatches: " + this.mInputHatches.size() + ", Output Hatches: " + this.mOutputHatches.size());
            return false;
        }
        this.mufflerReduction = this.getMufflerReduction();
        return aStructure;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 2);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 3, 0, realBudget, env, false, true);
    }

    public boolean addTurbineHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Turbine) {
            this.log("Found GT_MetaTileEntity_Hatch_Turbine");
            this.updateTexture(aTileEntity, aBaseCasingIndex);
            GT_MetaTileEntity_Hatch_Turbine aTurbineHatch = (GT_MetaTileEntity_Hatch_Turbine)aMetaTileEntity;
            IGregTechTileEntity g = this.getBaseMetaTileEntity();
            if (aTurbineHatch.setController(new BlockPos(g.getXCoord(), (int)g.getYCoord(), g.getZCoord(), g.getWorld()))) {
                boolean aDidAdd = this.mTurbineRotorHatches.add(aTurbineHatch);
                Logger.INFO("Injected Controller into Turbine Assembly. Found: " + this.mTurbineRotorHatches.size());
                return aDidAdd;
            }
            Logger.INFO("Failed to inject controller into Turbine Assembly Hatch.");
        }
        this.log("Bad Turbine Housing");
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    public final Block getShaftBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    public abstract int getCasingMeta();

    public byte getTurbineShaftMeta() {
        return 0;
    }

    public abstract int getCasingTextureIndex();

    public abstract int getFuelValue(FluidStack var1);

    public static boolean isValidTurbine(ItemStack aTurbine) {
        return aTurbine != null && aTurbine.func_77973_b() instanceof GT_MetaGenerated_Tool && aTurbine.func_77960_j() >= 170 && aTurbine.func_77960_j() <= 176;
    }

    protected ArrayList<ItemStack> getAllBufferedTurbines() {
        this.startRecipeProcessing();
        ArrayList<ItemStack> aTurbinesInStorage = new ArrayList<ItemStack>();
        for (ItemStack aStack : this.getStoredInputs()) {
            int tmpStackSize;
            if (!GregtechMetaTileEntity_LargerTurbineBase.isValidTurbine(aStack)) continue;
            for (int stackSize = aStack.field_77994_a; stackSize > 0; stackSize -= tmpStackSize) {
                tmpStackSize = Math.min(stackSize, aStack.func_77976_d());
                ItemStack copy = aStack.func_77946_l();
                copy.field_77994_a = tmpStackSize;
                aTurbinesInStorage.add(copy);
            }
        }
        this.endRecipeProcessing();
        return aTurbinesInStorage;
    }

    public boolean areAllTurbinesTheSame() {
        ArrayList<GT_MetaTileEntity_Hatch_Turbine> aTurbineAssemblies = this.getFullTurbineAssemblies();
        if (aTurbineAssemblies.size() < 12) {
            this.log("Found " + aTurbineAssemblies.size() + ", expected 12.");
            return false;
        }
        AutoMap<Materials> aTurbineMats = new AutoMap<Materials>();
        AutoMap<Integer> aTurbineSizes = new AutoMap<Integer>();
        for (GT_MetaTileEntity_Hatch_Turbine aHatch : aTurbineAssemblies) {
            aTurbineMats.add(GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aHatch.getTurbine()));
            aTurbineSizes.add(GregtechMetaTileEntity_LargerTurbineBase.getTurbineSize(aHatch.getTurbine()));
        }
        Materials aBaseMat = (Materials)aTurbineMats.get(0);
        int aBaseSize = (Integer)aTurbineSizes.get(0);
        Iterator iterator = aTurbineSizes.iterator();
        while (iterator.hasNext()) {
            int aSize = (Integer)iterator.next();
            if (aBaseSize == aSize) continue;
            return false;
        }
        for (Materials aMat : aTurbineMats) {
            if (aBaseMat == aMat) continue;
            return false;
        }
        return true;
    }

    public static int getTurbineSize(ItemStack aTurbine) {
        if (GregtechMetaTileEntity_LargerTurbineBase.isValidTurbine(aTurbine)) {
            if (aTurbine.func_77960_j() >= 170 && aTurbine.func_77960_j() < 172) {
                return 1;
            }
            if (aTurbine.func_77960_j() >= 172 && aTurbine.func_77960_j() < 174) {
                return 2;
            }
            if (aTurbine.func_77960_j() >= 174 && aTurbine.func_77960_j() < 176) {
                return 3;
            }
            if (aTurbine.func_77960_j() >= 176 && aTurbine.func_77960_j() < 178) {
                return 4;
            }
        }
        return 0;
    }

    public static String getTurbineSizeString(int aSize) {
        switch (aSize) {
            case 1: {
                return "Small Turbine";
            }
            case 2: {
                return "Turbine";
            }
            case 3: {
                return "Large Turbine";
            }
            case 4: {
                return "Huge Turbine";
            }
        }
        return "";
    }

    protected ArrayList<GT_MetaTileEntity_Hatch_Turbine> getEmptyTurbineAssemblies() {
        ArrayList<GT_MetaTileEntity_Hatch_Turbine> aEmptyTurbineRotorHatches = new ArrayList<GT_MetaTileEntity_Hatch_Turbine>();
        for (GT_MetaTileEntity_Hatch_Turbine aTurbineHatch : this.mTurbineRotorHatches) {
            if (aTurbineHatch.hasTurbine()) continue;
            aEmptyTurbineRotorHatches.add(aTurbineHatch);
        }
        return aEmptyTurbineRotorHatches;
    }

    protected ArrayList<GT_MetaTileEntity_Hatch_Turbine> getFullTurbineAssemblies() {
        ArrayList<GT_MetaTileEntity_Hatch_Turbine> aTurbineRotorHatches = new ArrayList<GT_MetaTileEntity_Hatch_Turbine>();
        for (GT_MetaTileEntity_Hatch_Turbine aTurbineHatch : this.mTurbineRotorHatches) {
            if (!aTurbineHatch.hasTurbine()) continue;
            aTurbineRotorHatches.add(aTurbineHatch);
        }
        return aTurbineRotorHatches;
    }

    protected boolean depleteTurbineFromStock(ItemStack aTurbine) {
        if (aTurbine == null) {
            return false;
        }
        this.startRecipeProcessing();
        for (GT_MetaTileEntity_Hatch_InputBus aInputBus : this.mInputBusses) {
            for (int slot = aInputBus.func_70302_i_() - 1; slot >= 0; --slot) {
                ItemStack aStack = aInputBus.func_70301_a(slot);
                if (aStack == null || !GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)aTurbine)) continue;
                aStack.field_77994_a -= aTurbine.field_77994_a;
                this.updateSlots();
                this.endRecipeProcessing();
                return true;
            }
        }
        this.endRecipeProcessing();
        return false;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(new ItemStack[0], this.getStoredFluids().toArray(new FluidStack[0]), 1, 100L, 100, 10000);
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        try {
            ArrayList<GT_MetaTileEntity_Hatch_Turbine> aEmptyTurbineRotorHatches = this.getEmptyTurbineAssemblies();
            if (aEmptyTurbineRotorHatches.size() > 0) {
                this.log("Found " + aEmptyTurbineRotorHatches.size() + " Assemblies without Turbine.");
                block2: for (GT_MetaTileEntity_Hatch_Turbine aHatch : aEmptyTurbineRotorHatches) {
                    ArrayList<ItemStack> aTurbines = this.getAllBufferedTurbines();
                    for (ItemStack aTurbineItem : aTurbines) {
                        if (aTurbineItem == null || !aHatch.insertTurbine(aTurbineItem.func_77946_l())) continue;
                        boolean aDidDeplete = this.depleteTurbineFromStock(aTurbineItem);
                        this.log("Put Turbine into Assembly - " + aDidDeplete);
                        continue block2;
                    }
                }
            }
            if (this.getEmptyTurbineAssemblies().size() > 0 || !this.areAllTurbinesTheSame()) {
                this.log("BAD RETURN - 1");
                this.stopMachine();
                return false;
            }
            ArrayList tFluids = this.getStoredFluids();
            if (tFluids.size() > 0) {
                if (this.baseEff == 0 || this.optFlow == 0L || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                    this.counter = 0;
                    float aTotalBaseEff = 0.0f;
                    float aTotalOptimalFlow = 0.0f;
                    ItemStack aStack = this.getFullTurbineAssemblies().get(0).getTurbine();
                    for (int i = 0; i < this.getSpeedMultiplier(); ++i) {
                        if (i == 0) {
                            aTotalBaseEff += (float)GT_Utility.safeInt((long)((long)((5.0f + ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 1000.0f)));
                        }
                        if (!((aTotalOptimalFlow += (float)GT_Utility.safeInt((long)((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f)))) < 0.0f)) continue;
                        this.log("Int overflow, report to issue tracker");
                        aTotalOptimalFlow = 100.0f;
                    }
                    this.flowMultipliers[0] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mSteamMultiplier;
                    this.flowMultipliers[1] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mGasMultiplier;
                    this.flowMultipliers[2] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mPlasmaMultiplier;
                    this.baseEff = MathUtils.roundToClosestInt(aTotalBaseEff);
                    this.optFlow = MathUtils.roundToClosestInt(aTotalOptimalFlow);
                    if (this.optFlow <= 0L || this.baseEff <= 0) {
                        this.log("Running checkRecipeGeneric(bad-1)");
                        this.stopMachine();
                        return false;
                    }
                } else {
                    ++this.counter;
                }
            }
            int newPower = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff, this.flowMultipliers);
            long difference = (long)newPower - this.lEUt;
            int maxChangeAllowed = Math.max(10, GT_Utility.safeInt((long)(Math.abs(difference) / 100L)));
            if (Math.abs(difference) > (long)maxChangeAllowed) {
                int change = maxChangeAllowed * (difference > 0L ? 1 : -1);
                this.lEUt += (long)change;
            } else {
                this.lEUt = newPower;
            }
            if (this.lEUt <= 0L) {
                this.lEUt = 0L;
                this.mEfficiency = 0;
                this.log("Running checkRecipeGeneric(bad-2)");
                return false;
            }
            this.mMaxProgresstime = 1;
            this.mEfficiencyIncrease = 10;
            this.startProcess();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public boolean doRandomMaintenanceDamage() {
        if (this.getMaxParallelRecipes() == 0 || this.getRepairStatus() == 0) {
            this.stopMachine();
            return false;
        }
        if (this.mRuntime++ > 1000) {
            this.mRuntime = 0;
            if (this.getBaseMetaTileEntity().getRandomNumber(6000) < this.getMaintenanceThreshold()) {
                switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
                    case 0: {
                        this.mWrench = false;
                        break;
                    }
                    case 1: {
                        this.mScrewdriver = false;
                        break;
                    }
                    case 2: {
                        this.mSoftHammer = false;
                        break;
                    }
                    case 3: {
                        this.mHardHammer = false;
                        break;
                    }
                    case 4: {
                        this.mSolderingTool = false;
                        break;
                    }
                    case 5: {
                        this.mCrowbar = false;
                    }
                }
            }
            for (GT_MetaTileEntity_Hatch_Turbine aHatch : this.getFullTurbineAssemblies()) {
                for (int i = 0; i < this.getTurbineDamageMultiplier(); ++i) {
                    aHatch.damageTurbine(this.lEUt / 5L, this.damageFactorLow, this.damageFactorHigh);
                }
            }
        }
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.getFullTurbineAssemblies().size();
    }

    abstract int fluidIntoPower(ArrayList<FluidStack> var1, long var2, int var4, float[] var5);

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return this.getMaxParallelRecipes() == 12 ? 10000 : 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean isLooseMode() {
        return false;
    }

    @Override
    public String[] getExtraInfoData() {
        int mPollutionReduction = (int)(100.0 * this.mufflerReduction);
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        int tDura = 0;
        StringBuilder aTurbineDamage = new StringBuilder();
        for (GT_MetaTileEntity_Hatch_Turbine aHatch : this.getFullTurbineAssemblies()) {
            ItemStack aTurbine = aHatch.getTurbine();
            tDura = MathUtils.safeInt((long)(100.0f / (float)GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)aTurbine) * (float)GT_MetaGenerated_Tool.getToolDamage((ItemStack)aTurbine) + 1.0f));
            aTurbineDamage.append(EnumChatFormatting.RED).append(tDura).append(EnumChatFormatting.RESET).append("% | ");
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GregtechMetaTileEntity_LargerTurbineBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        boolean aIsSteam = ((Object)((Object)this)).getClass().getName().toLowerCase().contains("steam");
        String[] ret = new String[]{tRunning + ": " + EnumChatFormatting.RED + this.lEUt * (long)this.mEfficiency / 10000L + EnumChatFormatting.RESET + " EU/t", tMaintainance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + MathUtils.safeInt((long)this.realOptFlow) + EnumChatFormatting.RESET + " L/s" + EnumChatFormatting.YELLOW + " (" + (this.isLooseMode() ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + this.storedFluid + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + aTurbineDamage, StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
        if (!aIsSteam) {
            ret[4] = StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + MathUtils.safeInt((long)this.realOptFlow) + EnumChatFormatting.RESET + " L/t";
        }
        return ret;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public boolean polluteEnvironment(int aPollutionLevel) {
        if (this.requiresMufflers()) {
            this.mPollution = (int)((double)this.mPollution + (double)(aPollutionLevel * this.getPollutionMultiplier()) * this.mufflerReduction);
            for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
                if (!GregtechMetaTileEntity_LargerTurbineBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                if (this.mPollution < 10000) break;
                if (!PollutionUtils.addPollution(this.getBaseMetaTileEntity(), 10000)) continue;
                this.mPollution -= 10000;
            }
            return this.mPollution < 10000;
        }
        return true;
    }

    public long maxAmperesOut() {
        if (this.mFastMode) {
            return 64L;
        }
        return 16L;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mFastMode", this.mFastMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFastMode = aNBT.func_74767_n("mFastMode");
        super.loadNBTData(aNBT);
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFastMode = Utils.invertBoolean(this.mFastMode);
        if (this.mFastMode) {
            PlayerUtils.messagePlayer(aPlayer, "Running in Fast (48x) Mode.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Running in Slow (16x) Mode.");
        }
    }

    @Override
    public final ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1], aFacing == aSide ? this.getFrontFacingTurbineTexture(aActive) : Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex())};
    }

    protected ITexture getFrontFacingTurbineTexture(boolean isActive) {
        if (isActive) {
            return this.frontFaceActive;
        }
        return this.frontFace;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.log("Cleared Rotor Assemblies.");
            this.mTurbineRotorHatches.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.maxProgresstime() > 0 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) {
            this.enableAllTurbineHatches();
        }
        if (this.maxProgresstime() <= 0) {
            this.stopMachine();
        }
    }

    @Override
    public void startProcess() {
        super.startProcess();
        this.enableAllTurbineHatches();
    }

    public void stopMachine() {
        this.baseEff = 0;
        this.optFlow = 0L;
        this.disableAllTurbineHatches();
        super.stopMachine();
    }

    public void onRemoval() {
        super.onRemoval();
        for (GT_MetaTileEntity_Hatch_Turbine h : this.mTurbineRotorHatches) {
            h.clearController();
        }
        this.disableAllTurbineHatches();
        this.mTurbineRotorHatches.clear();
    }

    public void enableAllTurbineHatches() {
        this.updateTurbineHatches(this.isMachineRunning());
    }

    public void disableAllTurbineHatches() {
        this.updateTurbineHatches(false);
    }

    public int updateTurbineHatches(boolean aState) {
        int aUpdated = 0;
        if (this.mLastHatchUpdate == null) {
            this.mLastHatchUpdate = System.currentTimeMillis() / 1000L;
        }
        if (this.mTurbineRotorHatches.isEmpty() || System.currentTimeMillis() / 1000L - this.mLastHatchUpdate <= 2L) {
            return 0;
        }
        for (GT_MetaTileEntity_Hatch_Turbine h : this.mTurbineRotorHatches) {
            h.setActive(aState);
            ++aUpdated;
        }
        this.mLastHatchUpdate = System.currentTimeMillis() / 1000L;
        return aUpdated;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().getFrontFacing() != 1) {
            this.log("Fixing Bad Facing. (GT Bug)");
            this.getBaseMetaTileEntity().setFrontFacing((byte)1);
        }
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.lEUt > 0L) {
            this.addEnergyOutput(this.lEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        return false;
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (this.mAllDynamoHatches.size() > 0) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (GT_MetaTileEntity_Hatch aDynamo : this.mAllDynamoHatches) {
            if (aDynamo == null) {
                return false;
            }
            if (!GregtechMetaTileEntity_LargerTurbineBase.isValidMetaTileEntity((MetaTileEntity)aDynamo)) continue;
            aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        for (GT_MetaTileEntity_Hatch aDynamo : this.mAllDynamoHatches) {
            if (!GregtechMetaTileEntity_LargerTurbineBase.isValidMetaTileEntity((MetaTileEntity)aDynamo)) continue;
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int ampsOnCurrentHatch = (int)Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject);
            for (int i = 0; i < ampsOnCurrentHatch; ++i) {
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(aVoltage, false);
            }
            injected = (int)((long)injected + aVoltage * (long)ampsOnCurrentHatch);
            if (aRemainder <= 0 || (long)ampsOnCurrentHatch >= aDynamo.maxAmperesOut()) continue;
            aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits((long)aRemainder, false);
            injected += aRemainder;
        }
        return injected > 0;
    }

    public int getSpeedMultiplier() {
        return this.mFastMode ? 48 : 16;
    }

    public int getMaintenanceThreshold() {
        return this.mFastMode ? 12 : 1;
    }

    public int getPollutionMultiplier() {
        return this.mFastMode ? 3 : 1;
    }

    public int getTurbineDamageMultiplier() {
        return this.mFastMode ? 3 : 1;
    }
}

