/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.algae;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_AlgaeFarm;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMTE_AlgaePondBase
extends GregtechMeta_MultiBlockBase<GregtechMTE_AlgaePondBase>
implements ISurvivalConstructable {
    private int mLevel = -1;
    private int mCasing;
    private static IStructureDefinition<GregtechMTE_AlgaePondBase> STRUCTURE_DEFINITION = null;
    private int checkMeta;
    private int minTierOfHatch;
    private static final Class<?> cofhWater = ReflectionUtils.getClass("cofh.asmhooks.block.BlockWater");

    public GregtechMTE_AlgaePondBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_AlgaePondBase(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_AlgaePondBase(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Algae Pond";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Grows Algae!").addInfo("Controller Block for the Algae Farm").addInfo("Provide compost to boost production by one tier").addInfo("Does not require power or maintenance").addInfo("All Machine Casings must be the same tier, this dictates machine speed.").addInfo("All Buses/Hatches must, at least, match the tier of the Casings").addInfo("Fill Input Hatch with Water to fill the inside of the multiblock.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(9, 3, 9, true).addController("Front Center").addCasingInfo("Machine Casings", 64).addCasingInfo("Sterile Farm Casings", 34).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    public void setMeta(int meta) {
        this.checkMeta = meta;
    }

    public int getMeta() {
        return this.checkMeta;
    }

    public IStructureDefinition<GregtechMTE_AlgaePondBase> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"CCCC~CCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMTE_AlgaePondBase.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).casingIndex(TAE.getIndexFromPage(1, 15)).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, GregtechMTE_AlgaePondBase.addTieredBlock(GregTech_API.sBlockCasings1, GregtechMTE_AlgaePondBase::setMeta, GregtechMTE_AlgaePondBase::getMeta, 10))})).addElement('X', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)15)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 4, 2, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mLevel = 0;
        this.checkMeta = 0;
        this.minTierOfHatch = 100;
        if (this.checkPiece(this.mName, 4, 2, 0) && this.mCasing >= 64 && this.checkMeta > 0) {
            this.mLevel = this.checkMeta - 1;
            return this.mLevel <= this.minTierOfHatch;
        }
        return false;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(207);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default;
    }

    @Override
    protected int getCasingTextureId() {
        int aID = TAE.getIndexFromPage(1, 15);
        if (this.mLevel > -1) {
            aID = this.mLevel;
        }
        return aID;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public boolean checkForWater() {
        boolean isValidWater;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mDirectionX = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int mOffsetX_Lower = 0;
        int mOffsetX_Upper = 0;
        int mOffsetZ_Lower = 0;
        int mOffsetZ_Upper = 0;
        int mCurrentDirectionX = 4;
        int mCurrentDirectionZ = 4;
        mOffsetX_Lower = -4;
        mOffsetX_Upper = 4;
        mOffsetZ_Lower = -4;
        mOffsetZ_Upper = 4;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * mCurrentDirectionX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * mCurrentDirectionZ;
        int tAmount = 0;
        for (int i = mOffsetX_Lower + 1; i <= mOffsetX_Upper - 1; ++i) {
            for (int j = mOffsetZ_Lower + 1; j <= mOffsetZ_Upper - 1; ++j) {
                for (int h = 0; h < 2; ++h) {
                    byte tMeta;
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if (this.isNotStaticWater(tBlock, tMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j)) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(FluidUtils.getFluidStack("water", 1)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            Block fluidUsed = Blocks.field_150355_j;
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, fluidUsed);
                        }
                    }
                    if ((tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j)) != Blocks.field_150355_j && tBlock != Blocks.field_150358_i) continue;
                    ++tAmount;
                }
            }
        }
        boolean bl = isValidWater = tAmount >= 49;
        if (isValidWater) {
            Logger.INFO("Filled structure.");
            return true;
        }
        return false;
    }

    private boolean isNotStaticWater(Block block, byte meta) {
        return block == Blocks.field_150350_a || block == Blocks.field_150358_i || block == BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater) || cofhWater != null && cofhWater.isAssignableFrom(block.getClass()) && meta != 0;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiAlgaePond;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.fixAllMaintenanceIssue();
        if (aBaseMetaTileEntity.isClientSide()) {
            this.mLevel = this.getCasingTier();
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), 0);
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        GT_Recipe tRecipe;
        if (this.mLevel < 0) {
            return false;
        }
        if (!this.checkForWater()) {
            return false;
        }
        this.lEUt = 0L;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        this.mLastRecipe = tRecipe = RecipeLoader_AlgaeFarm.getTieredRecipeFromCache(this.mLevel, this.isUsingCompost(aItemInputs));
        if (tRecipe == null) {
            return false;
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(120L).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation();
        if (!this.voidExcess) {
            helper.enableVoidProtection((GT_MetaTileEntity_MultiBlockBase)this);
        }
        if (this.batchMode) {
            helper.enableBatchMode(128);
        }
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = (int)Math.ceil((float)tRecipe.mDuration * helper.getDurationMultiplier());
        this.mOutputItems = helper.getItemOutputs();
        this.mOutputFluids = helper.getFluidOutputs();
        this.updateSlots();
        this.startProcess();
        return true;
    }

    private boolean isUsingCompost(ItemStack[] aItemInputs) {
        ItemStack aCompost = ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1);
        for (ItemStack i : aItemInputs) {
            if (!GT_Utility.areStacksEqual((ItemStack)aCompost, (ItemStack)i) || i.field_77994_a < 8) continue;
            return true;
        }
        return false;
    }

    private int getCasingTier() {
        if (this.getBaseMetaTileEntity().getWorld() == null) {
            return 0;
        }
        try {
            IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
            int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
            int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
            Block aInitStructureCheck = aBaseMetaTileEntity.getBlockOffset(xDir, -1, zDir);
            byte aInitStructureCheckMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir, -1, zDir);
            if (aInitStructureCheck == GregTech_API.sBlockCasings1) {
                return aInitStructureCheckMeta;
            }
            return 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }
}

