/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMetaTileEntity;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GregtechMetaTileEntityThaumcraftResearcher
extends GregtechMetaTileEntity {
    public GregtechMetaTileEntityThaumcraftResearcher(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public GregtechMetaTileEntityThaumcraftResearcher(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.mDescription, "Generates Thaumcraft research notes, because it's magic."};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{this.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Metal_Grate_A)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{this.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Metal_Grate_B)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{this.getSides(aColor)[0]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{this.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Dimensional_Blue)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_RedSteel)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{this.getSides(aColor)[0], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityThaumcraftResearcher(this.mName, (int)this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxEUStore() {
        return 512000L;
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public int getCapacity() {
        return 128000;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    public String[] getInfoData() {
        return new String[]{this.getLocalName()};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
    }

    public void loadNBTData(NBTTagCompound aNBT) {
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }
}

