/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.item.general.ItemAirFilter;
import gtPlusPlus.core.item.general.ItemBasicScrubberTurbine;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.ArrayUtils;

public class GregtechMetaAtmosphericReconditioner
extends GT_MetaTileEntity_BasicMachine {
    public int mPollutionReduction = 0;
    protected int mBaseEff = 2500;
    protected int mOptimalAirFlow = 0;
    protected boolean mHasPollution = false;
    protected int SLOT_ROTOR = 5;
    protected int SLOT_FILTER = 6;
    protected static boolean mPollutionEnabled = true;
    protected boolean mSaveRotor = false;
    private static final HashMap<Byte, ItemStack> mConveyorMap = new HashMap();
    private static ItemStack[] sGregTurbines;

    public GregtechMetaAtmosphericReconditioner(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 2, "Making sure you don't live in Gwalior - Uses 2A", 3, 0, "Recycler.png", "", new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_MatterFab_Active), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_MatterFab), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Vent_Fast), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Vent), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB)});
        mPollutionEnabled = PollutionUtils.isPollutionEnabled();
    }

    public GregtechMetaAtmosphericReconditioner(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 2, aDescription, aTextures, 2, 0, aGUIName, aNEIName);
        mPollutionEnabled = PollutionUtils.isPollutionEnabled();
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaAtmosphericReconditioner(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public String[] getDescription() {
        boolean highTier = this.mTier >= 7;
        Object[] A = new String[]{this.mDescription, highTier ? "Will attempt to remove 1/4 pollution from 8 surrounding chunks" : "", highTier ? "If these chunks are not loaded, they will be ignored" : "", "Requires a turbine rotor and an Air Filter [T1/T2] to run.", "The turbine rotor must be manually inserted/replaced", "Can be configured with a soldering iron to change modes", "Low Efficiency: Removes half pollution, Turbine takes 50% dmg", "High Efficiency: Removes full pollution, Turbine takes 100% dmg", "Turbine Rotor will not break in LE mode", "Insert an equal tier Conveyor Module to enable automation"};
        if (!mPollutionEnabled) {
            Object[] B = new String[]{"===============================================", "Pollution is disabled, scrubbers will now have a bonus use", "They are now able to remove ALL lingering pollution as GT ignores it", "and it will linger forever!", "==============================================="};
            A = (String[])ArrayUtils.addAll((Object[])A, (Object[])B);
        }
        return A;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mOptimalAirFlow", this.mOptimalAirFlow);
        aNBT.func_74757_a("mSaveRotor", this.mSaveRotor);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mOptimalAirFlow = aNBT.func_74762_e("mOptimalAirFlow");
        this.mSaveRotor = aNBT.func_74767_n("mSaveRotor");
    }

    public long maxAmperesIn() {
        return 2L;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 2L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 256L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            int mCurrentPollution = this.getCurrentChunkPollution();
            boolean isIdle = true;
            ItemStack stackRotor = this.mInventory[this.SLOT_ROTOR];
            ItemStack stackFilter = this.mInventory[this.SLOT_FILTER];
            long drainEU = this.maxEUInput() * this.maxAmperesIn();
            if (aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getStoredEU() >= drainEU) {
                if (aBaseMetaTileEntity.decreaseStoredEnergyUnits(drainEU, false)) {
                    isIdle = false;
                } else {
                    aBaseMetaTileEntity.setActive(false);
                    this.sendSound((byte)-122);
                }
            } else if (!aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getStoredEU() >= drainEU / 4L) {
                if (aBaseMetaTileEntity.decreaseStoredEnergyUnits(drainEU / 4L, false)) {
                    isIdle = false;
                } else {
                    aBaseMetaTileEntity.setActive(false);
                    this.sendSound((byte)-122);
                }
            } else {
                aBaseMetaTileEntity.setActive(false);
                this.sendSound((byte)-122);
            }
            if (!isIdle && aTick % 20L == 0L) {
                int i;
                for (i = 0; i < this.mInventory.length; ++i) {
                    ItemStack aSlotContent = this.mInventory[i];
                    if (aSlotContent == null) continue;
                    Logger.INFO("Found " + aSlotContent.func_82833_r() + " in slot " + i);
                }
                for (i = 0; i < this.mInventory.length; ++i) {
                    if (!this.hasRotor(this.mInventory[i])) continue;
                    Logger.INFO("Found Rotor in slot " + i);
                    break;
                }
                for (i = 0; i < this.mInventory.length; ++i) {
                    if (!this.hasAirFilter(this.mInventory[i])) continue;
                    Logger.INFO("Found Filter in slot " + i);
                    break;
                }
                if (aBaseMetaTileEntity.isAllowedToWork()) {
                    Logger.INFO("Can work.");
                    if (this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter) && this.mHasPollution) {
                        if (!this.getBaseMetaTileEntity().isActive()) {
                            Logger.INFO("Set Active.");
                            aBaseMetaTileEntity.setActive(true);
                        }
                    } else if (!(this.mHasPollution && mCurrentPollution > 0 && stackRotor != null && stackFilter != null && this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter) || this.getBaseMetaTileEntity().isActive())) {
                        Logger.INFO("Set Inactive.");
                        aBaseMetaTileEntity.setActive(false);
                        this.sendSound((byte)-122);
                    }
                    if (aBaseMetaTileEntity.isActive()) {
                        Logger.INFO("Doing something.");
                        if (this.mHasPollution && mCurrentPollution > 0) {
                            Logger.INFO("Has Pollution? " + this.mHasPollution + ", Current Pollution: " + mCurrentPollution);
                            if (!isIdle && aTick % 600L == 0L) {
                                mPollutionEnabled = PollutionUtils.isPollutionEnabled();
                                if (!PollutionUtils.isPollutionEnabled()) {
                                    PollutionUtils.nullifyPollution(this.getBaseMetaTileEntity());
                                }
                            }
                            if (this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter)) {
                                Logger.INFO("Found Turbine.");
                                this.mBaseEff = this.getBaseEfficiency(stackRotor);
                                this.mOptimalAirFlow = this.getOptimalAirFlow(stackRotor);
                                if (this.mBaseEff > 0 && this.mOptimalAirFlow > 0) {
                                    Logger.INFO("mBaseEff[1]:" + this.mBaseEff);
                                    Logger.INFO("mOptimalAirFlow[1]:" + this.mOptimalAirFlow);
                                    long tVoltage = drainEU;
                                    byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
                                    int mAirSides = this.getFreeSpaces();
                                    int reduction = 0;
                                    if (mAirSides > 0) {
                                        Logger.INFO("mPollutionReduction[1]:" + (reduction += Math.max(tTier - 2, 1) * 2 * 50 * mAirSides));
                                        reduction = MathUtils.safeInt((long)reduction * (long)this.mBaseEff) / 100000 * mAirSides * Math.max(tTier - 2, 1);
                                        Logger.INFO("reduction[2]:" + reduction);
                                        reduction = MathUtils.safeInt((long)reduction / 100L * (long)this.mOptimalAirFlow);
                                        Logger.INFO("reduction[3]:" + reduction);
                                        this.mPollutionReduction = reduction;
                                        int toRemove = 0;
                                        Logger.INFO("mCurrentPollution[4]:" + mCurrentPollution);
                                        Logger.INFO("mCurrentPollution[5]:" + reduction);
                                        toRemove = reduction <= mCurrentPollution ? reduction : mCurrentPollution;
                                        Logger.INFO("mCurrentPollution[6]:" + (toRemove /= 2));
                                        if (toRemove > 0) {
                                            if (this.damageTurbineRotor() && this.damageAirFilter()) {
                                                Logger.INFO("Removing " + toRemove + " pollution");
                                                this.removePollution(this.mSaveRotor ? toRemove / 2 : toRemove);
                                                Logger.INFO("mNewPollution[4]:" + this.getCurrentChunkPollution());
                                            } else {
                                                Logger.INFO("Could not damage turbine rotor or Air Filter.");
                                                aBaseMetaTileEntity.setActive(false);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else if (!aBaseMetaTileEntity.isActive()) {
                        return;
                    }
                }
            } else if (this.hasRotor(stackRotor) && this.hasAirFilter(stackFilter) && this.mHasPollution && !isIdle && aBaseMetaTileEntity.isAllowedToWork()) {
                aBaseMetaTileEntity.setActive(true);
            } else if (isIdle || !this.mHasPollution || mCurrentPollution <= 0 || stackRotor == null || stackFilter == null || !this.hasRotor(stackRotor) || !this.hasAirFilter(stackFilter)) {
                aBaseMetaTileEntity.setActive(false);
            }
            if (this.getBaseMetaTileEntity().isActive() && MathUtils.randInt(0, 5) <= 2) {
                this.sendSound((byte)-120);
            }
        }
    }

    public int getCurrentChunkPollution() {
        int mCurrentChunkPollution = 0;
        if (this.mTier < 7) {
            mCurrentChunkPollution = PollutionUtils.getPollution(this.getBaseMetaTileEntity());
        } else {
            AutoMap<Chunk> aSurrounding = new AutoMap<Chunk>();
            World aWorld = this.getBaseMetaTileEntity().getWorld();
            int xPos = this.getBaseMetaTileEntity().getXCoord();
            int zPos = this.getBaseMetaTileEntity().getZCoord();
            Chunk a1 = aWorld.func_72938_d(xPos - 32, zPos - 32);
            Chunk a2 = aWorld.func_72938_d(xPos - 32, zPos);
            Chunk a3 = aWorld.func_72938_d(xPos - 32, zPos + 32);
            Chunk b1 = aWorld.func_72938_d(xPos, zPos - 32);
            Chunk b2 = aWorld.func_72938_d(xPos, zPos);
            Chunk b3 = aWorld.func_72938_d(xPos, zPos + 32);
            Chunk c1 = aWorld.func_72938_d(xPos + 32, zPos - 32);
            Chunk c2 = aWorld.func_72938_d(xPos + 32, zPos);
            Chunk c3 = aWorld.func_72938_d(xPos + 32, zPos + 32);
            aSurrounding.put(a1);
            aSurrounding.put(a2);
            aSurrounding.put(a3);
            aSurrounding.put(b1);
            aSurrounding.put(b2);
            aSurrounding.put(b3);
            aSurrounding.put(c1);
            aSurrounding.put(c2);
            aSurrounding.put(c3);
            for (Chunk r : aSurrounding) {
                mCurrentChunkPollution += this.getPollutionInChunk(r);
            }
        }
        this.mHasPollution = mCurrentChunkPollution > 0;
        return mCurrentChunkPollution;
    }

    public int getPollutionInChunk(Chunk aChunk) {
        int mCurrentChunkPollution = PollutionUtils.getPollution(aChunk);
        this.mHasPollution = mCurrentChunkPollution > 0;
        return mCurrentChunkPollution;
    }

    public boolean hasRotor(ItemStack rotorStack) {
        if (rotorStack != null) {
            if (rotorStack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                return true;
            }
            if (rotorStack.func_77973_b() instanceof GT_MetaGenerated_Tool && rotorStack.func_77960_j() >= 170 && rotorStack.func_77960_j() <= 179) {
                return true;
            }
        }
        return false;
    }

    public boolean damageTurbineRotor() {
        block21: {
            try {
                boolean creativeRotor = false;
                ItemStack rotorStack = this.mInventory[this.SLOT_ROTOR];
                if (rotorStack == null) {
                    return false;
                }
                if (rotorStack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                    long currentUse = ItemBasicScrubberTurbine.getFilterDamage(rotorStack);
                    if (rotorStack.func_77960_j() == 0 && currentUse >= 1990L) {
                        Logger.INFO("Depleting ItemBasicScrubberTurbine T1");
                        this.mInventory[this.SLOT_FILTER] = null;
                        return false;
                    }
                    if (rotorStack.func_77960_j() == 1 && currentUse >= 3990L) {
                        Logger.INFO("Depleting ItemBasicScrubberTurbine T2");
                        this.mInventory[this.SLOT_FILTER] = null;
                        return false;
                    }
                    if (rotorStack.func_77960_j() == 2 && currentUse >= 5990L) {
                        Logger.INFO("Depleting ItemBasicScrubberTurbine T3");
                        this.mInventory[this.SLOT_FILTER] = null;
                        return false;
                    }
                    Logger.INFO("Damaging ItemBasicScrubberTurbine");
                    ItemBasicScrubberTurbine.setFilterDamage(rotorStack, currentUse + 10L);
                    Logger.INFO("Rotor Damage: " + currentUse);
                    return true;
                }
                if (rotorStack.func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
                    Materials t1 = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)rotorStack);
                    Materials t2 = GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)rotorStack);
                    if (t1 == Materials._NULL && t2 == Materials._NULL) {
                        Logger.INFO("Found creative rotor.");
                        creativeRotor = true;
                    }
                } else {
                    Logger.INFO("Bad item in rotor slot.");
                    return false;
                }
                if (this.mInventory[this.SLOT_ROTOR].func_77973_b() instanceof GT_MetaGenerated_Tool_01 && ((GT_MetaGenerated_Tool)this.mInventory[this.SLOT_ROTOR].func_77973_b()).getToolStats(this.mInventory[this.SLOT_ROTOR]).getSpeedMultiplier() > 0.0f && GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)this.mInventory[this.SLOT_ROTOR]).mToolSpeed > 0.0f) {
                    long damageValue = (long)Math.floor(Math.abs(MathUtils.randFloat(1.0f, 2.0f) - MathUtils.randFloat(1.0f, 3.0f)) * 3.0f + 1.0f);
                    double fDam = Math.floor(Math.abs(MathUtils.randFloat(1.0f, 2.0f) - MathUtils.randFloat(1.0f, 2.0f)) * 2.0f + 1.0f);
                    damageValue = (long)((double)damageValue - fDam);
                    long rotorDamage = creativeRotor ? 0L : GT_MetaGenerated_Tool.getToolDamage((ItemStack)this.mInventory[this.SLOT_ROTOR]);
                    long rotorDurabilityMax = creativeRotor ? Integer.MAX_VALUE : GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)this.mInventory[this.SLOT_ROTOR]);
                    long rotorDurability = rotorDurabilityMax - rotorDamage;
                    Logger.INFO("Rotor Damage: " + rotorDamage + " | Max Durability: " + rotorDurabilityMax + " |  Remaining Durability: " + rotorDurability);
                    if (rotorDurability >= damageValue) {
                        if (!this.mSaveRotor) {
                            long tempDur;
                            Logger.INFO("Damaging Rotor.");
                            if (!creativeRotor) {
                                GT_ModHandler.damageOrDechargeItem((ItemStack)this.mInventory[this.SLOT_ROTOR], (int)((int)damageValue), (int)0, null);
                            }
                            if ((tempDur = GT_MetaGenerated_Tool.getToolDamage((ItemStack)this.mInventory[this.SLOT_ROTOR])) < rotorDurabilityMax) {
                                return true;
                            }
                            rotorDurability = 0L;
                        } else {
                            Logger.INFO("Damaging Rotor.");
                            if (rotorDurability > 1000L) {
                                long tempDur;
                                if (!creativeRotor) {
                                    GT_ModHandler.damageOrDechargeItem((ItemStack)this.mInventory[this.SLOT_ROTOR], (int)((int)damageValue / 2), (int)0, null);
                                }
                                if ((tempDur = GT_MetaGenerated_Tool.getToolDamage((ItemStack)this.mInventory[this.SLOT_ROTOR])) < rotorDurabilityMax) {
                                    return true;
                                }
                                rotorDurability = 0L;
                            }
                        }
                    }
                    if (rotorDurability <= 0L && !this.mSaveRotor && !creativeRotor) {
                        Logger.INFO("Destroying Rotor.");
                        this.mInventory[this.SLOT_ROTOR] = null;
                        return false;
                    }
                    if (rotorDurability <= 0L && this.mSaveRotor) {
                        Logger.INFO("Saving Rotor.");
                        return false;
                    }
                    break block21;
                }
                Logger.INFO("Bad Rotor.");
                return false;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    public int getFreeSpaces() {
        int mAir = 0;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        if (aBaseMetaTileEntity.getAirOffset(1, 0, 0)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(-1, 0, 0)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, 0, 1)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, 0, -1)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, 1, 0)) {
            ++mAir;
        }
        if (aBaseMetaTileEntity.getAirOffset(0, -1, 0)) {
            ++mAir;
        }
        return mAir;
    }

    public boolean removePollution(int toRemove) {
        if (this == null || this.getBaseMetaTileEntity() == null || this.getBaseMetaTileEntity().getWorld() == null) {
            return false;
        }
        if (this.mTier < 7) {
            int startPollution = this.getCurrentChunkPollution();
            Logger.INFO("Current Chunk Pollution: " + startPollution);
            PollutionUtils.removePollution(this.getBaseMetaTileEntity(), toRemove);
            int after = this.getCurrentChunkPollution();
            Logger.INFO("Current Chunk Pollution: " + after);
            return after < startPollution;
        }
        int chunksWithRemoval = 0;
        int totalRemoved = 0;
        AutoMap<Chunk> aSurrounding = new AutoMap<Chunk>();
        Chunk aThisChunk = this.getBaseMetaTileEntity().getWorld().func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        int mainChunkX = aThisChunk.field_76635_g;
        int mainChunkZ = aThisChunk.field_76647_h;
        World aWorld = this.getBaseMetaTileEntity().getWorld();
        int xPos = this.getBaseMetaTileEntity().getXCoord();
        int zPos = this.getBaseMetaTileEntity().getZCoord();
        Chunk a1 = aWorld.func_72938_d(xPos - 32, zPos - 32);
        Chunk a2 = aWorld.func_72938_d(xPos - 32, zPos);
        Chunk a3 = aWorld.func_72938_d(xPos - 32, zPos + 32);
        Chunk b1 = aWorld.func_72938_d(xPos, zPos - 32);
        Chunk b2 = aWorld.func_72938_d(xPos, zPos);
        Chunk b3 = aWorld.func_72938_d(xPos, zPos + 32);
        Chunk c1 = aWorld.func_72938_d(xPos + 32, zPos - 32);
        Chunk c2 = aWorld.func_72938_d(xPos + 32, zPos);
        Chunk c3 = aWorld.func_72938_d(xPos + 32, zPos + 32);
        aSurrounding.put(a1);
        aSurrounding.put(a2);
        aSurrounding.put(a3);
        aSurrounding.put(b1);
        aSurrounding.put(b2);
        aSurrounding.put(b3);
        aSurrounding.put(c1);
        aSurrounding.put(c2);
        aSurrounding.put(c3);
        for (Chunk r : aSurrounding) {
            int startPollution;
            if (!r.field_76636_d || (startPollution = this.getPollutionInChunk(r)) == 0) continue;
            Logger.INFO("Trying to remove pollution from chunk " + r.field_76635_g + ", " + r.field_76647_h + " | " + startPollution);
            int after = 0;
            boolean isMainChunk = r.func_76600_a(mainChunkX, mainChunkZ);
            int removal = Math.max(0, !isMainChunk ? toRemove / 4 : toRemove);
            if (this.removePollution(r, removal)) {
                ++chunksWithRemoval;
                after = this.getPollutionInChunk(r);
            } else {
                after = 0;
            }
            if (startPollution - after > 0) {
                totalRemoved += startPollution - after;
            }
            Logger.INFO("Removed " + (startPollution - after) + " pollution from chunk " + r.field_76635_g + ", " + r.field_76647_h + " | " + after);
        }
        return totalRemoved > 0 && chunksWithRemoval > 0;
    }

    public boolean removePollution(Chunk aChunk, int toRemove) {
        int before = this.getCurrentChunkPollution();
        PollutionUtils.removePollution(aChunk, toRemove);
        int after = this.getCurrentChunkPollution();
        return after < before;
    }

    public boolean hasAirFilter(ItemStack filter) {
        if (filter == null) {
            return false;
        }
        return filter.func_77973_b() instanceof ItemAirFilter;
    }

    public boolean damageAirFilter() {
        ItemStack filter = this.mInventory[this.SLOT_FILTER];
        if (filter == null) {
            return false;
        }
        boolean creativeRotor = false;
        ItemStack rotorStack = this.mInventory[this.SLOT_ROTOR];
        if (rotorStack != null && rotorStack.func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            Materials t1 = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)rotorStack);
            Materials t2 = GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)rotorStack);
            if (t1 == Materials._NULL && t2 == Materials._NULL) {
                creativeRotor = true;
            }
        }
        if (creativeRotor) {
            return true;
        }
        if (filter.func_77973_b() instanceof ItemAirFilter) {
            long currentUse = ItemAirFilter.getFilterDamage(filter);
            if (filter.func_77960_j() == 0 && currentUse >= 49L) {
                this.mInventory[this.SLOT_FILTER] = null;
                return false;
            }
            if (filter.func_77960_j() == 1 && currentUse >= 2499L) {
                this.mInventory[this.SLOT_FILTER] = null;
                return false;
            }
            ItemAirFilter.setFilterDamage(filter, currentUse + 1L);
            Logger.INFO("Filter Damage: " + currentUse);
            return true;
        }
        return false;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        if (aIndex == this.SLOT_FILTER && aStack.func_77973_b() instanceof ItemAirFilter) {
            Logger.INFO("Inserting Air Filter into " + aIndex);
            return true;
        }
        if (aIndex == this.SLOT_ROTOR && this.mInventory[7] != null) {
            Logger.INFO("Found conveyor, can automate turbines. Inserting into " + aIndex);
            if (aStack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                return true;
            }
            if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && aStack.func_77960_j() >= 170 && aStack.func_77960_j() <= 179) {
                return true;
            }
        }
        return false;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
    }

    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mSaveRotor = Utils.invertBoolean(this.mSaveRotor);
        if (this.mSaveRotor) {
            PlayerUtils.messagePlayer(aPlayer, "Running in low efficiency mode, rotors will not break.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Running in high efficiency mode, rotors will break.");
        }
        return true;
    }

    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex == -120) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(103)), (int)MathUtils.randInt(5, 50), (float)0.05f, (double)aX, (double)aY, (double)aZ);
        } else if (aIndex != -121 && aIndex != -122) {
            super.doSound((byte)0, aX, aY, aZ);
        }
    }

    public boolean canHaveInsufficientEnergy() {
        return super.canHaveInsufficientEnergy();
    }

    public String[] getInfoData() {
        AutoMap<String> aTooltipSuper = new AutoMap<String>();
        for (String s : super.getInfoData()) {
            aTooltipSuper.put(s);
        }
        int mAirSides = this.getFreeSpaces();
        int reduction = 0;
        try {
            long tVoltage = this.maxEUInput();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            reduction += Math.max(tTier - 2, 1) * 2 * 50 * mAirSides;
            reduction = MathUtils.safeInt((long)reduction * (long)this.mBaseEff) / 100000 * mAirSides * Math.max(tTier - 2, 1);
            reduction = MathUtils.safeInt((long)reduction / 100L * (long)this.mOptimalAirFlow);
            aTooltipSuper.put("Maximum pollution removed per second: " + reduction);
        }
        catch (Throwable t) {
            aTooltipSuper.put("Maximum pollution removed per second: " + this.mPollutionReduction);
        }
        aTooltipSuper.put("Air Sides: " + mAirSides);
        String[] mBuiltOutput = new String[aTooltipSuper.size()];
        int aIndex = 0;
        for (String i : aTooltipSuper) {
            mBuiltOutput[aIndex++] = i;
        }
        return mBuiltOutput;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        if (aSide <= 1) {
            return false;
        }
        return super.allowCoverOnSide(aSide, aCoverID);
    }

    public ITexture[] getTopFacingInactive(byte aColor) {
        return super.getTopFacingInactive(aColor);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mOptimalAirFlow", this.mOptimalAirFlow);
        aNBT.func_74757_a("mSaveRotor", this.mSaveRotor);
        super.setItemNBT(aNBT);
    }

    public static ItemStack getTieredTurbine(int aTier) {
        if (sGregTurbines != null) {
            return sGregTurbines[aTier];
        }
        sGregTurbines = new ItemStack[3];
        GregtechMetaAtmosphericReconditioner.sGregTurbines[0] = ((GT_MetaGenerated_Tool)GT_MetaGenerated_Tool.sInstances.get("gt.metatool.01")).getToolWithStats(170, 1, Materials.Iron, Materials.Iron, null);
        GregtechMetaAtmosphericReconditioner.sGregTurbines[1] = ((GT_MetaGenerated_Tool)GT_MetaGenerated_Tool.sInstances.get("gt.metatool.01")).getToolWithStats(170, 1, Materials.Bronze, Materials.Bronze, null);
        GregtechMetaAtmosphericReconditioner.sGregTurbines[2] = ((GT_MetaGenerated_Tool)GT_MetaGenerated_Tool.sInstances.get("gt.metatool.01")).getToolWithStats(170, 1, Materials.Steel, Materials.Steel, null);
        return null;
    }

    public int getBaseEfficiency(ItemStack aStackRotor) {
        if (aStackRotor.func_77973_b() instanceof ItemBasicScrubberTurbine) {
            return this.getBaseEfficiency(GregtechMetaAtmosphericReconditioner.getTieredTurbine(aStackRotor.func_77960_j()));
        }
        return (int)((50.0f + 10.0f * ((GT_MetaGenerated_Tool)aStackRotor.func_77973_b()).getToolCombatDamage(aStackRotor)) * 100.0f);
    }

    public int getOptimalAirFlow(ItemStack aStackRotor) {
        if (aStackRotor.func_77973_b() instanceof ItemBasicScrubberTurbine) {
            return this.getOptimalAirFlow(GregtechMetaAtmosphericReconditioner.getTieredTurbine(aStackRotor.func_77960_j()));
        }
        return (int)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStackRotor.func_77973_b()).getToolStats(aStackRotor).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStackRotor).mToolSpeed * 50.0f);
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.SLOT_ROTOR).setFilter(stack -> {
            if (stack.func_77973_b() instanceof ItemBasicScrubberTurbine) {
                return true;
            }
            return stack.func_77973_b() instanceof GT_MetaGenerated_Tool && stack.func_77960_j() >= 170 && stack.func_77960_j() <= 179;
        }).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_TURBINE}).setPos(52, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, this.SLOT_FILTER).setFilter(stack -> stack.func_77973_b() instanceof ItemAirFilter).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_RECYCLE}).setPos(106, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 7).setFilter(stack -> GT_Utility.areStacksEqual((ItemStack)stack, (ItemStack)mConveyorMap.get(this.mTier), (boolean)true)).setPos(124, 62));
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_INFORMATION).dynamicTooltip(() -> Collections.singletonList("Reduction: " + this.mPollutionReduction + "/s")).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.mPollutionReduction, val -> {
            this.mPollutionReduction = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()).setPos(163, 5).setSize(7, 18));
    }

    static {
        for (byte i = 0; i < 9; i = (byte)(i + 1)) {
            mConveyorMap.put(i, CI.getConveyor(i, 1));
        }
    }
}

