/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.tesseract.TesseractHelper;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.GT_MetaTileEntity_TesseractGenerator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class GT_MetaTileEntity_TesseractTerminal
extends GT_MetaTileEntity_BasicTank {
    public int mFrequency = 0;
    public UUID mOwner;
    public boolean mDidWork = false;
    public static boolean sInterDimensionalTesseractAllowed = true;
    private static int TESSERACT_ENERGY_COST = 128;
    private static int TESSERACT_ENERGY_COST_DIMENSIONAL = 512;

    public GT_MetaTileEntity_TesseractTerminal(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "", new ITexture[0]);
    }

    public GT_MetaTileEntity_TesseractTerminal(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TesseractTerminal(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public long getMinimumStoredEU() {
        return this.getBaseMetaTileEntity().getEUCapacity() / 100L;
    }

    public long maxEUInput() {
        return TESSERACT_ENERGY_COST_DIMENSIONAL;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public long maxEUStore() {
        return TESSERACT_ENERGY_COST_DIMENSIONAL * 8 * 32;
    }

    public long maxSteamStore() {
        return this.maxEUStore();
    }

    public boolean ownerControl() {
        return true;
    }

    public int getProgresstime() {
        return this.getTesseract(this.mFrequency, false) != null ? 999 : 0;
    }

    public int maxProgresstime() {
        return 1000;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFrequency", this.mFrequency);
        aNBT.func_74778_a("mOwner", this.mOwner.toString());
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFrequency = aNBT.func_74762_e("mFrequency");
        this.mOwner = UUID.fromString(aNBT.func_74779_i("mOnwer"));
    }

    public void onConfigLoad(GT_Config aConfig) {
        sInterDimensionalTesseractAllowed = true;
        TESSERACT_ENERGY_COST = 512;
        TESSERACT_ENERGY_COST_DIMENSIONAL = 2048;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (this.mOwner == null && this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().equals("") && this.getBaseMetaTileEntity().getOwnerName().toLowerCase().equals(aPlayer.getDisplayName().toLowerCase())) {
            this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
        }
        if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
            if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
                float[] tCoords = GT_Utility.getClickedFacingCoords((byte)aSide, (float)aX, (float)aY, (float)aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        --this.mFrequency;
                        break;
                    }
                    case 1: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.mFrequency;
                    }
                    default: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                PlayerUtils.messagePlayer(aPlayer, "Frequency: " + this.mFrequency);
                if (this.getTesseract(this.mFrequency, false) != null) {
                    PlayerUtils.messagePlayer(aPlayer, EnumChatFormatting.GREEN + " (Connected)");
                }
            }
        } else if (aPlayer.func_110124_au().compareTo(this.mOwner) != 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"This is not your Tesseract Terminal to configure.");
        }
        return true;
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
            if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
                float[] tCoords = GT_Utility.getClickedFacingCoords((byte)aSide, (float)aX, (float)aY, (float)aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 64;
                        break;
                    }
                    case 1: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 64;
                        break;
                    }
                    case 2: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 512;
                        break;
                    }
                    case 3: {
                        try {
                            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 512;
                    }
                }
                GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)("Frequency: " + this.mFrequency + (this.getTesseract(this.mFrequency, false) == null ? "" : EnumChatFormatting.GREEN + " (Connected)")));
            }
        } else if (aPlayer.func_110124_au().compareTo(this.mOwner) != 0) {
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)"This is not your Tesseract Terminal to configure.");
        }
    }

    public boolean allowCoverOnSide(byte aSide, int aCoverID) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public GT_MetaTileEntity_TesseractGenerator getTesseract(int aFrequency, boolean aWorkIrrelevant) {
        GT_MetaTileEntity_TesseractGenerator rTesseract = TesseractHelper.getGeneratorByFrequency(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), aFrequency);
        if (rTesseract == null) {
            return null;
        }
        if (!TesseractHelper.isGeneratorOwnedByPlayer(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), rTesseract)) {
            return null;
        }
        if (rTesseract.mFrequency != aFrequency) {
            TesseractHelper.setTerminalOwnershipByPlayer(PlayerUtils.getPlayerOnServerFromUUID(this.mOwner), aFrequency, null);
            return null;
        }
        if (!rTesseract.isValidTesseractGenerator(this.getBaseMetaTileEntity().getOwnerName(), aWorkIrrelevant)) {
            return null;
        }
        if (!sInterDimensionalTesseractAllowed && rTesseract.getBaseMetaTileEntity().getWorld() != this.getBaseMetaTileEntity().getWorld()) {
            return null;
        }
        return rTesseract;
    }

    public String[] getInfoData() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity.isSendingInformation()) {
            return tTileEntity.getInfoData();
        }
        return new String[]{"Tesseract Generator", "Freqency:", "" + this.mFrequency, this.getTesseract(this.mFrequency, false) != null ? "Active" : "Inactive"};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean isDigitalChest() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.isDigitalChest();
    }

    public ItemStack[] getStoredItemData() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.getStoredItemData();
    }

    public void setItemCount(int aCount) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return;
        }
        tTileEntity.setItemCount(aCount);
    }

    public int getMaxItemCount() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.getMaxItemCount();
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int aSide) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return new int[0];
        }
        return tTileEntity.func_94128_d(aSide);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_102007_a(aIndex, aStack, aSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_102008_b(aIndex, aStack, aSide);
    }

    public int func_70302_i_() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70302_i_();
    }

    public ItemStack func_70301_a(int aIndex) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70301_a(aIndex);
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return;
        }
        tTileEntity.func_70299_a(aIndex, aStack);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70298_a(aIndex, aAmount);
    }

    public String func_145825_b() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return "";
        }
        return tTileEntity.func_145825_b();
    }

    public int func_70297_j_() {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70297_j_();
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canFill(aSide, aFluid);
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canDrain(aSide, aFluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return new FluidTankInfo[0];
        }
        return tTileEntity.getTankInfo(aSide);
    }

    public int fill_default(ForgeDirection aDirection, FluidStack aFluid, boolean doFill) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.fill(aDirection, aFluid, doFill);
    }

    public FluidStack drain(ForgeDirection aDirection, int maxDrain, boolean doDrain) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aDirection, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        GT_MetaTileEntity_TesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aSide, aFluid, doDrain);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            GT_MetaTileEntity_TesseractGenerator tTileEntity;
            if (PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName()) != null && this.mOwner == null) {
                this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
            }
            if ((tTileEntity = this.getTesseract(this.mFrequency, true)) != null) {
                tTileEntity.addEnergyConsumption(this);
                if (!this.mDidWork && this.getTesseract(this.mFrequency, false) != null) {
                    this.mDidWork = true;
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                    this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(128L, false);
                }
            } else if (this.mDidWork) {
                this.mDidWork = false;
                this.getBaseMetaTileEntity().issueBlockUpdate();
            }
        }
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Accesses Tesseract Generators remotely", "Connect with pipes to extract items or fluids", "Outputs from the back face", "Consumes " + TESSERACT_ENERGY_COST + "EU/t for same dimension transfers", "Consumes " + TESSERACT_ENERGY_COST_DIMENSIONAL + "EU/t for cross dimensional transfers", CORE.GT_Tooltip.get()};
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == aFacing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Screen_Frequency);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.VOID);
        }
        return iTextureArray;
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return false;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().equals("")) {
            this.mOwner = PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
        }
        super.onCreated(aStack, aWorld, aPlayer);
    }

    public void onRemoval() {
        try {
            CORE.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onRemoval();
    }
}

