/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers.treefarm;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.FakeBlockPos;
import gtPlusPlus.api.objects.minecraft.FakeWorld;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeGenerator {
    private static final FakeTreeInFakeWorldGenerator mTreeData;

    public TreeGenerator() {
        if (!mTreeData.hasGenerated) {
            mTreeData.func_76484_a(null, CORE.RANDOM, 0, 0, 0);
        }
    }

    public AutoMap<ItemStack> generateOutput(int aTreeSize) {
        AutoMap<ItemStack> aOutputMap = mTreeData.getOutputFromTree();
        if (aOutputMap != null && aOutputMap.size() > 0) {
            Logger.WARNING("Valid tree data output");
            return aOutputMap;
        }
        Logger.WARNING("Invalid tree data output");
        return new AutoMap<ItemStack>();
    }

    static {
        Logger.WARNING("Created Fake Tree Generator.");
        mTreeData = new FakeTreeInFakeWorldGenerator();
    }

    public static class FakeTreeInFakeWorldGenerator
    extends WorldGenAbstractTree {
        private final int minTreeHeight;
        private final boolean vinesGrow;
        private final int metaWood;
        private final int metaLeaves;
        private final AutoMap<FakeWorld> mFakeWorld;
        private final int mTreesToGenerate;
        private int mCurrentGeneratorIteration = 0;
        private boolean hasGenerated = false;
        private AutoMap<ItemStack> aOutputsFromGenerator = new AutoMap();
        private FakeWorld aFakeWorld;

        public FakeTreeInFakeWorldGenerator() {
            this(4, 0, 0, false, 5000);
        }

        public FakeTreeInFakeWorldGenerator(int aMinHeight, int aWoodMeta, int aLeafMeta, boolean aVines, int aTreeCount) {
            super(false);
            this.minTreeHeight = aMinHeight;
            this.metaWood = aWoodMeta;
            this.metaLeaves = aLeafMeta;
            this.vinesGrow = aVines;
            this.mFakeWorld = new AutoMap();
            this.mTreesToGenerate = aTreeCount;
            Logger.WARNING("Created Fake Tree In Fake World Instance.");
        }

        public AutoMap<ItemStack> getOutputFromTree() {
            if (!this.hasGenerated) {
                Logger.WARNING("Generating Tree sample data");
                this.func_76484_a(null, CORE.RANDOM, 0, 0, 0);
            }
            AutoMap<ItemStack> aOutputMap = new AutoMap<ItemStack>();
            int aRandomTreeID = MathUtils.randInt(0, this.mFakeWorld.size() - 1);
            FakeWorld aWorld = this.mFakeWorld.get(aRandomTreeID);
            if (aWorld != null) {
                aOutputMap = aWorld.getAllBlocksStoredInFakeWorld();
            }
            return aOutputMap;
        }

        protected boolean func_150523_a(Block p_150523_1_) {
            return p_150523_1_.func_149688_o() == Material.field_151579_a || p_150523_1_.func_149688_o() == Material.field_151584_j || p_150523_1_ == Blocks.field_150349_c || p_150523_1_ == Blocks.field_150346_d || p_150523_1_ == Blocks.field_150364_r || p_150523_1_ == Blocks.field_150363_s || p_150523_1_ == Blocks.field_150345_g || p_150523_1_ == Blocks.field_150395_bd;
        }

        protected boolean isReplaceable(World world, int x, int y, int z) {
            FakeWorld aWorld = this.getWorld();
            Block block = aWorld.func_147439_a(x, y, z);
            return block.isAir(null, x, y, z) || block.isLeaves(null, x, y, z) || block.isWood(null, x, y, z) || this.func_150523_a(block);
        }

        public boolean func_76484_a(World world, Random aRand, int aWorldX, int aWorldRealY, int aWorldZ) {
            if (this.hasGenerated) {
                return this.hasGenerated;
            }
            for (int yy = 0; yy < this.mTreesToGenerate; ++yy) {
                this.generateTree(0, 0, 0);
                ++this.mCurrentGeneratorIteration;
            }
            this.hasGenerated = true;
            if (this.mFakeWorld.size() > 0) {
                for (FakeWorld aWorld : this.mFakeWorld) {
                    for (ItemStack aBlockInFakeWorld : aWorld.getAllBlocksStoredInFakeWorld()) {
                        this.aOutputsFromGenerator.add(aBlockInFakeWorld);
                    }
                }
                return true;
            }
            return false;
        }

        public FakeWorld getWorld() {
            FakeWorld aWorld = this.mFakeWorld.get(this.mCurrentGeneratorIteration);
            if (aWorld == null) {
                this.mFakeWorld.set(this.mCurrentGeneratorIteration, new FakeWorld(200));
                aWorld = this.mFakeWorld.get(this.mCurrentGeneratorIteration);
            }
            return aWorld;
        }

        public boolean generateTree(int aWorldX, int aWorldRealY, int aWorldZ) {
            FakeWorld aWorld = this.getWorld();
            Logger.WARNING("Stepping through generateTree [0]");
            int aWorldY = 10;
            int l = CORE.RANDOM.nextInt(3) + this.minTreeHeight;
            boolean flag = true;
            if (aWorldY >= 1 && aWorldY + l + 1 <= 256) {
                Block block;
                int k1;
                int b0;
                Logger.WARNING("Stepping through generateTree [1]");
                for (int i1 = aWorldY; i1 <= aWorldY + 1 + l; ++i1) {
                    b0 = 1;
                    if (i1 == aWorldY) {
                        b0 = 0;
                    }
                    if (i1 >= aWorldY + 1 + l - 2) {
                        b0 = 2;
                    }
                    for (int j1 = aWorldX - b0; j1 <= aWorldX + b0 && flag; ++j1) {
                        for (k1 = aWorldZ - b0; k1 <= aWorldZ + b0 && flag; ++k1) {
                            if (i1 >= 0 && i1 < 256) {
                                block = aWorld.func_147439_a(j1, i1, k1);
                                if (this.isReplaceable(null, j1, i1, k1)) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                        }
                    }
                }
                if (!flag) {
                    Logger.WARNING("Stepping through generateTree [2]");
                    return false;
                }
                Logger.WARNING("Stepping through generateTree [3]");
                Block block2 = aWorld.func_147439_a(aWorldX, aWorldY - 1, aWorldZ);
                FakeBlockPos aBlockToGrowPlantOn = aWorld.getBlockAtCoords(aWorldX, aWorldY - 1, aWorldZ);
                boolean isSoil = block2.canSustainPlant((IBlockAccess)aWorld, aWorldX, aWorldY - 1, aWorldZ, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
                if (aWorldY < 256 - l - 1) {
                    int j2;
                    int i2;
                    int l1;
                    int i3;
                    Logger.WARNING("Stepping through generateTree [4]");
                    aBlockToGrowPlantOn.onPlantGrow(aWorld, aWorldX, aWorldY - 1, aWorldZ, aWorldX, aWorldY, aWorldZ);
                    b0 = 3;
                    int b1 = 0;
                    for (k1 = aWorldY - b0 + l; k1 <= aWorldY + l; ++k1) {
                        i3 = k1 - (aWorldY + l);
                        l1 = b1 + 1 - i3 / 2;
                        for (i2 = aWorldX - l1; i2 <= aWorldX + l1; ++i2) {
                            j2 = i2 - aWorldX;
                            for (int k2 = aWorldZ - l1; k2 <= aWorldZ + l1; ++k2) {
                                Block block1;
                                int l2 = k2 - aWorldZ;
                                if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (CORE.RANDOM.nextInt(2) == 0 || i3 == 0) || !(block1 = aWorld.func_147439_a(i2, k1, k2)).isAir(null, i2, k1, k2) && !block1.isLeaves(null, i2, k1, k2)) continue;
                                this.setBlockAndNotifyAdequately(aWorld, i2, k1, k2, (Block)Blocks.field_150362_t, this.metaLeaves);
                            }
                        }
                    }
                    Logger.WARNING("Stepping through generateTree [5]");
                    for (k1 = 0; k1 < l; ++k1) {
                        block = aWorld.func_147439_a(aWorldX, aWorldY + k1, aWorldZ);
                        if (!block.isAir(null, aWorldX, aWorldY + k1, aWorldZ) && !block.isLeaves(null, aWorldX, aWorldY + k1, aWorldZ)) continue;
                        this.setBlockAndNotifyAdequately(aWorld, aWorldX, aWorldY + k1, aWorldZ, Blocks.field_150364_r, this.metaWood);
                        if (!this.vinesGrow || k1 <= 0) continue;
                        if (CORE.RANDOM.nextInt(3) > 0 && aWorld.func_147437_c(aWorldX - 1, aWorldY + k1, aWorldZ)) {
                            this.setBlockAndNotifyAdequately(aWorld, aWorldX - 1, aWorldY + k1, aWorldZ, Blocks.field_150395_bd, 8);
                        }
                        if (CORE.RANDOM.nextInt(3) > 0 && aWorld.func_147437_c(aWorldX + 1, aWorldY + k1, aWorldZ)) {
                            this.setBlockAndNotifyAdequately(aWorld, aWorldX + 1, aWorldY + k1, aWorldZ, Blocks.field_150395_bd, 2);
                        }
                        if (CORE.RANDOM.nextInt(3) > 0 && aWorld.func_147437_c(aWorldX, aWorldY + k1, aWorldZ - 1)) {
                            this.setBlockAndNotifyAdequately(aWorld, aWorldX, aWorldY + k1, aWorldZ - 1, Blocks.field_150395_bd, 1);
                        }
                        if (CORE.RANDOM.nextInt(3) <= 0 || !aWorld.func_147437_c(aWorldX, aWorldY + k1, aWorldZ + 1)) continue;
                        this.setBlockAndNotifyAdequately(aWorld, aWorldX, aWorldY + k1, aWorldZ + 1, Blocks.field_150395_bd, 4);
                    }
                    Logger.WARNING("Stepping through generateTree [6]");
                    if (this.vinesGrow) {
                        Logger.WARNING("Stepping through generateTree [7]");
                        for (k1 = aWorldY - 3 + l; k1 <= aWorldY + l; ++k1) {
                            i3 = k1 - (aWorldY + l);
                            l1 = 2 - i3 / 2;
                            for (i2 = aWorldX - l1; i2 <= aWorldX + l1; ++i2) {
                                for (j2 = aWorldZ - l1; j2 <= aWorldZ + l1; ++j2) {
                                    if (!aWorld.func_147439_a(i2, k1, j2).isLeaves(null, i2, k1, j2)) continue;
                                    if (CORE.RANDOM.nextInt(4) == 0 && aWorld.func_147439_a(i2 - 1, k1, j2).isAir(null, i2 - 1, k1, j2)) {
                                        this.growVines(aWorld, i2 - 1, k1, j2, 8);
                                    }
                                    if (CORE.RANDOM.nextInt(4) == 0 && aWorld.func_147439_a(i2 + 1, k1, j2).isAir(null, i2 + 1, k1, j2)) {
                                        this.growVines(aWorld, i2 + 1, k1, j2, 2);
                                    }
                                    if (CORE.RANDOM.nextInt(4) == 0 && aWorld.func_147439_a(i2, k1, j2 - 1).isAir(null, i2, k1, j2 - 1)) {
                                        this.growVines(aWorld, i2, k1, j2 - 1, 1);
                                    }
                                    if (CORE.RANDOM.nextInt(4) != 0 || !aWorld.func_147439_a(i2, k1, j2 + 1).isAir(null, i2, k1, j2 + 1)) continue;
                                    this.growVines(aWorld, i2, k1, j2 + 1, 4);
                                }
                            }
                        }
                        Logger.WARNING("Stepping through generateTree [8]");
                        if (CORE.RANDOM.nextInt(5) == 0 && l > 5) {
                            for (k1 = 0; k1 < 2; ++k1) {
                                for (i3 = 0; i3 < 4; ++i3) {
                                    if (CORE.RANDOM.nextInt(4 - k1) != 0) continue;
                                    l1 = CORE.RANDOM.nextInt(3);
                                    this.setBlockAndNotifyAdequately(aWorld, aWorldX + Direction.field_71583_a[Direction.field_71580_e[i3]], aWorldY + l - 5 + k1, aWorldZ + Direction.field_71581_b[Direction.field_71580_e[i3]], Blocks.field_150375_by, l1 << 2 | i3);
                                }
                            }
                        }
                    }
                    Logger.WARNING("Stepping through generateTree [9]");
                    return true;
                }
                Logger.WARNING("Stepping through generateTree [10]");
                return false;
            }
            Logger.WARNING("Stepping through generateTree [11]");
            return false;
        }

        private void growVines(FakeWorld aWorld, int aX, int aY, int aZ, int aMeta) {
            int aLoopSize = this.vinesGrow ? MathUtils.randInt(0, 4) : 0;
            for (int i = 0; i < aLoopSize; ++i) {
                this.setBlockAndNotifyAdequately(aWorld, aX, aY, aZ, Blocks.field_150395_bd, aMeta);
            }
        }

        protected void func_150516_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta) {
            this.setBlockAndNotifyAdequately(this.getWorld(), aX, aY, aZ, aBlock, aMeta);
        }

        protected void setBlockAndNotifyAdequately(FakeWorld aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta) {
            if (aBlock != null && aMeta >= 0 && aMeta <= Short.MAX_VALUE) {
                Logger.WARNING("Setting block " + aX + ", " + aY + ", " + aZ + " | " + aBlock.func_149732_F() + " | " + aMeta);
                aWorld.setBlockAtCoords(aX, aY, aZ, aBlock, aMeta);
            }
        }
    }
}

