/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech;

import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gtPlusPlus.api.helpers.GregtechPlusPlus_API;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.api.objects.minecraft.multi.NoEUBonusMultiBehaviour;
import gtPlusPlus.api.objects.minecraft.multi.NoOutputBonusMultiBehaviour;
import gtPlusPlus.api.objects.minecraft.multi.NoSpeedBonusMultiBehaviour;
import gtPlusPlus.core.handler.COMPAT_HANDLER;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.core.util.reflect.AddGregtechRecipe;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.util.GTPP_Config;
import gtPlusPlus.xmod.gregtech.api.world.GTPP_Worldgen;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import gtPlusPlus.xmod.gregtech.common.blocks.fluid.GregtechFluidHandler;
import gtPlusPlus.xmod.gregtech.common.computer.GT_ComputerCube_Setup;
import gtPlusPlus.xmod.gregtech.common.computer.GT_Computercube_Description;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMTE_ElementalDuplicator;
import gtPlusPlus.xmod.gregtech.loaders.Gregtech_Blocks;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingAngleGrinder;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingElectricButcherKnife;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingElectricLighter;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingElectricSnips;
import gtPlusPlus.xmod.gregtech.loaders.ProcessingToolHeadChoocher;
import gtPlusPlus.xmod.gregtech.loaders.misc.AddCustomMachineToPA;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_AlgaeFarm;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_MolecularTransformer;
import gtPlusPlus.xmod.gregtech.recipes.RecipesToRemove;
import gtPlusPlus.xmod.gregtech.registration.gregtech.GregtechConduits;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class HANDLER_GT {
    public static GT_Config mMaterialProperties = null;
    public static GTPP_Config sCustomWorldgenFile = null;
    public static final List<WorldGen_GT> sWorldgenListEverglades = new ArrayList<WorldGen_GT>();
    public static final List<GTPP_Worldgen> sCustomWorldgenList = new ArrayList<GTPP_Worldgen>();
    public static GT_MetaGenerated_Tool sMetaGeneratedToolInstance;

    public static void preInit() {
        if (mMaterialProperties != null) {
            GregtechOrePrefixes.GT_Materials.init(mMaterialProperties);
        }
        GregtechFluidHandler.run();
    }

    public static void init() {
        Gregtech_Blocks.run();
        GregtechConduits.run();
        COMPAT_HANDLER.registerGregtechMachines();
        if (CORE.ConfigSwitches.enableSkookumChoochers) {
            sMetaGeneratedToolInstance = MetaGeneratedGregtechTools.getInstance();
        }
    }

    public static void postInit() {
        int i;
        if (CORE.ConfigSwitches.enableSkookumChoochers) {
            new ProcessingToolHeadChoocher().run();
        }
        new ProcessingAngleGrinder().run();
        new ProcessingElectricSnips().run();
        new ProcessingElectricButcherKnife().run();
        new ProcessingElectricLighter().run();
        AddCustomMachineToPA.register();
        GregtechPlusPlus_API.Multiblock_API.registerSpecialMultiBehaviour(new NoOutputBonusMultiBehaviour());
        GregtechPlusPlus_API.Multiblock_API.registerSpecialMultiBehaviour(new NoSpeedBonusMultiBehaviour());
        GregtechPlusPlus_API.Multiblock_API.registerSpecialMultiBehaviour(new NoEUBonusMultiBehaviour());
        if (GregtechItemList.Circuit_BioRecipeSelector.hasBeenSet()) {
            for (i = 1; i <= 24; ++i) {
                GregTech_API.registerConfigurationCircuit((ItemStack)CI.getNumberedBioCircuit(i), (int)0);
            }
        }
        if (GregtechItemList.Circuit_T3RecipeSelector.hasBeenSet()) {
            for (i = 1; i <= 24; ++i) {
                GregTech_API.registerConfigurationCircuit((ItemStack)CI.getNumberedAdvancedCircuit(i), (int)3);
            }
        }
    }

    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        HANDLER_GT.removeCrudeTurbineRotors();
        if (CORE.ConfigSwitches.enableHarderRecipesForHighTierCasings) {
            HANDLER_GT.removeOldHighTierCasingRecipes();
        }
        RecipesToRemove.go();
        HANDLER_GT.convertPyroToCokeOven();
        HANDLER_GT.generateElementalDuplicatorRecipes();
        Meta_GT_Proxy.fixIC2FluidNames();
        GT_Computercube_Description.addStandardDescriptions();
        GT_ComputerCube_Setup.init();
        RecipeLoader_AlgaeFarm.generateRecipes();
        if (LoadedMods.AdvancedSolarPanel) {
            RecipeLoader_MolecularTransformer.run();
        }
    }

    private static void generateElementalDuplicatorRecipes() {
        for (GT_Recipe aRecipe : GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.mRecipeList) {
            Object aDataOrb = aRecipe.mSpecialItems;
            if (aDataOrb != null) {
                ItemStack aOutput = aRecipe.mOutputs[0];
                if (aOutput != null) {
                    FluidStack aFluid = aRecipe.mFluidInputs[0];
                    if (aFluid != null && aFluid.amount > 0) {
                        ItemStack tDataOrb = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(aRecipe);
                        Materials tMaterial = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)tDataOrb)).mLinkedMaterials.get(0);
                        FluidStack aOutputFluid = null;
                        ItemStack aOutputItem = null;
                        if (tMaterial == null) continue;
                        boolean aUsingFluid = false;
                        aOutputItem = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)tMaterial, (long)1L);
                        if (aOutputItem == null && (aOutputItem = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)tMaterial, (long)1L)) != null) {
                            aOutputFluid = GT_Utility.getFluidForFilledItem((ItemStack)aOutputItem, (boolean)true);
                            aUsingFluid = true;
                        }
                        GTPP_Recipe aNewRecipe = new GTPP_Recipe(false, new ItemStack[]{}, new ItemStack[]{!aUsingFluid ? aOutputItem : null}, aRecipe.mSpecialItems, null, aRecipe.mFluidInputs, new FluidStack[]{aUsingFluid ? aOutputFluid : null}, aRecipe.mDuration, aRecipe.mEUt, aRecipe.mFluidInputs[0].amount);
                        GTPP_Recipe.GTPP_Recipe_Map.sElementalDuplicatorRecipes.add((GT_Recipe)aNewRecipe);
                        Logger.INFO("[EM] Generated recipe for " + tMaterial.mLocalizedName + ", Outputs " + (aUsingFluid ? "Fluid" : "Dust"));
                        continue;
                    }
                    Logger.INFO("[EM] Bad UU Requirement. " + RecipeUtils.getRecipeInfo(aRecipe));
                    continue;
                }
                Logger.INFO("[EM] Bad Output. " + RecipeUtils.getRecipeInfo(aRecipe));
                continue;
            }
            Logger.INFO("[EM] Bad Data Orb. " + RecipeUtils.getRecipeInfo(aRecipe));
        }
        int aSize = GTPP_Recipe.GTPP_Recipe_Map.sElementalDuplicatorRecipes.mRecipeList.size();
        Logger.INFO("[EM] Generated " + aSize + "/" + GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.mRecipeList.size() + " Replicator recipes.");
    }

    private static void convertPyroToCokeOven() {
        int aCount = 0;
        for (GT_Recipe g : GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.mRecipeList) {
            if (!AddGregtechRecipe.importPyroRecipe(g)) continue;
            ++aCount;
        }
        Logger.INFO("Converted " + aCount + " Pyrolyse recipes into Industrial Coke Oven recipes.");
    }

    private static GT_Recipe replaceItemInRecipeWithAnother(GT_Recipe aRecipe, ItemStack aExisting, ItemStack aNewItem) {
        ItemStack[] aInputItemsCopy = aRecipe.mInputs;
        String aOutputName = ItemUtils.getItemName(aRecipe.mOutputs[0]);
        boolean aDidChange = false;
        Logger.INFO("Attempting to Modify Recipe for " + aOutputName);
        for (int i = 0; i < aRecipe.mInputs.length; ++i) {
            ItemStack aCurrentInputSlot = aRecipe.mInputs[i];
            if (aCurrentInputSlot == null || !GT_Utility.areStacksEqual((ItemStack)aCurrentInputSlot, (ItemStack)aExisting, (boolean)true)) continue;
            aInputItemsCopy[i] = ItemUtils.getSimpleStack(aNewItem, aCurrentInputSlot.field_77994_a);
            aDidChange = true;
        }
        if (aDidChange) {
            aRecipe.mInputs = aInputItemsCopy;
            Logger.INFO("Modifed Recipe for " + aOutputName);
            return aRecipe;
        }
        Logger.INFO("Failed to Modify Recipe for " + aOutputName);
        return aRecipe;
    }

    private static void updateRecipeMap(GT_Recipe aOld, GT_Recipe aNew, GT_Recipe.GT_Recipe_Map aMap) {
        RecipeUtils.removeGtRecipe(aOld, aMap);
        RecipeUtils.addGtRecipe(aNew, aMap);
        Logger.INFO("Updating recipe map: " + aMap.mNEIName);
        Logger.INFO("Removed Recipe with hash: " + aOld.hashCode());
        Logger.INFO("Added Recipe with hash: " + aNew.hashCode());
    }

    private static void removeOldHighTierCasingRecipes() {
        ItemStack aCasing_LUV = CI.machineCasing_LuV;
        ItemStack aCasing_ZPM = CI.machineCasing_ZPM;
        ItemStack aCasing_UV = CI.machineCasing_UV;
        ItemStack aCasing_MAX = CI.machineCasing_MAX;
        ItemStack aHull_LUV = CI.machineHull_LuV;
        ItemStack aHull_ZPM = CI.machineHull_ZPM;
        ItemStack aHull_UV = CI.machineHull_UV;
        ItemStack aHull_MAX = CI.machineHull_MAX;
        int aTier_LUV = 5;
        int aTier_ZPM = 6;
        int aTier_UV = 7;
        ItemStack[] aCasings = new ItemStack[]{aCasing_LUV, aCasing_ZPM, aCasing_UV, aCasing_MAX};
        ItemStack[] aHulls = new ItemStack[]{aHull_LUV, aHull_ZPM, aHull_UV, aHull_MAX};
        Logger.INFO("Removing shaped crafting for Casings.");
        RecipeUtils.removeRecipeByOutput(aCasing_LUV);
        RecipeUtils.removeRecipeByOutput(aCasing_ZPM);
        RecipeUtils.removeRecipeByOutput(aCasing_UV);
        Logger.INFO("Removing shaped crafting for Hulls.");
        RecipeUtils.removeRecipeByOutput(aHull_LUV);
        RecipeUtils.removeRecipeByOutput(aHull_ZPM);
        RecipeUtils.removeRecipeByOutput(aHull_UV);
        Logger.INFO("Attempting to modify existing Assembly recipes for Casings & Hulls, this should provide best compatibility.");
        int aUpdateCount = 0;
        AutoMap<Pair<GT_Recipe, GT_Recipe>> aDataToModify = new AutoMap<Pair<GT_Recipe, GT_Recipe>>();
        block0: for (GT_Recipe gT_Recipe : GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList) {
            String aOutputName;
            if (gT_Recipe == null || gT_Recipe.mOutputs == null || gT_Recipe.mOutputs.length <= 0) continue;
            GT_Recipe aOldRecipeCopy = gT_Recipe;
            GT_Recipe aNewRecipe = gT_Recipe.copy();
            for (ItemStack aCasingObject : aCasings) {
                if (!GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aCasingObject)) continue;
                aOutputName = ItemUtils.getItemName(aOldRecipeCopy.mOutputs[0]);
                Logger.INFO("Attempting to Modify Assembly Recipe for " + aOutputName);
                if (GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aCasing_LUV)) {
                    aNewRecipe = HANDLER_GT.replaceItemInRecipeWithAnother(aOldRecipeCopy, ItemUtils.getItemStackOfAmountFromOreDict("plateChrome", 1), ELEMENT.getInstance().SELENIUM.getPlate(1));
                    aDataToModify.put(new Pair<GT_Recipe, GT_Recipe>(gT_Recipe, aNewRecipe));
                    ++aUpdateCount;
                    continue block0;
                }
                if (GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aCasing_ZPM)) {
                    aNewRecipe = HANDLER_GT.replaceItemInRecipeWithAnother(aOldRecipeCopy, ItemUtils.getItemStackOfAmountFromOreDict("plateIridium", 1), CI.getPlate(aTier_ZPM, 1));
                    aDataToModify.put(new Pair<GT_Recipe, GT_Recipe>(gT_Recipe, aNewRecipe));
                    ++aUpdateCount;
                    continue block0;
                }
                if (!GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aCasing_UV)) continue;
                aNewRecipe = HANDLER_GT.replaceItemInRecipeWithAnother(aOldRecipeCopy, ItemUtils.getItemStackOfAmountFromOreDict("plateOsmium", 1), CI.getPlate(aTier_UV, 1));
                aDataToModify.put(new Pair<GT_Recipe, GT_Recipe>(gT_Recipe, aNewRecipe));
                ++aUpdateCount;
                continue block0;
            }
            for (ItemStack aHullObject : aHulls) {
                if (!GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aHullObject)) continue;
                aOutputName = ItemUtils.getItemName(aOldRecipeCopy.mOutputs[0]);
                Logger.INFO("Attempting to Modify Assembly Recipe for " + aOutputName);
                if (GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aHull_LUV)) {
                    aNewRecipe = HANDLER_GT.replaceItemInRecipeWithAnother(aOldRecipeCopy, ItemUtils.getItemStackOfAmountFromOreDict("plateChrome", 1), ELEMENT.getInstance().SELENIUM.getPlate(1));
                    aDataToModify.put(new Pair<GT_Recipe, GT_Recipe>(gT_Recipe, aNewRecipe));
                    ++aUpdateCount;
                    continue block0;
                }
                if (GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aHull_ZPM)) {
                    aNewRecipe = HANDLER_GT.replaceItemInRecipeWithAnother(aOldRecipeCopy, ItemUtils.getItemStackOfAmountFromOreDict("plateIridium", 1), CI.getPlate(aTier_ZPM, 1));
                    aDataToModify.put(new Pair<GT_Recipe, GT_Recipe>(gT_Recipe, aNewRecipe));
                    ++aUpdateCount;
                    continue block0;
                }
                if (!GT_Utility.areStacksEqual((ItemStack)aOldRecipeCopy.mOutputs[0], (ItemStack)aHull_UV)) continue;
                aNewRecipe = HANDLER_GT.replaceItemInRecipeWithAnother(aOldRecipeCopy, ItemUtils.getItemStackOfAmountFromOreDict("plateOsmium", 1), CI.getPlate(aTier_UV, 1));
                aDataToModify.put(new Pair<GT_Recipe, GT_Recipe>(gT_Recipe, aNewRecipe));
                ++aUpdateCount;
                continue block0;
            }
        }
        Logger.INFO("There is " + aUpdateCount + " recipes flagged for update.");
        if (aUpdateCount > 0) {
            for (Pair pair : aDataToModify) {
                HANDLER_GT.updateRecipeMap((GT_Recipe)pair.getKey(), (GT_Recipe)pair.getValue(), GT_Recipe.GT_Recipe_Map.sAssemblerRecipes);
            }
            Logger.INFO("Modified " + aUpdateCount + " recipes.");
        }
        Logger.INFO("Adding new Shaped recipes for Casings.");
        GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Casing_LuV.get(1L, new Object[0]), (long)CI.bits, (Object[])new Object[]{"PPP", "PwP", "PPP", Character.valueOf('P'), ELEMENT.getInstance().SELENIUM.getPlate(1)});
        GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Casing_ZPM.get(1L, new Object[0]), (long)CI.bits, (Object[])new Object[]{"PPP", "PwP", "PPP", Character.valueOf('P'), CI.getPlate(aTier_ZPM, 1)});
        GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Casing_UV.get(1L, new Object[0]), (long)CI.bits, (Object[])new Object[]{"PPP", "PwP", "PPP", Character.valueOf('P'), CI.getPlate(aTier_UV, 1)});
        if (!GT_Mod.gregtechproxy.mHardMachineCasings) {
            Logger.INFO("Adding new easy Shaped recipes for Hulls.");
            GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Hull_LuV.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"CMC", Character.valueOf('M'), ItemList.Casing_LuV, Character.valueOf('C'), OrePrefixes.cableGt01.get((Object)Materials.VanadiumGallium)});
            GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Hull_ZPM.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"CMC", Character.valueOf('M'), ItemList.Casing_ZPM, Character.valueOf('C'), OrePrefixes.cableGt01.get((Object)Materials.Naquadah)});
            GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Hull_UV.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"CMC", Character.valueOf('M'), ItemList.Casing_UV, Character.valueOf('C'), OrePrefixes.wireGt04.get((Object)Materials.NaquadahAlloy)});
        } else {
            Materials aPolytetrafluoroethylene = MaterialUtils.getMaterial("Polytetrafluoroethylene", "Plastic");
            Logger.INFO("Adding new hard Shaped recipes for Hulls.");
            GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Hull_LuV.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PHP", "CMC", Character.valueOf('M'), ItemList.Casing_LuV, Character.valueOf('C'), OrePrefixes.cableGt01.get((Object)Materials.VanadiumGallium), Character.valueOf('H'), ELEMENT.getInstance().SELENIUM.getPlate(1), Character.valueOf('P'), OrePrefixes.plate.get((Object)Materials.Plastic)});
            GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Hull_ZPM.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PHP", "CMC", Character.valueOf('M'), ItemList.Casing_ZPM, Character.valueOf('C'), OrePrefixes.cableGt01.get((Object)Materials.Naquadah), Character.valueOf('H'), CI.getPlate(aTier_ZPM, 1), Character.valueOf('P'), OrePrefixes.plate.get((Object)aPolytetrafluoroethylene)});
            GT_ModHandler.addCraftingRecipe((ItemStack)ItemList.Hull_UV.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.BUFFERED), (Object[])new Object[]{"PHP", "CMC", Character.valueOf('M'), ItemList.Casing_UV, Character.valueOf('C'), OrePrefixes.wireGt04.get((Object)Materials.NaquadahAlloy), Character.valueOf('H'), CI.getPlate(aTier_UV, 1), Character.valueOf('P'), OrePrefixes.plate.get((Object)aPolytetrafluoroethylene)});
        }
    }

    private static int removeCrudeTurbineRotors() {
        int aRemoved = 0;
        int CUT = CORE.turbineCutoffBase;
        Collection aAssRecipes = GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList;
        if (aAssRecipes.size() > 0) {
            block0: for (GT_Recipe aG : aAssRecipes) {
                if (aG.mOutputs == null || aG.mOutputs.length <= 0) continue;
                for (ItemStack aI : aG.mOutputs) {
                    int aCutoff;
                    int aMeta;
                    Item aU;
                    if (aI == null || (aU = aI.func_77973_b()) == null || !(aU instanceof GT_MetaGenerated_Tool_01) || (aMeta = aI.func_77960_j()) < 170 || aMeta > 176) continue;
                    int n = aMeta == 170 ? CUT : (aMeta == 172 ? CUT * 2 : (aCutoff = aMeta == 174 ? CUT * 3 : CUT * 4));
                    String aType = aMeta == 170 ? "Small " : (aMeta == 172 ? "" : (aMeta == 174 ? "Large " : "Huge "));
                    Materials aMainMaterial = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aI);
                    Materials aSecondaryMaterial = GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)aI);
                    long rotorDurabilityMax = GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)aI);
                    if (rotorDurabilityMax >= (long)aCutoff) continue block0;
                    Logger.WARNING("[Turbine Cleanup] " + MaterialUtils.getMaterialName(aMainMaterial) + " " + aType + "Turbines have " + rotorDurabilityMax + ", which is below the cutoff durability of " + aCutoff + ", disabling.");
                    aG.mEnabled = false;
                    aG.mHidden = true;
                    aG.mCanBeBuffered = false;
                    ++aRemoved;
                }
            }
        }
        Logger.INFO("Removed " + aRemoved + " useless Turbines.");
        return aRemoved;
    }
}

