/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry;

import binnie.extratrees.genetics.ExtraTreeSpecies;
import cpw.mods.fml.common.Optional;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.arboriculture.genetics.TreeDefinition;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.forestry.bees.items.FR_ItemRegistry;
import gtPlusPlus.xmod.forestry.bees.recipe.FR_Gregtech_Recipes;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_Bees;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMetaTileEntityTreeFarm;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HANDLER_FR {
    public static void preInit() {
        if (LoadedMods.Forestry) {
            FR_ItemRegistry.Register();
        }
    }

    public static void Init() {
        if (LoadedMods.Forestry) {
            // empty if block
        }
    }

    public static void postInit() {
        if (LoadedMods.Forestry) {
            FR_Gregtech_Recipes.registerItems();
            new GTPP_Bees();
            HANDLER_FR.mapForestrySaplingToLog();
        }
        if (LoadedMods.ExtraTrees) {
            HANDLER_FR.mapExtraTreesSaplingToLog();
        }
    }

    public static boolean createBlockBreakParticles(World world, int x, int y, int z, Block block) {
        if (LoadedMods.Forestry) {
            HANDLER_FR.createBlockBreakParticles_INTERNAL(world, x, y, z, block);
        }
        return false;
    }

    @Optional.Method(modid="Forestry")
    private static void createBlockBreakParticles_INTERNAL(World world, int x, int y, int z, Block block) {
        if (LoadedMods.Forestry) {
            try {
                Class<?> oClass = ReflectionUtils.getClass("forestry.core.proxy.ProxyCommon");
                Field oProxy = ReflectionUtils.getField(oClass, "common");
                if (oProxy != null && oClass.isInstance(oProxy)) {
                    Method mParticles = ReflectionUtils.getMethod(oClass, "addBlockDestroyEffects", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Block.class, Integer.TYPE);
                    mParticles.invoke((Object)oProxy, world, x, y, z, block, 0);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    @Optional.Method(modid="Forestry")
    private static void mapForestrySaplingToLog() {
        for (TreeDefinition value : TreeDefinition.values()) {
            ItemStack aLog;
            ItemStack aSaplingStack = value.getMemberStack(EnumGermlingType.SAPLING);
            EnumWoodType woodType = (EnumWoodType)ReflectionUtils.getField(value, "woodType");
            if (woodType != null) {
                aLog = TreeManager.woodItemAccess.getLog(woodType, false);
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID(), aLog);
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID() + "fireproof", TreeManager.woodItemAccess.getLog(woodType, true));
            } else {
                aLog = (ItemStack)ReflectionUtils.getField(value, "vanillaWood");
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID(), (ItemStack)ReflectionUtils.getField(value, "vanillaWood"));
            }
            GregtechMetaTileEntityTreeFarm.addFakeRecipeToNEI(aSaplingStack, aLog);
        }
    }

    @Optional.Method(modid="ExtraTrees")
    private static void mapExtraTreesSaplingToLog() {
        for (ExtraTreeSpecies value : ExtraTreeSpecies.values()) {
            ItemStack aSaplingStack = TreeManager.treeRoot.getMemberStack((IIndividual)TreeManager.treeRoot.templateAsIndividual(value.getTemplate()), 0);
            ItemStack aLog = null;
            if (value.getLog() != null) {
                aLog = value.getLog().getItemStack();
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID(), aLog);
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID() + "fireproof", aLog);
            }
            GregtechMetaTileEntityTreeFarm.addFakeRecipeToNEI(aSaplingStack, aLog);
        }
    }
}

