/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.player;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class PlayerCache {
    private static final File cache = new File("PlayerCache.dat");

    public static final void initCache() {
        if (CORE.PlayerCache == null) {
            try {
                if (cache != null) {
                    CORE.PlayerCache = PlayerCache.readPropertiesFileAsMap();
                    Logger.INFO("Loaded PlayerCache.dat");
                }
            }
            catch (Exception e) {
                Logger.INFO("Failed to initialise PlayerCache.dat");
                PlayerCache.createPropertiesFile("PLAYER_", "DATA");
            }
        }
    }

    public static void createPropertiesFile(String playerName, String playerUUIDasString) {
        try {
            Properties props = new Properties();
            props.setProperty(playerName + " ", playerUUIDasString);
            FileOutputStream out = new FileOutputStream(cache);
            props.store(out, "Player Cache.");
            Logger.INFO("PlayerCache.dat created for future use.");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void appendParamChanges(String playerName, String playerUUIDasString) {
        HashMap<String, UUID> playerInfo = new HashMap<String, UUID>();
        playerInfo.put(playerName, UUID.fromString(playerUUIDasString));
        try {
            FileOutputStream fos = new FileOutputStream("PlayerCache.dat");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(playerInfo);
            oos.close();
            fos.close();
            Logger.INFO("Serialized Player data saved in PlayerCache.dat");
        }
        catch (IOException e) {
            Logger.INFO("No PlayerCache file found, creating one.");
            PlayerCache.createPropertiesFile(playerName, playerUUIDasString);
        }
    }

    @Deprecated
    public static Map<String, String> readPropertiesFileAsMapOld() throws Exception {
        String line;
        String delimiter = "=";
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(cache));
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
            int delimPosition = line.indexOf("=");
            String key = line.substring(0, delimPosition - 1).trim();
            String value = line.substring(delimPosition + 1).trim();
            map.put(key, value);
        }
        reader.close();
        CORE.PlayerCache = map;
        return map;
    }

    public static HashMap<String, UUID> readPropertiesFileAsMap() {
        HashMap map = null;
        try {
            FileInputStream fis = new FileInputStream(cache);
            ObjectInputStream ois = new ObjectInputStream(fis);
            map = (HashMap)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException c) {
            Logger.INFO("Class not found");
            c.printStackTrace();
            return null;
        }
        Logger.WARNING("Deserialized PlayerCache..");
        return map;
    }

    public static String lookupPlayerByUUID(UUID UUID2) {
        if (UUID2 == null) {
            return null;
        }
        List allPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP player : allPlayers) {
            if (!player.func_110124_au().equals(UUID2)) continue;
            return player.getDisplayName();
        }
        return "Offline Player.";
    }
}

