/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general.capture;

import cpw.mods.fml.common.registry.GameRegistry;
import gtPlusPlus.api.interfaces.IEntityCatcher;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEntityCatcher
extends Item
implements IEntityCatcher {
    public ItemEntityCatcher() {
        this.func_77655_b("itemDragonJar");
        this.func_111206_d("miscutils:" + this.func_77658_a());
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77625_d(16);
        this.func_77656_e(0);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @Override
    public boolean hasEntity(ItemStack aStack) {
        if (NBTUtils.hasKey(aStack, "mHasEntity")) {
            return NBTUtils.getBoolean(aStack, "mHasEntity");
        }
        return false;
    }

    @Override
    public Entity getStoredEntity(World aWorld, ItemStack aStack) {
        if (aStack == null || !this.hasEntity(aStack)) {
            Logger.INFO("Cannot get stored entity.");
            return null;
        }
        Logger.WARNING("getStoredEntity(1)");
        int mEntityID = NBTUtils.getInteger(aStack, "mEntityID");
        Entity mEntityToSpawn = EntityList.func_75616_a((int)mEntityID, (World)aWorld);
        if (mEntityToSpawn != null) {
            Logger.WARNING("getStoredEntity(2)");
            return mEntityToSpawn;
        }
        Logger.INFO("Failed to get stored entity. - getStoredEntity()");
        return null;
    }

    @Override
    public boolean setStoredEntity(World aWorld, ItemStack aStack, Entity aEntity) {
        if (aEntity == null) {
            NBTUtils.setBoolean(aStack, "mHasEntity", false);
            Logger.INFO("Bad Entity being stored.");
            return false;
        }
        Logger.WARNING("setStoredEntity(1)");
        Logger.WARNING("setStoredEntity(2)");
        NBTTagCompound mEntityData = aEntity.getEntityData();
        Class<?> mEntityClass = aEntity.getClass();
        String mClassName = mEntityClass.getName();
        String mEntityName = aEntity.func_70005_c_();
        int mEntityID = EntityList.func_75619_a((Entity)aEntity);
        int mEntityHashcode = aEntity.hashCode();
        UUID mUuidPersistent = aEntity.getPersistentID();
        UUID mUuidUnique = aEntity.func_110124_au();
        Logger.WARNING("setStoredEntity(3)");
        NBTUtils.createTagCompound(aStack, "mEntityData", mEntityData);
        NBTUtils.setString(aStack, "mEntityName", mEntityName);
        NBTUtils.setInteger(aStack, "mEntityID", mEntityID);
        NBTUtils.setString(aStack, "mClassName", mClassName);
        NBTUtils.setString(aStack, "mUuidPersistent", mUuidPersistent.toString());
        NBTUtils.setString(aStack, "mUuidUnique", mUuidUnique.toString());
        NBTUtils.setInteger(aStack, "mEntityHashcode", mEntityHashcode);
        NBTUtils.setBoolean(aStack, "mHasEntity", true);
        Logger.WARNING("setStoredEntity(4)");
        return true;
    }

    @Override
    public Class<? extends Entity> getStoredEntityClass(ItemStack aStack) {
        if (aStack == null || !this.hasEntity(aStack)) {
            return null;
        }
        String mClassName = NBTUtils.getString(aStack, "mClassName");
        Class<?> mEntityClass = ReflectionUtils.getClass(mClassName);
        if (mEntityClass != null) {
            return mEntityClass;
        }
        return null;
    }

    @Override
    public boolean spawnStoredEntity(World aWorld, ItemStack aStack, BlockPos aPos) {
        if (aStack == null || !this.hasEntity(aStack)) {
            Logger.INFO("Cannot release, either invalid Itemstack or no entity stored.");
            return false;
        }
        NBTTagCompound mEntityData = NBTUtils.getTagCompound(aStack, "mEntityData");
        int mEntityID = NBTUtils.getInteger(aStack, "mEntityID");
        String mClassName = NBTUtils.getString(aStack, "mClassName");
        UUID mUuidPersistent = UUID.fromString(NBTUtils.getString(aStack, "mUuidPersistent"));
        UUID mUuidUnique = UUID.fromString(NBTUtils.getString(aStack, "mUuidUnique"));
        int mEntityHashcode = NBTUtils.getInteger(aStack, "mEntityHashcode");
        EntityLiving mEntityToSpawn = (EntityLiving)this.getStoredEntity(aWorld, aStack);
        Class<? extends Entity> mEntityClass = this.getStoredEntityClass(aStack);
        Logger.WARNING("spawnStoredEntity(1)");
        if (mEntityToSpawn != null && mEntityClass != null) {
            Logger.WARNING("spawnStoredEntity(2)");
            if (mEntityToSpawn.getEntityData() != mEntityData) {
                Logger.WARNING("spawnStoredEntity(x)");
                NBTUtils.setEntityCustomData((Entity)mEntityToSpawn, mEntityData);
            }
            mEntityToSpawn.func_70012_b((double)aPos.xPos, (double)aPos.yPos, (double)aPos.zPos, aWorld.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (mEntityToSpawn != null) {
                mEntityToSpawn.func_110161_a(null);
                aWorld.func_72838_d((Entity)mEntityToSpawn);
                Logger.WARNING("spawnStoredEntity(3)");
            }
            if (mEntityToSpawn != null) {
                mEntityToSpawn.func_70642_aH();
                Logger.WARNING("spawnStoredEntity(4)");
            }
            Logger.WARNING("spawnStoredEntity(5)");
            NBTUtils.setBoolean(aStack, "mHasEntity", false);
            return true;
        }
        Logger.INFO("Failed to spawn stored entity. - spawnStoredEntity()");
        return false;
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return super.func_77659_a(aStack, aWorld, aPlayer);
    }

    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        if (this.hasEntity(p_77624_1_)) {
            String mName = NBTUtils.getString(p_77624_1_, "mEntityName");
            if (mName != null && !mName.equals("")) {
                p_77624_3_.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"item.itemDragonJar.1.tooltip", (Object[])new Object[]{mName}));
            }
        } else {
            p_77624_3_.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"item.itemDragonJar.0.tooltip"));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (Utils.isServer()) {
            Logger.WARNING("Trying to release (1)");
            if (NBTUtils.hasKey(itemstack, "mHasEntity") && NBTUtils.getBoolean(itemstack, "mHasEntity")) {
                Logger.WARNING("Trying to release (2)");
                boolean mDidSpawn = this.spawnStoredEntity(world, itemstack, new BlockPos(x, y + 1, z, world));
                if (!mDidSpawn) {
                    PlayerUtils.messagePlayer(player, "You failed to release a " + NBTUtils.getString(itemstack, "mEntityName") + ".");
                }
                return mDidSpawn;
            }
        }
        return super.func_77648_a(itemstack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public boolean func_111207_a(ItemStack aStack, EntityPlayer aPlayer, EntityLivingBase aEntity) {
        if (Utils.isServer()) {
            Logger.WARNING("Trying to catch (1)");
            if (!this.hasEntity(aStack)) {
                Logger.WARNING("Trying to catch (2)");
                boolean mStored = this.setStoredEntity(aPlayer.field_70170_p, aStack, (Entity)aEntity);
                if (mStored) {
                    Logger.WARNING("Trying to catch (3)");
                    aEntity.func_70106_y();
                    PlayerUtils.messagePlayer(aPlayer, "You have captured a " + NBTUtils.getString(aStack, "mEntityName") + " in the Jar.");
                }
            }
        }
        return super.func_111207_a(aStack, aPlayer, aEntity);
    }

    public String func_77653_i(ItemStack aStack) {
        if (this.hasEntity(aStack)) {
            return StatCollector.func_74838_a((String)"item.itemDragonJar.1.name");
        }
        return StatCollector.func_74838_a((String)"item.itemDragonJar.0.name");
    }
}

