/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import gregtech.api.enums.ItemList;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.entity.item.ItemEntityGiantEgg;
import gtPlusPlus.core.item.base.BaseItemTickable;
import gtPlusPlus.core.item.general.spawn.ItemCustomSpawnEgg;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemGiantEgg
extends BaseItemTickable {
    private static ItemStack turnsIntoItem;
    private static ItemStack mCorrectEgg;
    private static ItemStack mCorrectStemCells;

    public void registerFuel(int burn) {
        CORE.burnables.add(new Pair<Integer, ItemStack>(burn, ItemUtils.getSimpleStack(this, 1)));
    }

    public final void registerOrdictionary(String name) {
        ItemUtils.addItemToOreDictionary(ItemUtils.getSimpleStack(this), name);
    }

    public ItemGiantEgg() {
        this(Utils.rgbtoHexValue(255, 255, 255), 4161409, new String[]{"I had best try disassemble this.. for science!"});
    }

    private ItemGiantEgg(int colour, int maxTicks, String[] desc1) {
        super(true, false, "itemBigEgg", colour, maxTicks, desc1);
        this.func_111206_d("miscutils:itemBigEgg");
        this.func_77625_d(1);
        this.registerFuel(5000);
        this.registerOrdictionary("fuelLargeChickenEgg");
    }

    public static void postInit(ItemGiantEgg aGiantEggItem) {
        turnsIntoItem = ItemGiantEgg.getSpawnEggStack();
    }

    private static ItemStack getSpawnEggStack() {
        ItemStack aTempEgg;
        if (mCorrectEgg == null && (aTempEgg = ItemCustomSpawnEgg.getSpawnEggForEntityname("bigChickenFriendly", 1)) != null) {
            mCorrectEgg = aTempEgg;
        }
        return mCorrectEgg;
    }

    private static ItemStack getStemCellStack() {
        if (mCorrectStemCells == null) {
            mCorrectStemCells = ItemList.Circuit_Chip_Stemcell.get(1L, new Object[0]);
        }
        return mCorrectStemCells;
    }

    @Override
    protected int getMaxTicks(ItemStack aStack) {
        if (aStack != null && aStack.func_77942_o() && aStack.func_77978_p().func_74764_b("mEggAge")) {
            return NBTUtils.getInteger(aStack, "mEggAge");
        }
        return this.maxTicks;
    }

    @Override
    public void func_94581_a(IIconRegister i) {
        this.mIcon[0] = i.func_94245_a("miscutils:itemBigEgg");
    }

    @Override
    protected boolean createNBT(World world, ItemStack aStack) {
        if (aStack.func_77978_p() != null && aStack.func_77978_p().func_74764_b("size")) {
            return false;
        }
        Logger.INFO("Egg: " + ReflectionUtils.getMethodName(1));
        Logger.INFO("Egg: " + ReflectionUtils.getMethodName(2));
        Logger.INFO("Egg: " + ReflectionUtils.getMethodName(3));
        Logger.INFO("Egg: " + ReflectionUtils.getMethodName(4));
        Logger.INFO("Egg: " + ReflectionUtils.getMethodName(5));
        Logger.INFO("Egg: " + ReflectionUtils.getMethodName(6));
        boolean aSuper = super.createNBT(world, aStack);
        int size = MathUtils.randInt(1, 8);
        NBTUtils.setInteger(aStack, "size", size);
        NBTUtils.setInteger(aStack, "mEggAge", MathUtils.randInt(8000, 16000) * size);
        ItemStack aStemCells = ItemGiantEgg.getStemCellStack();
        if (aStemCells != null) {
            int mSize = NBTUtils.getInteger(aStack, "size");
            float mSizeMod = MathUtils.randInt(-5, 5) / 5;
            mSize = (int)((float)mSize + mSizeMod);
            mSize = Math.max(mSize, 1);
            ItemStack[] eggYolks = new ItemStack[mSize];
            for (int u = 0; u < mSize; ++u) {
                eggYolks[u] = ItemUtils.getSimpleStack(aStemCells, MathUtils.randInt(1, 4));
            }
            int mexpected = 0;
            for (ItemStack e : eggYolks) {
                if (e == null) continue;
                mexpected += e.field_77994_a;
            }
            if (mexpected > 0) {
                NBTUtils.setInteger(aStack, "mExpected", mexpected);
                NBTUtils.writeItemsToGtCraftingComponents(aStack, new ItemStack[]{ItemUtils.getSimpleStack(aStemCells, mexpected)}, true);
            }
        }
        return aSuper;
    }

    @Override
    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        boolean a1;
        boolean a2;
        if (world == null || iStack == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (iStack.func_77978_p() == null || !iStack.func_77978_p().func_74764_b("size")) {
            this.createNBT(world, iStack);
            Logger.INFO("Egg has no NBT, creating (onUpdate)");
        }
        boolean bl = a2 = (a1 = this.isTicking(world, iStack)) ? this.tickItemTag(world, iStack) : false;
        if (!a1 && !a2 && entityHolding instanceof EntityPlayer && MathUtils.randInt(0, 1000) >= 990 && NBTUtils.hasKey(iStack, "size") && NBTUtils.getInteger(iStack, "size") + 1 >= MathUtils.randInt(0, 9)) {
            ItemStack replacement = ItemUtils.getSimpleStack(this.getHatchResult(), 1);
            if (replacement == null) {
                // empty if block
            }
            ItemStack tempTransform = replacement.func_77946_l();
            if (iStack.field_77994_a > 1) {
                int u;
                tempTransform.field_77994_a = u = iStack.field_77994_a;
                ((EntityPlayer)entityHolding).field_71071_by.func_70441_a(tempTransform);
                for (int l = 0; l < u; ++l) {
                    ((EntityPlayer)entityHolding).field_71071_by.func_146026_a((Item)this);
                }
            } else {
                tempTransform.field_77994_a = 1;
                ((EntityPlayer)entityHolding).field_71071_by.func_70441_a(tempTransform);
                ((EntityPlayer)entityHolding).field_71071_by.func_146026_a((Item)this);
            }
        }
    }

    public ItemStack getHatchResult() {
        return turnsIntoItem;
    }

    public String func_77653_i(ItemStack aStack) {
        String localName = super.func_77653_i(aStack);
        int size = 1;
        if (NBTUtils.hasKey(aStack, "size")) {
            size = NBTUtils.getInteger(aStack, "size");
            return "" + size + " " + localName;
        }
        return "?? " + localName;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (location instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)location;
            if (itemstack == null) {
                return null;
            }
            if (itemstack.field_77994_a == 0) {
                return null;
            }
            ItemEntityGiantEgg entityitem = new ItemEntityGiantEgg(world, player.field_70165_t, player.field_70163_u - (double)0.3f + (double)player.func_70047_e(), player.field_70161_v, itemstack);
            entityitem.field_145804_b = 40;
            entityitem.func_145799_b(player.func_70005_c_());
            float f = 0.1f;
            f = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f1 = CORE.RANDOM.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w += Math.cos(f1) * (double)(f *= CORE.RANDOM.nextFloat());
            entityitem.field_70181_x += (double)((CORE.RANDOM.nextFloat() - CORE.RANDOM.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f1) * (double)f;
            return entityitem;
        }
        return null;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        int size = 0;
        long age = 0L;
        long life = 0L;
        int expected = 0;
        if (this.descriptionString.length > 0) {
            list.add(EnumChatFormatting.GRAY + this.descriptionString[0]);
        }
        if (NBTUtils.hasKey(stack, "size")) {
            NBTTagCompound aNBT;
            size = NBTUtils.getInteger(stack, "size");
            if (size > 0 && NBTUtils.hasKey(stack, "TickableItem") && (aNBT = stack.func_77978_p()) != null && (aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                age = aNBT.func_74763_f("Tick");
            }
            if (NBTUtils.hasKey(stack, "mEggAge")) {
                life = NBTUtils.getInteger(stack, "mEggAge");
            }
            if (NBTUtils.hasKey(stack, "mExpected")) {
                expected = NBTUtils.getInteger(stack, "mExpected");
            }
        }
        String aSize = size > 0 ? "" + size : "??";
        String aExpected = expected > 0 ? "" + expected : "??";
        String aAge = age > 0L ? "" + age / 20L : "??";
        String aLife = life > 0L ? "" + life / 20L : "??";
        list.add("Egg Size: " + aSize + " ounces");
        list.add("Expected Stem Cells: " + aExpected);
        list.add("Age: " + aAge + "s / " + aLife + "s");
        list.add("Larger eggs take longer to hatch,");
        list.add("but have a better chance of hatching.");
    }
}

