/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.AddGregtechRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CoalTar
extends ItemPackage {
    public static Fluid Coal_Gas;
    public static Fluid Coal_Oil;
    public static Fluid Ethylene;
    public static Fluid Ethylbenzene;
    public static Fluid Anthracene;
    public static Fluid Toluene;
    public static Fluid Coal_Tar;
    public static Fluid Coal_Tar_Oil;
    public static Fluid Sulfuric_Coal_Tar_Oil;
    public static Fluid Naphthalene;
    public static Fluid Phthalic_Acid;

    private static void recipeEthylBenzineFuelsIntoHeavyFuel() {
        CORE.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellFuel", 9), ItemUtils.getItemStackOfAmountFromOreDict("cellEthylbenzene", 2), null, FluidUtils.getFluidStack("nitrofuel", 7500), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 11), 100, 1000);
        CORE.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellBioDiesel", 9), ItemUtils.getItemStackOfAmountFromOreDict("cellEthylbenzene", 2), null, FluidUtils.getFluidStack("nitrofuel", 3000), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 11), 300, 1000);
    }

    public static void recipeCreateEthylene() {
        FluidStack bioEth1 = FluidUtils.getFluidStack("fluid.bioethanol", 1000);
        FluidStack bioEth2 = FluidUtils.getFluidStack("bioethanol", 1000);
        if (bioEth1 != null) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 1)}, bioEth1, FluidUtils.getWater(1000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 1)}, new int[]{10000}, 2400, 80);
        }
        if (bioEth2 != null) {
            CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(18), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 1)}, bioEth2, FluidUtils.getWater(1000), new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 1)}, new int[]{10000}, 2400, 80);
        }
    }

    public static void recipeCreateBenzene() {
        CORE.RA.addDehydratorRecipe(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellToluene", 1), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 2)}, null, null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellMethane", 1), ItemUtils.getItemStackOfAmountFromOreDict("cellBenzene", 1), Materials.Empty.getCells(1)}, new int[]{10000, 10000, 10000}, 200, 90);
    }

    public static void recipeCreateEthylbenzene() {
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 2), ItemUtils.getItemStackOfAmountFromOreDict("cellBenzene", 2), null, FluidUtils.getFluidStack("fluid.ethylbenzene", 2000), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 4), 300);
    }

    public static void recipeCoalToCoalTar() {
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Charcoal, (long)32L), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDirt", 2), FluidUtils.getFluidStack("fluid.coaltar", 800), 15, 120);
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Lignite, (long)16L), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDarkAsh", 2), FluidUtils.getFluidStack("fluid.coaltar", 800), 45, 60);
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Coal, (long)12L), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDarkAsh", 2), FluidUtils.getFluidStack("fluid.coaltar", 2200), 30, 120);
        AddGregtechRecipe.addCokeAndPyrolyseRecipes(ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 8), 8, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustSmallAsh", 3), FluidUtils.getFluidStack("fluid.coaltar", 3400), 15, 240);
    }

    private static void recipeCoalTarToCoalTarOil() {
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(1), FluidUtils.getFluidStack("fluid.coaltar", 1000), FluidUtils.getFluidStack("fluid.coaltaroil", 600), 600, 64, false);
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(2), FluidUtils.getFluidStack("fluid.coaltar", 1000), FluidUtils.getFluidStack("liquid_naphtha", 150), 300, 30, false);
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(3), FluidUtils.getFluidStack("fluid.coaltar", 1000), FluidUtils.getFluidStack("fluid.ethylbenzene", 200), 450, 86, false);
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(4), FluidUtils.getFluidStack("fluid.coaltar", 1000), FluidUtils.getFluidStack("fluid.anthracene", 50), 900, 30, false);
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(5), FluidUtils.getFluidStack("fluid.coaltar", 1500), FluidUtils.getFluidStack("fluid.kerosene", 600), 300, 64, false);
        GT_Values.RA.addDistillationTowerRecipe(FluidUtils.getFluidStack("fluid.coaltar", 1200), new FluidStack[]{FluidUtils.getFluidStack("fluid.coaltaroil", 500), FluidUtils.getFluidStack("liquid_naphtha", 100), FluidUtils.getFluidStack("fluid.ethylbenzene", 150), FluidUtils.getFluidStack("fluid.anthracene", 50), FluidUtils.getFluidStack("fluid.kerosene", 400)}, null, 900, 60);
    }

    private static void recipeCoalTarOilToSulfuricOilToNaphthalene() {
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 8), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricAcid", 8), null, null, ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 16), 320);
        GT_Values.RA.addDistilleryRecipe(CI.getNumberedCircuit(6), FluidUtils.getFluidStack("fluid.sulfuriccoaltaroil", 1000), FluidUtils.getFluidStack("fluid.naphthalene", 1000), 1200, 30, false);
    }

    private static void recipeNaphthaleneToPhthalicAcid() {
        GT_Values.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict("cellNaphthalene", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium", 5), null, FluidUtils.getFluidStack("fluid.phthalicacid", 2500), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 2), 320);
    }

    private static void recipePhthalicAcidToPhthalicAnhydride() {
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(15)}, FluidUtils.getFluidStack("fluid.phthalicacid", 1000), null, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustPhthalicAnhydride", 15)}, new int[]{10000}, 1200, 120);
    }

    @Override
    public String errorMessage() {
        return "Bad Coal Science!";
    }

    @Override
    public boolean generateRecipes() {
        CoalTar.recipeCreateEthylene();
        CoalTar.recipeCreateBenzene();
        CoalTar.recipeCreateEthylbenzene();
        CoalTar.recipeCoalToCoalTar();
        CoalTar.recipeCoalTarToCoalTarOil();
        CoalTar.recipeCoalTarOilToSulfuricOilToNaphthalene();
        CoalTar.recipeNaphthaleneToPhthalicAcid();
        CoalTar.recipePhthalicAcidToPhthalicAnhydride();
        CoalTar.recipeEthylBenzineFuelsIntoHeavyFuel();
        this.recipePhthalicAcidConversion();
        GT_Values.RA.addFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalGas", 1), null, 96, 1);
        CORE.RA.addSemifluidFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 1), 64);
        CORE.RA.addSemifluidFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 1), 32);
        CORE.RA.addSemifluidFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTar", 1), 16);
        return true;
    }

    private void recipePhthalicAcidConversion() {
        FluidStack aMyAcid = FluidUtils.getFluidStack(Phthalic_Acid, 500);
        FluidStack aGtAcid = FluidUtils.getFluidStack("phtalicacid", 500);
        if (aMyAcid != null && aGtAcid != null) {
            CORE.RA.addDistilleryRecipe(CI.getNumberedBioCircuit(8), aMyAcid, aGtAcid, null, 50, 16, false);
            CORE.RA.addDistilleryRecipe(CI.getNumberedBioCircuit(9), aGtAcid, aMyAcid, null, 50, 16, false);
        }
    }

    @Override
    public void items() {
        ItemUtils.generateSpecialUseDusts("PhthalicAnhydride", "Phthalic Anhydride", "C6H4(CO)2O", Utils.rgbtoHexValue(175, 175, 175));
        ItemUtils.generateSpecialUseDusts("LithiumHydroperoxide", "Lithium Hydroperoxide", "HLiO2", Utils.rgbtoHexValue(125, 125, 125));
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        Coal_Gas = FluidUtils.generateFluidNonMolten("CoalGas", "Coal Gas", 500, new short[]{48, 48, 48, 100}, null, null);
        Ethylene = !FluidUtils.doesFluidExist("ethylene") ? FluidUtils.generateFluidNonMolten("ethylene", "Ethylene", -103, new short[]{255, 255, 255, 100}, null, null) : FluidUtils.getWildcardFluidStack("ethylene", 1).getFluid();
        Ethylbenzene = FluidUtils.generateFluidNonMolten("Ethylbenzene", "Ethylbenzene", 136, new short[]{255, 255, 255, 100}, null, null);
        Anthracene = FluidUtils.generateFluidNonMolten("Anthracene", "Anthracene", 340, new short[]{255, 255, 255, 100}, null, null);
        Toluene = !FluidUtils.doesFluidExist("liquid_toluene") ? FluidUtils.generateFluidNonMolten("liquid_toluene", "Toluene", -95, new short[]{140, 70, 20, 100}, null, null) : FluidUtils.getWildcardFluidStack("liquid_toluene", 1).getFluid();
        Coal_Tar = FluidUtils.generateFluidNonMolten("CoalTar", "Coal Tar", 450, new short[]{32, 32, 32, 100}, null, null);
        Coal_Tar_Oil = FluidUtils.generateFluidNonMolten("CoalTarOil", "Coal Tar Oil", 240, new short[]{240, 240, 150, 100}, null, null);
        Sulfuric_Coal_Tar_Oil = FluidUtils.generateFluidNonMolten("SulfuricCoalTarOil", "Sulfuric Coal Tar Oil", 240, new short[]{250, 170, 12, 100}, null, null);
        Naphthalene = FluidUtils.generateFluidNonMolten("Naphthalene", "Naphthalene", 115, new short[]{210, 185, 135, 100}, null, null);
        Phthalic_Acid = FluidUtils.generateFluidNonMolten("PhthalicAcid", "Phthalic Acid", 207, new short[]{210, 220, 210, 100}, null, null);
    }
}

