/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.bauble.ElectricBaseBauble;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.common.helpers.ChargingHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BatteryPackBaseBauble
extends ElectricBaseBauble {
    public BatteryPackBaseBauble(int tier) {
        super(BaubleType.BELT, tier, GT_Values.V[tier] * 20L * 300L, "GTPP.BattPack.0" + tier + ".name");
        String aUnlocalName = "GTPP.BattPack.0" + tier + ".name";
        this.func_77637_a(AddToCreativeTab.tabMachines);
        if (GameRegistry.findItem((String)"miscutils", (String)aUnlocalName) == null) {
            GameRegistry.registerItem((Item)this, (String)aUnlocalName);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack charged;
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getEmptyItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 0.0, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getChargedItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        double aItemCharge = ElectricItem.manager.getCharge(itemStack);
        return aItemCharge > 0.0;
    }

    @Override
    public String func_77653_i(ItemStack p_77653_1_) {
        return EnumChatFormatting.BLUE + super.func_77653_i(p_77653_1_) + EnumChatFormatting.GRAY;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int secondsLeft(ItemStack stack) {
        double r = 0.0;
        r = this.getCharge(stack) / 200000.0;
        return (int)MathUtils.decimalRounding(r);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add("");
        String aString1 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.1");
        String aString2 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.2");
        String aString3 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.3");
        String aString4 = StatCollector.func_74838_a((String)"GTPP.battpack.tooltip.4");
        String aEU = StatCollector.func_74838_a((String)"GTPP.info.eu");
        String aEUT = aEU + "/t";
        list.add(EnumChatFormatting.GREEN + aString1 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString2 + " " + (int)this.getTransferLimit(stack) + aEUT + " " + aString3 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString4 + EnumChatFormatting.GRAY);
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    @Override
    public String getToolTip(ItemStack stack) {
        return ElectricItem.manager.getToolTip(stack);
    }

    @Override
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Override
    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Override
    public void onWornTick(ItemStack aBaubleStack, EntityLivingBase aPlayer) {
        block15: {
            if (!aPlayer.field_70170_p.field_72995_K) {
                try {
                    if (!(this.getCharge(aBaubleStack) >= this.getTransferLimit(aBaubleStack)) || !(aPlayer instanceof EntityPlayer)) break block15;
                    for (ItemStack aInvStack : ((EntityPlayer)aPlayer).field_71071_by.field_70460_b) {
                        if (aInvStack != null) {
                            if (aInvStack == aBaubleStack) continue;
                            if (ChargingHelper.isItemValid(aInvStack)) {
                                double aTransferRate = 0.0;
                                IElectricItem electricItem = (IElectricItem)aInvStack.func_77973_b();
                                if (electricItem != null) {
                                    double d;
                                    aTransferRate = electricItem.getTransferLimit(aInvStack);
                                    double aItemCharge = ElectricItem.manager.getCharge(aInvStack);
                                    if (aItemCharge >= 0.0 && aItemCharge != electricItem.getMaxCharge(aInvStack) && aItemCharge <= electricItem.getMaxCharge(aInvStack) - aTransferRate && ElectricItem.manager.getCharge(aBaubleStack) >= aTransferRate && ElectricItem.manager.getCharge(aInvStack) <= electricItem.getMaxCharge(aInvStack) - aTransferRate && (d = ElectricItem.manager.charge(aInvStack, aTransferRate * 16.0, this.mTier, false, true)) > 0.0) {
                                        d = ElectricItem.manager.charge(aInvStack, aTransferRate * 16.0, this.mTier, false, false);
                                        ElectricItem.manager.discharge(aBaubleStack, d, this.mTier, false, true, false);
                                    }
                                }
                            }
                        }
                        if (!(this.getCharge(aBaubleStack) > 0.0)) break;
                    }
                    int aSlotCounter = 0;
                    for (ItemStack aInvStack : ((EntityPlayer)aPlayer).field_71071_by.field_70462_a) {
                        if (aSlotCounter <= InventoryPlayer.func_70451_h() - 1) {
                            ++aSlotCounter;
                            if (aInvStack != null) {
                                if (aInvStack == aBaubleStack) continue;
                                if (ChargingHelper.isItemValid(aInvStack)) {
                                    double aTransferRate = 0.0;
                                    IElectricItem electricItem = (IElectricItem)aInvStack.func_77973_b();
                                    if (electricItem != null) {
                                        double d;
                                        aTransferRate = electricItem.getTransferLimit(aInvStack);
                                        double aItemCharge = ElectricItem.manager.getCharge(aInvStack);
                                        if (aItemCharge >= 0.0 && aItemCharge != electricItem.getMaxCharge(aInvStack) && aItemCharge <= electricItem.getMaxCharge(aInvStack) - aTransferRate && ElectricItem.manager.getCharge(aBaubleStack) >= aTransferRate && ElectricItem.manager.getCharge(aInvStack) <= electricItem.getMaxCharge(aInvStack) - aTransferRate && (d = ElectricItem.manager.charge(aInvStack, aTransferRate, this.mTier, false, true)) > 0.0) {
                                            d = ElectricItem.manager.charge(aInvStack, aTransferRate, this.mTier, false, false);
                                            ElectricItem.manager.discharge(aBaubleStack, d, this.mTier, false, true, false);
                                        }
                                    }
                                }
                            }
                            if (this.getCharge(aBaubleStack) > 0.0) {
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getTextureNameForBauble() {
        return "chargepack/" + this.mTier;
    }
}

