/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base;

import gregtech.api.enums.Materials;
import gtPlusPlus.api.enums.Quality;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BaseItemLoot
extends Item {
    private final String materialName;
    private final String unlocalName;
    private final LootTypes lootTypes;
    private Quality lootQuality;
    private final Materials lootMaterial;

    public BaseItemLoot(LootTypes lootType, Materials material) {
        this.lootTypes = lootType;
        this.lootMaterial = material;
        this.materialName = material.mDefaultLocalName;
        this.unlocalName = "item" + lootType.LOOT_TYPE + this.materialName;
        this.func_77655_b(this.unlocalName);
        this.func_77625_d(1);
        this.func_111206_d("miscutils:item" + lootType.LOOT_TYPE);
    }

    public ItemStack generateLootStack() {
        this.lootQuality = Quality.getRandomQuality();
        return ItemUtils.getSimpleStack(this, 1);
    }

    public String func_77653_i(ItemStack p_77653_1_) {
        return this.materialName + this.lootTypes.DISPLAY_SUFFIX;
    }

    public final String getMaterialName() {
        return this.materialName;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add(this.lootQuality.getQuality());
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        short[] temp = this.lootMaterial.mRGBa;
        return Utils.rgbtoHexValue(temp[0], temp[1], temp[2]);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
    }

    public static enum LootTypes {
        Sword("Sword", " Longsword", "sword"),
        Shortsword("Sword", " Short Blade", "blade"),
        Helmet("Helmet", " Medium Helm", "helmet"),
        Chestplate("Platebody", " Chestplate", "platebody"),
        Leggings("Platelegs", " Platelegs", "platelegs"),
        Boots("Boots", " Boots", "boots");

        private String LOOT_TYPE;
        private String DISPLAY_SUFFIX;
        private String OREDICT_NAME;

        private LootTypes(String LocalName, String DisplayName, String OreDictName) {
            this.LOOT_TYPE = LocalName;
            this.DISPLAY_SUFFIX = DisplayName;
            this.OREDICT_NAME = OreDictName;
        }

        public String getLootType() {
            return this.LOOT_TYPE;
        }

        public String getName() {
            return this.DISPLAY_SUFFIX;
        }

        public String getOreDictName() {
            return this.OREDICT_NAME;
        }
    }
}

