/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.creative.AddToCreativeTab;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class BaseEuItem
extends Item
implements ISpecialElectricItem,
IElectricItemManager {
    private final HashMap<Short, ArrayList<IItemBehaviour<BaseEuItem>>> mItemBehaviors = new HashMap();
    public final short mOffset;
    public final short mItemAmount;
    public final BitSet mEnabledItems;
    public final BitSet mVisibleItems;
    public final IIcon[][] mIconList;
    private String unlocalizedName;
    private final ArrayList<Pair<Integer, EnumRarity>> rarity = new ArrayList();
    private final ArrayList<Pair<Integer, EnumChatFormatting>> descColour = new ArrayList();
    private final ArrayList<Pair<Integer, String>> itemName = new ArrayList();
    private final ArrayList<Pair<Integer, String>> itemDescription = new ArrayList();
    private final ArrayList<Pair<Integer, Boolean>> hasEffect = new ArrayList();
    public final HashMap<Short, Long[]> mElectricStats = new HashMap();
    public final HashMap<Short, Short> mBurnValues = new HashMap();

    public BaseEuItem() {
        this("MU-metaitem.02", AddToCreativeTab.tabOther, 1000, 31766);
    }

    public BaseEuItem(String unlocalizedName, CreativeTabs creativeTab, short aOffset, short aItemAmount) {
        this.mEnabledItems = new BitSet(aItemAmount);
        this.mVisibleItems = new BitSet(aItemAmount);
        this.mOffset = (short)Math.min(32766, aOffset);
        this.mItemAmount = (short)Math.min(aItemAmount, 32766 - this.mOffset);
        this.mIconList = new IIcon[aItemAmount][1];
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(creativeTab);
        this.func_77625_d(1);
        GameRegistry.registerItem((Item)this, (String)unlocalizedName);
    }

    public void registerItem(int id, String localizedName, long euStorage, int tier, String description) {
        this.registerItem(id, localizedName, euStorage, (short)tier, description, EnumRarity.common, EnumChatFormatting.GRAY, false);
    }

    public void registerItem(int id, String localizedName, long euStorage, int tier, String description, int burnTime) {
        this.registerItem(id, localizedName, euStorage, (short)tier, description, EnumRarity.common, EnumChatFormatting.GRAY, false);
        this.setBurnValue(id, burnTime);
    }

    public void registerItem(int id, String localizedName, long euStorage, short tier, String description, EnumRarity regRarity, EnumChatFormatting colour, boolean Effect) {
        this.addItem(id, localizedName, colour + description, new Object[0]);
        this.setElectricStats(this.mOffset + id, euStorage, GT_Values.V[tier], tier, -3L, true);
        this.rarity.add(new Pair<Integer, EnumRarity>(id, regRarity));
        this.hasEffect.add(new Pair<Integer, Boolean>(id, Effect));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        if (this.rarity.get(par1ItemStack.func_77960_j() - this.mOffset) != null) {
            return this.rarity.get(par1ItemStack.func_77960_j() - this.mOffset).getValue();
        }
        return EnumRarity.common;
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        if (this.hasEffect.get(par1ItemStack.func_77960_j() - this.mOffset) != null) {
            return this.hasEffect.get(par1ItemStack.func_77960_j() - this.mOffset).getValue();
        }
        return false;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        ArrayList<IItemBehaviour<BaseEuItem>> tList;
        int keyValue = aStack.func_77960_j() - this.mOffset;
        String tKey = "gtplusplus." + this.func_77667_c(aStack) + "." + keyValue + ".tooltip";
        String tString = GT_LanguageManager.getTranslation((String)tKey);
        if (GT_Utility.isStringValid((Object)tString) && !tKey.equals(tString)) {
            aList.add(tString);
        }
        aList.add(StatCollector.func_74838_a((String)"item.itemBaseEuItem.tooltip.0"));
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats != null) {
            if (tStats[3] > 0L) {
                aList.add(EnumChatFormatting.AQUA + StatCollector.func_74837_a((String)"item.itemBaseEuItem.tooltip.1", (Object[])new Object[]{GT_Utility.formatNumbers((long)tStats[3]), tStats[2] >= 0L ? tStats[2] : 0L}) + EnumChatFormatting.GRAY);
            } else {
                long tCharge = this.getRealCharge(aStack);
                if (tStats[3] == -2L && tCharge <= 0L) {
                    aList.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"item.itemBaseEuItem.tooltip.2") + EnumChatFormatting.GRAY);
                } else {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = GT_Utility.formatNumbers((long)tCharge);
                    objectArray[1] = GT_Utility.formatNumbers((long)Math.abs(tStats[0]));
                    objectArray[2] = GT_Values.V[(int)(tStats[2] >= 0L ? (tStats[2] < (long)GT_Values.V.length ? tStats[2] : (long)(GT_Values.V.length - 1)) : 1L)];
                    aList.add(EnumChatFormatting.AQUA + StatCollector.func_74837_a((String)"item.itemBaseEuItem.tooltip.3", (Object[])objectArray) + EnumChatFormatting.GRAY);
                }
            }
        }
        if ((tList = this.mItemBehaviors.get((short)this.getDamage(aStack))) != null) {
            for (IItemBehaviour<BaseEuItem> tBehavior : tList) {
                aList = tBehavior.getAdditionalToolTips((Item)this, aList, aStack);
            }
        }
    }

    public final Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public final Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public final double getMaxCharge(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return Math.abs(tStats[0]);
    }

    public final double getTransferLimit(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return Math.max(tStats[1], tStats[3]);
    }

    public final int getTier(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        return (int)(tStats == null ? Integer.MAX_VALUE : tStats[2]);
    }

    public final double charge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aSimulate) {
        long tNewCharge;
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[2] > (long)aTier || tStats[3] != -1L && tStats[3] != -3L && (tStats[3] >= 0L || aCharge != 2.147483647E9) || aStack.field_77994_a != 1) {
            return 0.0;
        }
        long tChargeBefore = this.getRealCharge(aStack);
        long l = aCharge == 2.147483647E9 ? Long.MAX_VALUE : (tNewCharge = Math.min(Math.abs(tStats[0]), tChargeBefore + (aIgnoreTransferLimit ? (long)aCharge : Math.min(tStats[1], (long)aCharge))));
        if (!aSimulate) {
            this.setCharge(aStack, tNewCharge);
        }
        return tNewCharge - tChargeBefore;
    }

    public final double discharge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aBatteryAlike, boolean aSimulate) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[2] > (long)aTier) {
            return 0.0;
        }
        if (aBatteryAlike && !this.canProvideEnergy(aStack)) {
            return 0.0;
        }
        if (tStats[3] > 0L) {
            if (aCharge < (double)tStats[3].longValue() || aStack.field_77994_a < 1) {
                return 0.0;
            }
            if (!aSimulate) {
                --aStack.field_77994_a;
            }
            return tStats[3].longValue();
        }
        long tChargeBefore = this.getRealCharge(aStack);
        long tNewCharge = Math.max(0L, tChargeBefore - (aIgnoreTransferLimit ? (long)aCharge : Math.min(tStats[1], (long)aCharge)));
        if (!aSimulate) {
            this.setCharge(aStack, tNewCharge);
        }
        return tChargeBefore - tNewCharge;
    }

    public final double getCharge(ItemStack aStack) {
        return this.getRealCharge(aStack);
    }

    public final boolean canUse(ItemStack aStack, double aAmount) {
        return (double)this.getRealCharge(aStack) >= aAmount;
    }

    public final boolean use(ItemStack aStack, double aAmount, EntityLivingBase aPlayer) {
        this.chargeFromArmor(aStack, aPlayer);
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d) {
            return true;
        }
        double tTransfer = this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, true);
        if (tTransfer == aAmount) {
            this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, false);
            this.chargeFromArmor(aStack, aPlayer);
            return true;
        }
        this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, false);
        this.chargeFromArmor(aStack, aPlayer);
        return false;
    }

    public final boolean canProvideEnergy(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats[3] > 0L || aStack.field_77994_a == 1 && (tStats[3] == -2L || tStats[3] == -3L);
    }

    public final void chargeFromArmor(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aPlayer.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 1; i < 5; ++i) {
            Container tContainer;
            double tCharge;
            IElectricItem tArmorItem;
            ItemStack tArmor = aPlayer.func_71124_b(i);
            if (!GT_ModHandler.isElectricItem((ItemStack)tArmor) || !(tArmorItem = (IElectricItem)tArmor.func_77973_b()).canProvideEnergy(tArmor) || tArmorItem.getTier(tArmor) < this.getTier(aStack) || !((tCharge = ElectricItem.manager.discharge(tArmor, this.charge(aStack, 2.147483646E9, Integer.MAX_VALUE, true, true), Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(aStack, tCharge, Integer.MAX_VALUE, true, false);
            if (!(aPlayer instanceof EntityPlayer) || (tContainer = ((EntityPlayer)aPlayer).field_71070_bA) == null) continue;
            tContainer.func_75142_b();
        }
    }

    public final long getRealCharge(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        if (tStats[3] > 0L) {
            return (int)tStats[3].longValue();
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        return tNBT == null ? 0L : tNBT.func_74763_f("GT.ItemCharge");
    }

    public final boolean setCharge(ItemStack aStack, long aCharge) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[3] > 0L) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        tNBT.func_82580_o("GT.ItemCharge");
        aCharge = Math.min(tStats[0] < 0L ? Math.abs(tStats[0] / 2L) : aCharge, Math.abs(tStats[0]));
        if (aCharge > 0L) {
            aStack.func_77964_b((int)this.getChargedMetaData(aStack));
            tNBT.func_74772_a("GT.ItemCharge", aCharge);
        } else {
            aStack.func_77964_b((int)this.getEmptyMetaData(aStack));
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        this.isItemStackUsable(aStack);
        return true;
    }

    public short getChargedMetaData(ItemStack aStack) {
        return (short)aStack.func_77960_j();
    }

    public short getEmptyMetaData(ItemStack aStack) {
        return (short)aStack.func_77960_j();
    }

    public boolean isItemStackUsable(ItemStack aStack) {
        ArrayList<IItemBehaviour<BaseEuItem>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<BaseEuItem> tBehavior : tList) {
                if (tBehavior.isItemStackUsable((Item)this, aStack)) continue;
                return false;
            }
        }
        return true;
    }

    public final String getToolTip(ItemStack aStack) {
        return null;
    }

    public final IElectricItemManager getManager(ItemStack aStack) {
        return this;
    }

    public final BaseEuItem setBurnValue(int aMetaValue, int aValue) {
        if (aMetaValue < 0 || aValue < 0) {
            return this;
        }
        if (aValue == 0) {
            this.mBurnValues.remove((short)aMetaValue);
        } else {
            this.mBurnValues.put((short)aMetaValue, (short)(aValue > Short.MAX_VALUE ? Short.MAX_VALUE : (short)aValue));
        }
        return this;
    }

    public final BaseEuItem setElectricStats(int aMetaValue, long aMaxCharge, long aTransferLimit, long aTier, long aSpecialData, boolean aUseAnimations) {
        if (aMetaValue < 0) {
            return this;
        }
        if (aMaxCharge == 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, new Long[]{aMaxCharge, Math.max(0L, aTransferLimit), Math.max(-1L, aTier), aSpecialData});
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack;
            if (!this.mVisibleItems.get(i) && (!GT_Values.D1 || !this.mEnabledItems.get(i))) continue;
            Long[] tStats = this.mElectricStats.get((short)(this.mOffset + i));
            if (tStats != null && tStats[3] < 0L) {
                tStack = new ItemStack((Item)this, 1, this.mOffset + i);
                this.setCharge(tStack, Math.abs(tStats[0]));
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
            if (tStats != null && tStats[3] == -2L) continue;
            tStack = new ItemStack((Item)this, 1, this.mOffset + i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (!this.mEnabledItems.get(i)) continue;
            for (int k = 1; k < this.mIconList[i].length; k = (int)((byte)(k + 1))) {
                this.mIconList[i][k] = aIconRegister.func_94245_a("miscutils:" + this.func_77658_a() + "/" + i + "/" + k);
            }
            this.mIconList[i][0] = aIconRegister.func_94245_a("miscutils:" + this.func_77658_a() + "/" + i);
        }
    }

    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        return aMetaData - this.mOffset < this.mIconList.length ? this.mIconList[aMetaData - this.mOffset][0] : null;
    }

    public Item func_77655_b(String p_77655_1_) {
        this.unlocalizedName = p_77655_1_;
        super.func_77655_b(p_77655_1_);
        return this;
    }

    public String func_77658_a() {
        return this.unlocalizedName;
    }

    public final Long[] getElectricStats(ItemStack aStack) {
        return this.mElectricStats.get((short)aStack.func_77960_j());
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public final BaseEuItem addItemBehavior(int aMetaValue, IItemBehaviour<BaseEuItem> aBehavior) {
        if (aMetaValue < 0 || aMetaValue >= 32766 || aBehavior == null) {
            return this;
        }
        ArrayList<Object> tList = this.mItemBehaviors.get((short)aMetaValue);
        if (tList == null) {
            tList = new ArrayList(1);
            this.mItemBehaviors.put((short)aMetaValue, tList);
        }
        tList.add(aBehavior);
        return this;
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < this.mItemAmount) {
            ItemStack rStack = new ItemStack((Item)this, 1, this.mOffset + aID);
            this.mEnabledItems.set(aID);
            this.mVisibleItems.set(aID);
            GT_LanguageManager.addStringLocalization((String)("gtplusplus." + this.func_77667_c(rStack) + "." + aID + ".name"), (String)aEnglish);
            GT_LanguageManager.addStringLocalization((String)("gtplusplus." + this.func_77667_c(rStack) + "." + aID + ".tooltip"), (String)aToolTip);
            ArrayList tAspects = new ArrayList();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof SubTag)) continue;
                if (tRandomData == SubTag.INVISIBLE) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != SubTag.NO_UNIFICATION) continue;
                GT_OreDictUnificator.addToBlacklist((ItemStack)rStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(this.mOffset + aID, (IItemBehaviour<BaseEuItem>)((IItemBehaviour)tRandomData));
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TC_Aspects.TC_AspectStack) {
                    ((TC_Aspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GT_Utility.isStringValid((Object)tRandomData)) {
                        GT_OreDictUnificator.registerOre((Object)tRandomData, (ItemStack)rStack);
                        continue;
                    }
                    GT_OreDictUnificator.addItemData((ItemStack)rStack, (ItemData)((ItemData)tRandomData));
                    continue;
                }
                if (!tUseOreDict) continue;
                GT_OreDictUnificator.registerOre((Object)tRandomData, (ItemStack)rStack);
            }
            if (GregTech_API.sThaumcraftCompat != null) {
                GregTech_API.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        int keyValue = par1ItemStack.func_77960_j() - this.mOffset;
        if (keyValue < 0 || keyValue > 5) {
            keyValue = 0;
        }
        return GT_LanguageManager.getTranslation((String)("gtplusplus." + this.func_77667_c(par1ItemStack) + "." + keyValue + ".name"));
    }
}

