/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.general;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.api.objects.random.XSTR;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class HellFire
extends BlockFire {
    @Deprecated
    private final int[] field_149849_a = new int[Short.MAX_VALUE];
    @Deprecated
    private final int[] field_149848_b = new int[Short.MAX_VALUE];
    @SideOnly(value=Side.CLIENT)
    private IIcon[] IIconArray;
    private final IdentityHashMap<Block, FireInfo> blockInfo = Maps.newIdentityHashMap();

    public HellFire() {
        this.func_149675_a(true);
        this.func_149715_a(1.0f);
        this.func_149713_g(0);
        this.func_149663_c("blockHellFire");
        this.func_149647_a(AddToCreativeTab.tabBlock);
        GameRegistry.registerBlock((Block)this, (String)"blockHellFire");
        this.enableBrutalFire();
    }

    private void enableBrutalFire() {
        for (Object o : Block.field_149771_c.func_148742_b()) {
            try {
                String name = (String)o;
                Block b = Block.func_149684_b((String)name);
                if (b == Blocks.field_150350_a) continue;
                int spread = Blocks.field_150480_ab.getEncouragement(b);
                int flamm = Blocks.field_150480_ab.getFlammability(b);
                if (flamm <= 0 || spread <= 0) continue;
                this.setFireInfo(b, spread * 4, flamm * 4);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.setFireInfo(Blocks.field_150420_aW, 20, 100);
        this.setFireInfo(Blocks.field_150419_aX, 20, 100);
        this.setFireInfo((Block)Blocks.field_150349_c, 20, 100);
        this.setFireInfo((Block)Blocks.field_150391_bh, 20, 100);
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        random = new XSTR();
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            boolean flag = world.func_147439_a(x, y - 1, z).isFireSource(world, x, y - 1, z, ForgeDirection.UP);
            if (!this.func_149742_c(world, x, y, z)) {
                world.func_147468_f(x, y, z);
            }
            if (!flag && world.func_72896_J() && (world.func_72951_B(x, y, z) || world.func_72951_B(x - 1, y, z) || world.func_72951_B(x + 1, y, z) || world.func_72951_B(x, y, z - 1) || world.func_72951_B(x, y, z + 1))) {
                if (MathUtils.randInt(0, 100) >= 90) {
                    world.func_147468_f(x, y, z);
                }
            } else {
                int blockMeta = world.func_72805_g(x, y, z);
                if (blockMeta < 15) {
                    world.func_72921_c(x, y, z, blockMeta + random.nextInt(3) / 2, 4);
                }
                world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + random.nextInt(10));
                if (!flag && !this.canNeighborBurn(world, x, y, z)) {
                    if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || blockMeta > 3) {
                        world.func_147468_f(x, y, z);
                    }
                } else if (!flag && !this.canCatchFire((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) && blockMeta == 15 && random.nextInt(4) == 0) {
                    world.func_147468_f(x, y, z);
                } else {
                    boolean flag1 = world.func_72958_C(x, y, z);
                    int b0 = 0;
                    if (flag1) {
                        b0 = -50;
                    }
                    this.tryCatchFire(world, x + 1, y, z, 300 + b0, random, blockMeta, ForgeDirection.WEST);
                    this.tryCatchFire(world, x - 1, y, z, 300 + b0, random, blockMeta, ForgeDirection.EAST);
                    this.tryCatchFire(world, x, y - 1, z, 250 + b0, random, blockMeta, ForgeDirection.UP);
                    this.tryCatchFire(world, x, y + 1, z, 250 + b0, random, blockMeta, ForgeDirection.DOWN);
                    this.tryCatchFire(world, x, y, z - 1, 300 + b0, random, blockMeta, ForgeDirection.SOUTH);
                    this.tryCatchFire(world, x, y, z + 1, 300 + b0, random, blockMeta, ForgeDirection.NORTH);
                    for (int i1 = x - 1; i1 <= x + 1; ++i1) {
                        for (int j1 = z - 1; j1 <= z + 1; ++j1) {
                            for (int k1 = y - 1; k1 <= y + 4; ++k1) {
                                int neighbourFireChance;
                                if (i1 == x && k1 == y && j1 == z) continue;
                                int l1 = 100;
                                if (k1 > y + 1) {
                                    l1 += (k1 - (y + 1)) * 100;
                                }
                                if ((neighbourFireChance = this.getChanceOfNeighborsEncouragingFire(world, i1, k1, j1)) <= 0) continue;
                                int j2 = (neighbourFireChance + 40 + world.field_73013_u.func_151525_a() * 14) / (blockMeta + 30);
                                if (flag1) {
                                    j2 /= 2;
                                }
                                if (j2 <= 0 || random.nextInt(l1) > j2 || world.func_72896_J() && world.func_72951_B(i1, k1, j1) || world.func_72951_B(i1 - 1, k1, z) || world.func_72951_B(i1 + 1, k1, j1) || world.func_72951_B(i1, k1, j1 - 1) || world.func_72951_B(i1, k1, j1 + 1)) continue;
                                int k2 = blockMeta + random.nextInt(5) / 4;
                                if (k2 > 15) {
                                    k2 = 15;
                                }
                                world.func_147465_d(i1, k1, j1, (Block)this, k2, 3);
                            }
                        }
                    }
                }
            }
        }
    }

    private void tryCatchFire(World world, int p_149841_2_, int p_149841_3_, int p_149841_4_, int p_149841_5_, Random p_149841_6_, int p_149841_7_, ForgeDirection face) {
        int j1 = world.func_147439_a(p_149841_2_, p_149841_3_, p_149841_4_).getFlammability((IBlockAccess)world, p_149841_2_, p_149841_3_, p_149841_4_, face);
        if (p_149841_6_.nextInt(p_149841_5_) < j1) {
            boolean flag;
            boolean bl = flag = world.func_147439_a(p_149841_2_, p_149841_3_, p_149841_4_) == Blocks.field_150335_W;
            if (p_149841_6_.nextInt(p_149841_7_ + 10) < 5 && !world.func_72951_B(p_149841_2_, p_149841_3_, p_149841_4_)) {
                int k1 = p_149841_7_ + p_149841_6_.nextInt(5) / 4;
                if (k1 > 15) {
                    k1 = 15;
                }
                world.func_147465_d(p_149841_2_, p_149841_3_, p_149841_4_, (Block)this, k1, 3);
            } else {
                world.func_147468_f(p_149841_2_, p_149841_3_, p_149841_4_);
            }
            if (flag) {
                Blocks.field_150335_W.func_149664_b(world, p_149841_2_, p_149841_3_, p_149841_4_, 1);
            }
        }
    }

    private boolean canNeighborBurn(World world, int x, int y, int z) {
        return this.canCatchFire((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST) || this.canCatchFire((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST) || this.canCatchFire((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) || this.canCatchFire((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN) || this.canCatchFire((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH) || this.canCatchFire((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH);
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int x, int y, int z) {
        boolean b0 = false;
        if (!world.func_147437_c(x, y, z)) {
            return 0;
        }
        int l = 0;
        l = this.getChanceToEncourageFire((IBlockAccess)world, x + 1, y, z, l, ForgeDirection.WEST);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x - 1, y, z, l, ForgeDirection.EAST);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y - 1, z, l, ForgeDirection.UP);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y + 1, z, l, ForgeDirection.DOWN);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z - 1, l, ForgeDirection.SOUTH);
        l = this.getChanceToEncourageFire((IBlockAccess)world, x, y, z + 1, l, ForgeDirection.NORTH);
        return l;
    }

    @Deprecated
    public boolean func_149844_e(IBlockAccess p_149844_1_, int p_149844_2_, int p_149844_3_, int p_149844_4_) {
        return this.canCatchFire(p_149844_1_, p_149844_2_, p_149844_3_, p_149844_4_, ForgeDirection.UP);
    }

    public boolean func_149742_c(World worldObj, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)worldObj, (int)x, (int)(y - 1), (int)z) || this.canNeighborBurn(worldObj, x, y, z);
    }

    public void func_149695_a(World worldObj, int x, int y, int z, Block blockObj) {
        if (!World.func_147466_a((IBlockAccess)worldObj, (int)x, (int)(y - 1), (int)z) && !this.canNeighborBurn(worldObj, x, y, z)) {
            worldObj.func_147468_f(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g > 0 || !Blocks.field_150427_aO.func_150000_e(world, x, y, z)) {
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && !this.canNeighborBurn(world, x, y, z)) {
                world.func_147468_f(x, y, z);
            } else {
                world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(10));
            }
        }
    }

    public void func_149724_b(World world, int i, int j, int k, Entity entity) {
        entity.func_70015_d(10);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        entity.func_70015_d(10);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random randomObj) {
        block12: {
            block11: {
                float f2;
                float f1;
                float f;
                int l;
                randomObj = new XSTR();
                if (randomObj.nextInt(24) == 0) {
                    world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "fire.fire", 1.0f + randomObj.nextFloat(), randomObj.nextFloat() * 0.7f + 0.3f, false);
                }
                if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP)) break block11;
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)x + randomObj.nextFloat() * 0.1f;
                        f1 = (float)y + randomObj.nextFloat();
                        f2 = (float)z + randomObj.nextFloat();
                        world.func_72869_a("witchMagic", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)(f1 + 0.5f), (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)(x + 1) - randomObj.nextFloat() * 0.1f;
                        f1 = (float)y + randomObj.nextFloat();
                        f2 = (float)z + randomObj.nextFloat();
                        world.func_72869_a("witchMagic", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)(f1 + 0.5f), (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)x + randomObj.nextFloat();
                        f1 = (float)y + randomObj.nextFloat();
                        f2 = (float)z + randomObj.nextFloat() * 0.1f;
                        world.func_72869_a("witchMagic", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)(f1 + 0.5f), (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH)) {
                    for (l = 0; l < 2; ++l) {
                        f = (float)x + randomObj.nextFloat();
                        f1 = (float)y + randomObj.nextFloat();
                        f2 = (float)(z + 1) - randomObj.nextFloat() * 0.1f;
                        world.func_72869_a("witchMagic", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                        world.func_72869_a("largesmoke", (double)f, (double)(f1 + 0.5f), (double)f2, 0.0, 0.0, 0.0);
                    }
                }
                if (!Blocks.field_150480_ab.canCatchFire((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN)) break block12;
                for (l = 0; l < 2; ++l) {
                    f = (float)x + randomObj.nextFloat();
                    f1 = (float)(y + 1) - randomObj.nextFloat() * 0.1f;
                    f2 = (float)z + randomObj.nextFloat();
                    world.func_72869_a("witchMagic", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                    world.func_72869_a("largesmoke", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                    world.func_72869_a("largesmoke", (double)f, (double)(f1 + 0.5f), (double)f2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int l = 0; l < 5; ++l) {
                float f = (float)x + randomObj.nextFloat();
                float f1 = (float)y + randomObj.nextFloat() * 0.5f + 0.5f;
                float f2 = (float)z + randomObj.nextFloat();
                world.func_72869_a("witchMagic", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                world.func_72869_a("largesmoke", (double)f, (double)f1, (double)f2, 0.0, 0.0, 0.0);
                world.func_72869_a("largesmoke", (double)f, (double)(f1 + 0.5f), (double)f2, 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.IIconArray = new IIcon[]{IIconRegister2.func_94245_a("miscutils:hellfire/blockHellFire_layer_0"), IIconRegister2.func_94245_a("miscutils:hellfire/blockHellFire_layer_1")};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149840_c(int p_149840_1_) {
        return this.IIconArray[p_149840_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.IIconArray[0];
    }

    public MapColor func_149728_f(int p_149728_1_) {
        return MapColor.field_151666_j;
    }

    public void setFireInfo(Block block, int encouragement, int flammibility) {
        try {
            if (block == Blocks.field_150350_a) {
                throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
            }
            int id = Block.func_149682_b((Block)block);
            if (id >= 4096 || id >= this.field_149849_a.length || id >= this.field_149848_b.length) {
                return;
            }
            this.field_149849_a[id] = encouragement;
            this.field_149848_b[id] = flammibility;
            FireInfo info = this.getInfo(block, true);
            info.encouragement = encouragement;
            info.flammibility = flammibility;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private FireInfo getInfo(Block block, boolean garentee) {
        FireInfo ret = this.blockInfo.get(block);
        if (ret == null && garentee) {
            ret = new FireInfo();
            this.blockInfo.put(block, ret);
        }
        return ret;
    }

    public void rebuildFireInfo() {
        for (int x = 0; x < 4096; ++x) {
            this.field_149849_a[x] = 0;
            this.field_149848_b[x] = 0;
        }
        for (Map.Entry<Block, FireInfo> e : this.blockInfo.entrySet()) {
            int id = Block.func_149682_b((Block)e.getKey());
            if (id < 0 || id >= 4096) continue;
            this.field_149849_a[id] = e.getValue().encouragement;
            this.field_149848_b[id] = e.getValue().flammibility;
        }
    }

    public int getFlammability(Block block) {
        int id = Block.func_149682_b((Block)block);
        return id >= 0 && id < 4096 ? this.field_149848_b[id] : 0;
    }

    public int getEncouragement(Block block) {
        int id = Block.func_149682_b((Block)block);
        return id >= 0 && id < 4096 ? this.field_149849_a[id] : 0;
    }

    public boolean canCatchFire(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return world.func_147439_a(x, y, z).isFlammable(world, x, y, z, face);
    }

    public int getChanceToEncourageFire(IBlockAccess world, int x, int y, int z, int oldChance, ForgeDirection face) {
        int newChance = world.func_147439_a(x, y, z).getFireSpreadSpeed(world, x, y, z, face);
        return newChance > oldChance ? newChance : oldChance;
    }

    private static class FireInfo {
        private int encouragement = 0;
        private int flammibility = 0;

        private FireInfo() {
        }
    }
}

