/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.base;

import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BasicBlock
extends BlockContainer {
    public BasicBlock(String unlocalizedName, Material material) {
        this(BlockTypes.STANDARD, unlocalizedName, material, 2);
    }

    public BasicBlock(BlockTypes type, String unlocalizedName, Material material) {
        this(type, unlocalizedName, material, 2);
    }

    public BasicBlock(BlockTypes type, String unlocalizedName, Material material, int harvestLevel) {
        super(material);
        this.func_149663_c(Utils.sanitizeString(unlocalizedName));
        if (type != BlockTypes.ORE && !unlocalizedName.toLowerCase().contains("ore")) {
            this.func_149658_d("miscutils:" + unlocalizedName);
        }
        this.func_149647_a(AddToCreativeTab.tabBlock);
        this.func_149752_b(6.0f);
        this.func_149715_a(0.0f);
        this.func_149711_c(1.0f * (float)harvestLevel);
        this.setHarvestLevel("pickaxe", harvestLevel);
        this.func_149672_a(field_149777_j);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return null;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public static enum BlockTypes {
        STANDARD("blockBlock", "pickaxe", Block.field_149777_j),
        FRAME("blockFrameGt", "wrench", Block.field_149777_j),
        ORE("blockStone", "pickaxe", Block.field_149769_e);

        private String TEXTURE_NAME;
        private String HARVEST_TOOL;
        private Block.SoundType soundOfBlock;

        private BlockTypes(String textureName, String harvestTool, Block.SoundType blockSound) {
            this.TEXTURE_NAME = textureName;
            this.HARVEST_TOOL = harvestTool;
            this.soundOfBlock = blockSound;
        }

        public String getTexture() {
            return this.TEXTURE_NAME;
        }

        public String getHarvestTool() {
            return this.HARVEST_TOOL;
        }

        public Block.SoundType getBlockSoundType() {
            return this.soundOfBlock;
        }
    }
}

