/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.Reactor;
import Ic2ExpReactorPlanner.components.ReactorItem;
import gregtech.api.objects.GT_ItemStack;

public class Plating
extends ReactorItem {
    private final int heatAdjustment;

    public Plating(int id, String baseName, GT_ItemStack aItem, double maxDamage, double maxHeat, String sourceMod, int heatAdjustment, double explosionPowerMultiplier) {
        super(id, baseName, aItem, maxDamage, maxHeat, sourceMod);
        this.heatAdjustment = heatAdjustment;
        this.explosionPowerMultiplier = explosionPowerMultiplier;
    }

    public Plating(Plating other) {
        super(other);
        this.heatAdjustment = other.heatAdjustment;
        this.explosionPowerMultiplier = other.explosionPowerMultiplier;
    }

    @Override
    public void addToReactor(Reactor parent, int row, int col) {
        super.addToReactor(parent, row, col);
        if (parent != null) {
            parent.adjustMaxHeat(this.heatAdjustment);
        }
    }

    @Override
    public void removeFromReactor() {
        if (this.parent != null) {
            this.parent.adjustMaxHeat(-this.heatAdjustment);
        }
        super.removeFromReactor();
    }
}

