/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.witchery;

import com.mojang.authlib.GameProfile;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class WitchUtils {
    private static final GameProfile NORMAL_MINER_PROFILE;
    private static final GameProfile KOBOLDITE_MINER_PROFILE;

    public static void onHarvestDrops(EntityPlayer harvester, BlockEvent.HarvestDropsEvent event) {
        if (LoadedMods.Witchery && harvester != null && !harvester.field_70170_p.field_72995_K && !event.isCanceled() && (WitchUtils.isEqual(harvester.func_146103_bH(), KOBOLDITE_MINER_PROFILE) || WitchUtils.isEqual(harvester.func_146103_bH(), NORMAL_MINER_PROFILE))) {
            boolean hasKobolditePick = WitchUtils.isEqual(harvester.func_146103_bH(), KOBOLDITE_MINER_PROFILE);
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            double kobolditeChance = hasKobolditePick ? 0.02 : 0.01;
            for (ItemStack drop : event.drops) {
                String oreName;
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)drop);
                boolean addOriginal = true;
                if (oreIDs.length > 0 && (oreName = OreDictionary.getOreName((int)oreIDs[0])) != null && oreName.startsWith("ore")) {
                    ItemStack smeltedDrop = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                    if (smeltedDrop != null && hasKobolditePick && harvester.field_70170_p.field_73012_v.nextDouble() < 0.5) {
                        addOriginal = false;
                        newDrops.add(smeltedDrop.func_77946_l());
                        newDrops.add(smeltedDrop.func_77946_l());
                        if (harvester.field_70170_p.field_73012_v.nextDouble() < 0.25) {
                            newDrops.add(smeltedDrop.func_77946_l());
                        }
                    }
                    double d = kobolditeChance = hasKobolditePick ? 0.08 : 0.05;
                }
                if (!addOriginal) continue;
                newDrops.add(drop);
            }
            event.drops.clear();
            for (ItemStack newDrop : newDrops) {
                event.drops.add(newDrop);
            }
            if (kobolditeChance > 0.0 && harvester.field_70170_p.field_73012_v.nextDouble() < kobolditeChance) {
                event.drops.add(ALLOY.KOBOLDITE.getDust(1));
            }
        }
    }

    public static Field getField(String aClassName, String aFieldName) {
        Field f;
        Class<?> c = ReflectionUtils.getClass(aClassName);
        if (c != null && (f = ReflectionUtils.getField(c, aFieldName)) != null) {
            return f;
        }
        return null;
    }

    public static boolean isEqual(GameProfile a, GameProfile b) {
        return a != null && b != null && a.getId() != null && b.getId() != null && a.getId().equals(b.getId());
    }

    static {
        Field a1 = null;
        Field a2 = null;
        GameProfile b1 = null;
        GameProfile b2 = null;
        if (LoadedMods.Witchery) {
            try {
                a1 = WitchUtils.getField("com.emoniph.witchery.entity.ai.EntityAIDigBlocks", "NORMAL_MINER_PROFILE");
                a2 = WitchUtils.getField("com.emoniph.witchery.entity.ai.EntityAIDigBlocks", "KOBOLDITE_MINER_PROFILE");
                b1 = (GameProfile)a1.get(null);
                b2 = (GameProfile)a2.get(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        NORMAL_MINER_PROFILE = b1;
        KOBOLDITE_MINER_PROFILE = b2;
    }
}

