/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.reliquary.item;

import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ReliquaryItems {
    private static Class<?> CLASS_MAIN = ReflectionUtils.getClass("xreliquary.Reliquary");
    private static Field FIELD_CONTENT = ReflectionUtils.getField(CLASS_MAIN, "CONTENT");
    private static Object OBJECT_CONTENT = ReflectionUtils.getFieldValue(FIELD_CONTENT);
    private static Method METHOD_GETITEM = ReflectionUtils.getMethod(OBJECT_CONTENT, "getItem", new Class[]{String.class});

    public static Item getItem(String name) {
        try {
            return (Item)METHOD_GETITEM.invoke(OBJECT_CONTENT, name);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            return null;
        }
    }

    public static ItemStack emptyVoidTear() {
        return new ItemStack(ReliquaryItems.getItem("void_tear_empty"), 1, 0);
    }

    public static ItemStack glowingWater() {
        return new ItemStack(ReliquaryItems.getItem("glowing_water"));
    }

    public static ItemStack emptyVial() {
        return new ItemStack(ReliquaryItems.getItem("potion"), 1, 0);
    }

    public static ItemStack emperorChalice() {
        return new ItemStack(ReliquaryItems.getItem("emperor_chalice"));
    }

    public static ItemStack infernalChalice() {
        return new ItemStack(ReliquaryItems.getItem("infernal_chalice"));
    }

    public static ItemStack witherSkull() {
        return new ItemStack(Items.field_151144_bL, 1, 1);
    }

    public static ItemStack roseBush() {
        return new ItemStack((Block)Blocks.field_150398_cm, 1, 4);
    }

    public static ItemStack blackWool() {
        return new ItemStack(Blocks.field_150325_L, 1, 15);
    }

    public static ItemStack lapis() {
        return new ItemStack(Items.field_151100_aR, 1, 4);
    }

    public static ItemStack gunPart(int i, int m) {
        return new ItemStack(ReliquaryItems.getItem("gun_part"), i, m);
    }

    public static ItemStack magazine(int m) {
        return ReliquaryItems.magazine(1, m);
    }

    public static ItemStack magazine(int i, int m) {
        return new ItemStack(ReliquaryItems.getItem("magazine"), i, m);
    }

    public static ItemStack bullet(int m) {
        return ReliquaryItems.bullet(1, m);
    }

    public static ItemStack bullet(int i, int m) {
        return new ItemStack(ReliquaryItems.getItem("bullet"), i, m);
    }

    public static ItemStack ingredient(int m) {
        return new ItemStack(ReliquaryItems.getItem("mob_ingredient"), 1, m);
    }

    public static ItemStack enderHeart() {
        return ReliquaryItems.ingredient(11);
    }

    public static ItemStack creeperGland() {
        return ReliquaryItems.ingredient(3);
    }

    public static ItemStack slimePearl() {
        return ReliquaryItems.ingredient(4);
    }

    public static ItemStack batWing() {
        return ReliquaryItems.ingredient(5);
    }

    public static ItemStack ribBone() {
        return ReliquaryItems.ingredient(0);
    }

    public static ItemStack witherRib() {
        return ReliquaryItems.ingredient(1);
    }

    public static ItemStack stormEye() {
        return ReliquaryItems.ingredient(8);
    }

    public static ItemStack fertileEssence() {
        return ReliquaryItems.ingredient(9);
    }

    public static ItemStack frozenCore() {
        return ReliquaryItems.ingredient(10);
    }

    public static ItemStack moltenCore() {
        return ReliquaryItems.ingredient(7);
    }

    public static ItemStack zombieHeart() {
        return ReliquaryItems.ingredient(6);
    }

    public static ItemStack infernalClaw() {
        return ReliquaryItems.ingredient(13);
    }

    public static ItemStack shellFragment() {
        return ReliquaryItems.ingredient(14);
    }

    public static ItemStack squidBeak() {
        return ReliquaryItems.ingredient(12);
    }

    public static ItemStack spiderFangs() {
        return ReliquaryItems.ingredient(2);
    }

    public static ItemStack heartPearl(int m) {
        return new ItemStack(ReliquaryItems.getItem("heart_pearl"), 1, m);
    }

    public static ItemStack nianZhu(int m) {
        return new ItemStack(ReliquaryItems.getItem("heart_zhu"), 1, m);
    }

    public static ItemStack emptyVoidSatchel() {
        return new ItemStack(ReliquaryItems.getItem("void_tear_empty"), 1, 0);
    }
}

