/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.ic2.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.core.lib.LoadedMods;
import ic2.api.item.IKineticRotor;
import ic2.core.IC2;
import ic2.core.block.kineticgenerator.gui.GuiWaterKineticGenerator;
import ic2.core.block.kineticgenerator.gui.GuiWindKineticGenerator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class CustomKineticRotor
extends Item
implements IKineticRotor {
    private final int mTier;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] mTextures;
    private static final String[] mRegistrationNames = new String[]{"itemwoodrotor", "itemironrotor", "itemsteelrotor", "itemwcarbonrotor"};
    private static final String[] mUnlocalNames = new String[]{"itemEnergeticRotor", "itemTungstenSteelRotor", "itemVibrantRotor", "itemIridiumRotor", "itemMagnaliumRotor", "itemUltimetRotor"};
    private static final int[] mMaxDurability = new int[]{512000, 809600, 1600000, 3200000};
    private static final int[] mRadius = new int[]{9, 11, 13, 15};
    private static final float[] mEfficiency = new float[]{0.9f, 1.0f, 1.2f, 1.5f};
    private static final int[] mMinWindStrength = new int[]{12, 14, 16, 18};
    private static final int[] mMaxWindStrength = new int[]{80, 120, 160, 320};
    private static final ResourceLocation[] mResourceLocations = new ResourceLocation[]{new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorEnergeticModel.png"), new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorTungstenSteelModel.png"), new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorVibrantModel.png"), new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorIridiumModel.png"), new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorMagnaliumModel.png"), new ResourceLocation(IC2.textureDomain, "textures/items/rotors/rotorUltimetModel.png")};
    private final int maxWindStrength;
    private final int minWindStrength;
    private final int radius;
    private final float efficiency;
    private final ResourceLocation renderTexture;

    public CustomKineticRotor(int aTier) {
        this.mTier = aTier;
        this.func_77625_d(1);
        if (!(LoadedMods.EnderIO || aTier != 0 && aTier != 2)) {
            this.renderTexture = mResourceLocations[aTier == 0 ? 4 : 5];
            this.func_77655_b(mUnlocalNames[aTier == 0 ? 4 : 5]);
        } else {
            this.renderTexture = mResourceLocations[aTier];
            this.func_77655_b(mUnlocalNames[aTier]);
        }
        this.func_77656_e(mMaxDurability[aTier]);
        this.radius = mRadius[aTier];
        this.efficiency = mEfficiency[aTier];
        this.minWindStrength = mMinWindStrength[aTier];
        this.maxWindStrength = mMaxWindStrength[aTier];
        this.setNoRepair();
        this.func_77637_a((CreativeTabs)IC2.tabIC2);
        GameRegistry.registerItem((Item)this, (String)mRegistrationNames[aTier]);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (this.mTier < 3) {
            super.setDamage(stack, damage);
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        info.add(StatCollector.func_74837_a((String)"ic2.itemrotor.wind.info", (Object[])new Object[]{this.minWindStrength, this.maxWindStrength}));
        IKineticRotor.GearboxType type = null;
        if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiWaterKineticGenerator) {
            type = IKineticRotor.GearboxType.WATER;
        } else if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiWindKineticGenerator) {
            type = IKineticRotor.GearboxType.WIND;
        }
        if (type != null) {
            info.add(StatCollector.func_74838_a((String)("ic2.itemrotor.fitsin." + this.isAcceptedType(itemStack, type))));
        }
    }

    public int getDiameter(ItemStack stack) {
        return this.radius;
    }

    public ResourceLocation getRotorRenderTexture(ItemStack stack) {
        return this.renderTexture;
    }

    public float getEfficiency(ItemStack stack) {
        return this.efficiency;
    }

    public int getMinWindStrength(ItemStack stack) {
        return this.minWindStrength;
    }

    public int getMaxWindStrength(ItemStack stack) {
        return this.maxWindStrength;
    }

    public boolean isAcceptedType(ItemStack stack, IKineticRotor.GearboxType type) {
        return type == IKineticRotor.GearboxType.WIND || type == IKineticRotor.GearboxType.WATER;
    }

    public String func_77658_a() {
        return "ic2." + super.func_77658_a().substring(5);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)this.func_77667_c(itemStack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.mTier < 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (!(LoadedMods.EnderIO || this.mTier != 0 && this.mTier != 2)) {
            if (this.mTier == 0) {
                return this.mTextures[4];
            }
            return this.mTextures[5];
        }
        return this.mTextures[this.mTier];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack aIndex) {
        if (!(LoadedMods.EnderIO || this.mTier != 0 && this.mTier != 2)) {
            if (this.mTier == 0) {
                return this.mTextures[4];
            }
            return this.mTextures[5];
        }
        return this.mTextures[this.mTier];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int aDmg, int aPass) {
        if (!(LoadedMods.EnderIO || this.mTier != 0 && this.mTier != 2)) {
            if (this.mTier == 0) {
                return this.mTextures[4];
            }
            return this.mTextures[5];
        }
        return this.mTextures[this.mTier];
    }

    protected String func_111208_A() {
        return super.func_111208_A();
    }

    public int getDisplayDamage(ItemStack stack) {
        return super.getDisplayDamage(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return super.getDurabilityForDisplay(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (!(LoadedMods.EnderIO || this.mTier != 0 && this.mTier != 2)) {
            if (this.mTier == 0) {
                return this.mTextures[4];
            }
            return this.mTextures[5];
        }
        return this.mTextures[this.mTier];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (!(LoadedMods.EnderIO || this.mTier != 0 && this.mTier != 2)) {
            if (this.mTier == 0) {
                return this.mTextures[4];
            }
            return this.mTextures[5];
        }
        return this.mTextures[this.mTier];
    }

    public void func_94581_a(IIconRegister iconRegister) {
        int aIndex = 0;
        this.mTextures = new IIcon[6];
        for (String y : mUnlocalNames) {
            this.mTextures[aIndex++] = iconRegister.func_94245_a(IC2.textureDomain + ":rotors/" + y);
        }
    }
}

