/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.WeightedCollection;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoader_AlgaeFarm {
    private static final HashMap<Integer, AutoMap<GT_Recipe>> mRecipeCache = new HashMap();
    private static final HashMap<Integer, AutoMap<GT_Recipe>> mRecipeCompostCache = new HashMap();

    public static final void generateRecipes() {
        int i;
        for (i = 0; i < 10; ++i) {
            RecipeLoader_AlgaeFarm.getTieredRecipeFromCache(i, false);
        }
        for (i = 0; i < 10; ++i) {
            RecipeLoader_AlgaeFarm.getTieredRecipeFromCache(i, true);
        }
    }

    public static GT_Recipe getTieredRecipeFromCache(int aTier, boolean aCompost) {
        HashMap<Integer, AutoMap<GT_Recipe>> aMap = aCompost ? mRecipeCompostCache : mRecipeCache;
        String aComp = aCompost ? "(Compost)" : "";
        AutoMap<Object> aTemp = aMap.get(aTier);
        if (aTemp == null || aTemp.isEmpty()) {
            aTemp = new AutoMap();
            aMap.put(aTier, aTemp);
            Logger.INFO("Tier " + aTier + aComp + " had no recipes, initialising new map.");
        }
        if (aTemp.size() < 500) {
            Logger.INFO("Tier " + aTier + aComp + " has less than 500 recipes, generating " + (500 - aTemp.size()) + ".");
            for (int i = aTemp.size(); i < 500; ++i) {
                aTemp.put(RecipeLoader_AlgaeFarm.generateBaseRecipe(aCompost, aTier));
            }
        }
        int aIndex = MathUtils.randInt(0, aTemp.isEmpty() ? 1 : aTemp.size());
        Logger.INFO("Using recipe with index of " + aIndex + ". " + aComp);
        return (GT_Recipe)aTemp.get(aIndex);
    }

    private static GT_Recipe generateBaseRecipe(boolean aUsingCompost, int aTier) {
        if (aTier < 0) {
            return null;
        }
        WeightedCollection<Float> aOutputTimeMulti = new WeightedCollection<Float>();
        for (int i = 100; i > 0; --i) {
            float aValue = 0.0f;
            aValue = i < 10 ? 3.0f : (i < 20 ? 2.0f : 1.0f);
            aOutputTimeMulti.put(i, Float.valueOf(aValue));
        }
        int[] aDurations = new int[]{432000, 378000, 216000, 162000, 108000, 81000, 54000, 40500, 27000, 20250, 13500, 6750, 3375, 1686, 843, 421};
        ItemStack[] aInputs = new ItemStack[]{};
        if (aUsingCompost) {
            ItemStack aCompost = ItemUtils.getSimpleStack(AgriculturalChem.mCompost, aTier * 4);
            aInputs = new ItemStack[]{aCompost};
            ++aTier;
        }
        ItemStack[] aOutputs = RecipeLoader_AlgaeFarm.getOutputsForTier(aTier);
        GTPP_Recipe tRecipe = new GTPP_Recipe(false, aInputs, aOutputs, null, new int[0], new FluidStack[]{GT_Values.NF}, new FluidStack[]{GT_Values.NF}, (int)((float)aDurations[aTier] * ((Float)aOutputTimeMulti.get()).floatValue() / 2.0f), 0, 0);
        tRecipe.mSpecialValue = tRecipe.hashCode();
        return tRecipe;
    }

    private static ItemStack[] getOutputsForTier(int aTier) {
        AutoMap<ItemStack> aOutputMap = new AutoMap<ItemStack>();
        for (int i = 0; i < MathUtils.randInt(4, 8); ++i) {
            if (aTier >= 0) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, MathUtils.randInt(16, 32)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, MathUtils.randInt(32, 64)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(8, 16)));
                }
            }
            if (aTier >= 1) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, MathUtils.randInt(16, 32)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(16, 32)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(4, 8)));
                }
            }
            if (aTier >= 2) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(8, 16)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(16, 32)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(4, 8)));
                }
            }
            if (aTier >= 3) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, MathUtils.randInt(16, 32)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, MathUtils.randInt(2, 8)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, MathUtils.randInt(8, 16)));
                }
            }
            if (aTier >= 4) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, MathUtils.randInt(16, 32)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, MathUtils.randInt(32, 64)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, MathUtils.randInt(4, 8)));
                }
            }
            if (aTier >= 5) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, MathUtils.randInt(16, 32)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, MathUtils.randInt(16, 32)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, MathUtils.randInt(1, 2)));
                }
            }
            if (aTier >= 6) {
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, MathUtils.randInt(16, 32)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, MathUtils.randInt(8, 16)));
                if (MathUtils.randInt(0, 10) > 9) {
                    aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, MathUtils.randInt(8, 16)));
                }
            }
            for (int i2 = 0; i2 < 9 - aTier; ++i2) {
                if (aTier < 6 + i2) continue;
                int aMulti = i2 + 1;
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, MathUtils.randInt(4, 8 * aMulti)));
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, MathUtils.randInt(4, 8 * aMulti)));
                if (MathUtils.randInt(0, 10) <= 8) continue;
                aOutputMap.put(ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, MathUtils.randInt(8, 16 * aMulti)));
            }
        }
        ItemStack[] aOutputs = new ItemStack[aOutputMap.size()];
        for (int i = 0; i < aOutputMap.size(); ++i) {
            aOutputs[i] = (ItemStack)aOutputMap.get(i);
        }
        return aOutputs;
    }
}

