/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.misc;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.GT_Mod;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class AssLineAchievements {
    public static int assReg = -1;
    public static ConcurrentHashMap<String, Achievement> mAchievementMap;
    public static ConcurrentHashMap<String, Boolean> mIssuedAchievementMap;
    public static int adjX;
    public static int adjY;
    private static boolean active;
    private static boolean ready;
    private static int recipeTotal;
    private static int recipeCount;

    public AssLineAchievements() {
        Logger.INFO(active ? "Loading custom achievement page for Assembly Line recipes." : "Achievements are disabled.");
        Utils.registerEvent(this);
    }

    private static void init() {
        if (!ready) {
            active = GT_Mod.gregtechproxy.mAchievements;
            try {
                recipeTotal = ((GT_Recipe.GT_Recipe_Map)StaticFields59.mAssLineVisualMapNEI.get(null)).mRecipeList.size();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                recipeTotal = 0;
            }
            mAchievementMap = new ConcurrentHashMap();
            mIssuedAchievementMap = new ConcurrentHashMap();
            ready = true;
        }
    }

    public static void registerAchievements() {
        if (active && mAchievementMap.size() > 0) {
            AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("GT Assembly Line", mAchievementMap.values().toArray(new Achievement[mAchievementMap.size()])));
        } else if (active) {
            Logger.INFO("Unable to register custom achievement page for Assembly Line recipes.");
        }
    }

    public static Achievement registerAssAchievement(GT_Recipe recipe) {
        Achievement aYouDidSomethingInGT;
        String aSafeUnlocalName;
        AssLineAchievements.init();
        if (recipe == null) {
            Logger.INFO("Someone tried to register an achievement for an invalid recipe. Please report this to Alkalus.");
            return null;
        }
        if (recipe.getOutput(0) == null) {
            Logger.INFO("Someone tried to register an achievement for a recipe with null output. Please report this to Alkalus.");
            return null;
        }
        ItemStack aStack = recipe.getOutput(0);
        try {
            aSafeUnlocalName = aStack.func_77977_a();
        }
        catch (Throwable t) {
            aSafeUnlocalName = ItemUtils.getUnlocalizedItemName(aStack);
        }
        if (mAchievementMap.get(aSafeUnlocalName) == null) {
            ++recipeCount;
            aYouDidSomethingInGT = AssLineAchievements.registerAchievement(aSafeUnlocalName, -(11 + ++assReg % 5), assReg / 5 - 8, recipe.getOutput(0), AchievementList.field_76004_f, false);
        } else {
            aYouDidSomethingInGT = null;
        }
        if (recipeCount >= recipeTotal) {
            Logger.INFO("Critical mass achieved. [" + recipeCount + "]");
            AssLineAchievements.registerAchievements();
        }
        return aYouDidSomethingInGT;
    }

    public static Achievement registerAchievement(String textId, int x, int y, ItemStack icon, Achievement requirement, boolean special) {
        if (!GT_Mod.gregtechproxy.mAchievements) {
            return null;
        }
        Achievement achievement = new Achievement(textId, textId, adjX + x, adjY + y, icon, requirement);
        if (special) {
            achievement.func_75987_b();
        }
        achievement.func_75971_g();
        if (CORE.DEVENV) {
            GT_Log.out.println("achievement." + textId + "=");
            GT_Log.out.println("achievement." + textId + ".desc=");
        }
        mAchievementMap.put(textId, achievement);
        return achievement;
    }

    public static void issueAchievement(EntityPlayer entityplayer, String textId) {
        if (entityplayer == null || !GT_Mod.gregtechproxy.mAchievements) {
            return;
        }
        entityplayer.func_71029_a((StatBase)AssLineAchievements.getAchievement(textId));
    }

    public static Achievement getAchievement(String textId) {
        if (mAchievementMap.containsKey(textId)) {
            Logger.INFO("Found Achivement: " + textId);
            return mAchievementMap.get(textId);
        }
        return null;
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.entityPlayer;
        ItemStack stack = event.item.func_92059_d();
        String aPickupUnlocalSafe = ItemUtils.getUnlocalizedItemName(stack);
        if (player == null || stack == null) {
            return;
        }
        if (StaticFields59.sAssemblylineVisualRecipes == null) {
            return;
        }
        Logger.INFO("Trying to check for achievements");
        if (player.field_71075_bZ.field_75098_d && aPickupUnlocalSafe.equals("gt.metaitem.01.32761")) {
            for (GT_Recipe recipe : StaticFields59.sAssemblylineVisualRecipes.mRecipeList) {
                AssLineAchievements.issueAchievement(player, recipe.getOutput(0).func_77977_a());
                recipe.mHidden = false;
            }
        }
        for (GT_Recipe recipe : StaticFields59.sAssemblylineVisualRecipes.mRecipeList) {
            if (recipe.getOutput(0) == null) {
                Logger.INFO("Someone tried to register an achievement for a recipe with null output. Please report this to Alkalus.");
                continue;
            }
            ItemStack aStack = recipe.getOutput(0);
            String aSafeUnlocalName = ItemUtils.getUnlocalizedItemName(aStack);
            if (!aSafeUnlocalName.equals(aPickupUnlocalSafe)) continue;
            AssLineAchievements.issueAchievement(player, aSafeUnlocalName);
            recipe.mHidden = false;
            Logger.INFO("FOUND: " + aSafeUnlocalName + " | " + aPickupUnlocalSafe);
        }
    }

    static {
        adjX = 5;
        adjY = 9;
        active = true;
        ready = false;
        recipeTotal = 0;
        recipeCount = 0;
    }
}

