/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGen_Plasma
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_Plasma(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        if (material.getPlasma() != null) {
            ItemStack aContainerItem;
            ItemStack aPlasmaCell = material.getPlasmaCell(1);
            ItemStack aCell = material.getCell(1);
            ItemStack itemStack = aContainerItem = GT_Utility.getFluidForFilledItem((ItemStack)aPlasmaCell, (boolean)true) == null ? GT_Utility.getContainerItem((ItemStack)aPlasmaCell, (boolean)true) : CI.emptyCells(1);
            if (ItemUtils.checkForInvalidItems(new ItemStack[]{aPlasmaCell, aContainerItem})) {
                GT_Values.RA.addFuel(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aPlasmaCell}), aContainerItem, (int)Math.max(1024L, 1024L * material.getMass()), 4);
            }
            if (ItemUtils.checkForInvalidItems(new ItemStack[]{aCell, aPlasmaCell})) {
                GT_Values.RA.addVacuumFreezerRecipe(aPlasmaCell, aCell, (int)Math.max(material.getMass() * 2L, 1L));
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

