/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_DustGeneration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_Ore
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();
    private static Material mStone;

    public RecipeGen_Ore(Material M) {
        this(M, false);
    }

    public RecipeGen_Ore(Material M, boolean O) {
        this.toGenerate = M;
        this.disableOptional = O;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    /*
     * WARNING - void declaration
     */
    private void generateRecipes(Material material, boolean disableOptional) {
        ItemStack matDust;
        block74: {
            if (mStone == null) {
                mStone = MaterialUtils.generateMaterialFromGtENUM(Materials.Stone);
            }
            Logger.MATERIALS("[Recipe Generator Debug] [" + material.getLocalizedName() + "]");
            int tVoltageMultiplier = MaterialUtils.getVoltageForTier(material.vTier);
            ItemStack dustStone = ItemUtils.getItemStackOfAmountFromOreDict("dustStone", 1);
            Material bonusA = null;
            Material bonusB = null;
            bonusA = material.getComposites().size() >= 1 && material.getComposites().get(0) != null ? material.getComposites().get(0).getStackMaterial() : material;
            boolean allFailed = false;
            ArrayList<Material> aMatComp = new ArrayList<Material>();
            for (Material j : MaterialUtils.getCompoundMaterialsRecursively(material)) {
                aMatComp.add(j);
            }
            if (aMatComp.size() < 3) {
                while (aMatComp.size() < 3) {
                    aMatComp.add(material);
                }
            }
            AutoMap<Material> amJ = new AutoMap<Material>();
            boolean aIndexCounter = false;
            for (Material material2 : aMatComp) {
                if (!material2.hasSolidForm() || RecipeGen_Ore.getDust(material2) == null || RecipeGen_Ore.getTinyDust(material2) == null) continue;
                amJ.put(material2);
            }
            if (amJ.size() < 2) {
                if (material.getComposites().size() >= 2 && material.getComposites().get(1) != null) {
                    bonusB = material.getComposites().get(1).getStackMaterial();
                    if (!(bonusB.hasSolidForm() || material.getComposites().size() < 3 || material.getComposites().get(2) == null || (bonusB = material.getComposites().get(2).getStackMaterial()).hasSolidForm() || material.getComposites().size() < 4 || material.getComposites().get(3) == null || (bonusB = material.getComposites().get(3).getStackMaterial()).hasSolidForm() || material.getComposites().size() < 5 || material.getComposites().get(4) == null || (bonusB = material.getComposites().get(4).getStackMaterial()).hasSolidForm())) {
                        allFailed = true;
                        bonusB = mStone;
                    }
                } else {
                    allFailed = true;
                }
            } else {
                bonusA = (Material)amJ.get(0);
                bonusB = (Material)amJ.get(1);
            }
            if (bonusA == null) {
                Material material3 = bonusA = tVoltageMultiplier > 100 ? material : mStone;
            }
            if (allFailed || bonusB == null) {
                bonusB = tVoltageMultiplier > 100 ? material : mStone;
            }
            AutoMap<Pair<Integer, Material>> componentMap = new AutoMap<Pair<Integer, Material>>();
            for (MaterialStack r : material.getComposites()) {
                if (r == null) continue;
                componentMap.put(new Pair<Integer, Material>(r.getPartsPerOneHundred(), r.getStackMaterial()));
            }
            if (bonusA == null || bonusB == null || !bonusA.hasSolidForm() || !bonusB.hasSolidForm()) {
                if (bonusA == null) {
                    bonusA = mStone;
                }
                if (bonusB == null) {
                    bonusB = mStone;
                }
                if (!bonusA.hasSolidForm()) {
                    bonusA = mStone;
                }
                if (!bonusB.hasSolidForm()) {
                    bonusB = mStone;
                }
            }
            ItemStack itemStack = RecipeGen_Ore.getTinyDust(bonusA);
            ItemStack tinyDustB = RecipeGen_Ore.getTinyDust(bonusB);
            matDust = RecipeGen_Ore.getDust(material);
            ItemStack matDustA = RecipeGen_Ore.getDust(bonusA);
            ItemStack matDustB = RecipeGen_Ore.getDust(bonusB);
            if (ItemUtils.checkForInvalidItems(material.getSmallDust(1)) && ItemUtils.checkForInvalidItems(material.getTinyDust(1))) {
                RecipeGen_DustGeneration.generatePackagerRecipes(material);
            }
            if (GT_Values.RA.addPulveriserRecipe(material.getOre(1), new ItemStack[]{material.getCrushed(2)}, new int[]{10000}, 400, tVoltageMultiplier / 2)) {
                Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate ore to Crushed ore'");
            }
            if (GT_Values.RA.addPulveriserRecipe(material.getCrushed(1), new ItemStack[]{material.getDustImpure(1), matDustA}, new int[]{10000, 1000}, 400, tVoltageMultiplier / 2)) {
                Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Crushed ore to Impure Dust'");
            }
            if (GT_Values.RA.addPulveriserRecipe(material.getCrushedPurified(1), new ItemStack[]{material.getDustPurified(1), matDustA}, new int[]{10000, 1000}, 400, tVoltageMultiplier / 2)) {
                Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Washed ore to Purified Dust'");
            }
            if (GT_Values.RA.addPulveriserRecipe(material.getCrushedCentrifuged(1), new ItemStack[]{matDust, matDustA}, new int[]{10000, 1000}, 400, tVoltageMultiplier / 2)) {
                Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Centrifuged ore to Pure Dust'");
            }
            if (GT_ModHandler.addOreWasherRecipe((ItemStack)material.getCrushed(1), (int)1000, (Object[])new Object[]{material.getCrushedPurified(1), itemStack, dustStone})) {
                Logger.MATERIALS("[OreWasher] Added Recipe: 'Wash Crushed ore into Purified Crushed ore'");
            }
            Logger.MATERIALS("material.getCrushed(1): " + (material.getCrushed(1) != null));
            Logger.MATERIALS("material.getCrushedPurified(1): " + (material.getCrushedPurified(1) != null));
            Logger.MATERIALS("material.getTinyDust(1): " + ItemUtils.getItemName(bonusA.getCrushed(1)));
            Logger.MATERIALS("material.getTinyDust(1): " + ItemUtils.getItemName(bonusB.getCrushed(1)));
            try {
                if (GT_ModHandler.addThermalCentrifugeRecipe((ItemStack)material.getCrushed(1), (int)((int)Math.min(5000L, Math.abs(material.getMass() * 20L))), (Object[])new Object[]{material.getCrushedCentrifuged(1), tinyDustB, dustStone})) {
                    Logger.MATERIALS("[ThermalCentrifuge] Added Recipe: 'Crushed ore to Centrifuged Ore' | Input: " + material.getCrushed(1).func_82833_r() + " | Outputs: " + material.getCrushedCentrifuged(1).func_82833_r() + ", " + tinyDustB.func_82833_r() + ", " + dustStone.func_82833_r() + ".");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (GT_ModHandler.addThermalCentrifugeRecipe((ItemStack)material.getCrushedPurified(1), (int)((int)Math.min(5000L, Math.abs(material.getMass() * 20L))), (Object[])new Object[]{material.getCrushedCentrifuged(1), itemStack, dustStone})) {
                    Logger.MATERIALS("[ThermalCentrifuge] Added Recipe: 'Washed ore to Centrifuged Ore' | Input: " + material.getCrushedPurified(1).func_82833_r() + " | Outputs: " + material.getCrushedCentrifuged(1).func_82833_r() + ", " + itemStack.func_82833_r() + ", " + dustStone.func_82833_r() + ".");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (GT_Values.RA.addForgeHammerRecipe(material.getCrushedCentrifuged(1), matDust, 10, tVoltageMultiplier / 4)) {
                Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Crushed Centrifuged to Pure Dust'");
            }
            if (GT_Values.RA.addForgeHammerRecipe(material.getCrushedPurified(1), material.getDustPurified(1), 10, tVoltageMultiplier / 4)) {
                Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Crushed Purified to Purified Dust'");
            }
            if (GT_Values.RA.addForgeHammerRecipe(material.getOre(1), material.getCrushed(1), 10, tVoltageMultiplier / 4)) {
                Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Ore to Crushed'");
            }
            if (GT_Values.RA.addCentrifugeRecipe(material.getDustPurified(1), null, null, null, matDust, itemStack, null, null, null, null, new int[]{10000, 10000}, (int)Math.max(1L, material.getMass() * 8L), tVoltageMultiplier / 2)) {
                Logger.MATERIALS("[Centrifuge] Added Recipe: Purified Dust to Clean Dust");
            }
            if (GT_Values.RA.addCentrifugeRecipe(material.getDustImpure(1), null, null, null, matDust, tinyDustB, null, null, null, null, new int[]{10000, 10000}, (int)Math.max(1L, material.getMass() * 8L), tVoltageMultiplier / 2)) {
                Logger.MATERIALS("[Centrifuge] Added Recipe: Inpure Dust to Clean Dust");
            }
            if (!disableOptional) {
                int mCellCount;
                int[] mChances;
                ItemStack[] mInternalOutputs;
                if (componentMap.size() > 0 && componentMap.size() <= 6) {
                    ItemStack itemStack2;
                    mInternalOutputs = new ItemStack[6];
                    mChances = new int[6];
                    mCellCount = 0;
                    int mTotalCount = 0;
                    int mCounter = 0;
                    for (Pair pair : componentMap) {
                        if (((Material)pair.getValue()).getState() != MaterialState.SOLID) {
                            Logger.MATERIALS("[Electrolyzer] Found Fluid Component, adding " + pair.getKey() + " cells of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                            mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getCell((Integer)pair.getKey());
                            mTotalCount += ((Integer)pair.getKey()).intValue();
                            Logger.MATERIALS("[Electrolyzer] In total, adding " + (mCellCount += ((Integer)pair.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                            continue;
                        }
                        Logger.MATERIALS("[Electrolyzer] Found Solid Component, adding " + pair.getKey() + " dusts of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getDust((Integer)pair.getKey());
                        mTotalCount += ((Integer)pair.getKey()).intValue();
                    }
                    for (int g = 0; g < mInternalOutputs.length; ++g) {
                        Logger.MATERIALS("[Electrolyzer] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                        mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                    }
                    ItemStack emptyCell = null;
                    if (mCellCount > 0) {
                        emptyCell = ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", mCellCount);
                        Logger.MATERIALS("[Electrolyzer] Recipe now requires " + mCellCount + " empty cells as input.");
                    }
                    if ((itemStack2 = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                        Logger.MATERIALS("[Electrolyzer] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + itemStack2.func_82833_r() + " as input.");
                    } else {
                        ItemStack itemStack3 = material.getDust(mTotalCount);
                        Logger.MATERIALS("[Electrolyzer] Could not find valid input dust, trying alternative.");
                        if (itemStack3 != null) {
                            Logger.MATERIALS("[Electrolyzer] Recipe now requires " + mTotalCount + "x " + itemStack3.func_82833_r() + " as input.");
                        } else {
                            Logger.MATERIALS("[Electrolyzer] Could not find valid input dust, exiting.");
                        }
                    }
                    for (int j = 0; j < mInternalOutputs.length; ++j) {
                        if (mInternalOutputs[j] == null) {
                            mInternalOutputs[j] = GT_Values.NI;
                            Logger.MATERIALS("[Electrolyzer] Set slot " + j + "  to null.");
                            continue;
                        }
                        Logger.MATERIALS("[Electrolyzer] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                    }
                    try {
                        void var23_39;
                        if (RecipeGen_Ore.addElectrolyzerRecipe((ItemStack)var23_39, emptyCell, null, null, mInternalOutputs[0], mInternalOutputs[1], mInternalOutputs[2], mInternalOutputs[3], mInternalOutputs[4], mInternalOutputs[5], mChances, (int)Math.max(material.getMass() * 3L * 1L, 1L), tVoltageMultiplier)) {
                            Logger.MATERIALS("[Electrolyzer] Generated Electrolyzer recipe for " + matDust.func_82833_r());
                            break block74;
                        }
                        Logger.MATERIALS("[Electrolyzer] Failed to generate Electrolyzer recipe for " + matDust.func_82833_r());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else if (componentMap.size() > 6 && componentMap.size() <= 9) {
                    ItemStack itemStack4;
                    Logger.MATERIALS("[Issue][Electrolyzer] " + material.getLocalizedName() + " is composed of over 6 materials, so an electrolyzer recipe for processing cannot be generated. Trying to create one for the Dehydrator instead.");
                    mInternalOutputs = new ItemStack[9];
                    mChances = new int[9];
                    mCellCount = 0;
                    int mTotalCount = 0;
                    int mCounter = 0;
                    for (Pair pair : componentMap) {
                        if (((Material)pair.getValue()).getState() != MaterialState.SOLID && ((Material)pair.getValue()).getState() != MaterialState.ORE) {
                            Logger.MATERIALS("[Dehydrator] Found Fluid Component, adding " + pair.getKey() + " cells of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                            mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getCell((Integer)pair.getKey());
                            mTotalCount += ((Integer)pair.getKey()).intValue();
                            Logger.MATERIALS("[Dehydrator] In total, adding " + (mCellCount += ((Integer)pair.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                            continue;
                        }
                        Logger.MATERIALS("[Dehydrator] Found Solid Component, adding " + pair.getKey() + " dusts of " + ((Material)pair.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)pair.getValue()).getDust((Integer)pair.getKey());
                        mTotalCount += ((Integer)pair.getKey()).intValue();
                    }
                    for (int g = 0; g < mInternalOutputs.length; ++g) {
                        Logger.MATERIALS("[Dehydrator] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                        mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                    }
                    ItemStack emptyCell = null;
                    if (mCellCount > 0) {
                        emptyCell = ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", mCellCount);
                        Logger.MATERIALS("[Dehydrator] Recipe now requires " + mCellCount + " empty cells as input.");
                    }
                    if ((itemStack4 = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                        Logger.MATERIALS("[Dehydrator] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + itemStack4.func_82833_r() + " as input.");
                    } else {
                        ItemStack itemStack5 = material.getDust(mTotalCount);
                        Logger.MATERIALS("[Dehydrator] Could not find valid input dust, trying alternative.");
                        if (itemStack5 != null) {
                            Logger.MATERIALS("[Dehydrator] Recipe now requires " + mTotalCount + "x " + itemStack5.func_82833_r() + " as input.");
                        } else {
                            Logger.MATERIALS("[Dehydrator] Could not find valid input dust, exiting.");
                        }
                    }
                    for (int j = 0; j < mInternalOutputs.length; ++j) {
                        if (mInternalOutputs[j] == null) {
                            mInternalOutputs[j] = GT_Values.NI;
                            Logger.MATERIALS("[Dehydrator] Set slot " + j + "  to null.");
                            continue;
                        }
                        Logger.MATERIALS("[Dehydrator] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                    }
                    try {
                        void var23_43;
                        if (CORE.RA.addDehydratorRecipe(new ItemStack[]{var23_43, emptyCell}, null, null, mInternalOutputs, mChances, (int)Math.max(material.getMass() * 4L * 1L, 1L), tVoltageMultiplier)) {
                            Logger.MATERIALS("[Dehydrator] Generated Dehydrator recipe for " + matDust.func_82833_r());
                            Logger.MATERIALS("Inputs: " + var23_43.func_82833_r() + " x" + var23_43.field_77994_a + ", " + (emptyCell == null ? "No Cells" : "" + emptyCell.func_82833_r() + " x" + emptyCell.field_77994_a));
                            Logger.MATERIALS("Outputs " + ItemUtils.getArrayStackNames(mInternalOutputs));
                            Logger.MATERIALS("Time: " + (int)Math.max(material.getMass() * 4L * 1L, 1L));
                            Logger.MATERIALS("EU: " + tVoltageMultiplier);
                        } else {
                            Logger.MATERIALS("[Dehydrator] Failed to generate Dehydrator recipe for " + matDust.func_82833_r());
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        RecipeUtils.addShapedRecipe(CI.craftingToolHammer_Hard, null, null, material.getCrushedPurified(1), null, null, null, null, null, material.getDustPurified(1));
        RecipeUtils.addShapedRecipe(CI.craftingToolHammer_Hard, null, null, material.getCrushed(1), null, null, null, null, null, material.getDustImpure(1));
        RecipeUtils.addShapedRecipe(CI.craftingToolHammer_Hard, null, null, material.getCrushedCentrifuged(1), null, null, null, null, null, matDust);
        ItemStack normalDust = matDust;
        ItemStack smallDust = material.getSmallDust(1);
        ItemStack tinyDust = material.getTinyDust(1);
        if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
            Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, material.getTinyDust(9))) {
            Logger.WARNING("9 Tiny dust from 1 Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("9 Tiny dust from 1 Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
            Logger.WARNING("4 Small dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("4 Small dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, material.getSmallDust(4))) {
            Logger.WARNING("4 Small dust from 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("4 Small dust from 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
    }

    public static boolean addElectrolyzerRecipe(ItemStack aInput1, ItemStack aInput2, FluidStack aFluidInput, FluidStack aFluidOutput, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, ItemStack aOutput5, ItemStack aOutput6, int[] aChances, int aDuration, int aEUt) {
        if (aInput1 == null && aFluidInput == null || aOutput1 == null && aFluidOutput == null) {
            Logger.MATERIALS("[Electrolyzer] Either both inputs or outputs are null.");
            return false;
        }
        if (aInput1 != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"electrolyzer", aInput1, aDuration)) <= 0) {
            Logger.MATERIALS("[Electrolyzer] Fail 1.");
            return false;
        }
        if (aFluidInput != null && (aDuration = GregTech_API.sRecipeFile.get((Object)"electrolyzer", aFluidInput.getFluid().getName(), aDuration)) <= 0) {
            Logger.MATERIALS("[Electrolyzer] Fail 2.");
            return false;
        }
        GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.addRecipe(true, new ItemStack[]{aInput1, aInput2}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4, aOutput5, aOutput6}, null, aChances, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        Logger.MATERIALS("[Electrolyzer] Recipe added.");
        return true;
    }

    public static ItemStack getTinyDust(Material m) {
        ItemStack x = m.getTinyDust(1);
        if (x == null) {
            x = mStone.getDust(1);
        }
        return x;
    }

    public static ItemStack getDust(Material m) {
        ItemStack x = m.getDust(1);
        if (x == null) {
            x = mStone.getDust(1);
        }
        return x;
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

