/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_FluidCanning
implements Runnable {
    private static boolean mHasRun = false;
    private static HashSet<RecipeGen_FluidCanning> mCache = new HashSet();
    protected boolean disableOptional;
    private final GT_Recipe recipe;
    private final boolean isValid;

    public static void init() {
        FluidCanningRunnableHandler x = new FluidCanningRunnableHandler();
        x.run();
    }

    private static void addRunnableToRecipeCache(RecipeGen_FluidCanning r) {
        if (mHasRun) {
            CORE.crash();
        }
        mCache.add(r);
    }

    public boolean valid() {
        return this.isValid;
    }

    public RecipeGen_FluidCanning(boolean aExtracting, ItemStack aEmpty, ItemStack aFull, FluidStack aFluid) {
        this(aExtracting, aEmpty, aFull, aFluid, GT_Values.NF, null, null);
    }

    public RecipeGen_FluidCanning(boolean aExtracting, ItemStack aEmpty, ItemStack aFull, FluidStack aFluidIn, FluidStack aFluidOut) {
        this(aExtracting, aEmpty, aFull, aFluidIn, aFluidOut, null, null);
    }

    public RecipeGen_FluidCanning(boolean aExtracting, ItemStack aEmpty, ItemStack aFull, FluidStack aFluid, Integer aDuration, Integer aEUt) {
        this(aExtracting, aEmpty, aFull, aFluid, GT_Values.NF, aDuration, aEUt);
    }

    public RecipeGen_FluidCanning(boolean aExtracting, ItemStack aEmpty, ItemStack aFull, FluidStack aFluidIn, FluidStack aFluidOut, Integer aDuration, Integer aEUt) {
        FluidStack aFluidOutput;
        FluidStack aFluidInput;
        ItemStack aOutput;
        ItemStack aInput;
        if (aDuration == null || aDuration <= 0) {
            aDuration = aFluidIn != null ? aFluidIn.amount / 62 : (aFluidOut != null ? aFluidOut.amount / 62 : 10);
        }
        if (aEUt == null || aEUt <= 0) {
            aEUt = aExtracting ? Integer.valueOf(2) : Integer.valueOf(1);
        }
        if (aExtracting) {
            aInput = aFull;
            aOutput = aEmpty;
            aFluidInput = GT_Values.NF;
            aFluidOutput = aFluidIn;
        } else {
            aInput = aEmpty;
            aOutput = aFull;
            aFluidInput = aFluidIn;
            aFluidOutput = aFluidOut != null ? aFluidOut : GT_Values.NF;
        }
        GTPP_Recipe aRecipe = new GTPP_Recipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{10000}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, aDuration, aEUt, 0);
        boolean aTempValidityCheck = false;
        if (aExtracting) {
            Logger.INFO("Extracting.");
            if (aInput != null && aFluidOutput != null) {
                aTempValidityCheck = true;
            }
        } else if (aInput != null && aOutput != null && (aFluidInput != null || aFluidOutput != null)) {
            aTempValidityCheck = true;
        }
        if (aTempValidityCheck) {
            this.recipe = aRecipe;
            this.disableOptional = aExtracting;
            this.isValid = true;
            RecipeGen_FluidCanning.addRunnableToRecipeCache(this);
        } else {
            this.isValid = false;
            this.disableOptional = aExtracting;
            aRecipe.mEnabled = false;
            aRecipe.mHidden = true;
            this.recipe = null;
        }
    }

    @Override
    public void run() {
        Logger.INFO("Processing Recipe with Hash: " + this.recipe.hashCode());
        this.generateRecipes();
    }

    private void generateRecipes() {
        if (this.isValid && this.recipe != null) {
            if (this.disableOptional) {
                this.addFluidExtractionRecipe(this.recipe);
            } else {
                this.addFluidCannerRecipe(this.recipe);
            }
        }
    }

    private final boolean addFluidExtractionRecipe(GT_Recipe aRecipe) {
        int aCount1;
        boolean result = false;
        CORE.crash();
        Logger.INFO("[FE-Debug] " + aRecipe.mFluidOutputs[0].amount + "L of " + aRecipe.mFluidOutputs[0].getLocalizedName() + " fluid extractor from 1 " + aRecipe.mInputs[0].func_82833_r() + " - Success. Time: " + aRecipe.mDuration + ", Voltage: " + aRecipe.mEUt);
        int aCount2 = aCount1 = GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes.mRecipeList.size();
        GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes.addRecipe(aRecipe);
        aCount1 = GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes.mRecipeList.size();
        boolean bl = result = aCount1 > aCount2;
        if (!result) {
            Logger.INFO("[ERROR] Failed adding Extraction recipe for " + ItemUtils.getArrayStackNames(aRecipe.mInputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mOutputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mFluidInputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mFluidOutputs));
            this.dumpStack();
        }
        return result;
    }

    private final boolean addFluidCannerRecipe(GT_Recipe aRecipe) {
        int aCount1;
        boolean result = false;
        int aCount2 = aCount1 = GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.mRecipeList.size();
        GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(aRecipe);
        aCount1 = GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.mRecipeList.size();
        boolean bl = result = aCount1 > aCount2;
        if (!result) {
            Logger.INFO("[ERROR] Failed adding Canning recipe for " + ItemUtils.getArrayStackNames(aRecipe.mInputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mOutputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mFluidInputs) + ", " + ItemUtils.getArrayStackNames(aRecipe.mFluidOutputs));
            this.dumpStack();
        }
        return result;
    }

    private void dumpStack() {
        int parents = 2;
        for (int i = 0; i < 6; ++i) {
            Logger.INFO((this.disableOptional ? "EXTRACTING" : "CANNING") + " DEBUG | " + (i == 0 ? "Called from: " : "Parent: ") + ReflectionUtils.getMethodName(i + parents));
        }
    }

    private String buildLogString() {
        int solidSize = this.getMapSize(GT_Recipe.GT_Recipe_Map.sCannerRecipes);
        int fluidSize = this.getMapSize(GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes);
        return (this.disableOptional ? "EXTRACTING" : "CANNING") + " DEBUG | Solids: " + solidSize + " | Liquids: " + fluidSize + " | ";
    }

    private final int getMapSize(GT_Recipe.GT_Recipe_Map aMap) {
        return aMap.mRecipeList.size();
    }

    private static class FluidCanningRunnableHandler
    implements RunnableWithInfo<String> {
        private FluidCanningRunnableHandler() {
        }

        @Override
        public void run() {
            mHasRun = true;
            for (RecipeGen_FluidCanning aRecipe : mCache) {
                aRecipe.run();
            }
        }

        @Override
        public String getInfoData() {
            return "Fluid Canning Recipes";
        }
    }
}

