/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_BlastSmelterGT_Ex
implements IOreRecipeRegistrator {
    private final OrePrefixes[] mSmeltingPrefixes;

    public RecipeGen_BlastSmelterGT_Ex() {
        for (OrePrefixes tPrefix : this.mSmeltingPrefixes = new OrePrefixes[]{OrePrefixes.crushed, OrePrefixes.ingot, OrePrefixes.crushedPurified, OrePrefixes.crushedCentrifuged, OrePrefixes.dust, OrePrefixes.dustPure, OrePrefixes.dustImpure, OrePrefixes.dustRefined, OrePrefixes.dustSmall, OrePrefixes.dustTiny}) {
            tPrefix.add((IOreRecipeRegistrator)this);
        }
    }

    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean keepHighTempRecipes = !CORE.GTNH;
        switch (aPrefix) {
            case dust: {
                ItemStack tDustStack;
                if ((keepHighTempRecipes || aMaterial.mBlastFurnaceTemp <= 3600) && null != (tDustStack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial.mSmeltInto, (long)1L)) && !aMaterial.contains(SubTag.NO_SMELTING) && aMaterial.mBlastFurnaceRequired) {
                    this.addBlastRecipe(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack}), null, null, null, aMaterial.mBlastFurnaceTemp > 1750 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial.mSmeltInto, (ItemStack)tDustStack, (long)1L) : GT_Utility.copyAmount((long)1L, (Object[])new Object[]{tDustStack}), null, (int)Math.max(aMaterial.getMass() / 40L, 1L) * aMaterial.mBlastFurnaceTemp, 120, aMaterial);
                    if (aMaterial.mBlastFurnaceTemp <= 1000) {
                        // empty if block
                    }
                }
            }
            case ingot: {
                ItemStack tDustStack;
                if (!keepHighTempRecipes && aMaterial.mBlastFurnaceTemp > 3600 || null == (tDustStack = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial.mSmeltInto, (long)1L)) || aMaterial.contains(SubTag.NO_SMELTING) || !aMaterial.mBlastFurnaceRequired) break;
                this.addBlastRecipe(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack}), null, null, null, aMaterial.mBlastFurnaceTemp > 1750 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial.mSmeltInto, (ItemStack)tDustStack, (long)1L) : GT_Utility.copyAmount((long)1L, (Object[])new Object[]{tDustStack}), null, (int)Math.max(aMaterial.getMass() / 40L, 1L) * aMaterial.mBlastFurnaceTemp, 120, aMaterial);
                break;
            }
            case dustSmall: {
                if (!keepHighTempRecipes && aMaterial.mBlastFurnaceTemp > 3600 || !aMaterial.mBlastFurnaceRequired) break;
                this.addBlastRecipe(GT_Utility.copyAmount((long)4L, (Object[])new Object[]{aStack}), null, null, null, aMaterial.mBlastFurnaceTemp > 1750 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial.mSmeltInto, (ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial.mSmeltInto, (long)1L), (long)1L) : GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial.mSmeltInto, (long)1L), null, (int)Math.max(aMaterial.getMass() / 40L, 1L) * aMaterial.mBlastFurnaceTemp, 120, aMaterial);
                break;
            }
            case dustTiny: {
                if (!keepHighTempRecipes && aMaterial.mBlastFurnaceTemp > 3600 || aMaterial.contains(SubTag.NO_SMELTING) || !aMaterial.mBlastFurnaceRequired) break;
                this.addBlastRecipe(GT_Utility.copyAmount((long)9L, (Object[])new Object[]{aStack}), null, null, null, aMaterial.mBlastFurnaceTemp > 1750 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial.mSmeltInto, (ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial.mSmeltInto, (long)1L), (long)1L) : GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial.mSmeltInto, (long)1L), null, (int)Math.max(aMaterial.getMass() / 40L, 1L) * aMaterial.mBlastFurnaceTemp, 120, aMaterial);
                break;
            }
            default: {
                if (!keepHighTempRecipes && aMaterial.mBlastFurnaceTemp > 3600 || aMaterial.contains(SubTag.NO_SMELTING) || !aMaterial.mBlastFurnaceRequired && !aMaterial.mDirectSmelting.mBlastFurnaceRequired) break;
                this.addBlastRecipe(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack}), null, null, null, aMaterial.mBlastFurnaceTemp > 1750 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingotHot, (Object)aMaterial, (ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial, (long)1L), (long)1L) : GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)aMaterial, (long)1L), null, (int)Math.max(aMaterial.getMass() / 4L, 1L) * aMaterial.mBlastFurnaceTemp, 120, aMaterial);
            }
        }
    }

    public boolean addBlastRecipe(ItemStack input1, ItemStack input2, FluidStack fluid1, FluidStack fluid2, ItemStack output1, ItemStack output2, int time, int euCost, Materials smeltInto) {
        int count = 0;
        if (smeltInto == Materials._NULL) {
            return false;
        }
        if (input1 != null && input2 != null) {
            count = 2;
        } else {
            if (input1 == null && input2 == null) {
                return false;
            }
            count = 1;
        }
        ItemStack configCircuit = ItemUtils.getGregtechCircuit(count);
        ItemStack[] components = new ItemStack[]{configCircuit, input1, input2};
        if (fluid1 != null || fluid2 != null) {
            if (fluid1 != null && fluid2 != null) {
                return false;
            }
            FluidStack mInputfluidstack = fluid1 != null ? fluid1 : fluid2;
            return CORE.RA.addBlastSmelterRecipe(components, mInputfluidstack, smeltInto.mSmeltInto.getMolten(144L), 100, MathUtils.roundToClosestInt((double)time * 0.8), euCost);
        }
        return CORE.RA.addBlastSmelterRecipe(components, smeltInto.mSmeltInto.getMolten(144L), 100, MathUtils.roundToClosestInt((double)time * 0.8), euCost);
    }
}

