/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage.shelving;

import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull_NonElectric;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT4Entity_Shelf
extends GT_MetaTileEntity_BasicHull_NonElectric {
    public byte mType = 0;
    public String mOldDesc = "";
    public boolean mLocked = false;
    protected byte mIndex = (byte)MathUtils.randInt(1, 3);
    public static GT_RenderedTexture texBottom = new GT_RenderedTexture((IIconContainer)new TexturesGtBlock.CustomIcon("TileEntities/gt4/machine_bottom"));
    public static GT_RenderedTexture texTop = new GT_RenderedTexture((IIconContainer)new TexturesGtBlock.CustomIcon("TileEntities/gt4/machine_top"));
    public static GT_RenderedTexture texSide = new GT_RenderedTexture((IIconContainer)new TexturesGtBlock.CustomIcon("TileEntities/gt4/machine_side"));
    public static GT_RenderedTexture texSideCabinet = new GT_RenderedTexture((IIconContainer)new TexturesGtBlock.CustomIcon("TileEntities/gt4/machine_side_cabinet"));
    private static GT_RenderedTexture x1 = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.OVERLAY_WOODEN_SHELF_FRONT);
    private static GT_RenderedTexture x2 = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.OVERLAY_WOODEN_SHELF_PAPER_FRONT);
    private static GT_RenderedTexture x3 = new GT_RenderedTexture((IIconContainer)TexturesGtBlock.OVERLAY_WOODEN_SHELF_CANS_FRONT);

    public GT4Entity_Shelf(int aID, String aName, String aNameRegional, String aDescription) {
        super(aID, aName, aNameRegional, 0, aDescription);
        this.mOldDesc = aDescription;
    }

    public GT4Entity_Shelf(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 0, aDescription, aTextures);
        this.mOldDesc = aDescription;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public int getInvSize() {
        return 1;
    }

    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        if (this.getBaseMetaTileEntity().getOwnerName().equalsIgnoreCase(aPlayer.getDisplayName())) {
            return true;
        }
        PlayerUtils.messagePlayer(aPlayer, "This container belongs to " + this.getBaseMetaTileEntity().getOwnerName() + ".");
        return false;
    }

    public boolean ownerControl() {
        return false;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isInputFacing(byte aSide) {
        return false;
    }

    public boolean onRightclick(IGregTechTileEntity aTile, EntityPlayer aPlayer) {
        if (aTile.isClientSide()) {
            return true;
        }
        ItemStack tStack = aPlayer.field_71071_by.func_70301_a(aPlayer.field_71071_by.field_70461_c);
        if (tStack == null) {
            if (KeyboardUtils.isCtrlKeyDown()) {
                if (this.mInventory[0] != null) {
                    PlayerUtils.messagePlayer(aPlayer, "Contains " + this.mInventory[0].func_82833_r() + " x" + this.mInventory[0].field_77994_a + ".");
                }
                return false;
            }
            if (this.mInventory[0] != null && this.mInventory[0].field_77994_a > 0) {
                if (!this.mLocked) {
                    PlayerUtils.messagePlayer(aPlayer, "Removed " + this.mInventory[0].func_82833_r() + " x" + this.mInventory[0].field_77994_a + ".");
                    aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, this.mInventory[0]);
                    this.getBaseMetaTileEntity().func_70299_a(0, null);
                    this.mType = 0;
                    return true;
                }
                PlayerUtils.messagePlayer(aPlayer, "This container is locked. It belongs to " + aTile.getOwnerName() + ".");
                return false;
            }
            return false;
        }
        if (tStack != null && this.mInventory[0] == null) {
            if (KeyboardUtils.isCtrlKeyDown() || GT_MetaGenerated_Tool_01.class.isInstance(tStack.func_77973_b())) {
                return false;
            }
            PlayerUtils.messagePlayer(aPlayer, "Stored " + tStack.func_82833_r() + " x" + tStack.field_77994_a + ".");
            aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, null);
            this.getBaseMetaTileEntity().func_70299_a(0, tStack);
            this.mType = (byte)MathUtils.randInt(1, 3);
            return true;
        }
        if (this.mInventory[0] == null) {
            this.mType = 0;
        }
        return super.onRightclick(aTile, aPlayer);
    }

    public void onLeftclick(IGregTechTileEntity aTile, EntityPlayer aPlayer) {
        if (this.mInventory[0] != null && this.mInventory[0].field_77994_a > 0) {
            ItemStack tOutput = GT_Utility.copy((Object[])new Object[]{this.mInventory[0]});
            if (!aPlayer.func_70093_af()) {
                tOutput.field_77994_a = 1;
            }
            this.getBaseMetaTileEntity().func_70298_a(0, tOutput.field_77994_a);
            EntityItem tEntity = new EntityItem(this.getBaseMetaTileEntity().getWorld(), (double)this.getBaseMetaTileEntity().getOffsetX(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, (double)this.getBaseMetaTileEntity().getOffsetY(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, (double)this.getBaseMetaTileEntity().getOffsetZ(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, tOutput);
            tEntity.field_70159_w = 0.0;
            tEntity.field_70181_x = 0.0;
            tEntity.field_70179_y = 0.0;
            this.getBaseMetaTileEntity().getWorld().func_72838_d((Entity)tEntity);
            if (this.mInventory[0] == null) {
                this.mType = 0;
            }
        }
        super.onLeftclick(aTile, aPlayer);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT4Entity_Shelf(this.mName, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mType", (int)this.mType);
        aNBT.func_74757_a("mLocked", this.mLocked);
        aNBT.func_74774_a("mIndex", this.mIndex);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mIndex")) {
            this.mType = (byte)aNBT.func_74762_e("mType");
        }
        if (aNBT.func_74764_b("mIndex")) {
            this.mLocked = aNBT.func_74767_n("mLocked");
        }
        if (aNBT.func_74764_b("mIndex")) {
            this.mIndex = aNBT.func_74771_c("mIndex");
        }
    }

    public void onValueUpdate(byte aValue) {
        this.mType = aValue;
    }

    public byte getUpdateData() {
        return this.mType;
    }

    public String[] getDescription() {
        return new String[]{this.mOldDesc, "Decorative Item Storage", "Right click to store/remove something", "Ctrl + Rmb to check contents", "Ctrl + Rmb with a screwdriver to lock"};
    }

    public byte getTileEntityBaseType() {
        return 0;
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity p0, int p1, byte p2, ItemStack p3) {
        return true;
    }

    public boolean allowPutStack(IGregTechTileEntity p0, int p1, byte p2, ItemStack p3) {
        return false;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[7][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            ITexture[] tmp0 = new ITexture[]{this.getBottom((byte)0)[0]};
            rTextures[0][i + 1] = tmp0;
            ITexture[] tmp1 = new ITexture[]{this.getTop((byte)0)[0]};
            rTextures[1][i + 1] = tmp1;
            ITexture[] tmp2 = new ITexture[]{this.getSides((byte)0)[0]};
            rTextures[2][i + 1] = tmp2;
            ITexture[] tmp4 = new ITexture[]{this.getSides((byte)0)[0]};
            rTextures[3][i + 1] = tmp4;
            ITexture[] tmp5 = new ITexture[]{this.getSides((byte)0)[0], this.getFront((byte)0)[0]};
            rTextures[4][i + 1] = tmp5;
            ITexture[] tmp6 = new ITexture[]{this.getSides((byte)0)[0], this.getFront((byte)1)[0]};
            rTextures[5][i + 1] = tmp6;
            ITexture[] tmp7 = new ITexture[]{this.getSides((byte)0)[0], this.getFront((byte)2)[0]};
            rTextures[6][i + 1] = tmp7;
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] tmp = this.mTextures[aSide >= 2 ? (aSide != aFacing ? 2 : (this.mType == 0 ? 4 : (this.mType == 1 || this.mType == 2 ? 5 : (this.mType == 3 ? 6 : 0)))) : aSide][aColorIndex + 1];
        if (aSide != aFacing && tmp.length == 2) {
            tmp = new ITexture[]{tmp[0]};
        }
        return tmp;
    }

    public ITexture[] getFrontNormal() {
        return new ITexture[]{x1};
    }

    public ITexture[] getFrontActive() {
        return new ITexture[]{x2};
    }

    public ITexture[] getFrontAlternative() {
        return new ITexture[]{x3};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.VanillaIcon_OakPlanks)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Acacia_Log)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.VanillaIcon_OakPlanks)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.VanillaIcon_OakPlanks)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFrontNormal();
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public ITexture[] getFront(byte aColour) {
        if (aColour == 1) {
            return this.getFrontActive();
        }
        if (aColour == 2) {
            return this.getFrontAlternative();
        }
        return this.getFrontNormal();
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (KeyboardUtils.isCtrlKeyDown()) {
            if (!aPlayer.getDisplayName().equalsIgnoreCase(this.getBaseMetaTileEntity().getOwnerName())) {
                PlayerUtils.messagePlayer(aPlayer, "Container is not yours to lock.");
            } else {
                this.mLocked = Utils.invertBoolean(this.mLocked);
                if (this.mLocked) {
                    PlayerUtils.messagePlayer(aPlayer, "Container is now locked.");
                } else {
                    PlayerUtils.messagePlayer(aPlayer, "Container is now unlocked.");
                }
            }
        } else {
            super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        }
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }
}

