/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_TieredTank
extends GT_MetaTileEntity_BasicTank {
    public GT_MetaTileEntity_TieredTank(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "Stores " + (int)(Math.pow(2.0, aTier) * 32000.0) + "L of fluid", new ITexture[0]);
    }

    public GT_MetaTileEntity_TieredTank(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, "Stores " + (int)(Math.pow(2.0, aTier) * 32000.0) + "L of fluid", aTextures);
    }

    public String[] getDescription() {
        String aTankPortableness = "portable";
        String[] aTip = this.mFluid == null ? new String[]{this.mDescription, "A " + aTankPortableness + " tank.", CORE.GT_Tooltip} : new String[]{this.mDescription, "A " + aTankPortableness + " tank.", "Fluid: " + this.mFluid.getLocalizedName() + " " + this.mFluid.amount + "L", CORE.GT_Tooltip};
        return aTip;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aSide == 1) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER_ACTIVE);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_POTIONBREWER);
        }
        return iTextureArray;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public final byte getUpdateData() {
        return 0;
    }

    public boolean doesFillContainers() {
        return true;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return true;
    }

    public String[] getInfoData() {
        if (this.mFluid == null) {
            return new String[]{GT_Values.VOLTAGE_NAMES[this.mTier] + " Fluid Tank", "Stored Fluid:", "No Fluid", Integer.toString(0) + "L", Integer.toString(this.getCapacity()) + "L"};
        }
        return new String[]{GT_Values.VOLTAGE_NAMES[this.mTier] + " Fluid Tank", "Stored Fluid:", this.mFluid.getLocalizedName(), Integer.toString(this.mFluid.amount) + "L", Integer.toString(this.getCapacity()) + "L"};
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TieredTank(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public int getCapacity() {
        return (int)(Math.pow(2.0, this.mTier) * 32000.0);
    }

    public int getTankPressure() {
        return 100;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public boolean displaysItemStack() {
        return true;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (CORE.NBT_PERSISTENCY_PATCH_APPLIED && this.mFluid != null) {
            Logger.WARNING("Setting item fluid nbt");
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
            if (aNBT.func_74764_b("mFluid")) {
                Logger.WARNING("Set mFluid to NBT.");
            }
        }
    }
}

