/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IRedstoneCircuitBlock;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_CircuitryBehavior;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.xmod.gregtech.api.gui.computer.GT_Container_RedstoneCircuitBlock;
import gtPlusPlus.xmod.gregtech.api.gui.computer.GT_GUIContainer_RedstoneCircuitBlock;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.GT_MetaTileEntity_RedstoneBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class GT_MetaTileEntity_RedstoneCircuitBlock
extends GT_MetaTileEntity_RedstoneBase
implements IRedstoneCircuitBlock {
    public int mGate = 0;
    public int[] mGateData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public boolean bOutput = true;
    public static final Map<Integer, ItemStack> sCoversItems = new HashMap<Integer, ItemStack>();

    public GT_MetaTileEntity_RedstoneCircuitBlock(int aID) {
        super(aID, "redstone.circuit", "Redstone Circuit Block", 1, 5, "Computes Redstone", new ITexture[0]);
    }

    public GT_MetaTileEntity_RedstoneCircuitBlock(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 1, 5, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_RedstoneCircuitBlock(this.mName, this.mDescription, this.mTextures);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_RedstoneCircuitBlock(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_RedstoneCircuitBlock(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getOutputFacing();
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long maxEUInput() {
        return GT_Values.V[1];
    }

    public long maxEUOutput() {
        return this.bOutput ? GT_Values.V[1] : 0L;
    }

    public long maxAmperesIn() {
        return 2L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public int func_70302_i_() {
        return 5;
    }

    public long maxEUStore() {
        return GT_Values.V[3] * 1024L;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer, 147);
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mGate", this.mGate);
        aNBT.func_74783_a("mGateData", this.mGateData);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mGate = aNBT.func_74762_e("mGate");
        this.mGateData = aNBT.func_74759_k("mGateData");
        if (this.mGateData.length != 8) {
            this.mGateData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        }
    }

    public void switchOutput() {
        this.bOutput = !this.bOutput;
    }

    public void switchGateForward(boolean aShift) {
        try {
            Set tKeys = GregTech_API.sCircuitryBehaviors.keySet();
            ArrayList tList = new ArrayList();
            tList.addAll(tKeys);
            if (tList.size() <= 0) {
                return;
            }
            Collections.sort(tList);
            if (!GregTech_API.sCircuitryBehaviors.containsKey(this.mGate)) {
                this.mGate = (Integer)tList.get(0);
            }
            int tIndex = Collections.binarySearch(tList, this.mGate);
            tIndex += aShift ? 16 : 1;
            while (tIndex >= tList.size()) {
                tIndex -= tList.size();
            }
            this.mGate = (Integer)tList.get(tIndex);
            this.switchGate();
        }
        catch (Throwable e) {
            GT_Log.err.print(e);
        }
    }

    public void switchGateBackward(boolean aShift) {
        try {
            Set tKeys = GregTech_API.sCircuitryBehaviors.keySet();
            ArrayList tList = new ArrayList();
            tList.addAll(tKeys);
            if (tList.size() <= 0) {
                return;
            }
            Collections.sort(tList);
            if (!GregTech_API.sCircuitryBehaviors.containsKey(this.mGate)) {
                this.mGate = (Integer)tList.get(0);
            }
            int tIndex = Collections.binarySearch(tList, this.mGate);
            tIndex -= aShift ? 16 : 1;
            while (tIndex < 0) {
                tIndex += tList.size();
            }
            this.mGate = (Integer)tList.get(tIndex);
            this.switchGate();
        }
        catch (Throwable e) {
            GT_Log.err.print(e);
        }
    }

    public void onFacingChange() {
        this.resetRedstone();
    }

    private void resetRedstone() {
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)0, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)1, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)2, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)3, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)4, (byte)0);
        this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal((byte)5, (byte)0);
    }

    public void changeGateData(int aIndex, int aValue) {
        int n = aIndex;
        this.mGateData[n] = this.mGateData[n] + aValue;
        this.validateGateData();
    }

    public void stackGateData(int aIndex, ItemStack aStack) {
        this.mGateData[aIndex] = GT_Utility.stackToInt((ItemStack)aStack);
        this.validateGateData();
    }

    private void switchGate() {
        this.resetRedstone();
        for (int i = 0; i < this.mGateData.length; ++i) {
            this.mGateData[i] = 0;
        }
        GT_CircuitryBehavior tBehaviour = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
        if (tBehaviour != null) {
            try {
                tBehaviour.initParameters(this.mGateData, (IRedstoneCircuitBlock)this);
            }
            catch (Throwable e) {
                GT_Log.err.print(e);
            }
        }
        this.validateGateData();
    }

    private void validateGateData() {
        GT_CircuitryBehavior tBehaviour = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate);
        if (tBehaviour != null) {
            try {
                tBehaviour.validateParameters(this.mGateData, (IRedstoneCircuitBlock)this);
            }
            catch (Throwable e) {
                GT_Log.err.print(e);
            }
        }
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
        this.validateGateData();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide()) {
            this.mInventory[4] = null;
            this.mInventory[3] = null;
            this.mInventory[2] = null;
            this.mInventory[1] = null;
            this.mInventory[0] = null;
            if (this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU()) {
                GT_CircuitryBehavior tBehaviour;
                if (this.getBaseMetaTileEntity().isActive() && (tBehaviour = (GT_CircuitryBehavior)GregTech_API.sCircuitryBehaviors.get(this.mGate)) != null) {
                    try {
                        tBehaviour.onTick(this.mGateData, (IRedstoneCircuitBlock)this);
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 0)) {
                            this.mInventory[1] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[0]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 1)) {
                            this.mInventory[2] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[1]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 2)) {
                            this.mInventory[3] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[2]);
                        }
                        if (tBehaviour.displayItemStack(this.mGateData, (IRedstoneCircuitBlock)this, 3)) {
                            this.mInventory[4] = GT_MetaTileEntity_RedstoneCircuitBlock.getCoverByID(this.mGateData[3]);
                        }
                    }
                    catch (Throwable e) {
                        GT_Log.err.print(e);
                    }
                }
                this.getBaseMetaTileEntity().setErrorDisplayID(0);
            } else {
                this.getBaseMetaTileEntity().setErrorDisplayID(1);
            }
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (!this.getBaseMetaTileEntity().isServerSide()) {
            return;
        }
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            byte aRedstone = this.getBaseMetaTileEntity().getOutputRedstoneSignal(i);
            this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(i, aRedstone);
        }
    }

    @Override
    public final boolean hasRedstoneSignal() {
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            if (this.getBaseMetaTileEntity().getOutputRedstoneSignal(i) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean allowGeneralRedstoneOutput() {
        return true;
    }

    private static void initCovers() {
        for (GT_ItemStack aKey : GregTech_API.sCovers.keySet()) {
            ItemStack aStack = aKey.toStack().func_77946_l();
            if (aStack == null) continue;
            sCoversItems.put(GT_Utility.stackToInt((ItemStack)aStack), aStack);
        }
    }

    public static ItemStack getCoverByID(int aStack) {
        if (sCoversItems.isEmpty()) {
            GT_MetaTileEntity_RedstoneCircuitBlock.initCovers();
        }
        return sCoversItems.get(aStack);
    }

    public byte getOutputFacing() {
        return this.getBaseMetaTileEntity().getBackFacing();
    }

    public boolean setRedstone(byte aStrength, byte aSide) {
        if (this.getOutputRedstone(aSide) != aStrength) {
            if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(1L, false)) {
                this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(aSide, aStrength);
                this.getBaseMetaTileEntity().setErrorDisplayID(0);
                return true;
            }
            this.getBaseMetaTileEntity().setErrorDisplayID(1);
            return false;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public byte getOutputRedstone(byte aSide) {
        return this.getBaseMetaTileEntity().getOutputRedstoneSignal(aSide);
    }

    public byte getInputRedstone(byte aSide) {
        return this.getBaseMetaTileEntity().getInternalInputRedstoneSignal(aSide);
    }

    public Block getBlockAtSide(byte aSide) {
        return this.getBaseMetaTileEntity().getBlockAtSide(aSide);
    }

    public byte getMetaIDAtSide(byte aSide) {
        return this.getBaseMetaTileEntity().getMetaIDAtSide(aSide);
    }

    public TileEntity getTileEntityAtSide(byte aSide) {
        return this.getBaseMetaTileEntity().getTileEntityAtSide(aSide);
    }

    public int getRandom(int aRange) {
        return this.getBaseMetaTileEntity().getRandomNumber(aRange);
    }

    public GT_CoverBehavior getCover(byte aSide) {
        return this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide);
    }

    public int getCoverID(byte aSide) {
        return this.getBaseMetaTileEntity().getCoverIDAtSide(aSide);
    }

    public int getCoverVariable(byte aSide) {
        return this.getBaseMetaTileEntity().getCoverDataAtSide(aSide);
    }

    public ICoverable getOwnTileEntity() {
        return this.getBaseMetaTileEntity();
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getSides(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getSidesActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    private GT_RenderedTexture getBase() {
        return new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top);
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Top_Off)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Top_On)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_Off), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_On), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red_Redstone)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Bottom_Off)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Bottom_On)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_Off)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{this.getBase(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_On)};
    }
}

