/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Turbine;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MTE_LargeTurbine_Plasma
extends GregtechMetaTileEntity_LargerTurbineBase {
    public GT_MTE_LargeTurbine_Plasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_Plasma(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_Plasma(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 4;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 60;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        try {
            ArrayList<GT_MetaTileEntity_Hatch_Turbine> aEmptyTurbineRotorHatches = this.getEmptyTurbineAssemblies();
            if (aEmptyTurbineRotorHatches.size() > 0) {
                this.log("Found " + aEmptyTurbineRotorHatches.size() + " Assemblies without Turbine.");
                ArrayList<ItemStack> aTurbines = this.getAllBufferedTurbines();
                block2: for (GT_MetaTileEntity_Hatch_Turbine aHatch : aEmptyTurbineRotorHatches) {
                    for (ItemStack aTurbineItem : aTurbines) {
                        if (aTurbineItem == null || aTurbineItem == null || !aHatch.insertTurbine(aTurbineItem.func_77946_l())) continue;
                        boolean aDidDeplete = this.depleteTurbineFromStock(aTurbineItem);
                        this.log("Put Turbine into Assembly - " + aDidDeplete);
                        continue block2;
                    }
                }
            }
            this.log("Found " + this.getFullTurbineAssemblies().size() + " Assemblies with a Turbine.");
            if (this.getEmptyTurbineAssemblies().size() > 0 || !this.areAllTurbinesTheSame()) {
                this.log("BAD RETURN - 1");
                this.stopMachine();
                return false;
            }
            this.log("Running checkRecipeGeneric(0)");
            ArrayList tFluids = this.getStoredFluids();
            if (tFluids.size() > 0) {
                if (this.baseEff == 0 || this.optFlow == 0 || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                    this.counter = 0;
                    float aTotalBaseEff = 0.0f;
                    float aTotalOptimalFlow = 0.0f;
                    ItemStack aStack = this.getFullTurbineAssemblies().get(0).getTurbine();
                    for (int i = 0; i < 18; ++i) {
                        if (i == 0) {
                            aTotalBaseEff += (float)GT_Utility.safeInt((long)((long)((5.0f + ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 1000.0f)));
                        }
                        aTotalOptimalFlow += (float)GT_Utility.safeInt((long)((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f)));
                    }
                    this.baseEff = MathUtils.roundToClosestInt(aTotalBaseEff);
                    this.optFlow = MathUtils.roundToClosestInt(aTotalOptimalFlow);
                    if (this.optFlow <= 0 || this.baseEff <= 0) {
                        this.log("Running checkRecipeGeneric(bad-1)");
                        this.stopMachine();
                        return false;
                    }
                } else {
                    ++this.counter;
                }
            }
            int newPower = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff);
            int difference = newPower - this.mEUt;
            int maxChangeAllowed = Math.max(200, GT_Utility.safeInt((long)((long)Math.abs(difference) / 5L)));
            if (Math.abs(difference) > maxChangeAllowed) {
                int change = maxChangeAllowed * (difference > 0 ? 1 : -1);
                this.mEUt += change;
            } else {
                this.mEUt = newPower;
            }
            if (this.mEUt <= 0) {
                this.mEUt = 0;
                this.mEfficiency = 0;
                this.log("Running checkRecipeGeneric(bad-2)");
                return false;
            }
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 200;
            this.startProcess();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            actualOptimalFlow = GT_Utility.safeInt((long)((long)Math.ceil((double)(aOptFlow *= 800) / (double)fuelValue)));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((long)((float)actualOptimalFlow * 1.25f)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            String fn = FluidRegistry.getFluidName((FluidStack)firstFuelType);
            String[] nameSegments = fn.split("\\.", 2);
            if (nameSegments.length == 2) {
                String outputName = nameSegments[1];
                FluidStack output = FluidRegistry.getFluidStack((String)outputName, (int)totalFlow);
                if (output == null) {
                    output = FluidRegistry.getFluidStack((String)("molten." + outputName), (int)totalFlow);
                }
                if (output != null) {
                    this.addOutput(output);
                }
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GT_Utility.safeInt((long)((long)((double)fuelValue / 20.0 * (double)totalFlow)));
            if (totalFlow == actualOptimalFlow) {
                tEU = GT_Utility.safeInt((long)((long)((double)aBaseEff / 10000.0 * (double)tEU)));
            } else {
                double efficiency = 1.0 - (double)Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((double)tEU * efficiency);
                tEU = GT_Utility.safeInt((long)((long)((double)aBaseEff / 10000.0 * (double)tEU)));
            }
            return tEU;
        }
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public String getMachineType() {
        return "Large Plasma Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Plasma";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Plasma Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_TU5);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_TU_ACTIVE5);
    }
}

