/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GT_MTE_LargeTurbine_Gas
extends GregtechMetaTileEntity_LargerTurbineBase {
    public GT_MTE_LargeTurbine_Gas(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_Gas(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_Gas(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 3;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 58;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return false;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 5000;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = GT_Recipe.GT_Recipe_Map.sTurbineFuels.findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (aOptFlow < fuelValue) {
                this.realOptFlow = 1.0;
                this.depleteInput(new FluidStack(firstFuelType, 1));
                ++this.storedFluid;
                return GT_Utility.safeInt((long)((long)aOptFlow * (long)aBaseEff / 10000L));
            }
            actualOptimalFlow = GT_Utility.safeInt((long)((long)aOptFlow / (long)fuelValue));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((long)((float)actualOptimalFlow * 1.25f)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GT_Utility.safeInt((long)((long)totalFlow * (long)fuelValue));
            if (totalFlow == actualOptimalFlow) {
                tEU = GT_Utility.safeInt((long)((long)tEU * (long)aBaseEff / 10000L));
            } else {
                float efficiency = 1.0f - Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((float)tEU * efficiency);
                tEU = GT_Utility.safeInt((long)((long)tEU * (long)aBaseEff / 10000L));
            }
            return tEU;
        }
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return CORE.RANDOM.nextInt(4) == 0 ? 0 : 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public String getMachineType() {
        return "Large Gas Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Gas";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Gas Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_SS5);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_SS_ACTIVE5);
    }
}

