/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.bedrock;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.ORES;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MiningUtils;
import gtPlusPlus.core.util.minecraft.OreDictUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GregtechMetaTileEntity_BedrockMiningPlatformBase
extends GregtechMeta_MultiBlockBase {
    protected double mProductionModifier = 0.0;
    private static final ItemStack miningPipe = GT_ModHandler.getIC2Item((String)"miningPipe", (long)0L);
    private static final ItemStack miningPipeTip = GT_ModHandler.getIC2Item((String)"miningPipeTip", (long)0L);
    private Block casingBlock;
    private int casingMeta;
    private int casingTextureIndex;
    private ForgeDirection back;
    private int xDrill;
    private int yDrill;
    private int zDrill;
    private int[] xCenter = new int[5];
    private int[] zCenter = new int[5];
    private AutoMap<ItemStack> mOutputs;

    public GregtechMetaTileEntity_BedrockMiningPlatformBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initFields();
    }

    public GregtechMetaTileEntity_BedrockMiningPlatformBase(String aName) {
        super(aName);
        this.initFields();
    }

    private void initFields() {
        this.casingBlock = this.getCasingBlockItem().getBlock();
        this.casingMeta = this.getCasingBlockItem().get(0L, new Object[0]).func_77960_j();
        this.casingTextureIndex = this.getCasingTextureIndex();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.casingTextureIndex), new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE : Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_FRONT))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.casingTextureIndex)};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OreDrillingPlant.png");
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74780_a("mProductionModifier", this.mProductionModifier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mProductionModifier = aNBT.func_74769_h("mProductionModifier");
    }

    public boolean checkRecipe(ItemStack aStack) {
        return false;
    }

    private boolean isEnergyEnough() {
        long requiredEnergy = 512L + this.getMaxInputVoltage() * 4L;
        for (GT_MetaTileEntity_Hatch_Energy energyHatch : this.mEnergyHatches) {
            if ((requiredEnergy -= energyHatch.getEUVar()) > 0L) continue;
            return true;
        }
        return false;
    }

    private void setElectricityStats() {
        this.mEfficiencyIncrease = 10000;
        int overclock = 8 << GT_Utility.getTier((long)this.getMaxInputVoltage());
        Logger.INFO("Trying to set EU to " + 12 * overclock * overclock);
        int mCombinedAvgTime = 0;
        for (int g = 0; g < 5; ++g) {
            mCombinedAvgTime += this.getBaseProgressTime() / overclock;
        }
        Logger.INFO("Trying to set Max Time to " + mCombinedAvgTime);
    }

    private boolean tryConsumeDrillingFluid() {
        boolean consumed = false;
        boolean g = this.getBaseMetaTileEntity().getWorld().func_82737_E() % 2L == 0L;
        boolean bl = consumed = g ? this.tryConsumePyrotheum() : this.tryConsumeCryotheum();
        if (consumed) {
            // empty if block
        }
        return consumed;
    }

    private boolean tryConsumePyrotheum() {
        return this.depleteInput(FluidUtils.getFluidStack("pyrotheum", 4));
    }

    private boolean tryConsumeCryotheum() {
        return this.depleteInput(FluidUtils.getFluidStack("cryotheum", 4));
    }

    private void putMiningPipesFromInputsInController() {
        int maxPipes = 64;
        if (this.isHasMiningPipes(64)) {
            return;
        }
        ItemStack pipes = this.func_70301_a(1);
        for (ItemStack storedItem : this.getStoredInputs()) {
            if (!storedItem.func_77969_a(miningPipe)) continue;
            if (pipes == null) {
                this.func_70299_a(1, GT_Utility.copy((Object[])new Object[]{miningPipe}));
                pipes = this.func_70301_a(1);
            }
            if (pipes.field_77994_a == 64) break;
            int needPipes = 64 - pipes.field_77994_a;
            int transferPipes = storedItem.field_77994_a < needPipes ? storedItem.field_77994_a : needPipes;
            ItemStack itemStack = pipes;
            itemStack.field_77994_a += transferPipes;
            ItemStack itemStack2 = storedItem;
            itemStack2.field_77994_a -= transferPipes;
        }
        this.updateSlots();
    }

    private boolean isHasMiningPipes(int minCount) {
        ItemStack pipe = this.func_70301_a(1);
        return pipe != null && pipe.field_77994_a > minCount - 1 && pipe.func_77969_a(miningPipe);
    }

    public boolean checkMultiblock(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.updateCoordinates();
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tAmount = 0;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 0, zDir)) {
            return false;
        }
        Block aCasing = Block.func_149634_a((Item)this.getCasingBlockItem().getItem());
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int h = -1; h < 2; ++h) {
                    if (h == 0 && (xDir + i == 0 && zDir + j == 0 || i == 0 && j == 0)) continue;
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j);
                    Block aBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    byte aMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j);
                    if (!this.addToMachineList(tTileEntity, 48)) {
                        if (aBlock != aCasing) {
                            Logger.INFO("Found Bad Casing");
                            return false;
                        }
                        if (aMeta != 3) {
                            Logger.INFO("Found Bad Meta");
                            return false;
                        }
                    }
                    ++tAmount;
                }
            }
        }
        return tAmount >= 10;
    }

    private void updateCoordinates() {
        this.xDrill = this.getBaseMetaTileEntity().getXCoord();
        this.yDrill = this.getBaseMetaTileEntity().getYCoord() - 1;
        this.zDrill = this.getBaseMetaTileEntity().getZCoord();
        this.back = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing());
        this.xCenter[0] = this.xDrill + this.back.offsetX;
        this.zCenter[0] = this.zDrill + this.back.offsetZ;
        this.xCenter[1] = this.xCenter[0] + 1;
        this.zCenter[1] = this.zCenter[0];
        this.xCenter[2] = this.xCenter[0] - 1;
        this.zCenter[2] = this.zCenter[0];
        this.xCenter[3] = this.xCenter[0];
        this.zCenter[3] = this.zCenter[0] + 1;
        this.xCenter[4] = this.xCenter[0];
        this.zCenter[4] = this.zCenter[0] - 1;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected GregtechItemList getCasingBlockItem() {
        return GregtechItemList.Casing_BedrockMiner;
    }

    protected abstract Material getFrameMaterial();

    protected abstract int getCasingTextureIndex();

    protected abstract int getRadiusInChunks();

    protected abstract int getMinTier();

    protected abstract int getBaseProgressTime();

    protected String[] getDescriptionInternal(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).func_82833_r();
        return new String[]{"Controller Block for the Experimental Deep Earth Drilling Platform - MK " + (tierSuffix != null ? tierSuffix : ""), "Size(WxHxD): 3x7x3, Controller (Front middle bottom)", "3x1x3 Base of " + casings, "1x3x1 " + casings + " pillar (Center of base)", "1x3x1 " + this.getFrameMaterial().getLocalizedName() + " Frame Boxes (Each pillar side and on top)", "2x Input Hatch (Any bottom layer casing)", "1x Input Bus for mining pipes (Any bottom layer casing; not necessary)", "1x Output Bus (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x " + GT_Values.VN[this.getMinTier()] + "+ Energy Hatch (Any bottom layer casing)", "Radius is " + (this.getRadiusInChunks() << 4) + " blocks", "Every tick, this machine altenates betweem consumption of Pyrotheum & Cryotheum", "Pyrotheum is used to bore through the Mantle of the world", "Cryotheum is used to keep the internal components cool"};
    }

    public void process() {
        ItemStack aOutput = this.generateOutputWithchance();
        if (aOutput != null) {
            this.addOutput(aOutput);
            Logger.INFO("Mined some " + aOutput.func_82833_r());
        }
        this.updateSlots();
    }

    public ItemStack generateOutputWithchance() {
        int aChance = MathUtils.randInt(0, 7500);
        if (aChance < 100) {
            return this.generateOutput();
        }
        return null;
    }

    public ItemStack generateOutput() {
        AutoMap<ItemStack> aData = this.generateOreForOutput();
        int aMax = aData.size() - 1;
        return aData.get(MathUtils.randInt(0, aMax));
    }

    public AutoMap<ItemStack> generateOreForOutput() {
        ItemStack aTempOreStack4;
        ItemStack aTempOreStack3;
        ItemStack aTempOreStack2;
        if (this.mOutputs != null) {
            return this.mOutputs;
        }
        AutoMap<GT_Worldgen_GT_Ore_Layer> aOverWorldOres = MiningUtils.getOresForDim(0);
        AutoMap<GT_Worldgen_GT_Ore_Layer> aNetherOres = MiningUtils.getOresForDim(-1);
        AutoMap<GT_Worldgen_GT_Ore_Layer> aEndOres = MiningUtils.getOresForDim(1);
        AutoMap<ItemStack> aTempMap = new AutoMap<ItemStack>();
        Block tOreBlock = GregTech_API.sBlockOres1;
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [Initial]");
        for (GT_Worldgen_GT_Ore_Layer gT_Worldgen_GT_Ore_Layer : aOverWorldOres) {
            if (!gT_Worldgen_GT_Ore_Layer.mEnabled) continue;
            ItemStack itemStack = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mPrimaryMeta, 1);
            aTempOreStack2 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mSecondaryMeta, 1);
            aTempOreStack3 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mBetweenMeta, 1);
            aTempOreStack4 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mSporadicMeta, 1);
            aTempMap.put(itemStack);
            aTempMap.put(aTempOreStack2);
            aTempMap.put(aTempOreStack3);
            aTempMap.put(aTempOreStack4);
            aTempMap.put(itemStack);
            aTempMap.put(aTempOreStack2);
            aTempMap.put(aTempOreStack3);
            aTempMap.put(aTempOreStack4);
            aTempMap.put(itemStack);
            aTempMap.put(aTempOreStack2);
            aTempMap.put(aTempOreStack3);
            aTempMap.put(aTempOreStack4);
        }
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [Overworld]");
        for (GT_Worldgen_GT_Ore_Layer gT_Worldgen_GT_Ore_Layer : aNetherOres) {
            if (!gT_Worldgen_GT_Ore_Layer.mEnabled) continue;
            ItemStack itemStack = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mPrimaryMeta, 1);
            aTempOreStack2 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mSecondaryMeta, 1);
            aTempOreStack3 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mBetweenMeta, 1);
            aTempOreStack4 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mSporadicMeta, 1);
            aTempMap.put(itemStack);
            aTempMap.put(aTempOreStack2);
            aTempMap.put(aTempOreStack3);
            aTempMap.put(aTempOreStack4);
            aTempMap.put(itemStack);
            aTempMap.put(aTempOreStack2);
            aTempMap.put(aTempOreStack3);
            aTempMap.put(aTempOreStack4);
        }
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [Nether]");
        for (GT_Worldgen_GT_Ore_Layer gT_Worldgen_GT_Ore_Layer : aEndOres) {
            if (!gT_Worldgen_GT_Ore_Layer.mEnabled) continue;
            ItemStack itemStack = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mPrimaryMeta, 1);
            aTempOreStack2 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mSecondaryMeta, 1);
            aTempOreStack3 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mBetweenMeta, 1);
            aTempOreStack4 = ItemUtils.simpleMetaStack(tOreBlock, (int)gT_Worldgen_GT_Ore_Layer.mSporadicMeta, 1);
            aTempMap.put(itemStack);
            aTempMap.put(aTempOreStack2);
            aTempMap.put(aTempOreStack3);
            aTempMap.put(aTempOreStack4);
        }
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [End]");
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().IRON, 200, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().COPPER, 175, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().TIN, 150, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().GOLD, 150, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().SILVER, 110, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().NICKEL, 40, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().ZINC, 40, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().LEAD, 40, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().ALUMINIUM, 30, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.getInstance().THORIUM, 20, aTempMap);
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [Extra Common Ores]");
        AutoMap<Pair<String, Integer>> mMixedOreData = new AutoMap<Pair<String, Integer>>();
        mMixedOreData.put(new Pair<String, Integer>("oreRuby", 30));
        mMixedOreData.put(new Pair<String, Integer>("oreSapphire", 25));
        mMixedOreData.put(new Pair<String, Integer>("oreEmerald", 25));
        mMixedOreData.put(new Pair<String, Integer>("oreLapis", 40));
        mMixedOreData.put(new Pair<String, Integer>("oreRedstone", 40));
        if (LoadedMods.Thaumcraft || OreDictUtils.containsValidEntries("oreAmber") && OreDictUtils.containsValidEntries("oreCinnabar")) {
            mMixedOreData.put(new Pair<String, Integer>("oreAmber", 20));
            mMixedOreData.put(new Pair<String, Integer>("oreCinnabar", 20));
        }
        if (LoadedMods.Railcraft || OreDictUtils.containsValidEntries("oreSaltpeter")) {
            mMixedOreData.put(new Pair<String, Integer>("oreSaltpeter", 10));
        }
        if (LoadedMods.IndustrialCraft2 || OreDictUtils.containsValidEntries("oreUranium")) {
            mMixedOreData.put(new Pair<String, Integer>("oreUranium", 10));
        }
        if (OreDictUtils.containsValidEntries("oreSulfur")) {
            mMixedOreData.put(new Pair<String, Integer>("oreSulfur", 15));
        }
        if (OreDictUtils.containsValidEntries("oreSilicon")) {
            mMixedOreData.put(new Pair<String, Integer>("oreSilicon", 15));
        }
        if (OreDictUtils.containsValidEntries("oreApatite")) {
            mMixedOreData.put(new Pair<String, Integer>("oreApatite", 25));
        }
        mMixedOreData.put(new Pair<String, Integer>("oreFirestone", 2));
        mMixedOreData.put(new Pair<String, Integer>("oreBismuth", 20));
        mMixedOreData.put(new Pair<String, Integer>("oreLithium", 20));
        mMixedOreData.put(new Pair<String, Integer>("oreManganese", 20));
        mMixedOreData.put(new Pair<String, Integer>("oreBeryllium", 20));
        mMixedOreData.put(new Pair<String, Integer>("oreCoal", 75));
        mMixedOreData.put(new Pair<String, Integer>("oreLignite", 75));
        mMixedOreData.put(new Pair<String, Integer>("oreSalt", 15));
        mMixedOreData.put(new Pair<String, Integer>("oreCalcite", 15));
        mMixedOreData.put(new Pair<String, Integer>("oreBauxite", 20));
        mMixedOreData.put(new Pair<String, Integer>("oreAlmandine", 15));
        mMixedOreData.put(new Pair<String, Integer>("oreGraphite", 25));
        mMixedOreData.put(new Pair<String, Integer>("oreGlauconite", 15));
        mMixedOreData.put(new Pair<String, Integer>("orePyrolusite", 15));
        mMixedOreData.put(new Pair<String, Integer>("oreGrossular", 15));
        mMixedOreData.put(new Pair<String, Integer>("oreTantalite", 15));
        for (Pair pair : mMixedOreData) {
            for (int i = 0; i < (Integer)pair.getValue(); ++i) {
                aTempMap.put(ItemUtils.getItemStackOfAmountFromOreDict((String)pair.getKey(), 1));
            }
        }
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [Extra Mixed Ores]");
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.STANDALONE.RUNITE, 2, aTempMap);
        GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(ELEMENT.STANDALONE.GRANITE, 8, aTempMap);
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [OSRS Ores]");
        AutoMap<Material> autoMap = new AutoMap<Material>();
        autoMap.add(ORES.CROCROITE);
        autoMap.add(ORES.GEIKIELITE);
        autoMap.add(ORES.NICHROMITE);
        autoMap.add(ORES.TITANITE);
        autoMap.add(ORES.ZIMBABWEITE);
        autoMap.add(ORES.ZIRCONILITE);
        autoMap.add(ORES.GADOLINITE_CE);
        autoMap.add(ORES.GADOLINITE_Y);
        autoMap.add(ORES.LEPERSONNITE);
        autoMap.add(ORES.SAMARSKITE_Y);
        autoMap.add(ORES.SAMARSKITE_YB);
        autoMap.add(ORES.XENOTIME);
        autoMap.add(ORES.YTTRIAITE);
        autoMap.add(ORES.YTTRIALITE);
        autoMap.add(ORES.YTTROCERITE);
        autoMap.add(ORES.ZIRCON);
        autoMap.add(ORES.POLYCRASE);
        autoMap.add(ORES.ZIRCOPHYLLITE);
        autoMap.add(ORES.ZIRKELITE);
        autoMap.add(ORES.LANTHANITE_LA);
        autoMap.add(ORES.LANTHANITE_CE);
        autoMap.add(ORES.LANTHANITE_ND);
        autoMap.add(ORES.AGARDITE_Y);
        autoMap.add(ORES.AGARDITE_CD);
        autoMap.add(ORES.AGARDITE_LA);
        autoMap.add(ORES.AGARDITE_ND);
        autoMap.add(ORES.HIBONITE);
        autoMap.add(ORES.CERITE);
        autoMap.add(ORES.FLUORCAPHITE);
        autoMap.add(ORES.FLORENCITE);
        autoMap.add(ORES.CRYOLITE);
        autoMap.add(ORES.LAUTARITE);
        autoMap.add(ORES.LAFOSSAITE);
        autoMap.add(ORES.DEMICHELEITE_BR);
        autoMap.add(ORES.COMANCHEITE);
        autoMap.add(ORES.PERROUDITE);
        autoMap.add(ORES.HONEAITE);
        autoMap.add(ORES.ALBURNITE);
        autoMap.add(ORES.MIESSIITE);
        autoMap.add(ORES.KASHINITE);
        autoMap.add(ORES.IRARSITE);
        autoMap.add(ORES.RADIOBARITE);
        autoMap.add(ORES.DEEP_EARTH_REACTOR_FUEL_DEPOSIT);
        for (Material aOreType : autoMap) {
            if (aOreType == ORES.DEEP_EARTH_REACTOR_FUEL_DEPOSIT || aOreType == ORES.RADIOBARITE) {
                GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(aOreType, 4, aTempMap);
                continue;
            }
            GregtechMetaTileEntity_BedrockMiningPlatformBase.addOreTypeToMap(aOreType, 7, aTempMap);
        }
        Logger.INFO("Ore Map contains " + aTempMap.size() + " values. [GT++]");
        AutoMap<ItemStack> autoMap2 = new AutoMap<ItemStack>();
        for (ItemStack verify : aTempMap) {
            if (ItemUtils.checkForInvalidItems(verify)) continue;
            autoMap2.put(verify);
        }
        Logger.INFO("Cleanup Map contains " + autoMap2.size() + " values.");
        for (ItemStack remove : autoMap2) {
            aTempMap.remove(remove);
        }
        AutoMap<ItemStack> aFinalMap = new AutoMap<ItemStack>();
        for (ItemStack aTempItem : aTempMap) {
            int aTempMulti = MathUtils.randInt(20, 50);
            for (int i = 0; i < aTempMulti; ++i) {
                aFinalMap.put(aTempItem.func_77946_l());
            }
        }
        Logger.INFO("Final Ore Map contains " + aFinalMap.size() + " values.");
        this.mOutputs = aFinalMap;
        return this.mOutputs;
    }

    private static void addOreTypeToMap(Material aMaterial, int aAmount, AutoMap<ItemStack> aMap) {
        for (int i = 0; i < aAmount; ++i) {
            aMap.add(aMaterial.getOre(1));
        }
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public String getMachineType() {
        return "Miner";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }
}

