/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.algae;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoader_AlgaeFarm;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMTE_AlgaePondBase
extends GregtechMeta_MultiBlockBase<GregtechMTE_AlgaePondBase> {
    private int mLevel = -1;
    private int mCasing;
    private IStructureDefinition<GregtechMTE_AlgaePondBase> STRUCTURE_DEFINITION = null;
    private int checkMeta;

    public GregtechMTE_AlgaePondBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_AlgaePondBase(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_AlgaePondBase(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Algae Pond";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Grows Algae!").addInfo("Controller Block for the Algae Farm").addInfo("Provide compost to boost production by one tier").addInfo("Does not require power or maintenance").addInfo("All Machine Casings must be the same tier, this dictates machine speed.").addInfo("Fill Input Hatch with water.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(9, 3, 9, true).addController("Front Center").addCasingInfo("Machine Casings", 64).addCasingInfo("Sterile Farm Casings", 34).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public void setMeta(int meta) {
        this.checkMeta = meta;
    }

    public int getMeta() {
        return this.checkMeta;
    }

    public IStructureDefinition<GregtechMTE_AlgaePondBase> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"CCCC~CCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMTE_AlgaePondBase::addAlgaePondBaseList, (int)TAE.getIndexFromPage(1, 15), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, GregtechMTE_AlgaePondBase.addTieredBlock(GregTech_API.sBlockCasings1, GregtechMTE_AlgaePondBase::setMeta, GregtechMTE_AlgaePondBase::getMeta, 10))})).addElement(Character.valueOf('X'), StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)15)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 2, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mLevel = 0;
        this.checkMeta = 0;
        if (this.checkPiece(this.mName, 4, 2, 0) && this.mCasing >= 64 && this.checkMeta > 0) {
            this.mLevel = this.checkMeta - 1;
            return true;
        }
        return false;
    }

    public final boolean addAlgaePondBaseList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(207);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        int aID = TAE.getIndexFromPage(1, 15);
        if (this.mLevel > -1) {
            aID = this.mLevel;
        }
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)aID), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Default_Active : TexturesGtBlock.Overlay_Machine_Controller_Default))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)aID)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public boolean checkForWater() {
        boolean isValidWater;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mDirectionX = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int mOffsetX_Lower = 0;
        int mOffsetX_Upper = 0;
        int mOffsetZ_Lower = 0;
        int mOffsetZ_Upper = 0;
        int mCurrentDirectionX = 4;
        int mCurrentDirectionZ = 4;
        mOffsetX_Lower = -4;
        mOffsetX_Upper = 4;
        mOffsetZ_Lower = -4;
        mOffsetZ_Upper = 4;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * mCurrentDirectionX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * mCurrentDirectionZ;
        int tAmount = 0;
        for (int i = mOffsetX_Lower + 1; i <= mOffsetX_Upper - 1; ++i) {
            for (int j = mOffsetZ_Lower + 1; j <= mOffsetZ_Upper - 1; ++j) {
                for (int h = 0; h < 2; ++h) {
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if ((tBlock == Blocks.field_150350_a || tBlock == Blocks.field_150358_i || tBlock == BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater)) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(FluidUtils.getFluidStack("water", 1)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            Block fluidUsed = Blocks.field_150355_j;
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, fluidUsed);
                        }
                    }
                    if ((tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j)) != Blocks.field_150355_j && tBlock != Blocks.field_150358_i) continue;
                    ++tAmount;
                }
            }
        }
        boolean bl = isValidWater = tAmount >= 49;
        if (isValidWater) {
            Logger.INFO("Filled structure.");
            return true;
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiAlgaePond;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.fixAllMaintenanceIssue();
        if (aBaseMetaTileEntity.isClientSide()) {
            this.mLevel = this.getCasingTier();
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        void var15_22;
        GT_Recipe tRecipe;
        if (this.mLevel < 0) {
            Logger.INFO("Bad Tier.");
            return false;
        }
        if (!this.checkForWater()) {
            Logger.INFO("Not enough Water.");
            return false;
        }
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        Logger.INFO("Running checkRecipeGeneric(0)");
        this.mLastRecipe = tRecipe = RecipeLoader_AlgaeFarm.getTieredRecipeFromCache(this.mLevel, this.isUsingCompost(aItemInputs));
        if (tRecipe == null) {
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            return false;
        }
        if (tRecipe.mInputs.length > 0) {
            for (ItemStack aInputToConsume : tRecipe.mInputs) {
                this.depleteInput(aInputToConsume);
            }
        }
        this.mMaxProgresstime = tRecipe.mDuration;
        this.mEUt = 0;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        Logger.INFO("Recipe time: " + this.mMaxProgresstime);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= aMaxParallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < aMaxParallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var15_22 < n) {
            Object tS = objectArray[var15_22];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var15_22;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        Logger.INFO("GOOD RETURN - 1");
        return true;
    }

    private boolean isUsingCompost(ItemStack[] aItemInputs) {
        ItemStack aCompost = ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1);
        for (ItemStack i : aItemInputs) {
            if (!GT_Utility.areStacksEqual((ItemStack)aCompost, (ItemStack)i) || i.field_77994_a < 8) continue;
            return true;
        }
        return false;
    }

    private int getCasingTier() {
        if (this.getBaseMetaTileEntity().getWorld() == null) {
            return 0;
        }
        try {
            IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
            int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
            int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
            Block aInitStructureCheck = aBaseMetaTileEntity.getBlockOffset(xDir, -1, zDir);
            byte aInitStructureCheckMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir, -1, zDir);
            if (aInitStructureCheck == GregTech_API.sBlockCasings1) {
                return aInitStructureCheckMeta;
            }
            return 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }
}

