/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.misc.TileEntitySolarHeater;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_SolarTower
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_SolarTower> {
    private static final int mCasingTextureID = TAE.getIndexFromPage(3, 9);
    private int mHeatLevel = 0;
    private int mCasing1;
    private int mCasing2;
    private int mCasing3;
    private int mCasing4;
    public ArrayList<TileEntitySolarHeater> mSolarHeaters = new ArrayList();
    private static final String STRUCTURE_PIECE_BASE = "base";
    private static final String STRUCTURE_PIECE_TOWER = "tower";
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String SOLAR_HEATER_RING_1 = "ring1";
    private static final String SOLAR_HEATER_RING_2 = "ring2";
    private static final String SOLAR_HEATER_RING_3 = "ring3";
    private static final String SOLAR_HEATER_RING_4 = "ring4";
    private static final String SOLAR_HEATER_RING_5 = "ring5";
    private static final ClassValue<IStructureDefinition<GregtechMetaTileEntity_SolarTower>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GregtechMetaTileEntity_SolarTower>>(){

        @Override
        protected IStructureDefinition<GregtechMetaTileEntity_SolarTower> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GregtechMetaTileEntity_SolarTower.STRUCTURE_PIECE_TOP, (String[][])new String[][]{{"     ", "     ", "  ~  ", "     ", "     "}, {"     ", "  s  ", " sss ", "  s  ", "     "}, {"  c  ", " ccc ", "ccscc", " ccc ", "  c  "}, {"  c  ", " ccc ", "ccscc", " ccc ", "  c  "}, {"  c  ", " ccc ", "ccscc", " ccc ", "  c  "}, {"  c  ", " ccc ", "ccscc", " ccc ", "  c  "}, {"  c  ", " ccc ", "ccscc", " ccc ", "  c  "}}).addShape(GregtechMetaTileEntity_SolarTower.STRUCTURE_PIECE_TOWER, (String[][])new String[][]{{" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}, {" i ", "isi", " i "}}).addShape(GregtechMetaTileEntity_SolarTower.STRUCTURE_PIECE_BASE, (String[][])new String[][]{{"           ", "           ", "     t     ", "    ttt    ", "   ttstt   ", "  ttssstt  ", "   ttstt   ", "    ttt    ", "     t     ", "           ", "           "}, {"           ", "           ", "     t     ", "    ttt    ", "   tssst   ", "  ttssstt  ", "   tssst   ", "    ttt    ", "     t     ", "           ", "           "}, {"           ", "     t     ", "    ttt    ", "   ttttt   ", "  ttssstt  ", " tttsssttt ", "  ttssstt  ", "   ttttt   ", "    ttt    ", "     t     ", "           "}, {"           ", "     t     ", "    ttt    ", "   ttttt   ", "  ttssstt  ", " tttsssttt ", "  ttssstt  ", "   ttttt   ", "    ttt    ", "     t     ", "           "}, {"    hhh    ", "   ttttt   ", "  ttttttt  ", " ttttttttt ", "htttsssttth", "htttsssttth", "htttsssttth", " ttttttttt ", "  ttttttt  ", "   ttttt   ", "    hhh    "}, {"    hhh    ", "   ttttt   ", "  ttttttt  ", " ttttttttt ", "httttttttth", "httttttttth", "httttttttth", " ttttttttt ", "  ttttttt  ", "   ttttt   ", "    hhh    "}}).addShape(GregtechMetaTileEntity_SolarTower.SOLAR_HEATER_RING_1, (String[][])new String[][]{{"     ggggg     ", "    g     g    ", "   g       g   ", "  g         g  ", " g           g ", "g             g", "g             g", "g             g", "g             g", "g             g", " g           g ", "  g         g  ", "   g       g   ", "    g     g    ", "     ggggg     "}}).addShape(GregtechMetaTileEntity_SolarTower.SOLAR_HEATER_RING_2, (String[][])new String[][]{{"     ggggggggg     ", "    g         g    ", "   g           g   ", "  g             g  ", " g               g ", "g                 g", "g                 g", "g                 g", "g                 g", "g                 g", "g                 g", "g                 g", "g                 g", "g                 g", " g               g ", "  g             g  ", "   g           g   ", "    g         g    ", "     ggggggggg     "}}).addShape(GregtechMetaTileEntity_SolarTower.SOLAR_HEATER_RING_3, (String[][])new String[][]{{"     ggggggggggggg     ", "    g             g    ", "   g               g   ", "  g                 g  ", " g                   g ", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", "g                     g", " g                   g ", "  g                 g  ", "   g               g   ", "    g             g    ", "     ggggggggggggg     "}}).addShape(GregtechMetaTileEntity_SolarTower.SOLAR_HEATER_RING_4, (String[][])new String[][]{{"     ggggggggggggggggg     ", "    g                 g    ", "   g                   g   ", "  g                     g  ", " g                       g ", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", "g                         g", " g                       g ", "  g                     g  ", "   g                   g   ", "    g                 g    ", "     ggggggggggggggggg     "}}).addShape(GregtechMetaTileEntity_SolarTower.SOLAR_HEATER_RING_5, (String[][])new String[][]{{"     ggggggggggggggggggggg     ", "    g                     g    ", "   g                       g   ", "  g                         g  ", " g                           g ", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", "g                             g", " g                           g ", "  g                         g  ", "   g                       g   ", "    g                     g    ", "     ggggggggggggggggggggg     "}}).addElement(Character.valueOf('g'), (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.ofHatchAdder((rec$, x$0, x$1) -> ((GregtechMetaTileEntity_SolarTower)((Object)((Object)((Object)rec$)))).addSolarHeater(x$0, x$1), (int)0, (int)1))).addElement(Character.valueOf('t'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++((GregtechMetaTileEntity_SolarTower)x).mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta())))).addElement(Character.valueOf('i'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++((GregtechMetaTileEntity_SolarTower)x).mCasing2, (IStructureElement)StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta2())))).addElement(Character.valueOf('s'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++((GregtechMetaTileEntity_SolarTower)x).mCasing3, (IStructureElement)StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta3())))).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++((GregtechMetaTileEntity_SolarTower)x).mCasing4, (IStructureElement)StructureUtility.ofBlock((Block)t.getCasingBlock2(), (int)t.getCasingMeta4())))).addElement(Character.valueOf('h'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_SolarTower::addGenericHatch, (int)t.getCasingTextureIndex(), (int)2), StructureUtility.onElementPass(x -> ++((GregtechMetaTileEntity_SolarTower)x).mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))}))).build();
        }
    };
    private Fluid mColdSalt = null;
    private Fluid mHotSalt = null;

    public GregtechMetaTileEntity_SolarTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_SolarTower(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_SolarTower(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Solar Tower";
    }

    protected final GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Contributing Green Energy towards the future").addInfo("Input: " + MISC_MATERIALS.SOLAR_SALT_COLD.getLocalizedName()).addInfo("Output: " + MISC_MATERIALS.SOLAR_SALT_HOT.getLocalizedName()).addInfo("Surround with rings of Solar Heaters").addInfo("Each ring increases tier").addInfo("1 = 1, 2 = 2, 3 = 4, 4 = 8, 5 = 16").addInfo("Tier decreases heating time and allows more salt to be processed").addSeparator().beginStructureBlock(6, 27, 6, false).addController("Top Middle").addCasingInfo("Structural Solar Casing", 229).addCasingInfo("Thermally Insulated Casing", 60).addCasingInfo("Salt Containment Casing", 66).addCasingInfo("Thermal Containment Casing", 60).addInputHatch("Any 2 dot hint(min 1)", new int[]{2}).addOutputHatch("Any 2 dot hint(min 1)", new int[]{2}).addMaintenanceHatch("Any 2 dot hint", new int[]{2}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        boolean aAllCasings;
        this.resetSolarHeaters();
        this.mMaintenanceHatches.clear();
        this.mInputHatches.clear();
        this.mOutputHatches.clear();
        this.mCasing1 = 0;
        this.mCasing2 = 0;
        this.mCasing3 = 0;
        this.mCasing4 = 0;
        boolean aStructureTop = this.checkPiece(STRUCTURE_PIECE_TOP, 2, 2, 0);
        this.log("Top Check: " + aStructureTop);
        boolean aStructureTower = this.checkPiece(STRUCTURE_PIECE_TOWER, 1, 1, -7);
        this.log("Tower Check: " + aStructureTower);
        boolean aStructureBase = this.checkPiece(STRUCTURE_PIECE_BASE, 5, 5, -22);
        this.log("Base Check: " + aStructureBase);
        boolean aCasingCount1 = this.mCasing1 >= 229;
        boolean aCasingCount2 = this.mCasing2 == 60;
        boolean aCasingCount3 = this.mCasing3 == 66;
        boolean aCasingCount4 = this.mCasing4 == 60;
        boolean aAllStructure = aStructureTop && aStructureTower && aStructureBase;
        boolean bl = aAllCasings = aCasingCount1 && aCasingCount2 && aCasingCount3 && aCasingCount4;
        if (!aAllCasings || !aAllStructure || this.mMaintenanceHatches.size() != 1 || this.mInputHatches.size() < 1 || this.mOutputHatches.size() < 1) {
            this.log("Bad Hatches - Solar Heaters: " + this.mSolarHeaters.size() + ", Maint: " + this.mMaintenanceHatches.size() + ", Input Hatches: " + this.mInputHatches.size() + ", Output Hatches: " + this.mOutputHatches.size() + ", Top: " + aStructureTop + ", Tower: " + aStructureTower + ", Base: " + aStructureBase + ", Casing Count: " + aCasingCount1 + " | Found: " + this.mCasing1 + ", Casing Count: " + aCasingCount2 + " | Found: " + this.mCasing2 + ", Casing Count: " + aCasingCount3 + " | Found: " + this.mCasing3 + ", Casing Count: " + aCasingCount4 + " | Found: " + this.mCasing4);
            return false;
        }
        this.log("Built " + this.getLocalName() + " with " + this.mCasing1 + " Structural Solar casings, " + this.mCasing2 + " Thermally Insulated casings, " + this.mCasing3 + " Salt Containment casings, " + this.mCasing4 + " Thermal Containment casings.");
        return aAllCasings && aAllStructure;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 2, 2, 0);
        this.buildPiece(STRUCTURE_PIECE_TOWER, stackSize, hintsOnly, 1, 1, -7);
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 5, 5, -22);
        if (stackSize.field_77994_a >= 1) {
            this.buildPiece(SOLAR_HEATER_RING_1, stackSize, hintsOnly, 7, 7, -27);
            if (stackSize.field_77994_a >= 2) {
                this.buildPiece(SOLAR_HEATER_RING_2, stackSize, hintsOnly, 9, 9, -27);
                if (stackSize.field_77994_a >= 3) {
                    this.buildPiece(SOLAR_HEATER_RING_3, stackSize, hintsOnly, 11, 11, -27);
                    if (stackSize.field_77994_a >= 4) {
                        this.buildPiece(SOLAR_HEATER_RING_4, stackSize, hintsOnly, 13, 13, -27);
                        if (stackSize.field_77994_a >= 5) {
                            this.buildPiece(SOLAR_HEATER_RING_5, stackSize, hintsOnly, 15, 15, -27);
                        }
                    }
                }
            }
        }
    }

    public IStructureDefinition<GregtechMetaTileEntity_SolarTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(((Object)((Object)this)).getClass());
    }

    public final boolean addGenericHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        this.log("Bad Hatch");
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(212);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == 0 || aSide == 1) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(12)), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Default_Active : TexturesGtBlock.Overlay_Machine_Controller_Default))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(12))};
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    private int getHeaterTier() {
        int aSolarHeaterCounter = this.mSolarHeaters.size();
        if (aSolarHeaterCounter > 0) {
            if (aSolarHeaterCounter == 36) {
                return 1;
            }
            if (aSolarHeaterCounter == 88) {
                return 2;
            }
            if (aSolarHeaterCounter == 156) {
                return 4;
            }
            if (aSolarHeaterCounter == 240) {
                return 8;
            }
            if (aSolarHeaterCounter == 340) {
                return 16;
            }
        }
        return 0;
    }

    private int getHeaterCountForTier(int aTier) {
        switch (aTier) {
            case 1: {
                return 36;
            }
            case 2: {
                return 88;
            }
            case 4: {
                return 156;
            }
            case 8: {
                return 240;
            }
            case 16: {
                return 340;
            }
        }
        return 0;
    }

    public boolean getConnectedSolarReflectors() {
        boolean aRing5;
        boolean aRing4;
        boolean aRing3;
        boolean aRing2;
        boolean aRing1;
        this.mSolarHeaters.clear();
        boolean aRing = true;
        if (this.mSolarHeaters.size() >= 36 || (aRing1 = this.checkPiece(SOLAR_HEATER_RING_1, 7, 7, -27))) {
            // empty if block
        }
        if (this.mSolarHeaters.size() >= 88 || (aRing2 = this.checkPiece(SOLAR_HEATER_RING_2, 9, 9, -27))) {
            // empty if block
        }
        if (this.mSolarHeaters.size() >= 156 || (aRing3 = this.checkPiece(SOLAR_HEATER_RING_3, 11, 11, -27))) {
            // empty if block
        }
        if (this.mSolarHeaters.size() >= 240 || (aRing4 = this.checkPiece(SOLAR_HEATER_RING_4, 13, 13, -27))) {
            // empty if block
        }
        if (this.mSolarHeaters.size() >= 340 || (aRing5 = this.checkPiece(SOLAR_HEATER_RING_5, 15, 15, -27))) {
            // empty if block
        }
        return this.mSolarHeaters.size() > 0;
    }

    private boolean addSolarHeater(IGregTechTileEntity aTileEntity, int a) {
        TileEntitySolarHeater mTile;
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof TileEntitySolarHeater && (mTile = (TileEntitySolarHeater)aMetaTileEntity) != null && !mTile.hasSolarTower() && mTile.canSeeSky()) {
            mTile.setSolarTower(this);
            return this.mSolarHeaters.add(mTile);
        }
        return false;
    }

    public boolean checkRecipe(ItemStack aStack) {
        World w;
        int aTier;
        int aHeaters;
        this.mEfficiencyIncrease = 10;
        this.mMaxProgresstime = 100;
        if (this.mSolarHeaters.isEmpty() || this.mSolarHeaters.size() < 340 || this.getTotalRuntimeInTicks() % 200L == 0L) {
            this.getConnectedSolarReflectors();
        }
        if ((aHeaters = this.getHeaterCountForTier(aTier = this.getHeaterTier())) > 0) {
            for (int i = 0; i < aHeaters; ++i) {
                Math.min(this.mHeatLevel += aTier, 20000);
            }
        }
        if (this.mHeatLevel > 0 && this.mHeatLevel > 20000) {
            this.mHeatLevel = 20000;
        }
        if ((w = this.getBaseMetaTileEntity().getWorld()) != null) {
            int aRemovalFactor = 0;
            aRemovalFactor = w.func_72935_r() ? 1 : 8;
            for (int i = 0; i < MathUtils.randInt(aHeaters / 10, aHeaters); ++i) {
                this.mHeatLevel -= aRemovalFactor;
            }
        }
        if (this.mEfficiency == this.getMaxEfficiency(null) && this.mHeatLevel >= 10000) {
            if (this.mColdSalt == null) {
                this.mColdSalt = MISC_MATERIALS.SOLAR_SALT_COLD.getFluid();
            }
            if (this.mHotSalt == null) {
                this.mHotSalt = MISC_MATERIALS.SOLAR_SALT_HOT.getFluid();
            }
            ArrayList aFluids = this.getStoredFluids();
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.getFluid().equals(this.mColdSalt) || aFluid.amount < aTier * 1000) continue;
                this.depleteInput(FluidUtils.getFluidStack(this.mColdSalt, aTier * 1000));
                this.addOutput(FluidUtils.getFluidStack(this.mHotSalt, aTier * 1000));
                break;
            }
        }
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    public Block getCasingBlock2() {
        return ModBlocks.blockCasings2Misc;
    }

    public byte getCasingMeta() {
        return 6;
    }

    public byte getCasingMeta2() {
        return 8;
    }

    public byte getCasingMeta3() {
        return 7;
    }

    public byte getCasingMeta4() {
        return 11;
    }

    public byte getCasingTextureIndex() {
        return (byte)mCasingTextureID;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mHeatLevel", this.mHeatLevel);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mHeatLevel = aNBT.func_74762_e("mHeatLevel");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().getFrontFacing() != 1) {
            this.getBaseMetaTileEntity().setFrontFacing((byte)1);
        }
    }

    public void onRemoval() {
        this.resetSolarHeaters();
        super.onRemoval();
    }

    private void resetSolarHeaters() {
        for (TileEntitySolarHeater aTile : this.mSolarHeaters) {
            aTile.clearSolarTower();
        }
        this.mSolarHeaters.clear();
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Internal Heat Level: " + this.mHeatLevel, "Connected Solar Reflectors: " + this.mSolarHeaters.size()};
    }
}

