/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntity_Refinery
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_Refinery> {
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_Refinery> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_Refinery(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Refinery(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Fuel Refinery";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Fission Fuel Processing Unit").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 9, 3, false).addController("Bottom Center").addCasingInfo("Hastelloy-X Structural Casing", 7).addCasingInfo("Incoloy-DS Fluid Containment Block", 5).addCasingInfo("Zeron-100 Reactor Shielding", 4).addCasingInfo("Hastelloy-N Sealant Blocks", 17).addInputHatch("Base platform", new int[]{1}).addOutputHatch("Base platform", new int[]{1}).addOutputBus("Base platform", new int[]{1}).addMufflerHatch("Base platform", new int[]{1}).addMaintenanceHatch("Base platform", new int[]{1}).addEnergyHatch("Base platform", new int[]{1}).addStructureInfo("Muffler's Tier must be LuV+").addStructureInfo("4x Input Hatches, 2x Output Hatches, 1x Output Bus").addStructureInfo("1x Muffler, 1x Maintenance Hatch, 1x Energy Hatch").toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(18)), new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(18))};
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "MatterFabricator";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sFissionFuelProcessing;
    }

    public boolean checkRecipe(ItemStack aStack) {
        for (GT_MetaTileEntity_Hatch_Input g : this.mInputHatches) {
            g.mRecipeMap = null;
        }
        boolean ab = super.checkRecipeGeneric();
        return ab;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public final boolean addRefineryList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler && ((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity).mTier >= 6) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public IStructureDefinition<GregtechMetaTileEntity_Refinery> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"   ", " N ", "   "}, {" N ", "NIN", " N "}, {" N ", "NIN", " N "}, {" N ", "NIN", " N "}, {" Z ", "ZIZ", " Z "}, {" N ", "NIN", " N "}, {"XXX", "XXX", "XXX"}, {"X~X", "XXX", "XXX"}})).addElement(Character.valueOf('X'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_Refinery::addRefineryList, (int)TAE.GTPP_INDEX(18), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)2))})).addElement(Character.valueOf('I'), StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)3)).addElement(Character.valueOf('N'), StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)1)).addElement(Character.valueOf('Z'), StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)13)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 7, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (this.checkPiece(this.mName, 1, 7, 0) && this.mCasing >= 7 && this.mInputHatches.size() == 4 && this.mOutputHatches.size() == 2 && this.mOutputBusses.size() == 1 && this.mMufflerHatches.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() == 1) {
            this.resetRecipeMapForAllInputHatches(this.getRecipeMap());
            return true;
        }
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiRefinery;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 5;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Refinery(this.mName);
    }
}

