/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.RocketFuels;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_AirIntake;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler_Adv;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_LargeRocketEngine
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_LargeRocketEngine> {
    protected int fuelConsumption = 0;
    protected int fuelValue = 0;
    protected int fuelRemaining = 0;
    protected int freeFuelTicks = 0;
    protected int euProduction = 0;
    protected boolean boostEu = false;
    public static String mLubricantName = "Carbon Dioxide";
    public static String mCoolantName = "Liquid Hydrogen";
    public static String mCasingName = "Turbodyne Casing";
    public static String mIntakeHatchName = "Tungstensteel Turbine Casing";
    public static String mGearboxName = "Inconel Reinforced Casing";
    private static Fluid sAirFluid = null;
    private static FluidStack sAirFluidStack = null;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_LargeRocketEngine> STRUCTURE_DEFINITION = null;
    private static final int CASING_ID = TAE.getIndexFromPage(3, 11);

    public GregtechMetaTileEntity_LargeRocketEngine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        GregtechMetaTileEntity_LargeRocketEngine.setAir();
    }

    public GregtechMetaTileEntity_LargeRocketEngine(String aName) {
        super(aName);
        GregtechMetaTileEntity_LargeRocketEngine.setAir();
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Large Rocket Engine").addInfo("Supply Rocket Fuels and 1000L of " + mLubricantName + " per hour").addInfo("Produces as much energy as you put fuel in, with optional boosting").addInfo("Supply 4L of " + mCoolantName + " per second, per 2100 EU/t to boost").addInfo("Takes 3x the amount of fuel and " + mLubricantName + "to run 3x faster").addInfo("Consumes 2000L/s of air and pollutes 1500 gibbl/s per 16384 eu/t produced").addInfo("If producing more than 18.4k EU/t, fuel will be consumed less efficiently:").addInfo("- 75% of max fuel efficiency at 44k EU/t output energy").addInfo("- 50% of max fuel efficiency at 105k EU/t output energy").addInfo("- 25% of max fuel efficiency at 294k EU/t output energy").addInfo("(These thresholds are 3x higher when boosted)").addInfo("formula: x = input of energy (10K^(1/3)/ x^(1/3)) * (40K^(1/3)/ x^(1/3))").addSeparator().beginStructureBlock(3, 3, 10, false).addController("Front Center").addCasingInfo(mCasingName, 64).addCasingInfo(mGearboxName, 8).addStructureHint("Air Intake Hatch", new int[]{1}).addInputBus("Side center line", new int[]{1}).addInputHatch("Side center line", new int[]{1}).addMaintenanceHatch("Any Block Touching Inconel Reinforced Casing", new int[]{1}).addDynamoHatch("Top center line", new int[]{2}).addMufflerHatch("Back Center", new int[]{3}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_LargeRocketEngine> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC", "CTC"}, {"C~C", "SIS", "SIS", "SIS", "SIS", "SIS", "SIS", "SIS", "SIS", "CMC"}, {"CCC", "CSC", "CSC", "CSC", "CSC", "CSC", "CSC", "CSC", "CSC", "CCC"}})).addElement(Character.valueOf('C'), StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())).addElement(Character.valueOf('I'), StructureUtility.ofBlock((Block)this.getGearboxBlock(), (int)this.getGearboxMeta())).addElement(Character.valueOf('T'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_LargeRocketEngine::addLargeRocketEngineTopList, (int)this.getCasingTextureIndex(), (int)2), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta()))})).addElement(Character.valueOf('S'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_LargeRocketEngine::addLargeRocketEngineSideList, (int)this.getCasingTextureIndex(), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta()))})).addElement(Character.valueOf('M'), (IStructureElement)GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_LargeRocketEngine::addLargeRocketEngineBackList, (int)this.getCasingTextureIndex(), (int)3)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mTecTechDynamoHatches.clear();
        this.mAllDynamoHatches.clear();
        this.mAirIntakes.clear();
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 16 && this.mAirIntakes.size() >= 8 && this.checkHatch();
    }

    public final boolean addLargeRocketEngineTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_AirIntake) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (LoadedMods.TecTech && this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addLargeRocketEngineSideList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_AirIntake) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addLargeRocketEngineBackList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_ID), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_ID)};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return super.getClientGUI(aID, aPlayerInventory, aBaseMetaTileEntity);
    }

    public static void setAir() {
        if (sAirFluidStack == null) {
            sAirFluidStack = FluidUtils.getFluidStack("air", 1);
        }
        if (sAirFluid == null && sAirFluidStack != null) {
            sAirFluid = sAirFluidStack.getFluid();
        }
    }

    public int getAir() {
        GregtechMetaTileEntity_LargeRocketEngine.setAir();
        if (this.mAirIntakes.isEmpty() || this.mAirIntakes.size() <= 0) {
            return 0;
        }
        int totalAir = 0;
        for (GT_MetaTileEntity_Hatch_AirIntake u : this.mAirIntakes) {
            FluidStack f;
            if (u == null || u.mFluid == null || !(f = u.mFluid).isFluidEqual(sAirFluidStack)) continue;
            totalAir += f.amount;
        }
        return totalAir;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sRocketFuels;
    }

    public boolean checkRecipe(ItemStack aStack) {
        int aSplitAmount;
        ArrayList tFluids = this.getStoredFluids();
        this.clearRecipeMapForAllInputHatches();
        int aircount = this.getAir();
        int aAirToConsume = this.euProduction / 100;
        if (aircount < aAirToConsume) {
            this.log("Not Enough Air to Run " + aircount);
            return false;
        }
        int aTotalAir = 0;
        for (Object aAirHatch : this.mAirIntakes) {
            if (((GT_MetaTileEntity_Hatch_AirIntake)((Object)aAirHatch)).mFluid == null) continue;
            aTotalAir += aAirHatch.getFluidAmount();
        }
        this.log("Total Air: " + aTotalAir);
        if (aTotalAir >= aAirToConsume && (aSplitAmount = aAirToConsume / this.mAirIntakes.size()) > 0) {
            for (GT_MetaTileEntity_Hatch_AirIntake aAirHatch : this.mAirIntakes) {
                boolean hasIntakeAir;
                boolean bl = hasIntakeAir = aAirHatch.drain(aSplitAmount, true) != null;
                if (!hasIntakeAir) {
                    this.log("Could not consume Air to run " + aSplitAmount);
                    this.freeFuelTicks = 0;
                    return false;
                }
                this.log("Consumed Air to run " + aSplitAmount);
            }
        }
        if (this.freeFuelTicks != 0 && this.mProgresstime == 0 && this.mEfficiency == 0) {
            this.freeFuelTicks = 0;
        }
        this.log("Running " + aircount);
        this.log("looking at hatch");
        if (tFluids.size() > 0 && this.getRecipeMap() != null) {
            FluidStack aCO2 = MISC_MATERIALS.CARBON_DIOXIDE.getFluidStack(this.boostEu ? 3 : 1);
            FluidStack aCO2Fallback = FluidUtils.getWildcardFluidStack("carbondioxide", this.boostEu ? 3 : 1);
            boolean aHasCO2 = false;
            for (FluidStack aFluid : tFluids) {
                if (aCO2 != null && aFluid.isFluidEqual(aCO2)) {
                    this.log("Found CO2 (1)");
                    aHasCO2 = true;
                    break;
                }
                if (aCO2Fallback != null && aFluid.isFluidEqual(aCO2Fallback)) {
                    this.log("Found CO2 (2)");
                    aHasCO2 = true;
                    break;
                }
                this.log("Found: " + aFluid.getUnlocalizedName());
            }
            if (aHasCO2) {
                if (!(this.mRuntime % 72 != 0 && this.mRuntime != 0 || this.consumeCO2())) {
                    this.freeFuelTicks = 0;
                    this.log("Bad Return 1");
                    return false;
                }
            } else {
                this.freeFuelTicks = 0;
                this.log("Bad Return 2 | " + aHasCO2 + " | " + (aCO2 != null) + " | " + (aCO2Fallback != null));
                return false;
            }
            if (this.freeFuelTicks == 0) {
                this.boostEu = this.consumeLOH();
            }
            for (FluidStack hatchFluid1 : tFluids) {
                if (hatchFluid1.isFluidEqual(sAirFluidStack)) continue;
                if (this.freeFuelTicks == 0) {
                    for (GT_Recipe aFuel : this.getRecipeMap().mRecipeList) {
                        FluidStack tLiquid = aFuel.mFluidInputs[0];
                        if (!hatchFluid1.isFluidEqual(tLiquid) || !this.consumeFuel(aFuel, hatchFluid1.amount)) continue;
                        this.fuelValue = aFuel.mSpecialValue * 3;
                        this.fuelRemaining = hatchFluid1.amount;
                        this.mEUt = (int)(this.mEfficiency < 2000 ? 0L : GT_Values.V[5] << 1);
                        this.mProgresstime = 1;
                        this.mMaxProgresstime = 1;
                        this.mEfficiencyIncrease = this.euProduction / 2000;
                        return true;
                    }
                    continue;
                }
                this.mEfficiencyIncrease = this.euProduction / 2000;
                --this.freeFuelTicks;
                this.mEUt = (int)(this.mEfficiency < 1000 ? 0L : GT_Values.V[5] << 1);
                this.mProgresstime = 1;
                this.mMaxProgresstime = 1;
                return true;
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        this.freeFuelTicks = 0;
        this.log("Bad Return 3");
        return false;
    }

    public boolean consumeFuel(GT_Recipe aFuel, int amount) {
        amount = (int)((double)amount * (this.boostEu ? 0.3 : 0.9));
        this.freeFuelTicks = 0;
        int value = aFuel.mSpecialValue * 3;
        int energy = value * amount;
        if (amount < 5) {
            return false;
        }
        FluidStack tLiquid = FluidUtils.getFluidStack(aFuel.mFluidInputs[0], this.boostEu ? amount * 3 : amount);
        if (!this.depleteInput(tLiquid)) {
            return false;
        }
        this.fuelConsumption = this.boostEu ? amount * 3 : amount;
        this.freeFuelTicks = 20;
        this.setEUProduction(energy);
        return true;
    }

    public void setEUProduction(int energy) {
        double energyEfficiency;
        double tDivideEnergy = Math.cbrt(energy /= 20);
        if (energy > 10000) {
            energyEfficiency = 21.5443469 / tDivideEnergy;
            if (energy >= 40000) {
                energyEfficiency *= 34.19951893 / tDivideEnergy;
            }
            energyEfficiency *= (double)energy;
        } else {
            energyEfficiency = energy;
        }
        this.euProduction = (int)(energyEfficiency * 1.84);
        if (this.boostEu) {
            this.euProduction *= 3;
        }
    }

    public boolean consumeCO2() {
        return this.depleteInput(MISC_MATERIALS.CARBON_DIOXIDE.getFluidStack(this.boostEu ? 3 : 1)) || this.depleteInput(FluidUtils.getFluidStack("carbondioxide", this.boostEu ? 3 : 1));
    }

    public boolean consumeLOH() {
        int LOHamount = 3 * this.euProduction / 1000;
        return this.depleteInput(FluidUtils.getFluidStack(RocketFuels.Liquid_Hydrogen, LOHamount));
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        if (this.mAllDynamoHatches.size() > 0) {
            return this.addEnergyOutputMultipleDynamos(aEU, true);
        }
        return false;
    }

    public boolean addEnergyOutputMultipleDynamos(long aEU, boolean aAllowMixedVoltageDynamos) {
        long aVoltage;
        int injected = 0;
        long totalOutput = 0L;
        long aFirstVoltageFound = -1L;
        boolean aFoundMixedDynamos = false;
        for (GT_MetaTileEntity_Hatch aDynamo : this.mAllDynamoHatches) {
            if (aDynamo == null) {
                return false;
            }
            if (!GregtechMetaTileEntity_LargeRocketEngine.isValidMetaTileEntity((MetaTileEntity)aDynamo)) continue;
            aVoltage = aDynamo.maxEUOutput();
            long aTotal = aDynamo.maxAmperesOut() * aVoltage;
            if (aFirstVoltageFound == -1L) {
                aFirstVoltageFound = aVoltage;
            } else if (aFirstVoltageFound != aVoltage) {
                aFoundMixedDynamos = true;
            }
            totalOutput += aTotal;
        }
        if (totalOutput < aEU || aFoundMixedDynamos && !aAllowMixedVoltageDynamos) {
            this.explodeMultiblock();
            return false;
        }
        for (GT_MetaTileEntity_Hatch aDynamo : this.mAllDynamoHatches) {
            if (!GregtechMetaTileEntity_LargeRocketEngine.isValidMetaTileEntity((MetaTileEntity)aDynamo)) continue;
            long leftToInject = aEU - (long)injected;
            aVoltage = aDynamo.maxEUOutput();
            int aAmpsToInject = (int)(leftToInject / aVoltage);
            int aRemainder = (int)(leftToInject - (long)aAmpsToInject * aVoltage);
            int i = 0;
            while ((long)i < Math.min(aDynamo.maxAmperesOut(), (long)(aAmpsToInject + 1))) {
                long powerGain = (long)i == Math.min(aDynamo.maxAmperesOut(), (long)aAmpsToInject) ? (long)aRemainder : aVoltage;
                aDynamo.getBaseMetaTileEntity().increaseStoredEnergyUnits(powerGain, false);
                injected = (int)((long)injected + powerGain);
                ++i;
            }
        }
        return injected > 0;
    }

    public boolean onRunningTick(ItemStack aStack) {
        GT_MetaTileEntity_Hatch_Muffler_Adv tMuffler;
        if (this.mRuntime % 20 == 0 && this.mMufflerHatches.size() == 1 && this.mMufflerHatches.get(0) instanceof GT_MetaTileEntity_Hatch_Muffler_Adv && !(tMuffler = (GT_MetaTileEntity_Hatch_Muffler_Adv)((Object)this.mMufflerHatches.get(0))).hasValidFilter()) {
            ArrayList tInputs = this.getStoredInputs();
            for (ItemStack tItem : tInputs) {
                if (!tMuffler.isAirFilter(tItem)) continue;
                tMuffler.mInventory[0] = tItem.func_77946_l();
                this.depleteInput(tItem);
                this.updateSlots();
                break;
            }
        }
        super.onRunningTick(aStack);
        return true;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings4Misc;
    }

    public byte getCasingMeta() {
        return 11;
    }

    public Block getGearboxBlock() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getGearboxMeta() {
        return 1;
    }

    public byte getCasingTextureIndex() {
        return (byte)CASING_ID;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_LargeRocketEngine(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("freeFuelTicks", this.freeFuelTicks);
        aNBT.func_74768_a("euProduction", this.euProduction);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.freeFuelTicks = aNBT.func_74762_e("freeFuelTicks");
        this.euProduction = aNBT.func_74762_e("euProduction");
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return this.euProduction;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 75 * (this.euProduction / 10000);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Rocket Engine", "Current Air: " + this.getAir(), "Current Pollution: " + this.getPollutionPerTick(null), "Time until next fuel consumption: " + this.freeFuelTicks, "Current Output: " + this.mEUt * this.mEfficiency / 10000 + " EU/t", "Fuel Consumption: " + this.fuelConsumption + "L/s", "Fuel Value: " + this.fuelValue + " EU/L", "Fuel Remaining: " + this.fuelRemaining + " Litres", "Current Efficiency: " + this.mEfficiency / 100 + "%", this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public String getMachineType() {
        return "Rocket Engine";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }
}

