/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.FishPondFakeRecipe;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialFishingPond
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialFishingPond> {
    private boolean isUsingControllerCircuit = false;
    private static final Item circuit = CI.getNumberedCircuit(0).func_77973_b();
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialFishingPond> STRUCTURE_DEFINITION = null;
    private static AutoMap<AutoMap<WeightedRandomFishable>> categories = new AutoMap();
    private static AutoMap<WeightedRandomFishable> categoryFish = new AutoMap();
    private static AutoMap<WeightedRandomFishable> categoryJunk = new AutoMap();
    private static AutoMap<WeightedRandomFishable> categoryLoot = new AutoMap();
    private static boolean hasGenerateRecipes = false;
    private int mMode = 14;
    private int mMax = 8;
    private static Map<WeightedRandomFishable, ItemStack> reflectiveFishMap = new HashMap<WeightedRandomFishable, ItemStack>();

    public GregtechMetaTileEntity_IndustrialFishingPond(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialFishingPond(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialFishingPond(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fish Trap";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Fishing Pond").addInfo("Can process (Tier + 1) * 2 recipes").addInfo("Put a numbered circuit into the input bus.").addInfo("Circuit 14 for Fish").addInfo("Circuit 15 for Junk").addInfo("Circuit 16 for Treasure").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(9, 3, 9, true).addController("Front Center").addCasingInfo("Aquatic Casings", 64).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialFishingPond> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXX~XXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX"}})).addElement(Character.valueOf('X'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialFishingPond::addIndustrialFishingPondList, (int)this.getCasingTextureIndex(), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta()))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public final boolean addIndustrialFishingPondList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 4, 1, 0) && this.mCasing >= 64 && this.checkHatch();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex()), new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex())};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (aStack != null) {
            this.log("Found " + aStack.func_82833_r());
            if (aStack.func_77973_b() == circuit) {
                this.isUsingControllerCircuit = true;
                this.mMode = aStack.func_77960_j();
                this.log("Found Circuit!");
            } else {
                this.isUsingControllerCircuit = false;
            }
        } else {
            this.isUsingControllerCircuit = false;
        }
        if (!hasGenerateRecipes) {
            this.log("Generating Recipes.");
            this.generateRecipes();
        }
        if (hasGenerateRecipes) {
            if (!this.checkForWater()) {
                return false;
            }
            this.log("Trying to run recipe.");
            ArrayList tItems = this.getStoredInputs();
            ArrayList tFluids = this.getStoredFluids();
            ItemStack[] tItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
            FluidStack[] tFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
            if (!this.isUsingControllerCircuit && tItems.size() == 0) {
                return false;
            }
            return this.checkRecipeGeneric(tItemInputs, tFluidInputs, this.getMaxParallelRecipes(), 100, 80, 100);
        }
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * (GT_Utility.getTier((long)this.getMaxInputVoltage()) + 1);
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialFishingPond;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getCasingMeta() {
        return 0;
    }

    public int getCasingTextureIndex() {
        return TAE.GTPP_INDEX(32);
    }

    public boolean checkForWater() {
        boolean isValidWater;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mDirectionX = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int mOffsetX_Lower = 0;
        int mOffsetX_Upper = 0;
        int mOffsetZ_Lower = 0;
        int mOffsetZ_Upper = 0;
        int mCurrentDirectionX = 4;
        int mCurrentDirectionZ = 4;
        mOffsetX_Lower = -4;
        mOffsetX_Upper = 4;
        mOffsetZ_Lower = -4;
        mOffsetZ_Upper = 4;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * mCurrentDirectionX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * mCurrentDirectionZ;
        int tAmount = 0;
        for (int i = mOffsetX_Lower + 1; i <= mOffsetX_Upper - 1; ++i) {
            for (int j = mOffsetZ_Lower + 1; j <= mOffsetZ_Upper - 1; ++j) {
                for (int h = 0; h < 2; ++h) {
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if ((tBlock == Blocks.field_150350_a || tBlock == Blocks.field_150358_i || tBlock == BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater)) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(FluidUtils.getFluidStack("water", 1)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            Block fluidUsed = Blocks.field_150355_j;
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, fluidUsed);
                        }
                    }
                    if ((tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j)) != Blocks.field_150355_j && tBlock != Blocks.field_150358_i) continue;
                    ++tAmount;
                }
            }
        }
        boolean bl = isValidWater = tAmount >= 60;
        if (isValidWater) {
            this.log("Filled structure.");
            return true;
        }
        long aAvgVoltage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy g : this.mEnergyHatches) {
            if (g == null) continue;
            aAvgVoltage += g.maxEUInput() * g.maxAmperesIn();
        }
        this.mEUt = (int)Math.max(30L, aAvgVoltage);
        this.mMaxProgresstime = (int)Math.max(aAvgVoltage / 8L * 20L / 10L, 100L);
        this.mProgresstime = 1;
        this.log("Did not fill structure. Consuming " + aAvgVoltage + "eu/t to try fill.");
        return false;
    }

    private boolean generateRecipes() {
        if (!hasGenerateRecipes) {
            categories.put(categoryFish);
            categories.put(categoryJunk);
            categories.put(categoryLoot);
            for (WeightedRandomFishable h : FishPondFakeRecipe.fish) {
                categoryFish.put(h);
            }
            for (WeightedRandomFishable h : FishPondFakeRecipe.junk) {
                categoryJunk.put(h);
            }
            for (WeightedRandomFishable h : FishPondFakeRecipe.treasure) {
                categoryLoot.put(h);
            }
            hasGenerateRecipes = true;
            return true;
        }
        return true;
    }

    private int getCircuit(ItemStack[] t) {
        block8: {
            ItemStack[] itemStackArray;
            int n;
            int n2;
            if (this.isUsingControllerCircuit || (n2 = 0) >= (n = (itemStackArray = t).length)) break block8;
            ItemStack j = itemStackArray[n2];
            if (j.func_77973_b() == CI.getNumberedCircuit(0).func_77973_b()) {
                if (j.func_77960_j() == 14) {
                    this.mMax = 8 + (this.getMaxParallelRecipes() - 2);
                    this.mMode = 14;
                } else if (j.func_77960_j() == 15) {
                    this.mMode = 15;
                    this.mMax = 4;
                } else if (j.func_77960_j() == 16) {
                    this.mMode = 16;
                    this.mMax = 4;
                } else {
                    this.mMode = 0;
                    this.mMax = 0;
                }
            } else {
                this.mMode = 0;
                this.mMax = 0;
            }
        }
        return this.mMode;
    }

    private ItemStack reflectiveFish(WeightedRandomFishable y) {
        if (reflectiveFishMap.containsKey(y)) {
            return reflectiveFishMap.get(y);
        }
        try {
            ItemStack t = (ItemStack)ReflectionUtils.getField(WeightedRandomFishable.class, "field_150711_b").get(y);
            ItemStack k = ItemUtils.getSimpleStack(t, 1);
            reflectiveFishMap.put(y, k);
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    private ItemStack[] generateLoot(int mode) {
        ItemStack[] mFishOutput = new ItemStack[this.mMax];
        if (this.mMode == 14) {
            for (int k = 0; k < this.mMax; ++k) {
                if (mFishOutput[k] != null) continue;
                for (WeightedRandomFishable g : categoryFish.values()) {
                    ItemStack t;
                    if (MathUtils.randInt(0, 65 - this.getMaxParallelRecipes()) > 2 || (t = this.reflectiveFish(g)) == null) continue;
                    mFishOutput[k] = ItemUtils.getSimpleStack(t, 1);
                }
            }
        } else if (this.mMode == 15) {
            for (int k = 0; k < this.mMax; ++k) {
                if (mFishOutput[k] != null) continue;
                for (WeightedRandomFishable g : categoryJunk.values()) {
                    ItemStack t;
                    if (MathUtils.randInt(0, 100) > 1 || (t = this.reflectiveFish(g)) == null) continue;
                    mFishOutput[k] = ItemUtils.getSimpleStack(t, 1);
                }
            }
        } else if (this.mMode == 16) {
            for (int k = 0; k < this.mMax; ++k) {
                if (mFishOutput[k] != null) continue;
                for (WeightedRandomFishable g : categoryLoot.values()) {
                    ItemStack t;
                    if (MathUtils.randInt(0, 1000) > 2 || (t = this.reflectiveFish(g)) == null) continue;
                    mFishOutput[k] = ItemUtils.getSimpleStack(t, 1);
                }
            }
        } else {
            mFishOutput = null;
        }
        return mFishOutput;
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        byte tTierOld;
        int parallelRecipes;
        int aControlCoreTier = this.getControlCoreTier();
        if (aControlCoreTier == 0) {
            // empty if block
        }
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        this.log("Running checkRecipeGeneric(0)");
        if (tTier > aControlCoreTier) {
            // empty if block
        }
        this.getCircuit(aItemInputs);
        ItemStack[] mFishOutput = this.generateLoot(this.mMode);
        mFishOutput = ArrayUtils.removeNulls(mFishOutput);
        GTPP_Recipe g = new GTPP_Recipe(true, new ItemStack[0], mFishOutput, null, new int[0], aFluidInputs, this.mOutputFluids, 200, 16, 0);
        aMaxParallelRecipes = this.canBufferOutputs(g, aMaxParallelRecipes);
        if (aMaxParallelRecipes == 0) {
            this.log("No Space");
            return false;
        }
        this.log("Mode: " + this.mMode + " | Is loot valid? " + (mFishOutput != null));
        int jslot = 0;
        for (ItemStack x : mFishOutput) {
            if (x != null) {
                this.log("Slot " + jslot + " in mFishOutput contains " + x.field_77994_a + "x " + x.func_82833_r() + ".");
            } else {
                this.log("Slot " + jslot + " in mFishOutput was null.");
            }
            ++jslot;
        }
        float tRecipeEUt = (float)(8 * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tVoltage - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)(20.0f * tTimeFactor * 4.0f);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        tTier = tTierOld = tTier;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.log("Recipe Step. [3]");
        ItemStack[] tOutputItems = mFishOutput;
        int rslot = 0;
        for (ItemStack x : tOutputItems = ArrayUtils.removeNulls(mFishOutput)) {
            if (x != null) {
                this.log("rSlot " + rslot + " in mFishOutput contains " + x.field_77994_a + "x " + x.func_82833_r() + ".");
            } else {
                this.log("rSlot " + rslot + " in mFishOutput was null.");
            }
            ++rslot;
        }
        this.mOutputItems = tOutputItems;
        this.updateSlots();
        this.startProcess();
        return true;
    }
}

