/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_AlloyBlastSmelter
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_AlloyBlastSmelter> {
    private int mMode = 0;
    private boolean isUsingControllerCircuit = false;
    private static Item circuit;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_AlloyBlastSmelter> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_AlloyBlastSmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_AlloyBlastSmelter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_AlloyBlastSmelter(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fluid Alloy Cooker";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Alloy Blast Smelter").addInfo("20% Faster than the Electric Blast Furnace").addInfo("Allows Complex GT++ alloys to be created").addInfo("This multiblock cannot be overclocked").addInfo("Circuit for recipe goes in the Input Bus or GUI slot").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Bottom Center").addCasingInfo("Blast Smelter Casings", 10).addCasingInfo("Blast Smelter Heat Containment Coils", 16).addInputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_AlloyBlastSmelter> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_AlloyBlastSmelter::addAlloyBlastSmelterList, (int)TAE.GTPP_INDEX(15), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15))})).addElement(Character.valueOf('H'), StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 3, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 3, 0) && this.mCasing >= 10 && this.mEnergyHatches.size() == 1 && this.checkHatch();
    }

    public final boolean addAlloyBlastSmelterList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(208);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(15)), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(15))};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "ElectricBlastFurnace";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (circuit == null) {
                circuit = CI.getNumberedCircuit(0).func_77973_b();
            }
            if (aStack != null && aStack.func_77973_b() == circuit) {
                this.mMode = aStack.func_77960_j();
                this.isUsingControllerCircuit = true;
                return true;
            }
            if (aStack == null) {
                this.isUsingControllerCircuit = false;
                return true;
            }
            Logger.WARNING("Not circuit in GUI inputs.");
            this.isUsingControllerCircuit = false;
            return false;
        }
        Logger.WARNING("No Circuit, clientside.");
        this.isUsingControllerCircuit = false;
        return false;
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.isUsingControllerCircuit = this.isCorrectMachinePart(aStack);
            ArrayList tInputList = this.getStoredInputs();
            block0: for (int i = 0; i < tInputList.size() - 1; ++i) {
                for (int j = i + 1; j < tInputList.size(); ++j) {
                    if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                    if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                        tInputList.remove(j--);
                        continue;
                    }
                    tInputList.remove(i--);
                    continue block0;
                }
            }
            if (this.isUsingControllerCircuit && tInputList.size() < 1 || !this.isUsingControllerCircuit && tInputList.size() < 2) {
                Logger.WARNING("Not enough inputs.");
                return false;
            }
            if (this.isUsingControllerCircuit && tInputList.size() >= 1) {
                tInputList.add(CI.getNumberedCircuit(this.mMode));
            }
            ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[tInputList.size()]), 0, tInputList.size());
            ArrayList tFluidList = this.getStoredFluids();
            block2: for (int i = 0; i < tFluidList.size() - 1; ++i) {
                for (int j = i + 1; j < tFluidList.size(); ++j) {
                    if (!GT_Utility.areFluidsEqual((FluidStack)((FluidStack)tFluidList.get(i)), (FluidStack)((FluidStack)tFluidList.get(j)))) continue;
                    if (((FluidStack)tFluidList.get((int)i)).amount >= ((FluidStack)tFluidList.get((int)j)).amount) {
                        tFluidList.remove(j--);
                        continue;
                    }
                    tFluidList.remove(i--);
                    continue block2;
                }
            }
            FluidStack[] tFluids = Arrays.copyOfRange(tFluidList.toArray(new FluidStack[tInputList.size()]), 0, 1);
            if (tInputList.size() > 1) {
                long tVoltage = this.getMaxInputVoltage();
                byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
                GT_Recipe tRecipe = GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
                if (tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                    Logger.WARNING("Found some Valid Inputs.");
                    this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                    this.mEfficiencyIncrease = 10000;
                    if (tRecipe.mEUt <= 16) {
                        this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                        this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
                    } else {
                        this.mEUt = tRecipe.mEUt;
                        this.mMaxProgresstime = tRecipe.mDuration;
                        while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                            this.mEUt *= 4;
                            this.mMaxProgresstime /= 2;
                        }
                    }
                    if (this.mEUt > 0) {
                        this.mEUt = -this.mEUt;
                    }
                    this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                    this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
                    ArrayList<ItemStack> tOutPutItems = new ArrayList<ItemStack>();
                    for (ItemStack tOut : tRecipe.mOutputs) {
                        if (!ItemUtils.checkForInvalidItems(tOut)) continue;
                        tOutPutItems.add(tOut);
                    }
                    if (tOutPutItems.size() > 0) {
                        this.mOutputItems = tOutPutItems.toArray(new ItemStack[tOutPutItems.size()]);
                    }
                    this.updateSlots();
                    return true;
                }
            }
        }
        Logger.WARNING("Failed to find some Valid Inputs or Clientside.");
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiABS;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

